/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEProcedure;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.TransactionModeType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEProcedureImpl;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.JDBCParameterType;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.routines.impl.SQLRoutinesFactoryImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogProcedure
extends SybaseASEProcedureImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 2969974132309352611L;
    static final String rsKeyword = "RESULT SETS";
    private Boolean sourceLoaded = Boolean.FALSE;
    private Boolean parametersLoaded = Boolean.FALSE;
    private Boolean privilegesLoaded = Boolean.FALSE;
    private Boolean isSystemProcLoaded = Boolean.FALSE;
    private Boolean transactionModeLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.isNeedRefresh()) {
            Boolean bl = this.parametersLoaded;
            synchronized (bl) {
                if (this.parametersLoaded.booleanValue()) {
                    this.parametersLoaded = Boolean.FALSE;
                }
            }
            bl = this.privilegesLoaded;
            synchronized (bl) {
                if (this.privilegesLoaded.booleanValue()) {
                    this.privilegesLoaded = Boolean.FALSE;
                }
            }
            bl = this.sourceLoaded;
            synchronized (bl) {
                if (this.sourceLoaded.booleanValue()) {
                    this.sourceLoaded = Boolean.FALSE;
                    this.setSource(null);
                }
            }
            bl = this.isSystemProcLoaded;
            synchronized (bl) {
                if (this.isSystemProcLoaded.booleanValue()) {
                    this.isSystemProcLoaded = Boolean.FALSE;
                }
            }
            bl = this.transactionModeLoaded;
            synchronized (bl) {
                if (this.transactionModeLoaded.booleanValue()) {
                    this.transactionModeLoaded = Boolean.FALSE;
                }
            }
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getSource() {
        Boolean bl = this.sourceLoaded;
        synchronized (bl) {
            if (!this.sourceLoaded.booleanValue()) {
                this.loadCode();
            }
        }
        return super.getSource();
    }

    protected void loadCode() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Source source = SQLRoutinesFactoryImpl.eINSTANCE.createSource();
        source.setBody(SybaseASECatalogUtils.getCompiledObjectText((SQLObject)this, this.getConnection(), this.getSchema().getCatalog().getName()));
        this.setSource(source);
        this.eSetDeliver(deliver);
        this.sourceLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSystemProcedure() {
        Boolean bl = this.isSystemProcLoaded;
        synchronized (bl) {
            if (!this.isSystemProcLoaded.booleanValue()) {
                this.loadIsSystemProc();
            }
        }
        return super.isSystemProcedure();
    }

    private void loadIsSystemProc() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Catalog sysprocCatalog = (Catalog)ASEUtil.getSQLObject((Collection)this.getCatalogDatabase().getCatalogs(), "sybsystemprocs");
        Schema dboSchema = (Schema)ASEUtil.getSQLObject((Collection)sysprocCatalog.getSchemas(), "dbo");
        Object proc = ASEUtil.findSP((Collection)dboSchema.getProcedures(), this.getName(), this.getGroupNumber());
        super.setSystemProcedure(proc != null);
        this.eSetDeliver(deliver);
        this.isSystemProcLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionModeType getTransactionMode() {
        Boolean bl = this.transactionModeLoaded;
        synchronized (bl) {
            if (!this.transactionModeLoaded.booleanValue()) {
                this.loadTransactionMode();
            }
        }
        return super.getTransactionMode();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadTransactionMode() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getSchema().getCatalog().getName());
                stmt = conn.prepareStatement("SELECT O.sysstat2 FROM sysusers U, sysobjects O, sysprocedures P WHERE U.uid=O.uid and P.id = O.id and P.sequence =0 AND P.status & 4096 != 4096 AND U.name like ? and O.name like ? and O.type='P' and P.number = ?");
                stmt.setString(1, this.getSchema().getName());
                stmt.setString(2, this.getName());
                stmt.setInt(3, this.getGroupNumber());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int status2 = rs.getInt(1);
                    if ((status2 & 0x10) == 16) {
                        super.setTransactionMode(TransactionModeType.CHAINED_LITERAL);
                        continue;
                    }
                    if ((status2 & 0x20) == 32) {
                        super.setTransactionMode(TransactionModeType.ANYMODE_LITERAL);
                        continue;
                    }
                    super.setTransactionMode(TransactionModeType.UNCHAINED_LITERAL);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.eSetDeliver(deliver);
        this.transactionModeLoaded = Boolean.TRUE;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 18: {
                this.getSource();
                break;
            }
            case 17: {
                this.getParameters();
                break;
            }
            case 25: {
                this.isSystemProcedure();
                break;
            }
            case 24: {
                this.getTransactionMode();
                break;
            }
            case 6: {
                this.getPrivileges();
            }
        }
        return super.eIsSet(eFeature);
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getParameters() {
        Boolean bl = this.parametersLoaded;
        synchronized (bl) {
            if (!this.parametersLoaded.booleanValue()) {
                this.loadParameters();
                this.parametersLoaded = Boolean.TRUE;
            }
        }
        return super.getParameters();
    }

    protected void loadParameters() {
        new SybaseASEParameterLoader((Routine)this).loadParameterInfo(super.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getPrivileges() {
        Boolean bl = this.privilegesLoaded;
        synchronized (bl) {
            if (!this.privilegesLoaded.booleanValue()) {
                this.loadPrivileges();
                this.privilegesLoaded = Boolean.TRUE;
            }
        }
        return super.getPrivileges();
    }

    protected void loadPrivileges() {
        super.getPrivileges().clear();
        SybaseASECatalog catalog = (SybaseASECatalog)this.getSchema().getCatalog();
        List privileges = SybaseASECatalogUtils.getPrivileges((SybaseAuthorizedObject)this, catalog);
        super.getPrivileges().addAll((Collection)privileges);
    }

    public static String getASEProcedureName(SybaseASEProcedure proc) {
        String procName = proc.getName();
        int groupNumb = proc.getGroupNumber();
        return String.valueOf(procName) + ";" + groupNumb;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    private boolean isNeedRefresh() {
        return this.sourceLoaded != false || this.parametersLoaded != false || this.privilegesLoaded != false || this.transactionModeLoaded != false;
    }

    public class SybaseASEParameterLoader {
        protected Routine routine;

        public SybaseASEParameterLoader(Routine routine) {
            this.routine = routine;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void loadParameterInfo(EList paramContaintmentList) {
            boolean deliver = this.routine.eDeliver();
            this.routine.eSetDeliver(false);
            paramContaintmentList.clear();
            Connection conn = ((ICatalogObject)this.routine).getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    Schema schema = this.routine.getSchema();
                    Database database = schema.getCatalog().getDatabase();
                    conn.setCatalog(schema.getCatalog().getName());
                    stmt = conn.prepareStatement("select c.name as COLUMN_NAME,c.status2 COLUMN_TYPE, c.usertype DATA_TYPE,t.name TYPE_NAME,c.prec PRECISION,c.length,c.scale,t.allownulls NULLABLE,NULL as REMARKS,char_length = isnull(@@ncharsize,1) from syscolumns c join systypes t on c.usertype = t.usertype where id = object_id(?) order by colid");
                    String qualName = String.valueOf(schema.getName()) + "." + this.routine.getName();
                    stmt.setString(1, qualName);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String parmName = rs.getString(1);
                        int paramType = rs.getInt(2);
                        int dataType = rs.getInt(3);
                        String typeName = rs.getString(4);
                        int precision = rs.getInt(5);
                        int length = rs.getInt(6);
                        int scale = rs.getInt(7);
                        boolean nullable = rs.getBoolean(8);
                        String remarks = rs.getString(9);
                        int iCharSize = rs.getInt(10);
                        SybaseParameter param = SybasesqlmodelFactory.eINSTANCE.createSybaseParameter();
                        param.setName(parmName);
                        if (dataType <= 100) {
                            DatabaseDefinition dbDefn = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                            PredefinedDataType datatype = SybaseASECatalogUtils.getASEPredefinedType(length, precision, scale, iCharSize, typeName, dbDefn);
                            param.setDataType((DataType)datatype);
                        } else {
                            DataType domain = SybaseASECatalogUtils.getSpecifiedUserDefinedDatatype(schema.getCatalog(), typeName);
                            param.setDataType(domain);
                        }
                        ParameterMode mode = null;
                        JDBCParameterType pType = JDBCParameterType.IN_LITERAL;
                        if (paramType == 2) {
                            mode = ParameterMode.INOUT_LITERAL;
                            pType = JDBCParameterType.IN_OUT_LITERAL;
                        } else {
                            mode = ParameterMode.IN_LITERAL;
                        }
                        param.setMode(mode);
                        param.setNullable(nullable);
                        param.setJDBCParameterType(pType);
                        param.setDescription(remarks);
                        paramContaintmentList.add((Object)param);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                }
            }
            catch (Throwable throwable) {
                Object var23_25 = null;
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            {
                Object var23_26 = null;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            this.routine.eSetDeliver(deliver);
        }
    }
}

