/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEUserImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogUser
extends SybaseASEUserImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 6956551574517156423L;
    public static final String LOGIN_NAME = "LONGIN_NAME";
    private SybaseASECatalog catalog;
    private Boolean isPrivilegesLoaded = Boolean.FALSE;
    private Boolean isOwnedSchemaLoaded = Boolean.FALSE;
    private Boolean isLoginNameLoaded = Boolean.FALSE;

    public SybaseASECatalogUser(SybaseASECatalog catalog) {
        this.catalog = catalog;
    }

    public Database getCatalogDatabase() {
        return this.catalog.getDatabase();
    }

    public Connection getConnection() {
        return this.catalog.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.isPrivilegesLoaded;
        synchronized (bl) {
            this.isPrivilegesLoaded = Boolean.FALSE;
        }
        bl = this.isOwnedSchemaLoaded;
        synchronized (bl) {
            this.isOwnedSchemaLoaded = Boolean.FALSE;
        }
        bl = this.isLoginNameLoaded;
        synchronized (bl) {
            this.isLoginNameLoaded = Boolean.FALSE;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 12: {
                this.getReceivedPrivilege();
                break;
            }
            case 7: {
                this.getOwnedSchema();
                break;
            }
            case 15: {
                this.getLoginName();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLoginName() {
        Boolean bl = this.isLoginNameLoaded;
        synchronized (bl) {
            if (!this.isLoginNameLoaded.booleanValue()) {
                this.loadLoginName();
                this.isLoginNameLoaded = Boolean.TRUE;
            }
        }
        return super.getLoginName();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadLoginName() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.catalog.getName());
                stmt = conn.prepareStatement("SELECT L.name AS LONGIN_NAME FROM master.dbo.syslogins L, sysusers U WHERE U.suid = L.suid AND U.name = ?");
                stmt.setString(1, this.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String loginName = rs.getString(LOGIN_NAME);
                    super.setLoginName(loginName);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getOwnedSchema() {
        Boolean bl = this.isOwnedSchemaLoaded;
        synchronized (bl) {
            if (!this.isOwnedSchemaLoaded.booleanValue()) {
                EList ownedSchemas = super.getOwnedSchema();
                ownedSchemas.clear();
                Schema schema = (Schema)ASEUtil.getSQLObject((Collection)this.catalog.getSchemas(), this.getName());
                ownedSchemas.add((Object)schema);
            }
        }
        return super.getOwnedSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getReceivedPrivilege() {
        Boolean bl = this.isPrivilegesLoaded;
        synchronized (bl) {
            if (!this.isPrivilegesLoaded.booleanValue()) {
                this.loadPrivileges();
            }
        }
        return super.getReceivedPrivilege();
    }

    private void loadPrivileges() {
        if (this.isPrivilegesLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList privileges = super.getReceivedPrivilege();
        privileges.clear();
        this.eSetDeliver(deliver);
        this.isPrivilegesLoaded = Boolean.TRUE;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

