/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.ctxhelp;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.ctxhelp.CtxHelpModel;
import org.eclipse.pde.internal.core.text.ctxhelp.CtxHelpObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpBlock;
import org.eclipse.pde.internal.ui.editor.ctxhelp.CtxHelpSourcePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CtxHelpPage
extends PDEFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "ctxHelpPage";
    private CtxHelpBlock fBlock = new CtxHelpBlock(this);

    public CtxHelpPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.TocPage_title);
    }

    public PDEMasterDetailsBlock getBlock() {
        return this.fBlock;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        CtxHelpModel model = (CtxHelpModel)this.getModel();
        if (model == null || !model.isLoaded()) {
            this.createFormErrorContent(managedForm, PDEUIMessages.CtxHelpPage_failedToLoad, PDEUIMessages.CtxHelpPage_errorParsing, null);
            return;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.ctx_help_editor");
        super.createFormContent(managedForm);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_CTXHELP_CONTEXT_OBJ));
        form.setText(PDEUIMessages.CtxHelpPage_contextHelp);
        this.fBlock.createContent(managedForm);
        this.fBlock.getMasterSection().fireSelection();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        CtxHelpModel model = (CtxHelpModel)this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        this.fBlock.modelChanged(event);
    }

    public ISelection getSelection() {
        return this.fBlock.getSelection();
    }

    public void setActive(boolean active) {
        IFormPage page;
        super.setActive(active);
        if (active && (page = this.getPDEEditor().findPage("ctxhelp-context")) instanceof CtxHelpSourcePage && ((CtxHelpSourcePage)page).getInputContext().isInSourceMode()) {
            ISourceViewer viewer = ((CtxHelpSourcePage)page).getViewer();
            if (viewer == null) {
                return;
            }
            StyledText text = viewer.getTextWidget();
            if (text == null) {
                return;
            }
            int offset = text.getCaretOffset();
            if (offset < 0) {
                return;
            }
            IDocumentRange range = ((CtxHelpSourcePage)page).getRangeElement(offset, true);
            if (range instanceof IDocumentAttributeNode) {
                range = ((IDocumentAttributeNode)range).getEnclosingElement();
            } else if (range instanceof IDocumentTextNode) {
                range = ((IDocumentTextNode)range).getEnclosingElement();
            }
            if (range instanceof CtxHelpObject) {
                this.fBlock.getMasterSection().setSelection((ISelection)new StructuredSelection((Object)range));
            }
        }
    }

    protected String getHelpResource() {
        return "/org.eclipse.pde.doc.user/guide/tools/editors/ctx_help_editor/ctx_help_editor.htm";
    }
}

