/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboViewerPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class JRESection
extends PDESection {
    private Button fNoneRadioButton;
    private Button fJRERadioButton;
    private Button fEERadioButton;
    private Button fInstalledJREsButton;
    private Button fExecutionEnvironmentsButton;
    private ComboViewerPart fJREsCombo;
    private ComboViewerPart fEEsCombo;
    private boolean fBlockChanges;
    private static final String[] TAB_LABELS = new String[]{"linux", "macosx", "solaris", "win32"};
    private static final String[] TAB_OS = new String[]{"linux", "macosx", "solaris", "win32"};
    private CTabFolder fTabFolder;
    private int fLastTab;

    public JRESection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.ProductJRESection_title);
        section.setDescription(PDEUIMessages.ProductJRESection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(768));
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.refresh();
            }
        });
        this.fTabFolder.setUnselectedImageVisible(false);
        this.fNoneRadioButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_none, 16);
        this.fNoneRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JRESection.this.fNoneRadioButton.getSelection()) {
                    JRESection.this.updateWidgets();
                    JRESection.this.setJRE(null);
                }
            }
        });
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.fNoneRadioButton);
        this.fJRERadioButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_jreName, 16);
        this.fJRERadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JRESection.this.fJRERadioButton.getSelection()) {
                    JRESection.this.updateWidgets();
                    if (JRESection.this.fJREsCombo.getSelection() == null) {
                        JRESection.this.fJREsCombo.select(0);
                    } else {
                        JRESection.this.setJRE((IVMInstall)JRESection.this.fJREsCombo.getSelection());
                    }
                }
            }
        });
        this.fJREsCombo = new ComboViewerPart();
        this.fJREsCombo.createControl(client, toolkit, 2060);
        this.fJREsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fJREsCombo.setItems(VMUtil.getAllVMInstances());
        this.fJREsCombo.setLabelProvider((IBaseLabelProvider)new JRELabelProvider());
        this.fJREsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.setJRE(JRESection.this.fJREsCombo.getSelection() == ComboViewerPart.NULL_OBJECT ? null : (IVMInstall)JRESection.this.fJREsCombo.getSelection());
                }
            }
        });
        this.fInstalledJREsButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_browseJREs, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.fInstalledJREsButton);
        this.fInstalledJREsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)JRESection.this.getSection().getShell(), (String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (String[])new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage"}, null).open();
            }
        });
        this.fEERadioButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_eeName, 16);
        this.fEERadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JRESection.this.fEERadioButton.getSelection()) {
                    JRESection.this.updateWidgets();
                    if (JRESection.this.fEEsCombo.getSelection() == null) {
                        JRESection.this.fEEsCombo.select(0);
                    } else {
                        JRESection.this.setEE((IExecutionEnvironment)JRESection.this.fEEsCombo.getSelection());
                    }
                }
            }
        });
        this.fEEsCombo = new ComboViewerPart();
        this.fEEsCombo.createControl(client, toolkit, 2060);
        this.fEEsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fEEsCombo.setLabelProvider((IBaseLabelProvider)new EELabelProvider());
        this.fEEsCombo.setComparator(new ViewerComparator());
        this.fEEsCombo.setItems(VMUtil.getExecutionEnvironments());
        this.fEEsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.setEE((IExecutionEnvironment)((IStructuredSelection)event.getSelection()).getFirstElement());
                }
            }
        });
        this.fExecutionEnvironmentsButton = toolkit.createButton(client, PDEUIMessages.ProductJRESection_browseEEs, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.fExecutionEnvironmentsButton);
        this.fExecutionEnvironmentsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)JRESection.this.getSection().getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
            }
        });
        this.createTabs();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getProductModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void setEE(IExecutionEnvironment ee) {
        IPath eePath = null;
        if (ee != null) {
            eePath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee);
        }
        this.getJVMLocations().setJREContainerPath(this.getOS(this.fLastTab), eePath);
    }

    private void setJRE(IVMInstall install) {
        IPath jrePath = null;
        if (install != null) {
            jrePath = JavaRuntime.newJREContainerPath((IVMInstall)install);
        }
        this.getJVMLocations().setJREContainerPath(this.getOS(this.fLastTab), jrePath);
    }

    private IProductModel getProductModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void dispose() {
        IProductModel model = this.getProductModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createTabs() {
        int i = 0;
        while (i < TAB_LABELS.length) {
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(TAB_LABELS[i]);
            item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
            ++i;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
        String currentTarget = TargetPlatform.getOS();
        if ("win32".equals(currentTarget)) {
            this.fTabFolder.setSelection(3);
        } else if ("macosx".equals(currentTarget)) {
            this.fTabFolder.setSelection(1);
        } else if ("solaris".equals(currentTarget)) {
            this.fTabFolder.setSelection(2);
        }
    }

    public void refresh() {
        this.fBlockChanges = true;
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        IPath jrePath = this.getJVMLocations().getJREContainerPath(this.getOS(this.fLastTab));
        if (jrePath != null) {
            String eeID = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
            IExecutionEnvironment env = VMUtil.getExecutionEnvironment((String)eeID);
            if (env != null) {
                if (!this.fEEsCombo.getItems().contains(env)) {
                    this.fEEsCombo.addItem(env);
                }
                this.fEEsCombo.select(env);
                this.fNoneRadioButton.setSelection(false);
                this.fEERadioButton.setSelection(true);
                this.fJRERadioButton.setSelection(false);
                this.fJREsCombo.select(null);
            } else {
                IVMInstall install = JavaRuntime.getVMInstall((IPath)jrePath);
                if (install != null) {
                    if (!this.fJREsCombo.getItems().contains(install)) {
                        this.fJREsCombo.addItem(install);
                    }
                    this.fJREsCombo.select(install);
                    this.fNoneRadioButton.setSelection(false);
                    this.fJRERadioButton.setSelection(true);
                    this.fEERadioButton.setSelection(false);
                    this.fEEsCombo.select(null);
                }
            }
        } else {
            this.fNoneRadioButton.setSelection(true);
            this.fJRERadioButton.setSelection(false);
            this.fJREsCombo.select(null);
            this.fEERadioButton.setSelection(false);
            this.fEEsCombo.select(null);
        }
        this.updateWidgets();
        super.refresh();
        this.fBlockChanges = false;
    }

    private IJREInfo getJVMLocations() {
        IJREInfo info = this.getProduct().getJREInfo();
        if (info == null) {
            info = this.getModel().getFactory().createJVMInfo();
            this.getProduct().setJREInfo(info);
        }
        return info;
    }

    private String getOS(int tab) {
        if (tab >= 0 && tab < TAB_OS.length) {
            return TAB_OS[tab];
        }
        return null;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    protected void updateWidgets() {
        this.fJREsCombo.setEnabled(this.fJRERadioButton.getSelection());
        this.fEEsCombo.setEnabled(this.fEERadioButton.getSelection());
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl(this.fJREsCombo.getControl());
    }

    private final class EELabelProvider
    extends LabelProvider {
        private EELabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof IExecutionEnvironment)) {
                return "";
            }
            IExecutionEnvironment env = (IExecutionEnvironment)element;
            IPath path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
            IVMInstall install = JavaRuntime.getVMInstall((IPath)path);
            String eeItem = install != null ? MessageFormat.format((String)PDEUIMessages.JRESection_eeBoundJRE, (Object[])new String[]{env.getId(), install.getName()}) : MessageFormat.format((String)PDEUIMessages.JRESection_eeUnboundJRE, (Object[])new String[]{env.getId()});
            return eeItem;
        }
    }

    private final class JRELabelProvider
    extends LabelProvider {
        private JRELabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof IVMInstall)) {
                return "";
            }
            IVMInstall vm = (IVMInstall)element;
            return vm.getName();
        }
    }
}

