/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.itarget.IArgumentsInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ArgumentsSection
extends PDESection {
    private static final String[] TAB_LABELS = new String[2];
    private CTabFolder fTabFolder;
    private FormEntry fArgument;
    private int fLastTab;
    private Image fImage = PDEPluginImages.DESC_ARGUMENT_TAB.createImage();

    static {
        ArgumentsSection.TAB_LABELS[0] = PDEUIMessages.ArgumentsSection_programTabLabel;
        ArgumentsSection.TAB_LABELS[1] = PDEUIMessages.ArgumentsSection_vmTabLabel;
    }

    public ArgumentsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(PDEUIMessages.ArgumentsSection_editorTitle);
        section.setDescription(PDEUIMessages.ArgumentsSection_description);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        client.setLayoutData((Object)gd);
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ArgumentsSection.this.fArgument.isDirty()) {
                    ArgumentsSection.this.fArgument.commit();
                }
                ArgumentsSection.this.refresh();
            }
        });
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fArgument = new FormEntry(client, toolkit, PDEUIMessages.ArgumentsSection_argumentsTextLabel, 66);
        this.fArgument.getText().setLayoutData((Object)new GridData(1808));
        this.fArgument.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                if (ArgumentsSection.this.fLastTab == 0) {
                    ArgumentsSection.this.getArgumentInfo().setProgramArguments(ArgumentsSection.this.fArgument.getValue());
                } else {
                    ArgumentsSection.this.getArgumentInfo().setVMArguments(ArgumentsSection.this.fArgument.getValue());
                }
            }
        });
        Button variables = toolkit.createButton(client, PDEUIMessages.ArgumentsSection_variableButtonTitle, 0);
        variables.setLayoutData((Object)new GridData(128));
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ArgumentsSection.this.getSection().getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ArgumentsSection.this.fArgument.getText().insert(variable);
                }
            }
        });
        this.createTabs();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    private void createTabs() {
        int i = 0;
        while (i < TAB_LABELS.length) {
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(TAB_LABELS[i]);
            item.setImage(this.fImage);
            ++i;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
    }

    private IArgumentsInfo getArgumentInfo() {
        IArgumentsInfo info = this.getTarget().getArguments();
        if (info == null) {
            info = this.getModel().getFactory().createArguments();
            this.getTarget().setArguments(info);
        }
        return info;
    }

    private ITarget getTarget() {
        return this.getModel().getTarget();
    }

    private ITargetModel getModel() {
        return (ITargetModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void refresh() {
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        if (this.fLastTab == 0) {
            this.fArgument.setValue(this.getArgumentInfo().getProgramArguments(), true);
        } else {
            this.fArgument.setValue(this.getArgumentInfo().getVMArguments(), true);
        }
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fArgument.commit();
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.fArgument.cancelEdit();
        super.cancelEdit();
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    public void dispose() {
        ITargetModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        super.dispose();
    }
}

