/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetFeature;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.itarget.ITargetModelFactory;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.ConditionalListSelectionDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyCalculator;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.wizards.FeatureSelectionDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ContentSection
extends TableSection {
    private static final String[] TAB_LABELS = new String[2];
    private static final String[] BUTTONS;
    private TableViewer fContentViewer;
    private CTabFolder fTabFolder;
    private int fLastTab;
    private Button fUseAllPlugins;
    private Button fUseSelectedPlugins;
    private Image[] fTabImages;
    private Button fIncludeOptionalButton;
    public static final QualifiedName OPTIONAL_PROPERTY;

    static {
        ContentSection.TAB_LABELS[0] = PDEUIMessages.ContentSection_plugins;
        ContentSection.TAB_LABELS[1] = PDEUIMessages.ContentSection_features;
        BUTTONS = new String[5];
        ContentSection.BUTTONS[0] = PDEUIMessages.ContentSection_add;
        ContentSection.BUTTONS[1] = PDEUIMessages.ContentSection_remove;
        ContentSection.BUTTONS[2] = PDEUIMessages.ContentSection_removeAll;
        ContentSection.BUTTONS[3] = PDEUIMessages.ContentSection_workingSet;
        ContentSection.BUTTONS[4] = PDEUIMessages.ContentSection_required;
        OPTIONAL_PROPERTY = new QualifiedName("org.eclipse.pde.ui", "target.includeOptional");
    }

    public ContentSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, BUTTONS);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        client.setLayoutData((Object)new GridData(1808));
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentSection.this.getTarget().setUseAllPlugins(ContentSection.this.fUseAllPlugins.getSelection());
            }
        };
        this.fUseAllPlugins = toolkit.createButton(client, PDEUIMessages.ContentSection_allTarget, 16);
        this.fUseAllPlugins.addSelectionListener((SelectionListener)radioListener);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUseAllPlugins.setLayoutData((Object)gd);
        this.fUseSelectedPlugins = toolkit.createButton(client, PDEUIMessages.ContentSection_selectedOnly, 16);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        this.fUseSelectedPlugins.setLayoutData((Object)gd);
        this.fTabFolder = new CTabFolder(client, 0x800080);
        gd = new GridData(768);
        gd.heightHint = 2;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 15;
        this.fTabFolder.setLayoutData((Object)gd);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentSection.this.refresh();
            }
        });
        this.createTabs();
        this.createViewerPartControl(client, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 15;
        this.fContentViewer = tablePart.getTableViewer();
        this.fContentViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fContentViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fContentViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ITargetPlugin) {
                    ITargetPlugin p1 = (ITargetPlugin)e1;
                    ITargetPlugin p2 = (ITargetPlugin)e2;
                    return super.compare(viewer, (Object)p1.getId(), (Object)p2.getId());
                }
                ITargetFeature f1 = (ITargetFeature)e1;
                ITargetFeature f2 = (ITargetFeature)e2;
                return super.compare(viewer, (Object)f1.getId(), (Object)f2.getId());
            }
        });
        this.fContentViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fContentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ContentSection.this.updateEnablement();
            }
        });
        this.createOptionalDependenciesButton(client);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        section.setText(PDEUIMessages.ContentSection_targetContent);
        section.setDescription(PDEUIMessages.ContentSection_targetContentDesc);
        section.setLayoutData((Object)new GridData(1808));
        this.updateEnablement();
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void createOptionalDependenciesButton(Composite client) {
        if (this.isEditable()) {
            this.fIncludeOptionalButton = new Button(client, 32);
            this.fIncludeOptionalButton.setText(PDEUIMessages.ContentSection_includeOptional);
            IEditorInput input = this.getPage().getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                try {
                    this.fIncludeOptionalButton.setSelection("true".equals(file.getPersistentProperty(OPTIONAL_PROPERTY)));
                }
                catch (CoreException coreException) {}
            }
            this.fIncludeOptionalButton.setEnabled(!this.getTarget().useAllPlugins());
            this.fIncludeOptionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IEditorInput input = ContentSection.this.getPage().getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)input).getFile();
                        try {
                            file.setPersistentProperty(OPTIONAL_PROPERTY, ContentSection.this.fIncludeOptionalButton.getSelection() ? "true" : null);
                        }
                        catch (CoreException coreException) {}
                    }
                }
            });
        }
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleDelete();
                break;
            }
            case 2: {
                this.handleRemoveAll();
                break;
            }
            case 3: {
                this.handleAddWorkingSet();
                break;
            }
            case 4: {
                ContentSection.handleAddRequired(this.getTarget().getPlugins(), this.fIncludeOptionalButton.getSelection());
            }
        }
    }

    private void createTabs() {
        this.fTabImages = new Image[]{PDEPluginImages.DESC_PLUGIN_OBJ.createImage(), PDEPluginImages.DESC_FEATURE_OBJ.createImage()};
        int i = 0;
        while (i < TAB_LABELS.length) {
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(TAB_LABELS[i]);
            item.setImage(this.fTabImages[i]);
            ++i;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
    }

    public void refresh() {
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        this.fContentViewer.refresh();
        this.updateEnablement();
        super.refresh();
    }

    protected void updateEnablement() {
        boolean useAllPlugins = this.getTarget().useAllPlugins();
        this.fUseAllPlugins.setSelection(useAllPlugins);
        this.fUseSelectedPlugins.setSelection(!useAllPlugins);
        EditableTablePart table = this.getTablePart();
        boolean itemsSelected = !this.fContentViewer.getSelection().isEmpty();
        boolean hasItems = this.fContentViewer.getTable().getItemCount() > 0;
        table.setEnabled(!useAllPlugins);
        table.setButtonEnabled(0, this.isEditable() && !useAllPlugins);
        table.setButtonEnabled(1, this.isEditable() && !useAllPlugins && itemsSelected);
        table.setButtonEnabled(2, this.isEditable() && !useAllPlugins && hasItems);
        boolean pluginTab = this.fLastTab == 0;
        table.setButtonEnabled(3, this.isEditable() && pluginTab && !useAllPlugins);
        table.setButtonEnabled(4, this.isEditable() && pluginTab && !useAllPlugins && hasItems);
        table.setButtonVisible(3, pluginTab);
        table.setButtonVisible(4, pluginTab);
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ITargetPlugin && this.fLastTab == 0 || objects[i] instanceof ITargetFeature && this.fLastTab == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ITarget getTarget() {
        return this.getModel().getTarget();
    }

    private ITargetModel getModel() {
        return (ITargetModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    private void handleAdd() {
        if (this.fLastTab == 0) {
            this.handleAddPlugin();
        } else {
            this.handleAddFeature();
        }
        this.updateEnablement();
    }

    private void handleAddPlugin() {
        ConditionalListSelectionDialog dialog = new ConditionalListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)PDEPlugin.getDefault().getLabelProvider(), PDEUIMessages.ContentSection_addDialogButtonLabel);
        TreeMap map = this.getBundles();
        dialog.setElements(map.values().toArray());
        dialog.setConditionalElements(this.getWorkspaceBundles(map).values().toArray());
        dialog.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        dialog.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        dialog.setMultipleSelection(true);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.plugin_selection");
        if (dialog.open() == 0) {
            Object[] bundles = dialog.getResult();
            ITarget target = this.getTarget();
            ITargetModelFactory factory = this.getModel().getFactory();
            ITargetPlugin[] plugins = new ITargetPlugin[bundles.length];
            int i = 0;
            while (i < bundles.length) {
                String id = ((BundleDescription)bundles[i]).getSymbolicName();
                ITargetPlugin plugin = factory.createPlugin();
                plugin.setId(id);
                plugins[i] = plugin;
                ++i;
            }
            target.addPlugins(plugins);
            this.fContentViewer.setSelection((ISelection)new StructuredSelection((Object)plugins[plugins.length - 1]));
        }
    }

    private TreeMap getBundles() {
        TreeMap<String, BundleDescription> map = new TreeMap<String, BundleDescription>();
        ITarget target = this.getTarget();
        IPluginModelBase[] models = PluginRegistry.getExternalModels();
        int i = 0;
        while (i < models.length) {
            BundleDescription desc = ((ExternalPluginModelBase)models[i]).getBundleDescription();
            String id = desc.getSymbolicName();
            if (!target.containsPlugin(id)) {
                map.put(id, desc);
            }
            ++i;
        }
        return map;
    }

    protected TreeMap getWorkspaceBundles(TreeMap used) {
        TreeMap<String, BundleDescription> map = new TreeMap<String, BundleDescription>();
        ITarget target = this.getTarget();
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        int i = 0;
        while (i < models.length) {
            BundleDescription desc = models[i].getBundleDescription();
            String id = desc.getSymbolicName();
            if (id != null && !target.containsPlugin(id) && !used.containsKey(id)) {
                map.put(id, desc);
            }
            ++i;
        }
        return map;
    }

    private void handleAddFeature() {
        IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
        ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
        ITarget target = this.getTarget();
        int i = 0;
        while (i < allModels.length) {
            if (!target.containsFeature(allModels[i].getFeature().getId())) {
                newModels.add(allModels[i]);
            }
            ++i;
        }
        IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
        FeatureSelectionDialog dialog = new FeatureSelectionDialog(this.getSection().getShell(), candidateModels, true);
        if (dialog.open() == 0) {
            Object[] models = dialog.getResult();
            ITargetModelFactory factory = this.getModel().getFactory();
            ITargetFeature[] features = new ITargetFeature[models.length];
            int i2 = 0;
            while (i2 < models.length) {
                IFeature feature = ((IFeatureModel)models[i2]).getFeature();
                String id = feature.getId();
                ITargetFeature tfeature = factory.createFeature();
                tfeature.setId(id);
                features[i2] = tfeature;
                ++i2;
            }
            target.addFeatures(features);
            this.fContentViewer.setSelection((ISelection)new StructuredSelection((Object)features[features.length - 1]));
        }
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fContentViewer.getSelection();
        if (ssel.size() > 0) {
            Object[] objects = ssel.toArray();
            ITarget target = this.getTarget();
            if (this.fLastTab == 0) {
                ITargetPlugin[] plugins = new ITargetPlugin[objects.length];
                System.arraycopy(objects, 0, plugins, 0, objects.length);
                target.removePlugins(plugins);
            } else {
                ITargetFeature[] features = new ITargetFeature[objects.length];
                System.arraycopy(objects, 0, features, 0, objects.length);
                target.removeFeatures(features);
            }
        }
        this.updateEnablement();
    }

    private void handleRemoveAll() {
        TableItem[] items = this.fContentViewer.getTable().getItems();
        ITarget target = this.getTarget();
        if (this.fLastTab == 0) {
            ITargetPlugin[] plugins = new ITargetPlugin[items.length];
            int i = 0;
            while (i < plugins.length) {
                plugins[i] = (ITargetPlugin)items[i].getData();
                ++i;
            }
            target.removePlugins(plugins);
        } else {
            ITargetFeature[] features = new ITargetFeature[items.length];
            int i = 0;
            while (i < features.length) {
                features[i] = (ITargetFeature)items[i].getData();
                ++i;
            }
            target.removeFeatures(features);
        }
        this.updateEnablement();
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen(selection);
    }

    private void handleOpen(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof ITargetPlugin) {
            ManifestEditor.openPluginEditor(((ITargetPlugin)object).getId());
        } else if (object instanceof ITargetFeature) {
            this.handleOpenFeature((ITargetFeature)object);
        }
    }

    private void handleOpenFeature(ITargetFeature feature) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModel(feature.getId());
        FeatureEditor.openFeatureEditor(model);
    }

    private void handleAddWorkingSet() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), true);
        if (dialog.open() == 0) {
            IWorkingSet[] workingSets = dialog.getSelection();
            ITarget target = this.getTarget();
            ITargetModelFactory factory = target.getModel().getFactory();
            HashSet<ITargetPlugin> plugins = new HashSet<ITargetPlugin>();
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IPluginModelBase model = this.findModel(elements[j]);
                    if (model != null) {
                        ITargetPlugin plugin = factory.createPlugin();
                        plugin.setId(model.getPluginBase().getId());
                        plugins.add(plugin);
                    }
                    ++j;
                }
                ++i;
            }
            target.addPlugins(plugins.toArray(new ITargetPlugin[plugins.size()]));
        }
        this.updateEnablement();
    }

    private IPluginModelBase findModel(IAdaptable object) {
        if (object instanceof IJavaProject) {
            object = ((IJavaProject)object).getProject();
        }
        if (object instanceof IProject) {
            return PluginRegistry.findModel((IProject)((IProject)object));
        }
        if (object instanceof PersistablePluginObject) {
            return PluginRegistry.findModel((String)((PersistablePluginObject)object).getPluginID());
        }
        return null;
    }

    public static void handleAddRequired(ITargetPlugin[] plugins, boolean includeOptional) {
        if (plugins.length == 0) {
            return;
        }
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>(plugins.length);
        int i = 0;
        while (i < plugins.length) {
            list.add(TargetPlatformHelper.getState().getBundle(plugins[i].getId(), null));
            ++i;
        }
        DependencyCalculator calculator = new DependencyCalculator(includeOptional);
        calculator.findDependencies(list.toArray());
        Set dependencies = calculator.getBundleIDs();
        ITarget target = plugins[0].getTarget();
        ITargetModelFactory factory = target.getModel().getFactory();
        ITargetPlugin[] pluginsToAdd = new ITargetPlugin[dependencies.size()];
        int i2 = 0;
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            String id = iter.next().toString();
            ITargetPlugin plugin = factory.createPlugin();
            plugin.setId(id);
            pluginsToAdd[i2++] = plugin;
        }
        target.addPlugins(pluginsToAdd);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        Object[] objects = e.getChangedObjects();
        if (e.getChangeType() == 1) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof ITargetPlugin && this.fLastTab == 0 || objects[i] instanceof ITargetFeature && this.fLastTab == 1) {
                    this.fContentViewer.add(objects[i]);
                }
                ++i;
            }
        } else if (e.getChangeType() == 2) {
            Table table = this.fContentViewer.getTable();
            int index = table.getSelectionIndex();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof ITargetPlugin && this.fLastTab == 0 || objects[i] instanceof ITargetFeature && this.fLastTab == 1) {
                    this.fContentViewer.remove(objects[i]);
                }
                ++i;
            }
            int count = table.getItemCount();
            if (count != 0) {
                if (index < count) {
                    table.setSelection(index);
                } else {
                    table.setSelection(count - 1);
                }
            }
        }
        if (e.getChangedProperty() == "useAllPlugins") {
            this.refresh();
            this.fIncludeOptionalButton.setEnabled((Boolean)e.getNewValue() == false);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.fContentViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.refresh();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.handleSelectAll();
            return true;
        }
        return false;
    }

    private void handleSelectAll() {
        this.fContentViewer.getTable().selectAll();
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection ssel = (IStructuredSelection)this.fContentViewer.getSelection();
        if (ssel == null) {
            return;
        }
        Action openAction = new Action(PDEUIMessages.ContentSection_open){

            public void run() {
                ContentSection.this.handleDoubleClick((IStructuredSelection)ContentSection.this.fContentViewer.getSelection());
            }
        };
        openAction.setEnabled(this.isEditable() && ssel.size() == 1);
        manager.add((IAction)openAction);
        manager.add((IContributionItem)new Separator());
        Action removeAction = new Action(PDEUIMessages.ContentSection_remove){

            public void run() {
                ContentSection.this.handleDelete();
            }
        };
        removeAction.setEnabled(this.isEditable() && ssel.size() > 0);
        manager.add((IAction)removeAction);
        Action removeAll = new Action(PDEUIMessages.ContentSection_removeAll){

            public void run() {
                ContentSection.this.handleRemoveAll();
            }
        };
        removeAll.setEnabled(this.isEditable());
        manager.add((IAction)removeAll);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    protected void doPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ITargetPlugin && this.fLastTab == 0) {
                this.getTarget().addPlugin((ITargetPlugin)objects[i]);
            } else if (objects[i] instanceof ITargetFeature && this.fLastTab == 1) {
                this.getTarget().addFeature((ITargetFeature)objects[i]);
            }
            ++i;
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ITargetPlugin) {
            if (this.fTabFolder.getSelectionIndex() != 0) {
                this.fTabFolder.setSelection(0);
                this.refresh();
            }
            this.fContentViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        if (input instanceof ITargetFeature) {
            if (this.fTabFolder.getSelectionIndex() != 1) {
                this.fTabFolder.setSelection(1);
                this.refresh();
            }
            this.fContentViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    public void dispose() {
        ITargetModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        if (this.fTabImages != null) {
            int i = 0;
            while (i < this.fTabImages.length) {
                this.fTabImages[i].dispose();
                ++i;
            }
        }
        super.dispose();
    }

    protected boolean createCount() {
        return true;
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ITarget target = ContentSection.this.getTarget();
            if (ContentSection.this.fLastTab == 0) {
                return target.getPlugins();
            }
            return target.getFeatures();
        }
    }
}

