/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import java.util.TreeSet;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetJRE;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class JRESection
extends PDESection {
    private Button fDefaultJREButton;
    private Button fNamedJREButton;
    private Button fExecEnvButton;
    private ComboPart fNamedJREsCombo;
    private ComboPart fExecEnvsCombo;
    private TreeSet fExecEnvChoices;
    private boolean fBlockChanges;
    private Button fConfigureJREButton;
    private static String JRE_PREF_PAGE_ID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
    private static String EE_PREF_PAGE_ID = "org.eclipse.jdt.debug.ui.jreProfiles";

    public JRESection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.JRESection_title);
        section.setDescription(PDEUIMessages.JRESection_description);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        this.initializeValues();
        this.fDefaultJREButton = toolkit.createButton(client, PDEUIMessages.JRESection_defaultJRE, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fDefaultJREButton.setLayoutData((Object)gd);
        this.fDefaultJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.updateWidgets();
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.getRuntimeInfo().setDefaultJRE();
                }
            }
        });
        this.fNamedJREButton = toolkit.createButton(client, PDEUIMessages.JRESection_JREName, 16);
        this.fNamedJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.updateWidgets();
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.getRuntimeInfo().setNamedJRE(JRESection.this.fNamedJREsCombo.getSelection());
                }
            }
        });
        this.fNamedJREsCombo = new ComboPart();
        this.fNamedJREsCombo.createControl(client, toolkit, 2052);
        this.fNamedJREsCombo.getControl().setLayoutData((Object)new GridData(768));
        String[] installs = VMUtil.getVMInstallNames();
        this.fNamedJREsCombo.setItems(installs);
        this.fNamedJREsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.getRuntimeInfo().setNamedJRE(JRESection.this.fNamedJREsCombo.getSelection());
                }
            }
        });
        this.fConfigureJREButton = toolkit.createButton(client, PDEUIMessages.JRESection_jrePreference, 8);
        this.fConfigureJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.openPreferencePage(JRE_PREF_PAGE_ID);
            }
        });
        this.fExecEnvButton = toolkit.createButton(client, PDEUIMessages.JRESection_ExecutionEnv, 16);
        this.fExecEnvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.updateWidgets();
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.getRuntimeInfo().setExecutionEnvJRE(JRESection.this.fExecEnvsCombo.getSelection());
                }
            }
        });
        this.fExecEnvsCombo = new ComboPart();
        this.fExecEnvsCombo.createControl(client, toolkit, 2052);
        this.fExecEnvsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fExecEnvsCombo.setItems(this.fExecEnvChoices.toArray(new String[this.fExecEnvChoices.size()]));
        this.fExecEnvsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!JRESection.this.fBlockChanges) {
                    JRESection.this.getRuntimeInfo().setExecutionEnvJRE(JRESection.this.fExecEnvsCombo.getSelection());
                }
            }
        });
        Button configureEEButton = toolkit.createButton(client, PDEUIMessages.JRESection_eePreference, 8);
        configureEEButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRESection.this.openPreferencePage(EE_PREF_PAGE_ID);
            }
        });
        configureEEButton.setLayoutData((Object)new GridData(256));
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.fConfigureJREButton);
    }

    public void dispose() {
        ITargetModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    protected void initializeValues() {
        this.fExecEnvChoices = new TreeSet();
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
        int i = 0;
        while (i < envs.length) {
            this.fExecEnvChoices.add(envs[i].getId());
            ++i;
        }
    }

    protected void updateWidgets() {
        this.fNamedJREsCombo.setEnabled(this.fNamedJREButton.getSelection());
        this.fExecEnvsCombo.setEnabled(this.fExecEnvButton.getSelection());
    }

    private ITargetJRE getRuntimeInfo() {
        ITargetJRE info = this.getTarget().getTargetJREInfo();
        if (info == null) {
            info = this.getModel().getFactory().createJREInfo();
            this.getTarget().setTargetJREInfo(info);
        }
        return info;
    }

    private ITarget getTarget() {
        return this.getModel().getTarget();
    }

    private ITargetModel getModel() {
        return (ITargetModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void refresh() {
        this.fBlockChanges = true;
        ITargetJRE info = this.getRuntimeInfo();
        int jreType = info.getJREType();
        this.fDefaultJREButton.setSelection(jreType == 0);
        this.fNamedJREButton.setSelection(jreType == 1);
        this.fExecEnvButton.setSelection(jreType == 2);
        String jreName = info.getJREName();
        if (jreType == 1) {
            if (this.fNamedJREsCombo.indexOf(jreName) < 0) {
                this.fNamedJREsCombo.add(jreName);
            }
            this.fNamedJREsCombo.select(this.fNamedJREsCombo.indexOf(jreName));
        } else if (jreType == 2) {
            if (this.fExecEnvsCombo.indexOf(jreName) < 0) {
                this.fExecEnvsCombo.add(jreName);
            }
            this.fExecEnvsCombo.select(this.fExecEnvsCombo.indexOf(jreName));
        }
        if (this.fExecEnvsCombo.getSelectionIndex() == -1) {
            this.fExecEnvsCombo.setText(this.fExecEnvChoices.first().toString());
        }
        if (this.fNamedJREsCombo.getSelectionIndex() == -1) {
            this.fNamedJREsCombo.setText(VMUtil.getDefaultVMInstallName());
        }
        this.updateWidgets();
        super.refresh();
        this.fBlockChanges = false;
    }

    private void openPreferencePage(String pageID) {
        this.fBlockChanges = true;
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getPage().getEditor().getEditorSite().getShell(), (String)pageID, (String[])new String[]{pageID}, null).open();
        this.fNamedJREsCombo.setItems(VMUtil.getVMInstallNames());
        this.fBlockChanges = false;
    }
}

