/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.AbstractHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;

public class TranslationHyperlink
extends AbstractHyperlink {
    private IModel fBase;
    private boolean fOpened;

    public TranslationHyperlink(IRegion region, String element, IModel base) {
        super(region, element);
        this.fBase = base;
    }

    private String getLocaliation() {
        String localiz = null;
        if (this.fBase instanceof IPluginModelBase) {
            localiz = PDEManager.getBundleLocalization((IPluginModelBase)((IPluginModelBase)this.fBase));
        } else if (this.fBase instanceof IBundleModel) {
            localiz = ((IBundleModel)this.fBase).getBundle().getLocalization();
        }
        return localiz;
    }

    public boolean getOpened() {
        return this.fOpened;
    }

    public void open() {
        this.fOpened = this.openHyperLink();
    }

    public boolean openHyperLink() {
        IDocument doc;
        TextEditor tEditor;
        block12: {
            IEditorPart editor;
            block11: {
                String localiz = this.getLocaliation();
                if (localiz == null) {
                    return false;
                }
                if (this.fBase.getUnderlyingResource() == null) {
                    return false;
                }
                if (this.fElement.length() == 0 || this.fElement.charAt(0) != '%') {
                    return false;
                }
                IProject proj = this.fBase.getUnderlyingResource().getProject();
                IFile file = proj.getFile(String.valueOf(localiz) + ".properties");
                if (!file.exists()) {
                    return false;
                }
                editor = IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file);
                if (editor instanceof TextEditor) break block11;
                return false;
            }
            tEditor = (TextEditor)editor;
            doc = tEditor.getDocumentProvider().getDocument((Object)tEditor.getEditorInput());
            if (doc != null) break block12;
            return false;
        }
        try {
            int index;
            String key = this.fElement.substring(1);
            int keyLen = key.length();
            String contents = doc.get();
            int length = contents.length();
            int start = 0;
            while ((index = contents.indexOf(key, start)) >= 0) {
                char c;
                if (index > 0 && (c = contents.charAt(index - 1)) != '\n' && c != '\r') {
                    start += keyLen;
                    continue;
                }
                if (index + keyLen < length && !Character.isWhitespace(c = contents.charAt(index + keyLen)) && c != '=' && c != ':') {
                    start += keyLen;
                    continue;
                }
                tEditor.selectAndReveal(index, keyLen);
                break;
            }
        }
        catch (PartInitException partInitException) {
            return false;
        }
        return true;
    }
}

