/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.toc;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.toc.HelpEditorUtil;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class TocFileValidator
implements ISelectionStatusValidator {
    IBaseModel fModel;

    public TocFileValidator(IBaseModel model) {
        this.fModel = model;
    }

    public IStatus validate(Object[] selection) {
        if (selection.length == 0) {
            return this.errorStatus("");
        }
        if (!(selection[0] instanceof IFile)) {
            return this.errorStatus("");
        }
        IFile file = (IFile)selection[0];
        if (!HelpEditorUtil.isTOCFile(file.getFullPath())) {
            return this.errorStatus(PDEUIMessages.TocFileValidator_errorInvalidTOC);
        }
        if (HelpEditorUtil.isCurrentResource(file.getFullPath(), this.fModel)) {
            return this.errorStatus(PDEUIMessages.TocFileValidator_errorSameTOC);
        }
        return this.okStatus("");
    }

    private IStatus errorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 4, message, null);
    }

    private IStatus okStatus(String message) {
        return new Status(0, PDEPlugin.getPluginId(), 0, message, null);
    }
}

