/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.ui.nls.ModelChange;

public class ModelChangeElement {
    private static final String DELIM = ".";
    private static final String KEY_PREFIX = "%";
    private static final String FRAGMENT_PREFIX = "f";
    private String fValue = "";
    private String fKey = "";
    private int fOffset = 0;
    private int fLength = 0;
    private boolean fExternalized = true;
    private ModelChange fParent;
    private Object fUnderlying;

    public ModelChangeElement(ModelChange parent, Object incoming) {
        this.fParent = parent;
        this.fUnderlying = incoming;
        if (incoming instanceof PluginElementNode) {
            PluginElementNode elem = (PluginElementNode)incoming;
            IDocumentTextNode text = elem.getTextNode();
            this.fValue = elem.getText();
            this.generateValidKey(elem.getParent().getName(), elem.getName());
            this.fOffset = text.getOffset();
            this.fLength = text.getLength();
        } else if (incoming instanceof PluginAttribute) {
            PluginAttribute attr = (PluginAttribute)incoming;
            this.fValue = attr.getValue();
            this.generateValidKey(attr.getEnclosingElement().getXMLTagName(), attr.getName());
            this.fOffset = attr.getValueOffset();
            this.fLength = attr.getValueLength();
        } else if (incoming instanceof PluginExtensionPointNode) {
            PluginExtensionPointNode extP = (PluginExtensionPointNode)incoming;
            this.fValue = extP.getName();
            this.generateValidKey("extension-point", "name");
            IDocumentAttributeNode attr = extP.getDocumentAttribute("name");
            this.fOffset = attr.getValueOffset();
            this.fLength = attr.getValueLength();
        } else if (incoming instanceof ManifestHeader) {
            ManifestHeader header = (ManifestHeader)incoming;
            this.fValue = header.getValue();
            this.generateValidKey(header.getName());
            this.fLength = this.fValue.length();
            this.fOffset = header.getOffset() + header.getLength() - header.getLineLimiter().length() - this.fLength;
        }
    }

    public String getKey() {
        return this.fKey;
    }

    public void setKey(String key) {
        this.fKey = key;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public boolean isExternalized() {
        return this.fExternalized;
    }

    public void setExternalized(boolean externalzied) {
        this.fExternalized = externalzied;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    private void generateValidKey(String pre, String mid) {
        this.generateValidKey(String.valueOf(pre) + DELIM + mid);
    }

    private void generateValidKey(String key) {
        int suffix = 0;
        Properties properties = this.fParent.getProperties();
        String newKey = this.fParent.getParentModel() instanceof IFragmentModel ? String.valueOf(key) + DELIM + FRAGMENT_PREFIX : String.valueOf(key) + DELIM;
        while (properties.containsKey(String.valueOf(newKey) + suffix)) {
            ++suffix;
        }
        properties.setProperty(String.valueOf(newKey) + suffix, this.fValue);
        this.fKey = String.valueOf(newKey) + suffix;
    }

    public String getExternKey() {
        return KEY_PREFIX + this.fKey;
    }

    public boolean updateValue() {
        block6: {
            try {
                String key = this.getExternKey();
                if (this.fUnderlying instanceof PluginElementNode) {
                    PluginElementNode elem = (PluginElementNode)this.fUnderlying;
                    elem.setText(key);
                    break block6;
                }
                if (this.fUnderlying instanceof PluginAttribute) {
                    PluginAttribute attr = (PluginAttribute)this.fUnderlying;
                    String attrName = attr.getName();
                    attr.getEnclosingElement().setXMLAttribute(attrName, key);
                    break block6;
                }
                if (this.fUnderlying instanceof PluginExtensionPointNode) {
                    PluginExtensionPointNode extP = (PluginExtensionPointNode)this.fUnderlying;
                    extP.setName(key);
                    break block6;
                }
                if (this.fUnderlying instanceof ManifestHeader) {
                    ManifestHeader header = (ManifestHeader)this.fUnderlying;
                    header.setValue(key);
                    break block6;
                }
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return true;
    }
}

