/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PluginSelectionDialog
extends ElementListSelectionDialog {
    public PluginSelectionDialog(Shell parentShell, boolean includeFragments, boolean multipleSelection) {
        this(parentShell, PluginSelectionDialog.getElements(includeFragments), multipleSelection);
    }

    public PluginSelectionDialog(Shell parentShell, IPluginModelBase[] models, boolean multipleSelection) {
        super(parentShell, (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        this.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        this.setElements(models);
        this.setMultipleSelection(multipleSelection);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.plugin_selection");
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    private static IPluginModelBase[] getElements(boolean includeFragments) {
        return PluginRegistry.getActiveModels((boolean)includeFragments);
    }

    public static HashSet getExistingImports(IPluginModelBase model, boolean includeImportPkg) {
        IFragment fragment;
        IPluginModelBase host;
        HashSet existingImports = new HashSet();
        PluginSelectionDialog.addSelfAndDirectImports(existingImports, model);
        if (model instanceof IFragmentModel && (host = PluginRegistry.findModel((String)(fragment = ((IFragmentModel)model).getFragment()).getPluginId())) instanceof IPluginModel) {
            PluginSelectionDialog.addSelfAndDirectImports(existingImports, host);
        }
        if (includeImportPkg && model instanceof IBundlePluginModelBase) {
            PluginSelectionDialog.addImportedPackages((IBundlePluginModelBase)model, existingImports);
        }
        return existingImports;
    }

    private static void addSelfAndDirectImports(HashSet set, IPluginModelBase model) {
        set.add(model.getPluginBase().getId());
        IPluginImport[] imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            String id = imports[i].getId();
            if (set.add(id)) {
                PluginSelectionDialog.addReexportedImport(set, id);
            }
            ++i;
        }
    }

    private static void addReexportedImport(HashSet set, String id) {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model != null) {
            IPluginImport[] imports = model.getPluginBase().getImports();
            int i = 0;
            while (i < imports.length) {
                if (imports[i].isReexported() && set.add(imports[i].getId())) {
                    PluginSelectionDialog.addReexportedImport(set, imports[i].getId());
                }
                ++i;
            }
        }
    }

    private static void addImportedPackages(IBundlePluginModelBase base, HashSet existingImports) {
        HashMap map = PluginSelectionDialog.getImportPackages(base);
        if (map == null) {
            return;
        }
        ExportPackageDescription[] exported = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
        int i = 0;
        while (i < exported.length) {
            ImportPackageObject ipo = (ImportPackageObject)map.get(exported[i].getName());
            if (ipo != null) {
                String version = ipo.getVersion();
                if (version != null) {
                    try {
                        if (!new VersionRange(version).isIncluded(exported[i].getVersion())) {
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    existingImports.add(exported[i].getSupplier().getSymbolicName());
                }
            }
            ++i;
        }
    }

    private static HashMap getImportPackages(IBundlePluginModelBase base) {
        ImportPackageHeader header;
        IBundleModel bmodel = base.getBundleModel();
        if (bmodel != null && (header = (ImportPackageHeader)bmodel.getBundle().getManifestHeader("Import-Package")) != null) {
            HashMap<String, ImportPackageObject> map = new HashMap<String, ImportPackageObject>();
            ImportPackageObject[] packages = header.getPackages();
            int i = 0;
            while (i < packages.length) {
                map.put(packages[i].getName(), packages[i]);
                ++i;
            }
            return map;
        }
        return null;
    }
}

