/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.cheatsheet;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.CSCategoryTrackerUtil;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.IRegisterCSData;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.NewCategoryNameDialog;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.RegisterCSOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class RegisterCSWizardPage
extends WizardPage
implements IRegisterCSData {
    public static final String F_PAGE_NAME = "register-cs";
    public static final String F_CS_ELEMENT_CATEGORY = "category";
    public static final String F_CS_ELEMENT_CHEATSHEET = "cheatsheet";
    public static final String F_CS_ELEMENT_DESCRIPTION = "description";
    private static final String F_LOCALE_VARIABLE = "$nl$/";
    private Combo fCategoryCombo;
    private Button fCategoryButton;
    private Text fDescriptionText;
    protected IModel fCheatSheetModel;
    private ISharedExtensionsModel fExtensionsModel;
    private IProject fPluginProject;
    private String fDataCategoryName;
    private String fDataDescription;
    private String fDataCheatSheetID;
    private CSCategoryTrackerUtil fCategoryTrackerUtil;

    public RegisterCSWizardPage(IModel model) {
        super(F_PAGE_NAME);
        this.fCheatSheetModel = model;
        this.initialize();
    }

    private void initialize() {
        this.setTitle(PDEUIMessages.CheatSheetFileWizardPage_1);
        this.setDescription(PDEUIMessages.RegisterCSWizardPage_wizardPageDescription);
        this.fCategoryCombo = null;
        this.fCategoryButton = null;
        this.fDescriptionText = null;
        this.fCategoryTrackerUtil = new CSCategoryTrackerUtil();
        this.fDataCategoryName = null;
        this.fDataDescription = null;
        this.fPluginProject = this.fCheatSheetModel.getUnderlyingResource().getProject();
        this.fDataCheatSheetID = this.generateCheatSheetID();
        this.initializePluginModel();
    }

    private void initializePluginModel() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.getPluginProject());
        if (base == null) {
            return;
        }
        this.fExtensionsModel = base instanceof IBundlePluginModelBase ? ((IBundlePluginModelBase)base).getExtensionsModel() : base;
    }

    public String getDataDescription() {
        return this.fDataDescription;
    }

    public String getDataCategoryName() {
        return this.fDataCategoryName;
    }

    public int getDataCategoryType() {
        String categoryID = this.getDataCategoryID();
        if (categoryID == null) {
            return 0;
        }
        return this.fCategoryTrackerUtil.getCategoryType(categoryID);
    }

    public String getDataCategoryID() {
        if (this.fDataCategoryName != null) {
            return this.fCategoryTrackerUtil.getCategoryID(this.fDataCategoryName);
        }
        return null;
    }

    public String getDataContentFile() {
        String portablePath = this.fCheatSheetModel.getUnderlyingResource().getProjectRelativePath().toPortableString();
        return F_LOCALE_VARIABLE + portablePath;
    }

    public String getDataCheatSheetID() {
        return this.fDataCheatSheetID;
    }

    public IProject getPluginProject() {
        return this.fPluginProject;
    }

    public abstract String getDataCheatSheetName();

    public abstract boolean isCompositeCheatSheet();

    public void createControl(Composite parent) {
        this.createUI(parent);
        this.createUIListeners();
        this.updateUI();
        this.validateUI();
    }

    private void createUI(Composite parent) {
        Composite container = this.createUIContainer(parent);
        this.createUILabel(container);
        Group group = this.createUIGroup(container);
        this.createUICategoryField((Composite)group);
        this.createUIDescriptionField((Composite)group);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.register_cs");
    }

    private void createUILabel(Composite container) {
        Label label = new Label(container, 64);
        label.setText(PDEUIMessages.RegisterCSWizardPage_labelInstructionText);
        GridData data = new GridData(768);
        data.widthHint = 300;
        label.setLayoutData((Object)data);
    }

    private Group createUIGroup(Composite container) {
        Group group = new Group(container, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 6;
        layout.marginHeight = 6;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        data.verticalIndent = 10;
        group.setLayoutData((Object)data);
        group.setText(PDEUIMessages.RegisterCSWizardPage_groupRegistration);
        return group;
    }

    private Composite createUIContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        return container;
    }

    private void createUICategoryField(Composite parent) {
        this.createUICategoryLabel(parent);
        this.createUICategoryCombo(parent);
        this.createUICategoryButton(parent);
    }

    private void createUICategoryLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.RegisterCSWizardPage_labelCategory);
    }

    private void createUICategoryCombo(Composite parent) {
        int style = 2056;
        this.fCategoryCombo = new Combo(parent, style);
        GridData data = new GridData(768);
        this.fCategoryCombo.setLayoutData((Object)data);
        this.fCategoryCombo.add(PDEUIMessages.SimpleCSCommandDetails_6);
        this.fCategoryCombo.setText(PDEUIMessages.SimpleCSCommandDetails_6);
    }

    private void createUICategoryButton(Composite parent) {
        this.fCategoryButton = new Button(parent, 8);
        GridData data = new GridData(128);
        data.widthHint = 50;
        this.fCategoryButton.setLayoutData((Object)data);
        this.fCategoryButton.setText(PDEUIMessages.RegisterCSWizardPage_buttonNew);
        this.fCategoryButton.setToolTipText(PDEUIMessages.RegisterCSWizardPage_toolTipNewCategory);
        SWTUtil.setButtonDimensionHint(this.fCategoryButton);
    }

    private void createUIDescriptionField(Composite parent) {
        this.createUIDescriptionLabel(parent);
        this.createUIDescriptionText(parent);
    }

    private void createUIDescriptionLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.RegisterCSWizardPage_labelDescription);
        int style = 130;
        GridData data = new GridData(style);
        label.setLayoutData((Object)data);
    }

    private void createUIDescriptionText(Composite parent) {
        int style = 2626;
        this.fDescriptionText = new Text(parent, style);
        GridData data = new GridData(768);
        data.heightHint = 60;
        data.horizontalSpan = 2;
        this.fDescriptionText.setLayoutData((Object)data);
    }

    private void createUIListeners() {
        this.createUIListenersCategoryButton();
        this.createUIListenersCategoryCombo();
        this.createUIListenersDescriptionText();
    }

    private void createUIListenersCategoryButton() {
        this.fCategoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegisterCSWizardPage.this.handleWidgetSelectedCategoryButton();
            }
        });
    }

    private void createUIListenersCategoryCombo() {
        this.fCategoryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegisterCSWizardPage.this.fDataCategoryName = RegisterCSWizardPage.this.fCategoryCombo.getText();
            }
        });
    }

    private void createUIListenersDescriptionText() {
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegisterCSWizardPage.this.fDataDescription = RegisterCSWizardPage.this.fDescriptionText.getText();
            }
        });
    }

    private void handleWidgetSelectedCategoryButton() {
        String newCategoryName;
        NewCategoryNameDialog dialog = new NewCategoryNameDialog(PDEPlugin.getActiveWorkbenchShell());
        dialog.create();
        dialog.getShell().setText(PDEUIMessages.RegisterCSWizardPage_dialogTitleNewCategory);
        if (dialog.open() == 0 && PDETextHelper.isDefinedAfterTrim((String)(newCategoryName = dialog.getNameText()))) {
            String trimmedText = newCategoryName.trim();
            this.fCategoryCombo.add(trimmedText);
            this.fCategoryCombo.setText(trimmedText);
            this.fCategoryCombo.setFocus();
            String id = this.generateCategoryID(trimmedText);
            this.fCategoryTrackerUtil.associate(id, trimmedText, 1);
        }
    }

    private void updateUI() {
        if (this.fExtensionsModel != null) {
            IPluginExtension[] extensions = RegisterCSOperation.findCheatSheetExtensions(this.fExtensionsModel);
            this.processCategoryElements(extensions);
            this.processCheatSheetElements(extensions);
        }
    }

    private void processCategoryElements(IPluginExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getChildCount() != 0) {
                IPluginExtension extension = extensions[i];
                IPluginObject[] pluginObjects = extension.getChildren();
                int j = 0;
                while (j < pluginObjects.length) {
                    IPluginElement element;
                    if (pluginObjects[j] instanceof IPluginElement && (element = (IPluginElement)pluginObjects[j]).getName().equals(F_CS_ELEMENT_CATEGORY)) {
                        this.updateUICategoryComboElement(element);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void processCheatSheetElements(IPluginExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getChildCount() != 0) {
                IPluginExtension extension = extensions[i];
                IPluginObject[] pluginObjects = extension.getChildren();
                int j = 0;
                while (j < pluginObjects.length) {
                    IPluginElement element;
                    if (pluginObjects[j] instanceof IPluginElement && (element = (IPluginElement)pluginObjects[j]).getName().equals(F_CS_ELEMENT_CHEATSHEET)) {
                        this.processCheatSheetElement(element, this.fDataCheatSheetID);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateUICategoryComboElement(IPluginElement parentElement) {
        IPluginAttribute idAttribute = parentElement.getAttribute("id");
        IPluginAttribute nameAttribute = parentElement.getAttribute("name");
        if (nameAttribute != null && PDETextHelper.isDefined((String)nameAttribute.getValue()) && idAttribute != null && PDETextHelper.isDefined((String)idAttribute.getValue()) && !this.fCategoryTrackerUtil.containsCategoryName(nameAttribute.getValue())) {
            this.fCategoryCombo.add(nameAttribute.getValue());
            this.fCategoryTrackerUtil.associate(idAttribute.getValue(), nameAttribute.getValue(), 2);
        }
    }

    private void updateUICategoryComboAttribute(IPluginElement element) {
        IPluginAttribute categoryAttribute = element.getAttribute(F_CS_ELEMENT_CATEGORY);
        if (categoryAttribute != null && PDETextHelper.isDefined((String)categoryAttribute.getValue())) {
            String id = categoryAttribute.getValue();
            if (this.fCategoryTrackerUtil.containsCategoryID(id)) {
                String name = this.fCategoryTrackerUtil.getCategoryName(id);
                this.fCategoryCombo.setText(name);
            } else {
                this.fCategoryCombo.add(id);
                this.fCategoryCombo.setText(id);
                this.fCategoryTrackerUtil.associate(id, id, 2);
            }
        }
    }

    private void processCheatSheetElement(IPluginElement parentElement, String generatedID) {
        IPluginAttribute idAttribute = parentElement.getAttribute("id");
        if (idAttribute != null && PDETextHelper.isDefined((String)idAttribute.getValue()) && generatedID.equals(idAttribute.getValue())) {
            if (parentElement.getChildCount() > 0) {
                this.updateUIDescriptionText(parentElement);
            }
            this.updateUICategoryComboAttribute(parentElement);
        }
    }

    private void updateUIDescriptionText(IPluginElement parentElement) {
        IPluginElement element;
        IPluginObject pluginObject = parentElement.getChildren()[0];
        if (pluginObject instanceof IPluginElement && (element = (IPluginElement)pluginObject).getName().equals(F_CS_ELEMENT_DESCRIPTION) && PDETextHelper.isDefinedAfterTrim((String)element.getText())) {
            this.fDescriptionText.setText(element.getText().trim());
        }
    }

    private void validateUI() {
        this.setPageComplete(true);
    }

    public IPluginExtension[] findExtensions(ISharedExtensionsModel model, String extensionPointID) {
        IPluginExtension[] extensions = model.getExtensions().getExtensions();
        ArrayList<IPluginExtension> csExtensions = new ArrayList<IPluginExtension>();
        int i = 0;
        while (i < extensions.length) {
            String point = extensions[i].getPoint();
            if (extensionPointID.equals(point)) {
                csExtensions.add(extensions[i]);
            }
            ++i;
        }
        return csExtensions.toArray(new IPluginExtension[csExtensions.size()]);
    }

    private String generateCheatSheetID() {
        long uniqueID = this.hash(this.fCheatSheetModel.getUnderlyingResource().getFullPath().toPortableString());
        String result = String.valueOf(this.fPluginProject.getName()) + '.' + F_CS_ELEMENT_CHEATSHEET + uniqueID;
        return result;
    }

    private String generateCategoryID(String name) {
        long uniqueID = this.hash(name);
        String result = String.valueOf(this.fPluginProject.getName()) + '.' + F_CS_ELEMENT_CATEGORY + uniqueID;
        return result;
    }

    private long hash(String string) {
        int b = 378551;
        int a = 63689;
        long hash = 0L;
        int i = 0;
        while (i < string.length()) {
            hash = hash * (long)a + (long)string.charAt(i);
            a *= b;
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }
}

