/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.JarImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportFinishDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.BundleException;

public class PluginImportOperation
extends JarImportOperation {
    public static final int IMPORT_BINARY = 1;
    public static final int IMPORT_BINARY_WITH_LINKS = 2;
    public static final int IMPORT_WITH_SOURCE = 3;
    private IPluginModelBase[] fModels;
    private int fImportType;
    private IImportQuery fReplaceQuery;
    private Hashtable fProjectClasspaths = new Hashtable();
    private boolean fForceAutobuild;
    private IImportQuery fExecutionQuery;
    private boolean fLaunchedConfigurations = false;
    private ArrayList fUnableToDeletePlugins;

    public PluginImportOperation(IPluginModelBase[] models, int importType, IImportQuery replaceQuery, IImportQuery executionQuery) {
        this.fModels = models;
        this.fImportType = importType;
        this.fReplaceQuery = replaceQuery;
        this.fExecutionQuery = executionQuery;
        this.fUnableToDeletePlugins = new ArrayList();
    }

    public PluginImportOperation(IPluginModelBase[] models, int importType, IImportQuery replaceQuery, IImportQuery executionQuery, boolean forceAutobuild) {
        this(models, importType, replaceQuery, executionQuery);
        this.fForceAutobuild = forceAutobuild;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(PDEUIMessages.ImportWizard_operation_creating, this.fModels.length + 1);
        try {
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEUIMessages.ImportWizard_operation_multiProblem, null);
            int i = 0;
            while (i < this.fModels.length) {
                try {
                    this.importPlugin(this.fModels[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    multiStatus.merge(e.getStatus());
                }
                if (monitor.isCanceled()) {
                    this.setClasspaths((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    throw new OperationCanceledException();
                }
                ++i;
            }
            this.setClasspaths((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding() && this.fForceAutobuild) {
                this.runBuildJob();
            }
            if (!multiStatus.isOK()) {
                throw new CoreException((IStatus)multiStatus);
            }
        }
        catch (Throwable throwable) {
            monitor.done();
            if (!this.fUnableToDeletePlugins.isEmpty()) {
                Display display = Display.getDefault();
                display.syncExec(new Runnable(display){
                    private final /* synthetic */ Display val$display;
                    {
                        this.val$display = display;
                    }

                    public void run() {
                        PluginImportFinishDialog dialog = new PluginImportFinishDialog(this.val$display.getActiveShell());
                        dialog.setTitle(PDEUIMessages.PluginImportInfoDialog_title);
                        dialog.setMessage(PDEUIMessages.PluginImportInfoDialog_message);
                        dialog.setInput(PluginImportOperation.this.fUnableToDeletePlugins);
                        dialog.open();
                    }
                });
            }
            throw throwable;
        }
        monitor.done();
        if (!this.fUnableToDeletePlugins.isEmpty()) {
            Display display = Display.getDefault();
            display.syncExec(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void runBuildJob() {
        Job buildJob = new Job(PDEUIMessages.CompilersConfigurationBlock_building){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_AUTO_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PDEPlugin.getWorkspace().build(10, monitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.schedule();
    }

    private void setClasspaths(IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask("", this.fProjectClasspaths.size());
        Enumeration keys = this.fProjectClasspaths.keys();
        while (keys.hasMoreElements()) {
            IProject project = (IProject)keys.nextElement();
            IClasspathEntry[] classpath = (IClasspathEntry[])this.fProjectClasspaths.get(project);
            monitor.subTask(project.getName());
            JavaCore.create((IProject)project).setRawClasspath(classpath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importPlugin(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        String id = model.getPluginBase().getId();
        monitor.beginTask(NLS.bind((String)PDEUIMessages.ImportWizard_operation_creating2, (Object)id), 6);
        try {
            BundleDescription desc = model.getBundleDescription();
            if (desc != null) {
                String message;
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                String[] envs = desc.getExecutionEnvironments();
                boolean found = false;
                int i = 0;
                while (i < envs.length) {
                    if (manager.getEnvironment(envs[i]) != null) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (envs.length > 0 && !found && !this.queryExecutionEnvironment(message = NLS.bind((String)PDEUIMessages.PluginImportOperation_executionEnvironment, (Object)id, (Object)envs[0]))) {
                    return;
                }
            }
            try {
                File location;
                IProject project = this.findProject(id);
                if (project.exists() || new File(project.getParent().getLocation().toFile(), project.getName()).exists()) {
                    if (!this.queryReplace(project)) return;
                    if (RepositoryProvider.isShared((IProject)project)) {
                        RepositoryProvider.unmap((IProject)project);
                    }
                    if (!project.exists()) {
                        project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (!this.safeDeleteCheck(project, monitor)) {
                        this.fUnableToDeletePlugins.add(model);
                        return;
                    }
                    try {
                        project.delete(true, true, monitor);
                    }
                    catch (CoreException coreException) {
                        this.fUnableToDeletePlugins.add(model);
                        return;
                    }
                }
                project.create(monitor);
                if (!project.isOpen()) {
                    project.open(monitor);
                }
                monitor.worked(1);
                if (Platform.inDevelopmentMode() && (location = new File(model.getInstallLocation())).isDirectory()) {
                    File classpathFile = new File(location, ".classpath");
                    File projectFile = new File(location, ".project");
                    if (classpathFile.exists() && classpathFile.isFile() && projectFile.exists() && projectFile.isFile()) {
                        this.importContent(location, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        return;
                    }
                }
                switch (this.fImportType) {
                    case 1: {
                        this.importAsBinary(project, model, true, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                        break;
                    }
                    case 2: {
                        if (id.startsWith("org.eclipse.swt") && !this.isJARd(model)) {
                            this.importAsBinary(project, model, true, monitor);
                            break;
                        }
                        this.importAsBinaryWithLinks(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                        break;
                    }
                    case 3: {
                        if (this.isExempt(model)) {
                            this.importAsBinary(project, model, true, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            break;
                        }
                        this.importAsSource(project, model, new SubProgressMonitor(monitor, 4));
                    }
                }
                this.setProjectDescription(project, model);
                if (!project.hasNature("org.eclipse.jdt.core.javanature") || project.findMember(".classpath") != null) return;
                this.fProjectClasspaths.put(project, ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, (boolean)true, (boolean)false));
                return;
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
            return;
        }
        finally {
            monitor.done();
        }
    }

    protected String getProjectName(IPluginModelBase model) {
        String id = model.getPluginBase().getId();
        String version = model.getPluginBase().getVersion();
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry != null) {
            IPluginModelBase[] existingModels = entry.getWorkspaceModels();
            int i = 0;
            while (i < existingModels.length) {
                IResource res;
                String existingVersion = existingModels[i].getPluginBase().getVersion();
                if (version.equals(existingVersion) && (res = existingModels[i].getUnderlyingResource()) != null) {
                    return res.getProject().getName();
                }
                ++i;
            }
        }
        return String.valueOf(id) + "_" + version;
    }

    private boolean safeDeleteCheck(IProject project, IProgressMonitor monitor) {
        if (!this.fLaunchedConfigurations) {
            return true;
        }
        IPluginModelBase base = PluginRegistry.findModel((IProject)project);
        if (base != null) {
            IPluginLibrary[] libraries = base.getPluginBase().getLibraries();
            int i = 0;
            while (i < libraries.length) {
                IResource res = project.findMember(libraries[i].getName());
                if (res != null) {
                    try {
                        if (!ResourcesPlugin.getWorkspace().delete(new IResource[]{res}, true, monitor).isOK()) {
                            return false;
                        }
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private void importAsBinaryWithLinks(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        if (this.isJARd(model)) {
            this.extractJARdPlugin(project, model, monitor);
        } else {
            File installLocation = new File(model.getInstallLocation());
            File[] items = installLocation.listFiles();
            if (items != null) {
                monitor.beginTask(PDEUIMessages.PluginImportOperation_linking, items.length + 1);
                int i = 0;
                while (i < items.length) {
                    File sourceFile = items[i];
                    String name = sourceFile.getName();
                    if (sourceFile.isDirectory()) {
                        project.getFolder(name).createLink((IPath)new Path(sourceFile.getPath()), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else if (!name.equals(".project")) {
                        project.getFile(name).createLink((IPath)new Path(sourceFile.getPath()), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        ArrayList<File> filesToImport = new ArrayList<File>(1);
                        filesToImport.add(sourceFile);
                        this.importContent(installLocation, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, filesToImport, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    ++i;
                }
            }
            this.linkSourceArchives(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
        }
        catch (TeamException teamException) {}
    }

    private void importAsBinary(IProject project, IPluginModelBase model, boolean markAsBinary, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 4);
        if (this.isJARd(model)) {
            this.extractJARdPlugin(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
        } else {
            this.importContent(new File(model.getInstallLocation()), project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.importSourceArchives(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IFragment[] fragments = this.getFragmentsFor(model);
            IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
            SubProgressMonitor fragmentMonitor = new SubProgressMonitor(monitor, 1);
            fragmentMonitor.beginTask("", libraries.length);
            int i = 0;
            while (i < libraries.length) {
                String libraryName = libraries[i].getName();
                if (ClasspathUtilCore.containsVariables((String)libraryName) && !project.exists((IPath)new Path(ClasspathUtilCore.expandLibraryName((String)libraryName)))) {
                    int j = 0;
                    while (j < fragments.length) {
                        this.importJarFromFragment(project, fragments[j], libraryName);
                        this.importSourceFromFragment(project, fragments[j], libraryName, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++j;
                    }
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
        }
        if (markAsBinary) {
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            this.importAdditionalResources(project, model, new SubProgressMonitor(monitor, 1));
        } else {
            monitor.done();
        }
    }

    private void importAsSource(IProject project, IPluginModelBase model, SubProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 4);
        this.importAsBinary(project, model, false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 2));
        List list = this.importAdditionalResources(project, model, new SubProgressMonitor((IProgressMonitor)monitor, 1));
        WorkspaceBuildModel buildModel = new WorkspaceBuildModel(project.getFile("build.properties"));
        if (!this.isJARd(model) || this.containsCode(new File(model.getInstallLocation()))) {
            String[] libraries = this.getLibraryNames(model, false);
            if (libraries.length == 0) {
                libraries = new String[]{"."};
            }
            int i = 0;
            while (i < libraries.length) {
                if (!ClasspathUtilCore.containsVariables((String)libraries[i])) {
                    String name = ClasspathUtilCore.expandLibraryName((String)libraries[i]);
                    Path libraryPath = name.equals(".") && this.isJARd(model) ? new Path(new File(model.getInstallLocation()).getName()) : new Path(name);
                    IResource jarFile = project.findMember((IPath)libraryPath);
                    if (jarFile != null) {
                        int extIndex;
                        String srcName = ClasspathUtilCore.getSourceZipName((String)libraryPath.lastSegment());
                        IResource srcZip = jarFile.getProject().findMember(srcName);
                        if (srcZip == null && (extIndex = srcName.lastIndexOf(46)) != -1) {
                            srcZip = jarFile.getProject().findMember(srcName.substring(0, extIndex));
                        }
                        if (srcZip == null && libraries[i].equals(".") && !this.isJARd(model)) {
                            srcZip = jarFile.getProject().findMember("src");
                        }
                        if (srcZip != null) {
                            String jarName = libraries[i].equals(".") ? "" : libraryPath.removeFileExtension().lastSegment();
                            String folder = this.addBuildEntry(buildModel, "source." + libraries[i], "src" + (jarName.length() == 0 ? "/" : "-" + jarName + "/"));
                            IFolder dest = jarFile.getProject().getFolder(folder);
                            if (srcZip instanceof IFolder) {
                                if (!srcZip.equals((Object)dest)) {
                                    if (dest.exists()) {
                                        dest.delete(true, null);
                                    }
                                    ((IFolder)srcZip).move(dest.getFullPath(), true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                                }
                            } else if (srcZip instanceof IFile) {
                                if (!dest.exists()) {
                                    dest.create(true, true, null);
                                }
                                this.extractZipFile(srcZip.getLocation().toFile(), dest.getFullPath(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                                srcZip.delete(true, null);
                            } else {
                                monitor.worked(1);
                            }
                            if (jarFile instanceof IFile) {
                                if (this.isJARd(model)) {
                                    this.extractJavaResources(jarFile.getLocation().toFile(), (IResource)dest, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                                } else {
                                    this.extractResources(jarFile.getLocation().toFile(), (IResource)dest, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                                }
                                jarFile.delete(true, null);
                            } else {
                                this.moveBinaryContents((IContainer)jarFile, dest, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                            }
                        }
                    } else if (name.equals(".") && project.getFolder("src").exists()) {
                        this.addBuildEntry(buildModel, "source..", "src/");
                    }
                }
                ++i;
            }
        }
        this.configureBinIncludes(buildModel, model, project);
        if (list.size() > 0) {
            this.configureSrcIncludes(buildModel, list);
        }
        buildModel.save();
    }

    private void moveBinaryContents(IContainer srcFolder, IFolder dest, IProgressMonitor monitor) {
        try {
            IResource[] children = dest.members();
            ArrayList<IResource> validFolders = new ArrayList<IResource>();
            int i = 0;
            while (i < children.length) {
                String folderName;
                IResource folder;
                if (children[i] instanceof IFolder && (folder = srcFolder.findMember(folderName = children[i].getName())) != null && folder instanceof IFolder) {
                    validFolders.add(folder);
                }
                ++i;
            }
            monitor.beginTask(new String(), validFolders.size());
            ListIterator li = validFolders.listIterator();
            while (li.hasNext()) {
                IFolder folder = (IFolder)li.next();
                int pathSegments = folder.getProjectRelativePath().segmentCount() - 1;
                Stack<IResource> stack = new Stack<IResource>();
                IResource[] resources = folder.members();
                int i2 = 0;
                while (i2 < resources.length) {
                    stack.push(resources[i2]);
                    ++i2;
                }
                while (!stack.isEmpty()) {
                    IResource res = (IResource)stack.pop();
                    if (res instanceof IFile) {
                        if (res.getName().endsWith(".class")) continue;
                        String pathName = res.getProjectRelativePath().removeFirstSegments(pathSegments).toString();
                        IFile destFile = dest.getFile(pathName);
                        if (!destFile.getParent().exists()) {
                            CoreUtility.createFolder((IFolder)((IFolder)destFile.getParent()));
                        }
                        if (destFile.exists()) {
                            destFile.delete(true, null);
                        }
                        res.move(destFile.getFullPath(), true, null);
                        continue;
                    }
                    resources = ((IFolder)res).members();
                    int i3 = 0;
                    while (i3 < resources.length) {
                        stack.push(resources[i3]);
                        ++i3;
                    }
                }
                folder.delete(true, null);
                monitor.worked(1);
            }
        }
        catch (CoreException coreException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List importAdditionalResources(IProject project, IPluginModelBase model, SubProgressMonitor monitor) throws CoreException {
        ArrayList<String> arrayList;
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        File location = manager.findSourcePlugin(model.getPluginBase());
        if (location == null) return new ArrayList(0);
        ArrayList<File> list = new ArrayList<File>();
        if (location.isDirectory()) {
            File root = location;
            File[] children = location.listFiles();
            if (children == null) return new ArrayList(0);
            int i = 0;
            while (true) {
                if (i >= children.length) break;
                String name = children[i].getName();
                if (!project.exists((IPath)new Path(name)) && !"src.zip".equals(name)) {
                    list.add(children[i]);
                }
                ++i;
            }
            this.importContent(root, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, list, (IProgressMonitor)monitor);
            ArrayList<String> srcEntryList = new ArrayList<String>(list.size());
            ListIterator iterator = list.listIterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return srcEntryList;
                }
                File current = (File)iterator.next();
                String entry = current.getName();
                if (current.isDirectory()) {
                    entry = String.valueOf(entry) + "/";
                }
                srcEntryList.add(entry);
            }
        }
        if (!location.isFile()) return new ArrayList(0);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(location);
            ZipFileStructureProvider zipProvider = new ZipFileStructureProvider(zipFile);
            ZipEntry root = zipProvider.getRoot();
            this.collectAdditionalResources(zipProvider, root, list, project);
            this.importContent(root, project.getFullPath(), (IImportStructureProvider)zipProvider, list, (IProgressMonitor)monitor);
            ArrayList<String> srcEntryList = new ArrayList<String>(list.size());
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    arrayList = srcEntryList;
                    if (zipFile == null) return arrayList;
                    break;
                }
                ZipEntry current = (ZipEntry)iterator.next();
                String entry = current.getName();
                srcEntryList.add(entry);
            }
        }
        catch (IOException e) {
            try {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (Throwable throwable) {
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            zipFile.close();
            return arrayList;
        }
        catch (IOException iOException) {}
        return arrayList;
    }

    private void configureBinIncludes(WorkspaceBuildModel buildModel, IPluginModelBase model, IProject project) throws CoreException {
        IBuild build = buildModel.getBuild(true);
        IBuildEntry entry = build.getEntry("bin.includes");
        HashMap libraryDirs = this.getSourceDirectories(build);
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("bin.includes");
            File location = new File(model.getInstallLocation());
            if (location.isDirectory()) {
                File[] files = location.listFiles();
                int i = 0;
                while (i < files.length) {
                    String token = files[i].getName();
                    if (project.findMember(token) != null || build.getEntry("source." + token) != null) {
                        if (files[i].isDirectory() && libraryDirs.containsKey(token = String.valueOf(token) + "/")) {
                            token = libraryDirs.get(token).toString();
                        }
                        entry.addToken(token);
                    }
                    ++i;
                }
            } else {
                String[] tokens = this.getTopLevelResources(location);
                int i = 0;
                while (i < tokens.length) {
                    IResource res = project.findMember(tokens[i]);
                    if (!(res == null && build.getEntry("source." + tokens[i]) == null || res instanceof IFolder && libraryDirs.containsKey(tokens[i]))) {
                        entry.addToken(tokens[i]);
                    }
                    ++i;
                }
            }
            buildModel.getBuild().add(entry);
        }
    }

    private HashMap getSourceDirectories(IBuild build) {
        HashMap<String, String> set = new HashMap<String, String>();
        IBuildEntry[] entries = build.getBuildEntries();
        int i = 0;
        while (i < entries.length) {
            String name = entries[i].getName();
            if (name.startsWith("source.")) {
                name = name.substring(7);
                String[] tokens = entries[i].getTokens();
                int j = 0;
                while (j < tokens.length) {
                    set.put(tokens[j], name);
                    ++j;
                }
            }
            ++i;
        }
        return set;
    }

    private void configureSrcIncludes(WorkspaceBuildModel buildModel, List list) throws CoreException {
        IBuildEntry entry = buildModel.getBuild(true).getEntry("src.includes");
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("src.includes");
            int i = 0;
            while (i < list.size()) {
                entry.addToken(list.get(i).toString());
                ++i;
            }
            buildModel.getBuild().add(entry);
        }
    }

    private String addBuildEntry(WorkspaceBuildModel model, String key, String value) throws CoreException {
        String[] tokens;
        IBuild build = model.getBuild(true);
        IBuildEntry entry = build.getEntry(key);
        if (entry == null) {
            entry = model.getFactory().createEntry(key);
            entry.addToken(value);
            build.add(entry);
        }
        return (tokens = entry.getTokens()).length > 0 ? tokens[0] : "src/";
    }

    private void linkSourceArchives(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(model, true);
        monitor.beginTask(PDEUIMessages.ImportWizard_operation_copyingSource, libraries.length);
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        if (manager.hasBundleManifestLocation(model.getPluginBase())) {
            Path path;
            IFile srcFile;
            IPath srcPath = manager.findSourcePath(model.getPluginBase(), null);
            if (srcPath != null && !(srcFile = project.getFile((path = new Path(String.valueOf(project.getName()) + "src.zip")).lastSegment())).exists()) {
                srcFile.createLink(srcPath, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.worked(libraries.length);
        } else {
            int i = 0;
            while (i < libraries.length) {
                IPath srcPath;
                String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                Path path = new Path(zipName);
                if (project.findMember((IPath)path) == null && (srcPath = manager.findSourcePath(model.getPluginBase(), (IPath)path)) != null) {
                    IFile zipFile;
                    if ("src.zip".equals(zipName) && this.isJARd(model)) {
                        path = new Path(ClasspathUtilCore.getSourceZipName((String)new File(model.getInstallLocation()).getName()));
                    }
                    if (!(zipFile = project.getFile(path.lastSegment())).exists()) {
                        zipFile.createLink(srcPath, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                monitor.worked(1);
                ++i;
            }
        }
        monitor.done();
    }

    private void importSourceArchives(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(model, true);
        monitor.beginTask(PDEUIMessages.ImportWizard_operation_copyingSource, libraries.length);
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        Set roots = null;
        if (manager.hasBundleManifestLocation(model.getPluginBase())) {
            roots = manager.findSourceRoots(model.getPluginBase());
        }
        int i = 0;
        while (i < libraries.length) {
            String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
            Path path = new Path(zipName);
            if (project.findMember((IPath)path) == null) {
                if (roots != null) {
                    String currentRoot;
                    IPath sourceLocation = manager.findSourcePath(model.getPluginBase(), null);
                    String string = currentRoot = ".".equals(libraries[i]) ? "." : path.removeFileExtension().toString();
                    if (roots.contains(currentRoot)) {
                        if (".".equals(currentRoot)) {
                            IPath sourceName = this.getDefaultSourceNameForProject(model);
                            IFolder dest = project.getFolder(sourceName = sourceName.removeFileExtension());
                            if (!dest.exists()) {
                                dest.create(true, true, null);
                            }
                            Set allBundleRoots = manager.findAllSourceRootsInSourceLocation(model.getPluginBase());
                            ArrayList<Path> rootsToExclude = new ArrayList<Path>(allBundleRoots.size() - 1);
                            Iterator iterator2 = allBundleRoots.iterator();
                            while (iterator2.hasNext()) {
                                String rootString = (String)iterator2.next();
                                if (".".equals(rootString)) continue;
                                rootsToExclude.add(new Path(rootString));
                            }
                            this.extractJavaSource(new File(sourceLocation.toOSString()), rootsToExclude, (IResource)dest, monitor);
                        } else {
                            this.extractResourcesFromFolder(new File(sourceLocation.toOSString()), (IPath)new Path(currentRoot), (IResource)project, monitor);
                        }
                    }
                } else {
                    IPath srcPath = manager.findSourcePath(model.getPluginBase(), (IPath)path);
                    if (srcPath != null) {
                        if ("src.zip".equals(zipName) && this.isJARd(model)) {
                            path = this.getDefaultSourceNameForProject(model);
                        }
                        this.importArchive(project, new File(srcPath.toOSString()), (IPath)path);
                    }
                }
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
    }

    private IPath getDefaultSourceNameForProject(IPluginModelBase model) {
        return new Path(ClasspathUtilCore.getSourceZipName((String)new File(model.getInstallLocation()).getName()));
    }

    private String[] getLibraryNames(IPluginModelBase model, boolean expand) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < libraries.length) {
            if (expand) {
                list.add(ClasspathUtilCore.expandLibraryName((String)libraries[i].getName()));
            } else {
                list.add(libraries[i].getName());
            }
            ++i;
        }
        if (libraries.length == 0 && this.isJARd(model)) {
            list.add(".");
        }
        return list.toArray(new String[list.size()]);
    }

    private void extractJARdPlugin(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        ZipFileStructureProvider provider;
        ZipFile zipFile;
        block22: {
            block23: {
                zipFile = null;
                zipFile = new ZipFile(model.getInstallLocation());
                provider = new ZipFileStructureProvider(zipFile);
                if (this.containsCode(provider)) break block22;
                this.extractZipFile(new File(model.getInstallLocation()), project.getFullPath(), monitor);
                if (zipFile == null) break block23;
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
        try {
            try {
                ArrayList collected = new ArrayList();
                this.collectNonJavaResources(provider, provider.getRoot(), collected);
                this.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
                File file = new File(model.getInstallLocation());
                if (this.hasEmbeddedSource(provider) && this.fImportType == 3) {
                    collected = new ArrayList();
                    this.collectJavaFiles(provider, provider.getRoot(), collected);
                    this.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
                    collected = new ArrayList();
                    this.collectJavaResources(provider, provider.getRoot(), collected);
                    this.importContent(provider.getRoot(), project.getFullPath().append("src"), (IImportStructureProvider)provider, collected, monitor);
                } else {
                    if (this.fImportType == 2) {
                        project.getFile(file.getName()).createLink((IPath)new Path(file.getAbsolutePath()), 0, null);
                    } else {
                        this.importArchive(project, file, (IPath)new Path(file.getName()));
                    }
                    if (!this.hasEmbeddedSource(provider)) {
                        if (this.fImportType == 2) {
                            this.linkSourceArchives(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            this.importSourceArchives(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                }
                if (this.fImportType != 3) {
                    this.modifyBundleClasspathHeader(project, model);
                } else {
                    this.removeSignedHeaders(project);
                }
                this.setPermissions(model, project);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void modifyBundleClasspathHeader(IProject project, IPluginModelBase base) {
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        if (file.exists()) {
            WorkspaceBundleModel bmodel = new WorkspaceBundleModel(file);
            IBundle bundle = bmodel.getBundle();
            String classpath = bundle.getHeader("Bundle-ClassPath");
            if (classpath == null) {
                bundle.setHeader("Bundle-ClassPath", ClasspathUtilCore.getFilename((IPluginModelBase)base));
            } else {
                try {
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < elements.length) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                            buffer.append(System.getProperty("line.separator"));
                            buffer.append(" ");
                        }
                        if (elements[i].getValue().equals(".")) {
                            buffer.append(ClasspathUtilCore.getFilename((IPluginModelBase)base));
                        } else {
                            buffer.append(elements[i].getValue());
                        }
                        ++i;
                    }
                    bundle.setHeader("Bundle-ClassPath", buffer.toString());
                }
                catch (BundleException bundleException) {}
            }
            bmodel.save();
        }
    }

    private void removeSignedHeaders(IProject project) {
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        if (!file.exists()) {
            return;
        }
        WorkspaceBundleModel model = new WorkspaceBundleModel(file);
        model.save();
    }

    private IProject findProject(String id) {
        IResource resource;
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model != null && (resource = model.getUnderlyingResource()) != null) {
            return resource.getProject();
        }
        return PDEPlugin.getWorkspace().getRoot().getProject(id);
    }

    private boolean queryReplace(IProject project) throws OperationCanceledException {
        switch (this.fReplaceQuery.doQuery(NLS.bind((String)PDEUIMessages.ImportWizard_messages_exists, (Object)project.getName()))) {
            case 0: {
                throw new OperationCanceledException();
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    private boolean queryExecutionEnvironment(String message) throws OperationCanceledException {
        switch (this.fExecutionQuery.doQuery(message)) {
            case 0: {
                throw new OperationCanceledException();
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    private void setProjectDescription(IProject project, IPluginModelBase model) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (!desc.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (this.needsJavaNature(project, model) && !desc.hasNature("org.eclipse.jdt.core.javanature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
    }

    private boolean needsJavaNature(IProject project, IPluginModelBase model) {
        if (model.getPluginBase().getLibraries().length > 0) {
            return true;
        }
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            if (desc.getExportPackages().length > 0) {
                return true;
            }
            if (desc.getRequiredBundles().length > 0) {
                return true;
            }
            if (desc.getImportPackages().length > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isExempt(IPluginModelBase model) {
        String id = model.getPluginBase().getId();
        if ("org.apache.ant".equals(id) || "org.eclipse.osgi.util".equals(id) || "org.eclipse.osgi.services".equals(id) || "org.eclipse.core.runtime.compatibility.registry".equals(id)) {
            return true;
        }
        return "org.eclipse.swt".equals(id) && !this.isJARd(model);
    }

    private boolean isJARd(IPluginModelBase model) {
        return new File(model.getInstallLocation()).isFile();
    }

    private void setPermissions(IPluginModelBase model, IProject project) {
        try {
            IFragment fragment;
            if (!Platform.getOS().equals("win32") && model instanceof IFragmentModel && "org.eclipse.swt".equals((fragment = ((IFragmentModel)model).getFragment()).getPluginId())) {
                IResource[] children = project.members();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IFile && this.isInterestingResource(children[i].getName())) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", children[i].getLocation().toOSString()}).waitFor();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {}
    }

    private boolean isInterestingResource(String name) {
        return name.endsWith(".jnilib") || name.endsWith(".sl") || name.endsWith(".a") || name.indexOf(".so") != -1;
    }

    private IFragment[] getFragmentsFor(IPluginModelBase model) {
        ArrayList<IFragment> result = new ArrayList<IFragment>();
        int i = 0;
        while (i < this.fModels.length) {
            if (this.fModels[i] instanceof IFragmentModel) {
                BundleDescription host;
                HostSpecification spec = this.fModels[i].getBundleDescription().getHost();
                BundleDescription bundleDescription = host = spec == null ? null : (BundleDescription)spec.getSupplier();
                if (model.getBundleDescription().equals(host)) {
                    result.add(((IFragmentModel)this.fModels[i]).getFragment());
                }
            }
            ++i;
        }
        return result.toArray(new IFragment[result.size()]);
    }

    private void importJarFromFragment(IProject project, IFragment fragment, String name) throws CoreException {
        Path jarPath = new Path(ClasspathUtilCore.expandLibraryName((String)name));
        File jar = new File(fragment.getModel().getInstallLocation(), jarPath.toString());
        if (jar.exists()) {
            this.importArchive(project, jar, (IPath)jarPath);
        }
    }

    private void importSourceFromFragment(IProject project, IFragment fragment, String libraryName, IProgressMonitor monitor) throws CoreException {
        try {
            SourceLocationManager manager;
            IPath srcPath;
            Path jarPath = new Path(ClasspathUtilCore.expandLibraryName((String)libraryName));
            String zipName = ClasspathUtilCore.getSourceZipName((String)jarPath.toString());
            Path path = new Path(zipName);
            if (project.findMember((IPath)path) == null && (srcPath = (manager = PDECore.getDefault().getSourceLocationManager()).findSourcePath((IPluginBase)fragment, (IPath)path)) != null) {
                if (manager.hasBundleManifestLocation((IPluginBase)fragment)) {
                    this.extractResourcesFromFolder(new File(srcPath.toOSString()), path.removeFileExtension(), (IResource)project, monitor);
                } else {
                    this.importArchive(project, new File(srcPath.toOSString()), (IPath)path);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void collectAdditionalResources(ZipFileStructureProvider provider, Object element, ArrayList collected, IProject project) {
        this.collectAdditionalResources(provider, element, collected);
        ListIterator li = collected.listIterator();
        while (li.hasNext()) {
            ZipEntry ze = (ZipEntry)li.next();
            String name = ze.getName();
            if (project.findMember(name) == null) continue;
            li.remove();
        }
    }

    protected void collectNonJavaResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        super.collectNonJavaResources(provider, element, collected);
        if (this.fImportType != 3) {
            return;
        }
        ListIterator li = collected.listIterator();
        while (li.hasNext()) {
            ZipEntry ze = (ZipEntry)li.next();
            String name = ze.getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".RSA") && !name.endsWith(".DSA") && !name.endsWith(".SF")) continue;
            li.remove();
        }
    }

    public void setLaunchedConfiguration(boolean launchedConfiguration) {
        this.fLaunchedConfigurations = launchedConfiguration;
    }

    public static interface IImportQuery {
        public static final int CANCEL = 0;
        public static final int NO = 1;
        public static final int YES = 2;

        public int doQuery(String var1);
    }
}

