/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.ui.wizards.product.BaseProductCreationOperation;

public class ProductFromConfigOperation
extends BaseProductCreationOperation {
    private ILaunchConfiguration fLaunchConfiguration;

    public ProductFromConfigOperation(IFile file, ILaunchConfiguration config) {
        super(file);
        this.fLaunchConfiguration = config;
    }

    protected void initializeProduct(IProduct product) {
        if (this.fLaunchConfiguration == null) {
            return;
        }
        try {
            String jreString;
            IProductModelFactory factory = product.getModel().getFactory();
            boolean useProduct = this.fLaunchConfiguration.getAttribute("useProduct", false);
            if (useProduct) {
                String id = this.fLaunchConfiguration.getAttribute("product", null);
                if (id != null) {
                    this.initializeProductInfo(factory, product, id);
                }
            } else {
                String appName = this.fLaunchConfiguration.getAttribute("application", TargetPlatform.getDefaultApplication());
                product.setApplication(appName);
            }
            if ((jreString = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null)) != null) {
                Path jreContainerPath = new Path(jreString);
                IJREInfo jreInfo = product.getJREInfo();
                if (jreInfo == null) {
                    jreInfo = product.getModel().getFactory().createJVMInfo();
                }
                jreInfo.setJREContainerPath(TargetPlatform.getOS(), (IPath)jreContainerPath);
                product.setJREInfo(jreInfo);
            }
            this.addPlugins(factory, product, LaunchPluginValidator.getPluginList(this.fLaunchConfiguration));
            if (this.fLaunchConfiguration.getAttribute("useDefaultConfig", true)) {
                super.initializeProduct(product);
            } else {
                String path = this.fLaunchConfiguration.getAttribute("templateConfig", "/");
                IContainer container = PDEPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(path));
                if (container != null) {
                    IConfigurationFileInfo info = factory.createConfigFileInfo();
                    info.setUse(null, "custom");
                    info.setPath(null, container.getFullPath().toString());
                    product.setConfigurationFileInfo(info);
                } else {
                    super.initializeProduct(product);
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

