/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetDefinitionManager;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.target.TargetModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.target.OpenTargetProfileAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.PDEWizardNewFileCreationPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TargetDefinitionWizardPage
extends PDEWizardNewFileCreationPage {
    protected static final int USE_DEFAULT = 0;
    protected static final int USE_CURRENT_TP = 1;
    protected static final int USE_EXISTING_TARGET = 2;
    private Button fDefaultButton;
    private Button fCurrentTPButton;
    private Button fExistingTargetButton;
    private Combo fTargets;
    private String[] fTargetIds;
    private Button fPreviewButton;
    private static String EXTENSION = "target";

    public TargetDefinitionWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(PDEUIMessages.TargetProfileWizardPage_title);
        this.setDescription(PDEUIMessages.TargetProfileWizardPage_description);
        this.setFileExtension(EXTENSION);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.target_definition_page");
    }

    protected void createAdvancedControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.TargetProfileWizardPage_groupTitle);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(1808));
        this.fDefaultButton = new Button((Composite)group, 16);
        this.fDefaultButton.setText(PDEUIMessages.TargetProfileWizardPage_blankTarget);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fDefaultButton.setLayoutData((Object)gd);
        this.fDefaultButton.setSelection(true);
        this.fCurrentTPButton = new Button((Composite)group, 16);
        this.fCurrentTPButton.setText(PDEUIMessages.TargetProfileWizardPage_currentPlatform);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fCurrentTPButton.setLayoutData((Object)gd);
        this.fExistingTargetButton = new Button((Composite)group, 16);
        this.fExistingTargetButton.setText(PDEUIMessages.TargetProfileWizardPage_existingTarget);
        this.fExistingTargetButton.setLayoutData((Object)new GridData());
        this.fExistingTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = TargetDefinitionWizardPage.this.fExistingTargetButton.getSelection();
                TargetDefinitionWizardPage.this.fTargets.setEnabled(enabled);
                TargetDefinitionWizardPage.this.fPreviewButton.setEnabled(enabled);
            }
        });
        this.fTargets = new Combo((Composite)group, 12);
        this.fTargets.setLayoutData((Object)new GridData(768));
        this.fTargets.setEnabled(false);
        this.initializeTargetCombo();
        this.fPreviewButton = new Button((Composite)group, 8);
        this.fPreviewButton.setText(PDEUIMessages.TargetProfileWizardPage_viewProfile);
        this.fPreviewButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fPreviewButton);
        this.fPreviewButton.setEnabled(false);
        this.fPreviewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block20: {
                    InputStream stream = null;
                    try {
                        URL url = TargetDefinitionWizardPage.this.getExternalTargetURL();
                        if (url != null) {
                            stream = new BufferedInputStream(url.openStream());
                        }
                        if (stream != null) {
                            TargetModel model = new TargetModel();
                            model.load(stream, false);
                            new OpenTargetProfileAction(TargetDefinitionWizardPage.this.getShell(), (ITargetModel)model, TargetDefinitionWizardPage.this.fTargets.getText()).run();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException2) {}
                        break block20;
                    }
                    catch (CoreException coreException) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {}
                        break block20;
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        Dialog.applyDialogFont((Control)group);
    }

    private URL getExternalTargetURL() {
        TargetDefinitionManager manager = PDECore.getDefault().getTargetProfileManager();
        IConfigurationElement elem = manager.getTarget(this.fTargetIds[this.fTargets.getSelectionIndex()]);
        if (elem != null) {
            String path = elem.getAttribute("definition");
            String symbolicName = elem.getDeclaringExtension().getNamespaceIdentifier();
            return TargetDefinitionManager.getResourceURL((String)symbolicName, (String)path);
        }
        return null;
    }

    protected void initializeTargetCombo() {
        IConfigurationElement[] elements = PDECore.getDefault().getTargetProfileManager().getSortedTargets();
        this.fTargetIds = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            String name = elements[i].getAttribute("name");
            if (this.fTargets.indexOf(name) == -1) {
                this.fTargets.add(name);
            }
            this.fTargetIds[i] = elements[i].getAttribute("id");
            ++i;
        }
        if (elements.length > 0) {
            this.fTargets.select(0);
        }
    }

    protected int getInitializationOption() {
        if (this.fDefaultButton.getSelection()) {
            return 0;
        }
        if (this.fCurrentTPButton.getSelection()) {
            return 1;
        }
        return 2;
    }

    protected String getTargetId() {
        return this.fTargetIds[this.fTargets.getSelectionIndex()];
    }
}

