/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.toc;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.toc.IRegisterTOCData;
import org.eclipse.pde.internal.ui.wizards.toc.RegisterTocOperation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RegisterTocWizardPage
extends WizardPage
implements IRegisterTOCData {
    public static final int NUM_COLUMNS = 2;
    public static final String F_PAGE_NAME = "register-toc";
    public static final String F_TOC_ELEMENT_TOC = "toc";
    private Button fPrimaryChkBox;
    protected IModel fTocModel;
    private ISharedExtensionsModel fExtensionsModel;
    private IProject fPluginProject;
    private boolean fDataIsPrimary;

    public RegisterTocWizardPage(IModel model) {
        super(F_PAGE_NAME);
        this.fTocModel = model;
        this.initialize();
    }

    private void initialize() {
        this.setTitle(PDEUIMessages.TocWizardPage_title);
        this.setDescription(PDEUIMessages.RegisterTocWizardPage_wizardPageDescription);
        this.fPrimaryChkBox = null;
        this.fDataIsPrimary = true;
        this.fPluginProject = this.fTocModel.getUnderlyingResource().getProject();
        this.initializePluginModel();
    }

    private void initializePluginModel() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.getPluginProject());
        if (base == null) {
            return;
        }
        this.fExtensionsModel = base instanceof IBundlePluginModelBase ? ((IBundlePluginModelBase)base).getExtensionsModel() : base;
    }

    private void updateUI() {
        if (this.fExtensionsModel != null) {
            IPluginExtension[] extensions = RegisterTocOperation.findTOCExtensions(this.fExtensionsModel);
            this.processTocElements(extensions);
        }
    }

    private void processTocElements(IPluginExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getChildCount() != 0) {
                IPluginExtension extension = extensions[i];
                IPluginObject[] pluginObjects = extension.getChildren();
                int j = 0;
                while (j < pluginObjects.length) {
                    IPluginElement element;
                    if (pluginObjects[j] instanceof IPluginElement && (element = (IPluginElement)pluginObjects[j]).getName().equals(F_TOC_ELEMENT_TOC)) {
                        this.processTocElement(element, this.getDataTocFile());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void processTocElement(IPluginElement parentElement, String generatedID) {
        IPluginAttribute fileAttribute = parentElement.getAttribute("file");
        if (fileAttribute != null && PDETextHelper.isDefined((String)fileAttribute.getValue()) && generatedID.equals(fileAttribute.getValue()) && parentElement.getChildCount() > 0) {
            this.updateUIPrimary(parentElement);
        }
    }

    private void updateUIPrimary(IPluginElement parentElement) {
        IPluginElement element;
        IPluginObject pluginObject = parentElement.getChildren()[0];
        if (pluginObject instanceof IPluginElement && (element = (IPluginElement)pluginObject).getName().equals("primary") && PDETextHelper.isDefinedAfterTrim((String)element.getText())) {
            this.fPrimaryChkBox.setSelection(Boolean.getBoolean(element.getText().trim()));
        }
    }

    public boolean getDataPrimary() {
        return this.fDataIsPrimary;
    }

    public String getDataTocFile() {
        return this.fTocModel.getUnderlyingResource().getProjectRelativePath().toPortableString();
    }

    public IProject getPluginProject() {
        return this.fPluginProject;
    }

    public void createControl(Composite parent) {
        this.createUI(parent);
        this.createUIListeners();
        this.updateUI();
        this.validateUI();
    }

    private void createUI(Composite parent) {
        Composite container = this.createUIContainer(parent);
        this.createUIPrimaryChkBox(container);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.register_toc");
    }

    private Composite createUIContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        return container;
    }

    private void createUIPrimaryChkBox(Composite parent) {
        this.fPrimaryChkBox = new Button(parent, 32);
        this.fPrimaryChkBox.setText(PDEUIMessages.RegisterTocWizardPage_labelPrimary);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fPrimaryChkBox.setLayoutData((Object)data);
        this.fPrimaryChkBox.setSelection(true);
    }

    private void createUIListeners() {
        this.createUIListenersPrimaryChkBox();
    }

    private void createUIListenersPrimaryChkBox() {
        this.fPrimaryChkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegisterTocWizardPage.this.fDataIsPrimary = RegisterTocWizardPage.this.fPrimaryChkBox.getSelection();
            }
        });
    }

    private void validateUI() {
        this.setPageComplete(true);
    }

    public IPluginExtension[] findExtensions(IPluginModelBase model, String extensionPointID) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        ArrayList<IPluginExtension> tocExtensions = new ArrayList<IPluginExtension>();
        int i = 0;
        while (i < extensions.length) {
            String point = extensions[i].getPoint();
            if (extensionPointID.equals(point)) {
                tocExtensions.add(extensions[i]);
            }
            ++i;
        }
        return tocExtensions.toArray(new IPluginExtension[tocExtensions.size()]);
    }
}

