/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.ddl;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.QueryObjectsSQL;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.AllowNullType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.EventCondition;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.EventType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.ParameterType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.Schedule;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseActionTime;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDBSpace;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseEvent;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseFunction;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseIndex;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseParameter;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseProcedure;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseProxyTable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseRemoteProcedure;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseTable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseTrigger;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUserDefinedType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseViewTable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASAWebService;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.TransactionOption;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASADatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASAForeignKey;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASAIndex;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASATable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasasqlmodel.SybaseASATempTable;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public class SybaseASADdlBuilder
extends SybaseDdlBuilder
implements ISybaseASADdlConstants {
    public static final DateFormat DATE_FORMAT = DateFormat.getDateInstance((int)2);
    public static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    protected static SybaseASADdlBuilder builder;

    protected SybaseASADdlBuilder() {
    }

    public static SybaseASADdlBuilder getInstance() {
        if (builder == null) {
            builder = new SybaseASADdlBuilder();
        }
        return builder;
    }

    public String[] createCatalogs(Catalog catalog, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return new String[]{""};
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = "DROP INDEX " + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + "." + this.getName(index, quoteIdentifiers, qualifyNames);
        String ownerName = index.getSchema().getName();
        String indexName = index.getName();
        String tableName = index.getTable().getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_INDEX, ownerName, tableName, indexName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropDatabase(Database db, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        SybaseASABaseDatabase database = (SybaseASABaseDatabase)db;
        sb.append("DROP").append(" ").append("DATABASE").append(" ").append(SQLUtil.quote((String)database.getDatabaseFileName(), (String)"'"));
        return sb.toString();
    }

    public String dropTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        if (qualifyNames) {
            String schemaName = trigger.getSchema().getName();
            String tableName = trigger.getSubjectTable().getName();
            if (quoteIdentifiers) {
                tableName = this.getDoubleQuotedString(tableName);
            }
            name = String.valueOf(schemaName) + "." + tableName + "." + name;
        }
        String dropStatement = "DROP TRIGGER " + name;
        String ownerName = trigger.getSchema().getName();
        String triggerName = trigger.getName();
        String tableName = trigger.getSubjectTable().getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_TRIGGER, ownerName, tableName, triggerName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String[] createDatabase(Database database, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASADatabase asaDatabase = (SybaseASADatabase)database;
        StringBuffer statement = new StringBuffer();
        statement.append(this.createSybaseASABaseDatabase((SybaseASABaseDatabase)database, quoteIdentifiers, qualifyNames));
        if (asaDatabase.isASECompatible() && fullSyntax) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "ASE" + " " + "COMPATIBLE");
        } else {
            statement.append(String.valueOf(NEWLINE) + "\t" + "ASE");
        }
        if (!asaDatabase.isBaseOnASA10() && asaDatabase.getJavaSupport() != null) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "JAVA" + " ");
            statement.append(asaDatabase.getJavaSupport().getLiteral());
        }
        if (asaDatabase.isCheckSumOn() && fullSyntax) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "CHECKSUM" + " " + "ON");
        } else {
            statement.append(String.valueOf(NEWLINE) + "\t" + "CHECKSUM" + " " + "OFF");
        }
        return new String[]{statement.toString()};
    }

    protected String createSybaseASABaseDatabase(SybaseASABaseDatabase asaDatabase, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE DATABASE ");
        statement.append(this.getSingleQuotedString(asaDatabase.getDatabaseFileName()));
        if (asaDatabase.getMirrorFileName() != null) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "MIRROR" + " ");
            statement.append(this.getSingleQuotedString(asaDatabase.getMirrorFileName()));
        }
        if (asaDatabase.isCaseSensitive()) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "CASE" + " " + "RESPECT");
        } else {
            statement.append(String.valueOf(NEWLINE) + "\t" + "CASE" + " " + "IGNORE");
        }
        if (asaDatabase.getPageSize() > -1) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "PAGE" + " " + "SIZE" + " ");
            statement.append(asaDatabase.getPageSize());
        }
        if (asaDatabase.getCollation() != null) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "COLLATION" + " ");
            statement.append(this.getSingleQuotedString(asaDatabase.getCollation()));
        }
        if (asaDatabase.getEncryptionInfo() != null && asaDatabase.getEncryptionInfo().isEncryptedTable()) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "ENCRYPTED" + " " + "ON");
            if (asaDatabase.getEncryptionInfo().getEncryptionKey() != null) {
                statement.append(" KEY ");
                statement.append(this.getSingleQuotedString(asaDatabase.getEncryptionInfo().getEncryptionKey()));
            }
        } else {
            statement.append(String.valueOf(NEWLINE) + "\t" + "ENCRYPTED" + " " + "OFF");
        }
        if (asaDatabase.isBlankPaddingOn()) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "BLANK" + " " + "PADDING" + " " + "ON");
        } else {
            statement.append(String.valueOf(NEWLINE) + "\t" + "BLANK" + " " + "PADDING" + " " + "OFF");
        }
        if (asaDatabase.isJConnectOn()) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "JCONNECT" + " " + "ON");
        } else {
            statement.append(String.valueOf(NEWLINE) + "\t" + "JCONNECT" + " " + "OFF");
        }
        if (asaDatabase.getPasswordCaseSensitive() != null) {
            if (asaDatabase.getPasswordCaseSensitive().booleanValue()) {
                statement.append(String.valueOf(NEWLINE) + "\t" + "PASSWORD" + " " + "CASE" + " " + "RESPECT");
            } else {
                statement.append(String.valueOf(NEWLINE) + "\t" + "PASSWORD" + " " + "CASE" + " " + "IGNORE");
            }
        }
        return statement.toString();
    }

    public String[] createEvent(Event event, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return this.getEventSource(event, quoteIdentifiers, qualifyNames, fullSyntax, false);
    }

    public String[] getEventSource(Event event, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, boolean debugFormat) {
        StringBuffer sb = new StringBuffer();
        String comment = this.createComment((SQLObject)event, quoteIdentifiers, qualifyNames);
        String body = event.getAction();
        if (QuickSQLParser.getInstance().match(body, 4)) {
            if (comment != null && !comment.trim().equals("")) {
                int start = body.toLowerCase().indexOf("create");
                if (start >= 0) {
                    body = body.substring(start);
                }
                return new String[]{body, comment};
            }
            return new String[]{body};
        }
        String eventHeader = this.getEventHeader(event, quoteIdentifiers, qualifyNames, fullSyntax, debugFormat);
        sb.append(eventHeader);
        if (body == null || body.equals("")) {
            body = "BEGIN" + NEWLINE + "END";
        }
        sb.append(body);
        if (!debugFormat && comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    public String getEventHeader(Event event, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, boolean debugFormat) {
        SybaseASABaseEvent evt = (SybaseASABaseEvent)event;
        StringBuffer sb = new StringBuffer();
        if (debugFormat && event.getDescription() != null && event.getDescription().trim().length() > 0) {
            sb.append("/*").append(NEWLINE).append(event.getDescription()).append(NEWLINE).append("*/").append(NEWLINE);
        }
        sb.append("CREATE").append(" ").append("EVENT").append(" ").append(this.getName(event, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        sb.append(this.getEventScheduleOrType(evt));
        sb.append(this.getEventStatus(evt));
        sb.append(this.getEventLocation(fullSyntax, evt));
        sb.append("HANDLER").append(NEWLINE);
        return sb.toString();
    }

    public String getEventStatus(SybaseASABaseEvent evt) {
        StringBuffer sb = new StringBuffer();
        if (evt.isEnabled()) {
            sb.append("ENABLE").append(NEWLINE);
        } else {
            sb.append("DISABLE").append(NEWLINE);
        }
        return sb.toString();
    }

    public String getEventLocation(boolean fullSyntax, SybaseASABaseEvent evt) {
        StringBuffer sb = new StringBuffer();
        if (fullSyntax || evt.eIsSet(evt.eClass().getEStructuralFeature(14))) {
            sb.append("AT").append(" ").append(evt.getLocation().getLiteral()).append(NEWLINE);
        }
        return sb.toString();
    }

    public String getEventScheduleOrType(SybaseASABaseEvent evt) {
        StringBuffer sb = new StringBuffer();
        EventType type = evt.getEventType();
        String schedule = this.getEventSchedules(evt);
        if (schedule != null && !schedule.trim().equals("")) {
            sb.append(schedule);
        } else if (type != null && !type.equals(EventType.NOEVENTTYPE_LITERAL)) {
            sb.append("TYPE").append(" ").append(type.getLiteral()).append(NEWLINE);
            String condition = evt.getCondition();
            EList details = evt.getConditionDetails();
            if (condition != null && !condition.trim().equals("")) {
                sb.append("WHERE").append(" ").append(condition).append(NEWLINE);
            } else if (details != null && !details.isEmpty()) {
                sb.append(this.getEventConditions((List)details));
            }
        }
        return sb.toString();
    }

    public String getEventConditions(List details) {
        StringBuffer sb = new StringBuffer();
        Iterator it = details.iterator();
        while (it.hasNext()) {
            EventCondition cond = (EventCondition)it.next();
            sb.append("EVENT_CONDITION").append("(").append("'").append(cond.getName()).append("'").append(")").append(" ").append(cond.getOperator()).append(" ").append(cond.getValue()).append(" ");
            if (!it.hasNext()) continue;
            sb.append("AND").append(" ");
        }
        return sb.toString();
    }

    public String[] createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String comment = this.createComment((SQLObject)procedure, quoteIdentifiers, qualifyNames);
        SybaseASABaseProcedure proc = (SybaseASABaseProcedure)procedure;
        Source source = procedure.getSource();
        String body = "";
        if (source != null && source.getBody() != null) {
            body = source.getBody();
        }
        if (QuickSQLParser.getInstance().match(body, 1)) {
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{body, comment};
            }
            return new String[]{body};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("PROCEDURE").append(" ").append(this.getName(procedure, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        int syntaxType = this.getSyntaxType(procedure);
        String param = "";
        param = syntaxType == 0 ? this.getTSQLParameters((Routine)procedure) : this.getWatcomParameters((Routine)procedure, fullSyntax);
        if (param != null && param.length() > 0) {
            sb.append("(").append(param).append(")").append(NEWLINE);
        }
        if (syntaxType == 0) {
            sb.append("AS").append(NEWLINE).append(body);
        } else {
            sb.append("\t").append(this.getRoutineResults(procedure));
            sb.append("\t").append(this.getCharacteristics((Routine)proc));
            if (proc instanceof SybaseASABaseRemoteProcedure) {
                sb.append("\t").append("AT").append(" ").append(((SybaseASABaseRemoteProcedure)proc).getLocation()).append(NEWLINE);
            } else if (proc.getExternalName() != null) {
                sb.append(this.getExternalNameOption((Routine)proc, quoteIdentifiers, qualifyNames));
            } else if (body.length() > 0) {
                sb.append(body);
            }
        }
        if (comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    public String getRoutineResults(Procedure procedure) {
        StringBuffer sb = new StringBuffer();
        EList resultSet = procedure.getResultSet();
        boolean hasColumn = false;
        if (resultSet != null && !resultSet.isEmpty()) {
            sb.append("RESULT").append(" ").append("(");
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                RoutineResultTable resultTable = (RoutineResultTable)iter.next();
                Iterator it = resultTable.getColumns().iterator();
                while (it.hasNext()) {
                    Column c = (Column)it.next();
                    if (c.getName() == null || c.getDataType() == null) continue;
                    hasColumn = true;
                    sb.append(c.getName()).append(" ").append(this.getDataTypeString((TypedElement)c, procedure.getSchema()));
                    if (!it.hasNext()) continue;
                    sb.append(",").append(" ");
                }
            }
            if (sb.charAt(sb.length() - 2) == ',') {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(")").append(NEWLINE);
        }
        if (hasColumn) {
            return sb.toString();
        }
        return "";
    }

    public String[] createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String comment = this.createComment((SQLObject)function, quoteIdentifiers, qualifyNames);
        Source source = function.getSource();
        String body = "";
        if (source != null && source.getBody() != null) {
            body = source.getBody();
        }
        if (QuickSQLParser.getInstance().match(body, 2)) {
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{body, comment};
            }
            return new String[]{body};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("FUNCTION").append(" ").append(this.getName(function, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        String param = this.getFuncParameters(function, fullSyntax);
        if (param != null && param.length() > 0) {
            sb.append("(").append(param).append(")").append(NEWLINE);
        }
        sb.append(this.getFunctionReturnsClause(function));
        sb.append("\t").append(this.getCharacteristics((Routine)function));
        if (function.getExternalName() != null) {
            sb.append(this.getExternalNameOption((Routine)function, quoteIdentifiers, qualifyNames));
        } else if (body.length() > 0) {
            sb.append(body);
        }
        if (comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    public String getCharacteristics(Routine routine) {
        StringBuffer sb = new StringBuffer();
        if (routine instanceof SybaseASABaseProcedure && ((SybaseASABaseProcedure)routine).isOnExceptionResume()) {
            sb.append("ON EXCEPTION RESUME").append(NEWLINE);
        } else if (routine instanceof SybaseASABaseFunction) {
            if (((SybaseASABaseFunction)routine).isOnExceptionResume()) {
                sb.append("ON EXCEPTION RESUME").append(" ");
            }
            sb.append(this.getDeterministic((Routine)((SybaseASABaseFunction)routine)));
        }
        return sb.toString();
    }

    public String[] createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(trigger instanceof SybaseASABaseTrigger)) {
            return new String[]{super.createTrigger(trigger, quoteIdentifiers, qualifyNames)};
        }
        String comment = this.createComment((SQLObject)trigger, quoteIdentifiers, qualifyNames);
        SybaseASABaseTrigger trig = (SybaseASABaseTrigger)trigger;
        String bodyString = this.getTriggerBody(trigger);
        if (QuickSQLParser.getInstance().match(bodyString, 3)) {
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{bodyString, comment};
            }
            return new String[]{bodyString};
        }
        if (trig.getSybaseASABaseActionTime().getValue() == 3) {
            String tsqltrigger = this.createTSQLTrigger(trigger, quoteIdentifiers, qualifyNames);
            if (comment != null && !comment.trim().equals("")) {
                return new String[]{tsqltrigger, comment};
            }
            return new String[]{tsqltrigger};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("TRIGGER").append(" ").append(this.getName(trigger, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        sb.append(this.getFullTriggerEvents(trig));
        sb.append(this.getTriggerOrder(fullSyntax, trig));
        Table subjectTable = trigger.getSubjectTable();
        if (subjectTable != null) {
            sb.append("ON").append(" ");
            Schema triggerOwner = trigger.getSchema();
            Schema tableOwner = subjectTable.getSchema();
            if (tableOwner != null && (qualifyNames || tableOwner.equals(triggerOwner))) {
                sb.append(tableOwner.getName()).append(".");
            }
            sb.append(trigger.getName()).append(NEWLINE);
        }
        sb.append(this.getTriggerReference(trig));
        sb.append(this.getTriggerGranularity(trig));
        SearchCondition when = trig.getWhen();
        if (when != null && when.getSQL() != null) {
            sb.append("WHEN").append(" ").append(when.getSQL()).append(NEWLINE);
        }
        sb.append(bodyString);
        if (comment != null && !comment.trim().equals("")) {
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    private boolean notEmpty(String text) {
        return text != null && !text.trim().equals("");
    }

    public String getTriggerReference(SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        if (this.notEmpty(trig.getOldName()) || this.notEmpty(trig.getNewName()) || this.notEmpty(trig.getRemoteName())) {
            sb.append("REFERENCING").append(" ");
        }
        if (this.notEmpty(trig.getOldName())) {
            sb.append("OLD").append(" ").append("AS").append(" ").append(trig.getOldName()).append(" ");
        }
        if (this.notEmpty(trig.getNewName())) {
            sb.append("NEW").append(" ").append("AS").append(" ").append(trig.getNewName()).append(" ");
        }
        if (this.notEmpty(trig.getRemoteName())) {
            sb.append("REMOTE").append(" ").append("AS").append(" ").append(trig.getRemoteName()).append(" ");
        }
        return sb.toString();
    }

    public String getTriggerGranularity(SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        switch (trig.getActionGranularity().getValue()) {
            case 1: {
                sb.append("FOR").append(" ").append("EACH").append(" ").append("ROW").append(NEWLINE);
                break;
            }
            case 0: {
                sb.append("FOR").append(" ").append("EACH").append(" ").append("STATEMENT").append(NEWLINE);
            }
        }
        return sb.toString();
    }

    public String getTriggerOrder(boolean fullSyntax, SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        if (fullSyntax || trig.eIsSet(trig.eClass().getEStructuralFeature(22))) {
            int order = trig.getOrder();
            sb.append("ORDER").append(" ").append(order).append(" ");
        }
        return sb.toString();
    }

    public String getFullTriggerEvents(SybaseASABaseTrigger trig) {
        StringBuffer sb = new StringBuffer();
        SybaseASABaseActionTime eventTime = trig.getSybaseASABaseActionTime();
        if (eventTime.equals(SybaseASABaseActionTime.ASE_LITERAL)) {
            eventTime = SybaseASABaseActionTime.AFTER_LITERAL;
        }
        sb.append(eventTime.getLiteral()).append(" ");
        EList triggerColumn = trig.getTriggerColumn();
        if (trig.isUpdateColumnType()) {
            if (triggerColumn != null && triggerColumn.size() > 0) {
                sb.append("UPDATE").append(" ").append("OF").append(" ");
                Iterator iter = triggerColumn.iterator();
                while (iter.hasNext()) {
                    Column column = (Column)iter.next();
                    sb.append(column.getName());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(" ");
            } else {
                sb.append("UPDATE").append(" ");
            }
        } else {
            sb.append(this.getTriggerEvents((Trigger)trig));
        }
        return sb.toString();
    }

    public String[] createUserDefinedType(UserDefinedType udt, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        CheckConstraint checkConstraint;
        EList constraints;
        SybaseASABaseUserDefinedType asaUDT = (SybaseASABaseUserDefinedType)udt;
        StringBuffer sb = new StringBuffer(128);
        if (quoteIdentifiers) {
            sb.append("CREATE").append(" ").append("DOMAIN").append(" ").append(SQLUtil.quote((String)asaUDT.getName(), (String)"\"")).append(" ");
        } else {
            sb.append("CREATE").append(" ").append("DOMAIN").append(" ").append(asaUDT.getName()).append(" ");
        }
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition definition = dbRegistry.getDefinition((Database)ContainmentServiceImpl.INSTANCE.getRootElement((EObject)asaUDT));
        PredefinedDataType pdt = asaUDT.getPredefinedRepresentation();
        sb.append(definition.getPredefinedDataTypeFormattedName(pdt));
        AllowNullType allowNullType = asaUDT.getNullable();
        if (allowNullType.getValue() == 0) {
            sb.append(NEWLINE).append("NULL").append(" ");
        } else if (allowNullType.getValue() == 1) {
            sb.append(NEWLINE).append("NOT").append(" ").append("NULL").append(" ");
        }
        String defaultValue = asaUDT.getDefaultValue();
        if (defaultValue != null) {
            sb.append(NEWLINE).append("DEFAULT").append(" ").append(defaultValue);
        }
        if ((constraints = asaUDT.getConstraint()) != null && constraints.size() > 0 && (checkConstraint = (CheckConstraint)constraints.get(0)).getSearchCondition().getSQL() != null && !checkConstraint.getSearchCondition().getSQL().trim().equals("")) {
            sb.append(NEWLINE).append(checkConstraint.getSearchCondition().getSQL());
        }
        return new String[]{sb.toString()};
    }

    public String[] grantPrivilege(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String[] stat = super.grantPrivilege(privilege, quoteIdentifiers, qualifyNames, fullSyntax);
        if (stat == null || stat.length == 0) {
            return new String[]{""};
        }
        StringBuffer sb = new StringBuffer(stat[0]);
        if (privilege.isGrantable()) {
            if (privilege.getAction() == null) {
                sb.append(" ").append("WITH GRANT OPTION");
            } else if (!privilege.getAction().equals("EXECUTE")) {
                sb.append(" ").append("WITH GRANT OPTION");
            }
        }
        return new String[]{sb.toString()};
    }

    public String[] createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(view instanceof SybaseASABaseViewTable)) {
            return null;
        }
        ArrayList<String> stats = new ArrayList<String>();
        StringBuffer viewDefinition = new StringBuffer("");
        viewDefinition.append("CREATE").append(" ").append("VIEW").append(" ").append(this.getName((Table)view, quoteIdentifiers, qualifyNames)).append(" ");
        String columns = this.getViewColumnList(view, quoteIdentifiers);
        if (columns != null) {
            viewDefinition.append("(").append(columns).append(")").append(NEWLINE);
        }
        viewDefinition.append("AS").append(NEWLINE);
        viewDefinition.append(view.getQueryExpression().getSQL());
        if (((SybaseASABaseViewTable)view).isWithCheckOption()) {
            viewDefinition.append(NEWLINE).append("WITH CHECK OPTION");
        }
        stats.add(viewDefinition.toString());
        String comment = this.createComment((SQLObject)view, quoteIdentifiers, qualifyNames);
        if (comment != null && !comment.trim().equals("")) {
            stats.add(comment);
        }
        Iterator i = view.getColumns().iterator();
        while (i.hasNext()) {
            Column c = (Column)i.next();
            comment = this.createComment((SQLObject)c, quoteIdentifiers, qualifyNames);
            if (comment == null || comment.trim().equals("")) continue;
            stats.add(comment);
        }
        return stats.toArray(new String[stats.size()]);
    }

    public String createComment(SQLObject obj, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createComment(obj, quoteIdentifiers, qualifyNames, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createComment(SQLObject obj, boolean quoteIdentifiers, boolean qualifyNames, boolean removeComment) {
        String description = obj.getDescription();
        if (description == null || description.trim().length() == 0) {
            if (!removeComment) return null;
            description = "NULL";
        } else {
            description = SQLUtil.quote((String)description, (String)"'");
        }
        String objectType = null;
        String objectName = this.getName((ENamedElement)obj, quoteIdentifiers, qualifyNames);
        if (obj instanceof Event) {
            objectType = "EVENT";
        } else if (obj instanceof ForeignKey) {
            objectType = "FOREIGN KEY";
        } else if (obj instanceof Index) {
            objectType = "INDEX";
        } else if (obj instanceof ViewTable) {
            objectType = "VIEW";
        } else if (obj instanceof Column) {
            objectType = "COLUMN";
        } else if (obj instanceof Routine) {
            objectType = "PROCEDURE";
        } else if (obj instanceof SybaseASAWebService) {
            objectType = "SERVICE";
        } else if (obj instanceof Table) {
            objectType = "TABLE";
        } else if (obj instanceof Trigger) {
            objectType = "TRIGGER";
        } else if (obj instanceof Schema) {
            objectType = "USER";
        }
        if (objectType == null) return null;
        StringBuffer comment = new StringBuffer("");
        comment.append("COMMENT").append(" ").append("ON").append(" ").append(objectType).append(" ");
        if (obj instanceof Index || obj instanceof Column || obj instanceof ForeignKey || obj instanceof Trigger) {
            objectName = this.getTableSubObjectCommentName(obj, quoteIdentifiers);
        }
        comment.append(objectName).append(" ").append("IS").append(" ").append(description);
        return comment.toString();
    }

    public String getEventComment(Event obj) {
        StringBuffer sb = new StringBuffer();
        String desc = obj.getDescription();
        if (desc != null) {
            sb.append("/*").append(NEWLINE).append(desc).append(NEWLINE).append("*/").append(NEWLINE);
        }
        return sb.toString();
    }

    private String getTableSubObjectCommentName(SQLObject obj, boolean quoteIdentifiers) {
        Table table = (Table)ContainmentServiceImpl.INSTANCE.getContainer((EObject)obj);
        String indexName = obj.getName();
        String schemaName = table.getSchema().getName();
        String tableName = table.getName();
        if (quoteIdentifiers) {
            indexName = this.getDoubleQuotedString(indexName);
            schemaName = this.getDoubleQuotedString(schemaName);
            tableName = this.getDoubleQuotedString(tableName);
        }
        return String.valueOf(schemaName) + "." + tableName + "." + indexName;
    }

    protected String[] createPersistentTable(PersistentTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (table instanceof SybaseASABaseTable && !(table instanceof SybaseASABaseProxyTable)) {
            return this.createBaseTable((SybaseASABaseTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        if (table instanceof SybaseASABaseProxyTable) {
            return this.createProxyTable((SybaseASABaseProxyTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        throw new UnsupportedOperationException();
    }

    protected String[] createBaseTable(SybaseASABaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASABaseTable baseTable = table;
        StringBuffer statement = this.createTableBaseParts(quoteIdentifiers, baseTable);
        if (this.getDBSpace(baseTable) != null) {
            statement.append(this.getDBSpace(baseTable));
        }
        ArrayList<String> results = new ArrayList<String>();
        results.add(statement.toString());
        String tableComment = this.createComment((SQLObject)table, quoteIdentifiers, qualifyNames);
        if (tableComment != null && !tableComment.equals("")) {
            results.add(tableComment);
        }
        int i = 0;
        while (i < table.getColumns().size()) {
            Column column = (Column)table.getColumns().get(i);
            String colComment = this.createComment((SQLObject)column, quoteIdentifiers, qualifyNames);
            if (colComment != null && !colComment.equals("")) {
                results.add(colComment);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    private StringBuffer createTableBaseParts(boolean quoteIdentifiers, SybaseASABaseTable baseTable) {
        String schemaName = baseTable.getSchema().getName();
        String tableName = baseTable.getName();
        if (quoteIdentifiers) {
            schemaName = this.getDoubleQuotedString(schemaName);
            tableName = this.getDoubleQuotedString(tableName);
        }
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE");
        statement.append(" ");
        if (baseTable instanceof SybaseASABaseProxyTable && ((SybaseASABaseProxyTable)baseTable).isExisting()) {
            statement.append("EXISTING").append(" ");
        }
        statement.append("TABLE");
        statement.append(" ");
        statement.append(schemaName);
        statement.append(".");
        statement.append(tableName);
        statement.append(" ");
        statement.append(this.getColumnAndPctfree((BaseTable)baseTable, quoteIdentifiers));
        return statement;
    }

    protected String[] createProxyTable(SybaseASABaseProxyTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer stmt = new StringBuffer(512);
        stmt.append(this.createTableBaseParts(quoteIdentifiers, (SybaseASABaseTable)table).toString());
        stmt.append(NEWLINE).append("AT").append(" ").append("'").append(table.getRemoteObjectLocation()).append("'");
        return new String[]{stmt.toString()};
    }

    protected String[] createTempoeryTable(TemporaryTable tempTable, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(tempTable instanceof SybaseASATempTable)) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        if (tempTable.isLocal()) {
            stmt.append("DECLARE LOCAL TEMPORARY TABLE").append(" ");
            String tableName = tempTable.getName();
            if (quoteIdentifiers) {
                tableName = this.getDoubleQuotedString(tableName);
            }
            stmt.append(tableName).append(" ");
        } else {
            stmt.append("CREATE").append(" ").append("GLOBAL TEMPORARY TABLE").append(" ").append(this.getName((Table)tempTable, quoteIdentifiers, qualifyNames)).append(" ");
        }
        stmt.append(this.getColumnAndPctfree((BaseTable)tempTable, quoteIdentifiers)).append(NEWLINE);
        if (((SybaseASATempTable)tempTable).getTransactionOption() == TransactionOption.NOT_TRANSACTION_LITERAL) {
            stmt.append("NOT TRANSACTIONAL");
        }
        if (((SybaseASATempTable)tempTable).getTransactionOption() == TransactionOption.PRESERVE_LITERAL) {
            stmt.append("ON COMMIT PRESERVE ROWS");
        }
        if (((SybaseASATempTable)tempTable).getTransactionOption() == TransactionOption.DELETE_LITERAL) {
            stmt.append("ON COMMIT DELETE ROWS");
        }
        ArrayList<String> results = new ArrayList<String>();
        results.add(stmt.toString());
        String tableComment = this.createComment((SQLObject)tempTable, quoteIdentifiers, qualifyNames);
        if (tableComment != null && !tableComment.equals("")) {
            results.add(tableComment);
        }
        int i = 0;
        while (i < tempTable.getColumns().size()) {
            Column column = (Column)tempTable.getColumns().get(i);
            String colComment = this.createComment((SQLObject)column, quoteIdentifiers, qualifyNames);
            if (colComment != null && !colComment.equals("")) {
                results.add(colComment);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String comment;
        SybaseASABaseIndex asaIndex = (SybaseASABaseIndex)index;
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE ");
        if (asaIndex instanceof SybaseASAIndex && ((SybaseASAIndex)asaIndex).isVirtual()) {
            statement.append("VIRTUAL ");
        }
        if (index.isUnique()) {
            statement.append("UNIQUE ");
        }
        if (index.isClustered()) {
            statement.append("CLUSTERED ");
        }
        statement.append("INDEX " + this.getName(index, quoteIdentifiers, qualifyNames) + " " + NEWLINE + "\t" + "ON" + " " + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + " " + NEWLINE + "\t" + "(" + this.getIndexKeyColumns(index, quoteIdentifiers) + ")");
        if (asaIndex.getDbSpace() != null) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "ON" + " " + this.getName((ENamedElement)asaIndex.getDbSpace(), quoteIdentifiers, qualifyNames));
        }
        if (!((comment = this.createComment((SQLObject)index, quoteIdentifiers, qualifyNames)) == null || comment.trim().equals("") || asaIndex instanceof SybaseASAIndex && ((SybaseASAIndex)asaIndex).isVirtual())) {
            return new String[]{statement.toString(), comment};
        }
        return new String[]{statement.toString()};
    }

    public String[] addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (constraint == null) {
            return null;
        }
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        statement.append(NEWLINE).append("\t").append("ADD").append(" ");
        statement.append(this.getAddUniqueConstraintClause(constraint, quoteIdentifiers));
        return new String[]{statement.toString()};
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getReferenceMembersString(EList members, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer(128);
        Iterator it = members.iterator();
        if (!it.hasNext()) {
            return " ";
        }
        Column c = (Column)it.next();
        if (quoteIdentifiers) {
            statement.append(this.getDoubleQuotedString(c.getName()));
        } else {
            statement.append(c.getName());
        }
        while (it.hasNext()) {
            c = (Column)it.next();
            if (quoteIdentifiers) {
                statement.append(",").append(" ").append(this.getDoubleQuotedString(c.getName()));
                continue;
            }
            statement.append(",").append(" ").append(c.getName());
        }
        return statement.toString();
    }

    public String[] addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (foreignKey == null) {
            return null;
        }
        SybaseASAForeignKey asaForeignKey = (SybaseASAForeignKey)foreignKey;
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
        }
        EList refMembers = foreignKey.getReferencedMembers();
        if (parentTable == null || refMembers == null || refMembers.size() == 0) {
            return null;
        }
        parentKey = this.getReferenceMembersString(refMembers, quoteIdentifiers);
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(super.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ").append("ADD").append(" ");
        String name = foreignKey.getName();
        if (name != null && name.trim().length() != 0) {
            if (quoteIdentifiers) {
                name = super.getDoubleQuotedString(name);
            }
            statement.append("CONSTRAINT").append(" ").append(name).append(" ");
        }
        if (asaForeignKey.isNullable()) {
            statement.append(" ");
        } else {
            statement.append("NOT").append(" ").append("NULL").append(" ");
        }
        statement.append("FOREIGN KEY").append(" ").append("(").append(this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers)).append(")").append(NEWLINE);
        statement.append("\t").append("REFERENCES").append(" ").append(super.getName((Table)parentTable, quoteIdentifiers, qualifyNames)).append(" ").append("(").append(parentKey).append(")");
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement.append(NEWLINE).append("\t").append("ON").append(" ").append("DELETE").append(" ");
        }
        statement.append(this.getReferentialAction(action));
        action = foreignKey.getOnUpdate();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement.append(NEWLINE).append("\t").append("ON").append(" ").append("UPDATE").append(" ");
        }
        statement.append(this.getReferentialAction(action));
        if (asaForeignKey.isCheckOnCommit()) {
            statement.append(NEWLINE).append("\t").append("CHECK").append(" ").append("ON").append(" ").append("COMMIT");
        }
        if (asaForeignKey.isClustered()) {
            statement.append(NEWLINE).append("\t").append("CLUSTERED");
        } else if (!asaForeignKey.isClustered()) {
            statement.append(NEWLINE).append("\t").append("NONCLUSTERED");
        }
        String addSql = statement.toString();
        String comments = this.createComment((SQLObject)foreignKey, quoteIdentifiers, qualifyNames);
        if (comments != null) {
            return new String[]{addSql, comments};
        }
        return new String[]{addSql};
    }

    public String[] createColumn(Column col, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName(col.getTable(), quoteIdentifiers, qualifyNames)).append(" ").append("ADD").append(" ").append(this.getColumnString(col, quoteIdentifiers));
        String comment = "";
        if (col.getDescription() != null && col.getDescription().trim().length() != 0) {
            comment = this.createComment((SQLObject)col, quoteIdentifiers, true);
            return new String[]{sb.toString(), comment};
        }
        return new String[]{sb.toString()};
    }

    public String[] createDBSpace(SybaseASABaseDBSpace dbSpace, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("CREATE").append(" ").append("DBSPACE").append(" ").append(this.getName((ENamedElement)dbSpace, quoteIdentifiers, qualifyNames)).append(" ").append("AS").append(" ").append(this.getSingleQuotedString(dbSpace.getFileName()));
        return new String[]{sb.toString()};
    }

    public String[] createAuthorizationId(AuthorizationIdentifier authId, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuffer sb1 = new StringBuffer(128);
        String name = this.getName((ENamedElement)authId, quoteIdentifiers, qualifyNames);
        sb1.append("GRANT").append(" ").append("CONNECT").append(" ").append("TO").append(" ").append(name).append(NEWLINE).append("\t").append("IDENTIFIED").append(" ").append("BY").append(" ").append("'******'");
        results.add(sb1.toString());
        if (authId instanceof Group) {
            StringBuffer sb2 = new StringBuffer(128);
            sb2.append("GRANT").append(" ").append("GROUP").append(" ").append("TO").append(" ").append(name);
            results.add(sb2.toString());
            EList users = ((Group)authId).getUser();
            StringBuffer strUserNames = new StringBuffer(128);
            int i = 0;
            while (i < users.size()) {
                User user = (User)users.get(i);
                strUserNames.append(this.getName((ENamedElement)user, quoteIdentifiers, qualifyNames));
                if (i != users.size() - 1) {
                    strUserNames.append(",").append(" ");
                }
                ++i;
            }
            if (users.size() > 0) {
                StringBuffer sb3 = new StringBuffer(128);
                sb3.append("GRANT").append(" ").append("MEMBERSHIP").append(" ").append("IN").append(" ").append("GROUP").append(" ").append(name).append(NEWLINE).append("TO").append(" ").append(strUserNames);
                results.add(sb3.toString());
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String dropEvent(Event event, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = "DROP EVENT " + this.getName(event, quoteIdentifiers, qualifyNames);
        String eventName = event.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_EVENT, eventName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = "DROP PROCEDURE " + this.getName(procedure, quoteIdentifiers, qualifyNames);
        String ownerName = procedure.getSchema().getName();
        String procName = procedure.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_PROCEDURE, ownerName, procName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = "DROP FUNCTION " + this.getName(function, quoteIdentifiers, qualifyNames);
        String ownerName = function.getSchema().getName();
        String procName = function.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_PROCEDURE, ownerName, procName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = super.dropTable(table, quoteIdentifiers, qualifyNames);
        String ownerName = table.getSchema().getName();
        String tableName = table.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_TABLE, ownerName, tableName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = super.dropView(view, quoteIdentifiers, qualifyNames);
        String ownerName = view.getSchema().getName();
        String viewName = view.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_VIEW, ownerName, viewName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = this.dropConstraint((TableConstraint)foreignKey, quoteIdentifiers, qualifyNames);
        statement.append(" ").append(this.getName((TableConstraint)foreignKey, quoteIdentifiers));
        String dropStatement = statement.toString();
        return this.getConstraintDropStatement((TableConstraint)foreignKey, dropStatement);
    }

    public String dropCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = this.dropTableConstraint((TableConstraint)constraint, quoteIdentifiers, qualifyNames);
        return this.getConstraintDropStatement((TableConstraint)constraint, dropStatement);
    }

    public String dropUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = this.dropConstraint((TableConstraint)constraint, quoteIdentifiers, qualifyNames);
        String dropStatement = null;
        if (constraint instanceof PrimaryKey) {
            dropStatement = statement.toString();
        } else {
            statement = new StringBuffer(128);
            statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
            statement.append("DROP").append(" ").append("CONSTRAINT").append(" ").append(this.getName((TableConstraint)constraint, quoteIdentifiers));
            dropStatement = statement.toString();
        }
        return this.getConstraintDropStatement((TableConstraint)constraint, dropStatement);
    }

    protected String getConstraintDropStatement(TableConstraint constraint, String dropStatement) {
        BaseTable table = constraint.getBaseTable();
        Schema schema = table.getSchema();
        String ownerName = schema.getName();
        String tableName = table.getName();
        String constraintName = constraint.getName();
        String type = "";
        type = constraint instanceof PrimaryKey ? "P" : (constraint instanceof UniqueConstraint ? "U" : (constraint instanceof ForeignKey ? "F" : (constraint instanceof SybaseASABaseColumnCheckConstraint ? "C" : "T")));
        SybaseASABaseDatabase database = (SybaseASABaseDatabase)schema.getDatabase();
        String queryPattern = QueryObjectsSQL.QUERY_CONSTRAINT;
        if (database.isBaseOnASA10()) {
            queryPattern = QueryObjectsSQL.QUERY_CONSTRAINT_FOR_ASA10;
        }
        String existingCheck = MessageFormat.format(queryPattern, ownerName, tableName, constraintName, type);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropUserDefinedType(UserDefinedType udt, boolean quoteIdentifiers, boolean qualifyNames) {
        SybaseASABaseUserDefinedType asaUDT = (SybaseASABaseUserDefinedType)udt;
        StringBuffer sb = new StringBuffer(128);
        if (quoteIdentifiers) {
            sb.append("DROP").append(" ").append("DOMAIN").append(" ").append(SQLUtil.quote((String)asaUDT.getName(), (String)"\""));
        } else {
            sb.append("DROP").append(" ").append("DOMAIN").append(" ").append(asaUDT.getName());
        }
        String dropStatement = sb.toString();
        String udtName = udt.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_UDT, udtName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropDBSpace(SybaseASABaseDBSpace dbspace, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("DBSPACE").append(" ").append(dbspace.getName());
        String dropStatement = sb.toString();
        String dbspaceName = dbspace.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_DBSPACE, dbspaceName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropAuthorizationId(AuthorizationIdentifier authId, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("REVOKE").append(" ").append("CONNECT").append(" ").append("FROM").append(" ").append(this.getName((ENamedElement)authId, quoteIdentifiers, qualifyNames));
        String dropStatement = sb.toString();
        String authIdName = authId.getName();
        String userOrGroup = authId instanceof Group ? "Y" : "N";
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_AUTHID, authIdName, userOrGroup);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        SybaseASABaseColumn baseColumn = (SybaseASABaseColumn)column;
        StringBuffer statement = new StringBuffer();
        String columnName = baseColumn.getName();
        String dataTypeName = this.getDataTypeString((TypedElement)column, column.getTable().getSchema(), quoteIdentifiers);
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        statement.append(columnName);
        statement.append(" ");
        statement.append(dataTypeName);
        if (baseColumn.isNullable()) {
            statement.append(" ");
            statement.append("NULL");
        } else {
            statement.append(" ");
            statement.append("NOT");
            statement.append(" ");
            statement.append("NULL");
        }
        if (baseColumn.getDefaultValue() != null) {
            String defaultName = column.getDefaultValue();
            statement.append(" ");
            statement.append(baseColumn.isIsComputedColumn() ? "COMPUTE" : "DEFAULT");
            statement.append(" ");
            String defaultValueStr = defaultName;
            if (baseColumn.isIsComputedColumn()) {
                defaultValueStr = "(" + defaultName + ")";
            }
            statement.append(defaultValueStr);
        }
        return statement.toString();
    }

    protected String getIdentityString(IdentitySpecifier identitySpecifier) {
        String clause = "START WITH " + identitySpecifier.getStartValue() + " ,INCREMENT BY " + identitySpecifier.getIncrement();
        return clause;
    }

    public String getWatcomParameters(Routine routine, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer();
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            sb.append(this.getWatcomParameter(routine, p));
            if (!it.hasNext()) continue;
            sb.append(",").append(" ");
        }
        return sb.toString();
    }

    public String getWatcomParameter(Routine routine, Parameter p) {
        ParameterType paramType = null;
        if (p instanceof SybaseASABaseParameter) {
            paramType = ((SybaseASABaseParameter)p).getParmType();
        }
        ParameterMode mode = p.getMode();
        String name = p.getName();
        String type = this.getDataTypeString((TypedElement)p, routine.getSchema());
        String dft = null;
        if (p instanceof SybaseParameter) {
            dft = ((SybaseParameter)p).getDefaultValue();
        }
        return this.getWatcomParameter(name, type, dft, mode.getLiteral(), paramType);
    }

    public String getWatcomParameter(String name, String type, String defValue, String mode, ParameterType paramType) {
        if (paramType != null && (paramType.getValue() == 3 || paramType.getValue() == 2)) {
            return paramType.getLiteral();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(mode).append(" ");
        if (name != null && name.length() != 0) {
            sb.append(name).append(" ");
        }
        sb.append(type);
        if (defValue != null && defValue.length() != 0) {
            sb.append(" ").append("DEFAULT").append(" ").append(defValue).append(" ");
        }
        return sb.toString();
    }

    protected String getFuncParameters(UserDefinedFunction function, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer();
        Iterator it = function.getParameters().iterator();
        while (it.hasNext()) {
            String name;
            Parameter p = (Parameter)it.next();
            ParameterMode mode = p.getMode();
            if (mode == ParameterMode.IN_LITERAL && fullSyntax) {
                sb.append("IN").append(" ");
            }
            if ((name = p.getName()) != null && name.length() != 0) {
                sb.append(p.getName()).append(" ");
            }
            sb.append(this.getDataTypeString((TypedElement)p, function.getSchema()));
            if (!it.hasNext()) continue;
            sb.append(",").append(" ");
        }
        return sb.toString();
    }

    protected String getExternalNameOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer();
        if ("JAVA".equalsIgnoreCase(routine.getLanguage())) {
            if (routine instanceof Procedure && ((Procedure)routine).getMaxResultSets() > 0) {
                sb.append("\t").append("DYNAMIC RESULT SETS").append(" ").append(((Procedure)routine).getMaxResultSets()).append(NEWLINE);
            }
            sb.append("\t").append("EXTERNAL NAME").append(" ").append(routine.getExternalName()).append(" ");
            sb.append("LANGUAGE").append(" ").append("JAVA").append(NEWLINE);
        } else {
            sb.append("\t").append("EXTERNAL NAME").append(" ").append(routine.getExternalName()).append(NEWLINE);
        }
        return sb.toString();
    }

    protected String getFunctionReturnsClause(UserDefinedFunction function) {
        if (function.getReturnScalar() != null) {
            Parameter scaler = function.getReturnScalar();
            StringBuffer sb = new StringBuffer();
            sb.append("RETURNS").append(" ").append(this.getDataTypeString((TypedElement)scaler, function.getSchema())).append(NEWLINE);
            return sb.toString();
        }
        return "";
    }

    public int getSyntaxType(Procedure routine) {
        int[] index;
        if (routine instanceof SybaseASABaseRemoteProcedure) {
            return 5;
        }
        if (routine.getExternalName() != null) {
            if ("Java".equalsIgnoreCase(routine.getLanguage())) {
                return 3;
            }
            return 4;
        }
        boolean watcom1 = false;
        EList params = routine.getParameters();
        if (routine instanceof SybaseASABaseProcedure) {
            watcom1 = ((SybaseASABaseProcedure)routine).isOnExceptionResume();
        }
        if (!watcom1 && params != null && params.size() >= 1) {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Parameter param = (Parameter)it.next();
                if (!(param instanceof SybaseASABaseParameter)) continue;
                SybaseASABaseParameter sybParam = (SybaseASABaseParameter)param;
                if (sybParam.getParmType().getValue() == 0) {
                    watcom1 |= param.getName() != null && !param.getName().startsWith("@");
                    continue;
                }
                if (sybParam.getParmType().getValue() == 1) {
                    int[] index2;
                    if (routine.getSource().getBody() == null || (index2 = QuickSQLParser.getInstance().find(routine.getSource().getBody(), new String[]{"result", "("})) == null || index2.length <= 0 || index2[0] <= 0) continue;
                    return 1;
                }
                if (sybParam.getParmType() != ParameterType.SQLSTATE_LITERAL && sybParam.getParmType() != ParameterType.SQLCODE_LITERAL) continue;
                return 2;
            }
        }
        if (watcom1) {
            return 1;
        }
        if (routine.getSource().getBody() != null && ((index = QuickSQLParser.getInstance().find(routine.getSource().getBody(), new String[]{"as"})) == null || index.length == 0 || index[0] < 0)) {
            return 1;
        }
        return 0;
    }

    protected String getColumnAndPctfree(BaseTable baseTable, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer();
        statement.append("(");
        statement.append(NEWLINE);
        EList list = baseTable.getColumns();
        String pctFREE = this.getPctfree(baseTable, quoteIdentifiers);
        int size = list.size();
        if (pctFREE != null) {
            ++size;
        }
        int i = 0;
        while (i < list.size()) {
            SybaseASABaseColumn column = (SybaseASABaseColumn)list.get(i);
            statement.append(this.getColumnString((Column)column, quoteIdentifiers));
            if (size > 1 && i < size - 1) {
                statement.append(",");
                statement.append(" ");
                statement.append(NEWLINE);
            }
            ++i;
        }
        if (pctFREE != null) {
            statement.append(pctFREE);
        }
        statement.append(")");
        return statement.toString();
    }

    protected String getDBSpace(SybaseASABaseTable baseTable) {
        StringBuffer statement = null;
        if (baseTable.getDbSpace() != null && baseTable.getDbSpace().getName() != null) {
            statement = new StringBuffer();
            statement.append(NEWLINE);
            statement.append("IN");
            statement.append(" ");
            statement.append(baseTable.getDbSpace().getName());
        }
        if (statement == null) {
            return null;
        }
        return statement.toString();
    }

    protected String getPctfree(BaseTable table, boolean quoteIdentifiers) {
        SybaseASATable sybaseASATable;
        StringBuffer statement = null;
        if (table instanceof SybaseASATable) {
            statement = new StringBuffer();
            sybaseASATable = (SybaseASATable)table;
            if (sybaseASATable.getPctfree() != -1) {
                statement.append("PCTFREE");
                statement.append(" ");
                statement.append(sybaseASATable.getPctfree());
            }
        }
        if (table instanceof SybaseASATempTable) {
            statement = new StringBuffer();
            sybaseASATable = (SybaseASATempTable)table;
            if (sybaseASATable.getPctfree() != -1) {
                statement.append("PCTFREE");
                statement.append(" ");
                statement.append(sybaseASATable.getPctfree());
            }
        }
        if (statement == null) {
            return null;
        }
        return statement.toString();
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer(128);
        String name = constraint.getName();
        if (name != null && name.trim().length() != 0) {
            if (quoteIdentifiers) {
                name = super.getDoubleQuotedString(name);
            }
            statement.append("CONSTRAINT").append(" ").append(name).append(" ");
        }
        statement.append(this.getUniqueConstraintType(constraint)).append(" ");
        SybaseASABaseUniqueConstraint asaUniqueConstraint = (SybaseASABaseUniqueConstraint)constraint;
        if (asaUniqueConstraint.isClustered()) {
            statement.append("CLUSTERED").append(" ");
        } else if (!asaUniqueConstraint.isClustered()) {
            statement.append("NONCLUSTERED").append(" ");
        }
        String keyColumns = this.getKeyColumns((ReferenceConstraint)constraint, quoteIdentifiers);
        statement.append("(").append(keyColumns).append(")");
        return statement.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getKeyColumns(SybaseASAIndex index, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer(128);
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) {
            return null;
        }
        IndexMember idxMember = (IndexMember)it.next();
        Column c = idxMember.getColumn();
        if (quoteIdentifiers) {
            statement.append(this.getDoubleQuotedString(c.getName()));
        } else {
            statement.append(c.getName());
        }
        while (it.hasNext()) {
            idxMember = (IndexMember)it.next();
            c = idxMember.getColumn();
            if (quoteIdentifiers) {
                statement.append(",").append(" ").append(this.getDoubleQuotedString(c.getName()));
                continue;
            }
            statement.append(",").append(" ").append(c.getName());
        }
        return statement.toString();
    }

    public String getEventSchedules(SybaseASABaseEvent evt) {
        StringBuffer sb = new StringBuffer();
        EList schedules = evt.getSchedules();
        Iterator iter = schedules.iterator();
        while (iter.hasNext()) {
            Schedule schedule = (Schedule)iter.next();
            sb.append(this.getEventSchedule(schedule));
            if (iter.hasNext()) {
                sb.append(",").append(NEWLINE);
                continue;
            }
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    public String getEventSchedule(Schedule schedule) {
        boolean recurring;
        StringBuffer sb = new StringBuffer();
        String name = schedule.getName();
        Date startDate = schedule.getStartDate();
        Date startTime = schedule.getStartTime();
        Date stopTime = schedule.getStopTime();
        int daysOfWeek = schedule.getDaysOfWeek();
        int daysOfMonth = schedule.getDaysOfMonth();
        sb.append("SCHEDULE").append(" ");
        if (name != null) {
            sb.append(name).append(" ");
        }
        if (startTime != null) {
            if (stopTime != null) {
                sb.append("BETWEEN").append(" ").append("'").append(this.toTimeString(startTime)).append("'").append(" ");
                sb.append("AND").append(" ").append("'").append(this.toTimeString(stopTime)).append("'").append(NEWLINE);
            } else {
                sb.append("START").append(" ").append("TIME").append(" ").append("'").append(this.toTimeString(startTime)).append("'").append(NEWLINE);
            }
        }
        if (recurring = schedule.isRecurring()) {
            sb.append("EVERY").append(" ").append(schedule.getIntervalMount()).append(" ").append(schedule.getIntervalUnit().getLiteral()).append(" ");
        }
        if (daysOfWeek > 0) {
            sb.append("ON").append(" ").append("(").append(this.parseDaysOfWeek(daysOfWeek)).append(")").append(" ");
        } else if (daysOfMonth != 0) {
            sb.append("ON").append(" ").append("(").append(this.parseDaysOfMonth(daysOfMonth)).append(")").append(" ");
        }
        if (startDate != null) {
            sb.append("START").append(" ").append("DATE").append(" ").append("'").append(this.toDateString(startDate)).append("'").append(" ");
        }
        return sb.toString();
    }

    public String parseDaysOfWeek(int daysOfWeek) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 7) {
            if ((daysOfWeek & 1 << i) > 0) {
                sb.append("'").append(DAYS_OF_WEEK[i]).append("'").append(",");
            }
            ++i;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String parseDaysOfMonth(int daysOfMonth) {
        StringBuffer sb = new StringBuffer();
        if ((daysOfMonth & Integer.MIN_VALUE) != 0) {
            sb.append(0).append(",");
        }
        int i = 0;
        while (i < 31) {
            if ((daysOfMonth & 1 << i) != 0) {
                sb.append(i + 1).append(",");
            }
            ++i;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String toDateString(Date date) {
        if (date != null) {
            return DATE_FORMAT.format(date);
        }
        return "";
    }

    protected String toTimeString(Date time) {
        if (time != null) {
            return TIME_FORMAT.format(time);
        }
        return "";
    }

    protected StringBuffer dropConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        statement.append("DROP").append(" ");
        if (constraint instanceof PrimaryKey) {
            statement.append("PRIMARY KEY");
        } else if (constraint instanceof CheckConstraint) {
            statement.append("CHECK");
        } else if (constraint instanceof ForeignKey) {
            statement.append("FOREIGN KEY");
        } else if (constraint instanceof UniqueConstraint) {
            statement.append("UNIQUE");
        }
        return statement;
    }

    public String[] addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (constraint instanceof SybaseASABaseColumnCheckConstraint) {
            StringBuffer statement = new StringBuffer(128);
            BaseTable table = constraint.getBaseTable();
            SybaseASABaseColumnCheckConstraint columnCheckConstraint = (SybaseASABaseColumnCheckConstraint)constraint;
            SybaseASABaseColumn column = columnCheckConstraint.getColumn();
            if (table == null) {
                if (column != null) {
                    table = (BaseTable)column.getTable();
                } else {
                    return new String[]{statement.toString()};
                }
            }
            if (table == null) {
                return new String[]{statement.toString()};
            }
            statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)table, quoteIdentifiers, qualifyNames)).append(" ");
            if (column != null) {
                String columnName = column.getName();
                if (quoteIdentifiers) {
                    columnName = this.getDoubleQuotedString(columnName);
                }
                statement.append("ALTER").append(" ").append(columnName).append(" ");
            }
            statement.append(NEWLINE).append("\t").append("ADD").append(" ");
            statement.append(this.getAddCheckConstraintClause(constraint, quoteIdentifiers));
            return new String[]{statement.toString()};
        }
        return super.addCheckConstraint(constraint, quoteIdentifiers, qualifyNames, fullSyntax);
    }

    protected String getName(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        String tableName = trigger.getSubjectTable().getName();
        String schemaName = trigger.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + tableName + "." + name;
        }
        return name;
    }
}

