/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tablewizard.ui.popup.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.sqltools.tablewizard.ui.Messages;
import org.eclipse.datatools.sqltools.tablewizard.ui.TableDefinitionUIPlugin;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.UIUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DeleteTableWizardAction
extends AbstractAction {
    private static final String TEXT = Messages.getString("table.delete.menu");

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (event.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject) {
            EObject o = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            String groupID = containmentService.getGroupId(o);
            this.setEnabled(groupID != null && groupID.startsWith("core."));
        }
    }

    public void initialize() {
        this.initializeAction(null, null, TEXT, TEXT);
    }

    public void run() {
        Iterator iter;
        Object selectedObj;
        if (!this.event.getSelection().isEmpty() && (selectedObj = (iter = ((IStructuredSelection)this.event.getSelection()).iterator()).next()) instanceof PersistentTable) {
            Database db = this.getDatabase(((PersistentTable)selectedObj).getSchema());
            ConnectionInfo conInfo = (ConnectionInfo)DatabaseConnectionRegistry.getConnectionForDatabase((Database)db);
            IConnectionProfile profile = conInfo.getConnectionProfile();
            PersistentTable table = (PersistentTable)selectedObj;
            try {
                this.deleteTable(profile, table);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Database getDatabase(Schema schema) {
        return schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
    }

    private void deleteTable(final IConnectionProfile profile, final PersistentTable table) throws Exception {
        final Database db = table.getSchema().getDatabase() != null ? table.getSchema().getDatabase() : table.getSchema().getCatalog().getDatabase();
        final DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor monitor) {
                try {
                    try {
                        String[] sqls = DeleteTableWizardAction.this.createDeleteSql(table, databaseDefinition, monitor);
                        UIUtils.openSQLEditor(profile, db, sqls, monitor);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        TableDefinitionUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().run(false, false, (IRunnableWithProgress)operation);
    }

    protected String[] createDeleteSql(PersistentTable table, DatabaseDefinition databaseDefinition, IProgressMonitor monitor) {
        DDLGenerator generator = databaseDefinition.getDDLGenerator();
        return generator.dropSQLObjects(new SQLObject[]{table}, false, false, monitor);
    }
}

