/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.internal.databinding.viewers.ViewerUpdater;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObservableListContentProvider
implements IStructuredContentProvider {
    private ObservableCollectionContentProvider impl = new Impl();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet getKnownElements() {
        return this.impl.getKnownElements();
    }

    public IObservableSet getRealizedElements() {
        return this.impl.getRealizedElements();
    }

    private static class Impl
    extends ObservableCollectionContentProvider
    implements IListChangeListener {
        private Impl() {
        }

        protected void checkInput(Object input) {
            Assert.isTrue((boolean)(input instanceof IObservableList), (String)"This content provider only works with input of type IObservableList");
        }

        protected void addCollectionChangeListener(IObservableCollection collection) {
            ((IObservableList)collection).addListChangeListener((IListChangeListener)this);
        }

        protected void removeCollectionChangeListener(IObservableCollection collection) {
            ((IObservableList)collection).removeListChangeListener((IListChangeListener)this);
        }

        public void handleListChange(ListChangeEvent event) {
            if (this.isViewerDisposed()) {
                return;
            }
            Set knownElementAdditions = ViewerElementSet.withComparer(this.comparer);
            Set knownElementRemovals = ViewerElementSet.withComparer(this.comparer);
            event.diff.accept(new ListDiffVisitor(this, knownElementAdditions, knownElementRemovals){
                final /* synthetic */ Impl this$1;
                private final /* synthetic */ Set val$knownElementAdditions;
                private final /* synthetic */ Set val$knownElementRemovals;
                {
                    this.this$1 = impl;
                    this.val$knownElementAdditions = set;
                    this.val$knownElementRemovals = set2;
                }

                public void handleAdd(int index, Object element) {
                    this.val$knownElementAdditions.add(element);
                }

                public void handleRemove(int index, Object element) {
                    this.val$knownElementRemovals.add(element);
                }
            });
            knownElementAdditions.removeAll((Collection<?>)this.knownElements);
            knownElementRemovals.removeAll((Collection<?>)event.getObservableList());
            this.knownElements.addAll((Collection)knownElementAdditions);
            if (this.realizedElements != null) {
                this.realizedElements.removeAll((Collection)knownElementRemovals);
            }
            event.diff.accept(new ListDiffVisitor(this){
                final /* synthetic */ Impl this$1;
                {
                    this.this$1 = impl;
                }

                public void handleAdd(int index, Object element) {
                    Impl.access$0(this.this$1).insert(element, index);
                }

                public void handleRemove(int index, Object element) {
                    Impl.access$0(this.this$1).remove(element, index);
                }

                public void handleReplace(int index, Object oldElement, Object newElement) {
                    Impl.access$0(this.this$1).replace(oldElement, newElement, index);
                }

                public void handleMove(int oldIndex, int newIndex, Object element) {
                    Impl.access$0(this.this$1).move(element, oldIndex, newIndex);
                }
            });
            if (this.realizedElements != null) {
                this.realizedElements.addAll((Collection)knownElementAdditions);
            }
            this.knownElements.removeAll((Collection)knownElementRemovals);
        }

        static /* synthetic */ ViewerUpdater access$0(Impl impl) {
            return impl.viewerUpdater;
        }
    }
}

