/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ButtonObservableValue
extends AbstractSWTObservableValue {
    private final Button button;
    private boolean selectionValue;
    private Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            boolean oldSelectionValue = ButtonObservableValue.this.selectionValue;
            ButtonObservableValue.this.selectionValue = ButtonObservableValue.this.button.getSelection();
            ButtonObservableValue.this.notifyIfChanged(oldSelectionValue, ButtonObservableValue.this.selectionValue);
        }
    };

    public ButtonObservableValue(Button button) {
        super((Widget)button);
        this.button = button;
        this.init();
    }

    public ButtonObservableValue(Realm realm, Button button) {
        super(realm, (Widget)button);
        this.button = button;
        this.init();
    }

    private void init() {
        this.button.addListener(13, this.updateListener);
        this.button.addListener(14, this.updateListener);
        this.selectionValue = this.button.getSelection();
    }

    public void doSetValue(Object value) {
        boolean oldSelectionValue = this.selectionValue;
        this.selectionValue = value == null ? false : (Boolean)value;
        this.button.setSelection(this.selectionValue);
        this.notifyIfChanged(oldSelectionValue, this.selectionValue);
    }

    public Object doGetValue() {
        return this.button.getSelection() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getValueType() {
        return Boolean.TYPE;
    }

    public synchronized void dispose() {
        super.dispose();
        if (!this.button.isDisposed()) {
            this.button.removeListener(13, this.updateListener);
            this.button.removeListener(14, this.updateListener);
        }
    }

    private void notifyIfChanged(boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.fireValueChange(Diffs.createValueDiff((Object)(oldValue ? Boolean.TRUE : Boolean.FALSE), (Object)(newValue ? Boolean.TRUE : Boolean.FALSE)));
        }
    }
}

