/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.viewers.ListViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ObservableViewerElementSet;
import org.eclipse.jface.internal.databinding.viewers.TableViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ViewerUpdater;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public abstract class ObservableCollectionContentProvider
implements IStructuredContentProvider {
    private Display display = Display.getDefault();
    private IObservableValue viewerObservable = new WritableValue(SWTObservables.getRealm(this.display));
    protected IElementComparer comparer;
    private IObservableFactory elementSetFactory = new IObservableFactory(){

        public IObservable createObservable(Object target) {
            IElementComparer comparer = null;
            if (target instanceof StructuredViewer) {
                comparer = ((StructuredViewer)target).getComparer();
            }
            return ObservableViewerElementSet.withComparer(SWTObservables.getRealm(ObservableCollectionContentProvider.this.display), null, comparer);
        }
    };
    protected ViewerUpdater viewerUpdater = null;
    protected IObservableSet knownElements = MasterDetailObservables.detailSet((IObservableValue)this.viewerObservable, (IObservableFactory)this.elementSetFactory, null);
    private IObservableSet unmodifiableKnownElements = Observables.unmodifiableObservableSet((IObservableSet)this.knownElements);
    protected IObservableSet realizedElements;
    private IObservableSet unmodifiableRealizedElements;
    private IObservableCollection observableCollection = null;

    protected ObservableCollectionContentProvider() {
    }

    public Object[] getElements(Object inputElement) {
        if (this.observableCollection == null) {
            return new Object[0];
        }
        if (this.realizedElements != null && !this.realizedElements.equals((Object)this.knownElements)) {
            this.asyncUpdateRealizedElements();
        }
        return this.observableCollection.toArray();
    }

    private void asyncUpdateRealizedElements() {
        if (this.realizedElements == null) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (ObservableCollectionContentProvider.this.realizedElements != null) {
                    ObservableCollectionContentProvider.this.realizedElements.addAll((Collection)ObservableCollectionContentProvider.this.knownElements);
                }
            }
        });
    }

    public void dispose() {
        if (this.observableCollection != null) {
            this.removeCollectionChangeListener(this.observableCollection);
        }
        if (this.viewerObservable != null) {
            this.viewerObservable.setValue(null);
            this.viewerObservable.dispose();
            this.viewerObservable = null;
        }
        this.viewerUpdater = null;
        this.knownElements = null;
        this.unmodifiableKnownElements = null;
        this.realizedElements = null;
        this.unmodifiableRealizedElements = null;
        this.display = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.setViewer(viewer);
        this.setInput(newInput);
    }

    private void setViewer(Viewer viewer) {
        this.viewerUpdater = this.createViewerUpdater(viewer);
        this.comparer = ObservableCollectionContentProvider.getElementComparer(viewer);
        this.viewerObservable.setValue((Object)viewer);
    }

    private static IElementComparer getElementComparer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            return ((StructuredViewer)viewer).getComparer();
        }
        return null;
    }

    ViewerUpdater createViewerUpdater(Viewer viewer) {
        if (viewer instanceof AbstractListViewer) {
            return new ListViewerUpdater((AbstractListViewer)viewer);
        }
        if (viewer instanceof AbstractTableViewer) {
            return new TableViewerUpdater((AbstractTableViewer)viewer);
        }
        throw new IllegalArgumentException("This content provider only works with AbstractTableViewer or AbstractListViewer");
    }

    void setInput(Object input) {
        if (this.observableCollection != null) {
            this.removeCollectionChangeListener(this.observableCollection);
            this.observableCollection = null;
        }
        if (input != null) {
            this.checkInput(input);
            Assert.isTrue((boolean)(input instanceof IObservableCollection), (String)"Input must be an IObservableCollection");
            this.observableCollection = (IObservableCollection)input;
            this.addCollectionChangeListener(this.observableCollection);
            this.knownElements.addAll((Collection)this.observableCollection);
        }
    }

    protected abstract void checkInput(Object var1);

    protected abstract void addCollectionChangeListener(IObservableCollection var1);

    protected abstract void removeCollectionChangeListener(IObservableCollection var1);

    protected final boolean isViewerDisposed() {
        Viewer viewer = (Viewer)this.viewerObservable.getValue();
        return viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed();
    }

    public IObservableSet getKnownElements() {
        return this.unmodifiableKnownElements;
    }

    public IObservableSet getRealizedElements() {
        if (this.realizedElements == null) {
            this.realizedElements = MasterDetailObservables.detailSet((IObservableValue)this.viewerObservable, (IObservableFactory)this.elementSetFactory, null);
            this.unmodifiableRealizedElements = Observables.unmodifiableObservableSet((IObservableSet)this.realizedElements);
            this.asyncUpdateRealizedElements();
        }
        return this.unmodifiableRealizedElements;
    }
}

