/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.xsl.debug.ui.Messages;

public abstract class ResourceSelectionBlock
extends AbstractLaunchConfigurationTab {
    protected static final int ERROR_DIRECTORY_NOT_SPECIFIED = 1;
    protected static final int ERROR_DIRECTORY_DOES_NOT_EXIST = 2;
    protected static final int GROUP_NAME = 3;
    protected static final int USE_DEFAULT_RADIO = 4;
    protected static final int USE_OTHER_RADIO = 5;
    protected static final int DIRECTORY_DIALOG_MESSAGE = 6;
    protected static final int WORKSPACE_DIALOG_MESSAGE = 7;
    protected static final int VARIABLES_BUTTON = 8;
    protected static final int FILE_SYSTEM_BUTTON = 9;
    protected static final int WORKSPACE_BUTTON = 10;
    protected static final int WORKSPACE_DIALOG_TITLE = 11;
    protected Button fWorkspaceButton;
    protected Button fFileSystemButton;
    protected Button fVariablesButton;
    protected Button useDefaultCheckButton;
    protected Text resourceText;
    protected WidgetListener widgetListener = new WidgetListener();
    private ILaunchConfiguration fLaunchConfiguration;
    protected final boolean showDefault;
    private final int resourceType;
    private final boolean mustExist;
    protected boolean required;
    protected String defaultResource;
    protected String resource;
    protected String fileLabel = Messages.getString("ResourceSelectionBlock.0");
    private final ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                if (ResourceSelectionBlock.this.resourceType == 2 && !(selection[i] instanceof IContainer)) {
                    return new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
                }
                if (ResourceSelectionBlock.this.resourceType == 1 && !(selection[i] instanceof IFile)) {
                    return new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
                }
                ++i;
            }
            return new Status(0, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
        }
    };

    public ResourceSelectionBlock() {
        this(true);
    }

    public ResourceSelectionBlock(boolean showDefault) {
        this(2, showDefault);
    }

    public ResourceSelectionBlock(int resourceType, boolean showDefault) {
        this(resourceType, showDefault, true);
    }

    public ResourceSelectionBlock(int resourceType, boolean showDefault, boolean required) {
        this(resourceType, showDefault, required, true);
    }

    public ResourceSelectionBlock(int resourceType, boolean showDefault, boolean required, boolean mustExist) {
        this.showDefault = showDefault;
        this.resourceType = resourceType;
        this.required = required;
        this.mustExist = mustExist;
    }

    public void createControl(Composite parent) {
        Composite group = this.createContainer(parent);
        this.setControl((Control)group);
        this.createContents(group);
    }

    protected Composite createContainer(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.getMessage(3));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)groupLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(parent.getFont());
        return group;
    }

    protected void createContents(Composite parent) {
        this.createCheckboxAndText(parent);
        this.createButtons(parent);
    }

    protected void createCheckboxAndText(Composite parent) {
        if (this.showDefault) {
            this.useDefaultCheckButton = this.createCheckButton(parent, this.getMessage(4));
            GridData gd = new GridData(32);
            gd.horizontalSpan = 2;
            this.useDefaultCheckButton.setLayoutData((Object)gd);
            this.useDefaultCheckButton.addSelectionListener((SelectionListener)this.widgetListener);
        }
        Composite specificFileComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginLeft = this.showDefault ? 20 : 0;
        layout.marginHeight = 0;
        specificFileComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        specificFileComp.setLayoutData((Object)gd);
        if (this.showDefault) {
            Label label = new Label(specificFileComp, 0);
            label.setText(this.fileLabel);
        }
        this.resourceText = new Text(specificFileComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = this.showDefault ? 1 : 2;
        this.resourceText.setLayoutData((Object)gd);
        this.resourceText.setFont(parent.getFont());
        this.resourceText.addModifyListener((ModifyListener)this.widgetListener);
    }

    protected void createButtons(Composite parent) {
        new Label(parent, 0);
        Composite buttonComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        GridData gd = new GridData(128);
        gd.horizontalSpan = 1;
        buttonComp.setLayoutData((Object)gd);
        buttonComp.setFont(parent.getFont());
        this.fWorkspaceButton = this.createPushButton(buttonComp, this.getMessage(10), null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, this.getMessage(9), null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.fVariablesButton = this.createPushButton(buttonComp, this.getMessage(8), null);
        this.fVariablesButton.addSelectionListener((SelectionListener)this.widgetListener);
    }

    protected void updateResourceText(boolean useDefault) {
        if (useDefault) {
            this.resourceText.setText(this.defaultResource == null ? "" : this.defaultResource);
        } else {
            this.resourceText.setText(this.resource == null ? "" : this.resource);
        }
        this.resourceText.setEnabled(!useDefault);
        this.fFileSystemButton.setEnabled(!useDefault);
        this.fVariablesButton.setEnabled(!useDefault);
        this.fWorkspaceButton.setEnabled(!useDefault);
    }

    public void dispose() {
    }

    protected void handleExternalResourceBrowseButtonSelected() {
        String currentWorkingDir = this.getText();
        String selected = null;
        if (this.resourceType == 2) {
            File path;
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            dialog.setMessage(this.getMessage(6));
            if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
                dialog.setFilterPath(currentWorkingDir);
            }
            selected = dialog.open();
        } else {
            String[] fileExtensions;
            File path;
            FileDialog dialog = new FileDialog(this.getShell());
            if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
                dialog.setFilterPath(currentWorkingDir);
            }
            if ((fileExtensions = this.getFileExtensions()) != null) {
                String[] filterExtensions = new String[fileExtensions.length];
                int i = 0;
                while (i < fileExtensions.length) {
                    String ext = fileExtensions[i];
                    filterExtensions[i] = "*." + ext;
                    ++i;
                }
                dialog.setFilterExtensions(filterExtensions);
            }
            selected = dialog.open();
        }
        if (selected != null) {
            this.resourceText.setText(selected);
        }
    }

    protected String[] getFileExtensions() {
        return null;
    }

    protected void handleWorkspaceResourceBrowseButtonSelected() {
        IPath path = this.openWorkspaceResourceDialog();
        if (path != null) {
            this.setText("${workspace_loc:" + path.toString() + "}");
        }
    }

    protected IPath openWorkspaceResourceDialog() {
        Object[] elements;
        IResource currentResource = this.getResource();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(this.getMessage(11));
        dialog.setMessage(this.getMessage(7));
        dialog.setValidator(this.validator);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IContainer) {
                    return true;
                }
                if (ResourceSelectionBlock.this.resourceType != 1) {
                    return false;
                }
                IFile file = (IFile)element;
                String[] extensions = ResourceSelectionBlock.this.getFileExtensions();
                if (extensions == null) {
                    return true;
                }
                String fileExt = file.getFileExtension();
                if (fileExt != null) {
                    String[] stringArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ext = stringArray[n2];
                        if (fileExt.equalsIgnoreCase(ext)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        });
        ViewerFilter filter = this.getResourceFilter();
        if (filter != null) {
            dialog.addFilter(filter);
        }
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setInitialSelection((Object)currentResource);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0) {
            return ((IResource)elements[0]).getFullPath();
        }
        return null;
    }

    protected ViewerFilter getResourceFilter() {
        return null;
    }

    protected IResource getResource() {
        String path = this.getText();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    IFile[] files;
                    path = manager.performStringSubstitution(path, false);
                    if (this.resourceType == 2) {
                        IContainer[] containers = root.findContainersForLocation((IPath)new Path(path));
                        if (containers.length > 0) {
                            res = containers[0];
                        }
                    } else if (this.resourceType == 1 && (files = root.findFilesForLocation((IPath)new Path(path))).length > 0) {
                        res = files[0];
                    }
                }
                catch (CoreException coreException) {}
            } else {
                res = root.findMember(path);
            }
            return res;
        }
        return null;
    }

    protected void handleResourceVariablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variableText = dialog.getVariableExpression();
        if (variableText != null) {
            this.resourceText.insert(variableText);
        }
    }

    protected abstract void setDefaultResource();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String workingDirPath = this.getText();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
                if (!this.mustExist) return true;
                String path = manager.performStringSubstitution(workingDirPath);
                this.validateResource(path);
                return true;
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else {
            if (this.mustExist && workingDirPath.length() > 0) {
                return this.validateResource(workingDirPath);
            }
            if (!this.required || workingDirPath.length() != 0) return true;
            this.setErrorMessage(this.getMessage(1));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean validateResource(String workingDirPath) {
        File file;
        if (this.resourceType == 2) {
            IContainer container = (IContainer)this.getResource();
            if (container != null) return true;
            File dir = new File(workingDirPath);
            if (dir.isDirectory()) {
                return true;
            }
        } else if (this.resourceType == 1 && (file = new File(workingDirPath)).isFile()) {
            return true;
        }
        this.setErrorMessage(this.getMessage(2));
        return false;
    }

    protected abstract String getMessage(int var1);

    protected void textModified() {
    }

    protected String getText() {
        return this.resourceText.getText().trim();
    }

    protected void setText(String text) {
        this.resourceText.setText(text);
    }

    protected void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            ResourceSelectionBlock.this.textModified();
            ResourceSelectionBlock.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ResourceSelectionBlock.this.fWorkspaceButton) {
                ResourceSelectionBlock.this.handleWorkspaceResourceBrowseButtonSelected();
            } else if (source == ResourceSelectionBlock.this.fFileSystemButton) {
                ResourceSelectionBlock.this.handleExternalResourceBrowseButtonSelected();
            } else if (source == ResourceSelectionBlock.this.fVariablesButton) {
                ResourceSelectionBlock.this.handleResourceVariablesButtonSelected();
            } else if (source == ResourceSelectionBlock.this.useDefaultCheckButton) {
                ResourceSelectionBlock.this.updateResourceText(ResourceSelectionBlock.this.useDefaultCheckButton.getSelection());
            }
        }
    }
}

