/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.debug.ui.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.InputFileBlock;
import org.eclipse.wst.xsl.launching.config.BaseLaunchHelper;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLLaunchShortcut
implements ILaunchShortcut {
    private IFile xmlFile;
    private IPath xmlFilePath;
    private IFile[] xslFiles;

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.searchAndLaunch(ssel.toArray(), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file;
        IEditorInput input = editor.getEditorInput();
        if (input != null && (file = (IFile)input.getAdapter(IFile.class)) != null) {
            this.searchAndLaunch(new Object[]{file}, mode);
        }
    }

    private void searchAndLaunch(Object[] objects, String mode) {
        if (this.fillFiles(objects)) {
            if (this.xmlFile == null) {
                this.promptForInput();
            }
            if (this.xmlFile != null || this.xmlFilePath != null) {
                this.launch(mode);
            }
        }
    }

    private void promptForInput() {
        StatusDialog dialog = new StatusDialog(this.getShell()){
            private InputFileBlock inputFileBlock;
            {
                this.inputFileBlock = new InputFileBlock(null);
            }

            protected Control createDialogArea(Composite parent) {
                Composite comp = (Composite)super.createDialogArea(parent);
                comp.setFont(parent.getFont());
                GridLayout layout = new GridLayout(1, false);
                comp.setLayout((Layout)layout);
                Label label = new Label(comp, 0);
                label.setFont(comp.getFont());
                GridData gd = new GridData();
                gd.horizontalIndent = 5;
                gd.verticalIndent = 5;
                gd.widthHint = 380;
                label.setLayoutData((Object)gd);
                label.setText(Messages.getString("XSLLaunchShortcut.0"));
                this.inputFileBlock.createControl(comp);
                return comp;
            }

            protected void okPressed() {
                IResource res = this.inputFileBlock.getResource();
                if (res == null) {
                    XSLLaunchShortcut.this.xmlFilePath = (IPath)new Path(this.inputFileBlock.getText());
                } else if (ResourcesPlugin.getWorkspace().getRoot().exists(res.getFullPath()) && res.getType() == 1) {
                    XSLLaunchShortcut.this.xmlFile = (IFile)res;
                }
                super.okPressed();
            }
        };
        dialog.setHelpAvailable(false);
        dialog.setStatusLineAboveButtons(true);
        dialog.setTitle(Messages.getString("XSLLaunchShortcut.1"));
        dialog.open();
    }

    private boolean fillFiles(Object[] selections) {
        this.xmlFile = null;
        this.xmlFilePath = null;
        ArrayList<IFile> xslFileList = new ArrayList<IFile>();
        Object[] objectArray = selections;
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object object = objectArray[n2];
            IResource resource = (IResource)object;
            if (resource.getType() == 1 && XSLCore.isXMLFile((IFile)(file = (IFile)resource))) {
                if (XSLCore.isXSLFile((IFile)file)) {
                    xslFileList.add(file);
                } else if (this.xmlFile == null) {
                    this.xmlFile = file;
                } else {
                    return false;
                }
            }
            ++n2;
        }
        this.xslFiles = xslFileList.toArray(new IFile[0]);
        return true;
    }

    private void launch(String mode) {
        if (this.xmlFile != null) {
            this.xmlFilePath = this.xmlFile.getLocation();
        }
        ILaunchConfiguration config = null;
        try {
            config = this.findOrCreateLaunchConfiguration();
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.xsl.launching.launchConfigurationType");
    }

    private ILaunchConfiguration findOrCreateLaunchConfiguration() throws CoreException {
        ILaunchConfiguration config;
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(this.getConfigurationType());
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                config = iLaunchConfigurationArray[n2];
                String inputFile = config.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null);
                try {
                    inputFile = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(inputFile);
                }
                catch (CoreException coreException) {
                    break block7;
                }
                Path path = new Path(inputFile);
                if (path.equals((Object)this.xmlFilePath)) {
                    BaseLaunchHelper lh = new BaseLaunchHelper(config);
                    boolean found = false;
                    IFile[] iFileArray = this.xslFiles;
                    int n3 = this.xslFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFile stylesheet = iFileArray[n4];
                        found = false;
                        for (LaunchTransform lt : lh.getPipeline().getTransformDefs()) {
                            if (!lt.getLocation().equals((Object)stylesheet.getLocation())) continue;
                            found = true;
                            break;
                        }
                        if (!found) break;
                        ++n4;
                    }
                    if (found) {
                        candidateConfigs.add(config);
                    }
                }
            }
            ++n2;
        }
        config = null;
        int candidateCount = candidateConfigs.size();
        config = candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : (candidateCount > 1 ? this.chooseConfiguration(candidateConfigs) : this.createConfiguration());
        return config;
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.getString("XSLLaunchShortcut.2"));
        dialog.setMessage("&Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createConfiguration() {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(this.xmlFilePath.lastSegment()));
            if (this.xmlFile != null) {
                wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", "${workspace_loc:" + this.xmlFile.getFullPath().toPortableString() + "}");
            } else {
                wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", this.xmlFilePath.toPortableString());
            }
            wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
            wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
            LaunchPipeline pipeline = new LaunchPipeline();
            IFile[] iFileArray = this.xslFiles;
            int n = this.xslFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile element = iFileArray[n2];
                pipeline.addTransformDef(new LaunchTransform(element.getFullPath().toPortableString(), "resource"));
                ++n2;
            }
            wc.setAttribute("org.eclipse.wst.xsl.launching.ATTR_PIPELINE", pipeline.toXML());
            if (this.xmlFile != null) {
                wc.setMappedResources(new IResource[]{this.xmlFile.getProject()});
            }
            config = wc.doSave();
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("XSLLaunchShortcut.6"), (String)exception.getStatus().getMessage());
        }
        return config;
    }

    protected Shell getShell() {
        return XSLDebugUIPlugin.getActiveWorkbenchShell();
    }
}

