/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.xsl.internal.debug.ui.ResourceSelectionBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.MainTabMessages;

public class InputFileBlock
extends ResourceSelectionBlock {
    private final IFile defaultFile;
    IContentTypeManager contentTypeManager = Platform.getContentTypeManager();

    public InputFileBlock(IFile defaultFile) {
        super(1, false);
        this.defaultFile = defaultFile;
    }

    protected String[] getFileExtensions() {
        IContentType contentType = this.contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        String[] xmlContentTypes = contentType.getFileSpecs(8);
        return xmlContentTypes;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String path = "";
        if (this.defaultFile != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", this.defaultFile.getFullPath().toPortableString());
        }
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", path);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null);
            if (wd != null) {
                this.setText(wd);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(MainTabMessages.InputFileBlock_Exception_occurred_reading_configuration) + e.getStatus().getMessage());
            XSLDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", this.getText());
    }

    public String getName() {
        return MainTabMessages.InputFileBlock_Name;
    }

    protected void setDefaultResource() {
    }

    protected void textModified() {
        String workingDirPath = this.getText();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
                new Path(manager.performStringSubstitution(workingDirPath));
            }
            catch (CoreException coreException) {}
        } else if (workingDirPath.length() > 0) {
            new Path(workingDirPath);
        }
    }

    protected String getMessage(int type) {
        switch (type) {
            case 1: {
                return MainTabMessages.InputFileBlock_DIRECTORY_NOT_SPECIFIED;
            }
            case 2: {
                return MainTabMessages.InputFileBlock_DIRECTORY_DOES_NOT_EXIST;
            }
            case 3: {
                return MainTabMessages.InputFileBlock_GROUP_NAME;
            }
            case 4: {
                return MainTabMessages.InputFileBlock_DEFAULT_RADIO;
            }
            case 5: {
                return MainTabMessages.InputFileBlock_OTHER_RADIO;
            }
            case 6: {
                return MainTabMessages.InputFileBlock_DIALOG_MESSAGE;
            }
            case 7: {
                return MainTabMessages.InputFileBlock_WORKSPACE_DIALOG_MESSAGE;
            }
            case 8: {
                return MainTabMessages.InputFileBlock_VARIABLES_BUTTON;
            }
            case 9: {
                return MainTabMessages.InputFileBlock_FILE_SYSTEM_BUTTON;
            }
            case 10: {
                return MainTabMessages.InputFileBlock_WORKSPACE_BUTTON;
            }
            case 11: {
                return MainTabMessages.InputFileBlock_WORKSPACE_DIALOG_TITLE;
            }
        }
        return "" + type;
    }

    protected void updateResourceText(boolean useDefault) {
    }
}

