/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.actions.AbstractParameterAction;
import org.eclipse.wst.xsl.internal.debug.ui.actions.AddParameterAction;
import org.eclipse.wst.xsl.internal.debug.ui.actions.RemoveParameterAction;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.IParametersChangedListener;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.ParameterViewer;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.ParametersContentProvider;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.ParametersLabelProvider;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.TransformsBlock;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class ParametersBlock
extends AbstractTableBlock {
    private ParameterViewer parametersViewer;
    private Button addParameterButton;
    private Button removeParameterButton;
    private final TransformsBlock transformsBlock;
    private final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection stylesheetSelection = (IStructuredSelection)event.getSelection();
            if (stylesheetSelection.size() == 1) {
                ParametersBlock.this.setTransform((LaunchTransform)stylesheetSelection.getFirstElement());
            } else {
                ParametersBlock.this.setTransform(null);
            }
            ParametersBlock.this.updateEnabled();
        }
    };
    private Table fTable;

    public ParametersBlock(TransformsBlock transformsBlock) {
        this.transformsBlock = transformsBlock;
    }

    protected void setTransform(LaunchTransform transform) {
        this.parametersViewer.setInput(transform);
    }

    protected void updateEnabled() {
        IStructuredSelection stylesheetSelection = (IStructuredSelection)this.transformsBlock.getStylesheetViewer().getSelection();
        boolean enabled = stylesheetSelection.size() == 1;
        this.parametersViewer.getTable().setEnabled(enabled);
        this.addParameterButton.setEnabled(enabled);
        IStructuredSelection parametersSelection = (IStructuredSelection)this.parametersViewer.getSelection();
        this.removeParameterButton.setEnabled(enabled && !parametersSelection.isEmpty());
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(this.getName());
        GridData gd = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.setControl((Control)group);
        this.fTable = new Table((Composite)group, 67586);
        GridData data = new GridData(4, 4, true, true);
        this.fTable.setLayoutData((Object)data);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.fTable, 0);
        column1.setWidth(150);
        column1.setResizable(true);
        column1.setText(Messages.getString("ParametersBlock.0"));
        TableColumn column3 = new TableColumn(this.fTable, 0);
        column3.setWidth(250);
        column3.setResizable(true);
        column3.setText(Messages.getString("ParametersBlock.2"));
        this.parametersViewer = new ParameterViewer(this.fTable);
        this.parametersViewer.setLabelProvider((IBaseLabelProvider)new ParametersLabelProvider());
        this.parametersViewer.setContentProvider((IContentProvider)new ParametersContentProvider());
        this.parametersViewer.addParametersChangedListener(new IParametersChangedListener(){

            public void parametersChanged(ParameterViewer viewer) {
                ParametersBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.parametersViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    RemoveParameterAction ra = new RemoveParameterAction(ParametersBlock.this.parametersViewer);
                    ra.run();
                    ParametersBlock.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.parametersViewer.setColumnProperties(new String[]{"name", "value"});
        TextCellEditor textEditor = new TextCellEditor((Composite)this.fTable);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = textEditor;
        CellEditor[] editors = cellEditorArray;
        this.parametersViewer.setCellEditors(editors);
        this.parametersViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return "value".equals(property);
            }

            public Object getValue(Object element, String property) {
                LaunchAttribute att = (LaunchAttribute)element;
                return att.value == null ? "" : att.value;
            }

            public void modify(Object element, String property, Object value) {
                Item item = (Item)element;
                LaunchAttribute att = (LaunchAttribute)item.getData();
                att.value = (String)value;
                ParametersBlock.this.parametersViewer.update(att, null);
                ParametersBlock.this.updateLaunchConfigurationDialog();
            }
        });
        Composite parameterButtonComp = new Composite((Composite)group, 0);
        GridLayout parameterButtonCompLayout = new GridLayout();
        parameterButtonCompLayout.marginHeight = 0;
        parameterButtonCompLayout.marginWidth = 0;
        parameterButtonComp.setLayout((Layout)parameterButtonCompLayout);
        gd = new GridData(258);
        gd.horizontalSpan = 2;
        parameterButtonComp.setLayoutData((Object)gd);
        parameterButtonComp.setFont(font);
        this.addParameterButton = this.createButton(parameterButtonComp, new AddParameterAction(this.parametersViewer));
        this.removeParameterButton = this.createButton(parameterButtonComp, new RemoveParameterAction(this.parametersViewer));
        this.transformsBlock.getStylesheetViewer().addSelectionChangedListener(this.selectionListener);
        this.restoreColumnSettings();
    }

    protected Button createButton(Composite pathButtonComp, AbstractParameterAction action) {
        Button button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        return button;
    }

    protected Table getTable() {
        return this.fTable;
    }

    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return "org.eclipse.wst.xsl.debug.ui.MAIN_PARAMATERS_BLOCK";
    }

    public String getName() {
        return Messages.getString("ParametersBlock.9");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateEnabled();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void dispose() {
        if (this.transformsBlock.getStylesheetViewer() != null) {
            this.transformsBlock.getStylesheetViewer().removeSelectionChangedListener(this.selectionListener);
        }
        super.dispose();
    }
}

