/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.debug.internal.util.XSLPluginImageHelper;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.XSLLaunchConfigurationTab;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.InputFileBlock;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.MainTabMessages;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.ParametersBlock;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.TransformsBlock;
import org.eclipse.wst.xsl.launching.config.LaunchPipeline;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class XSLMainTab
extends XSLLaunchConfigurationTab {
    private final InputFileBlock inputFileBlock;
    private final TransformsBlock transformsBlock;
    private final ParametersBlock parametersBlock;
    public LaunchPipeline pipeline;

    public XSLMainTab() {
        IResource[] resourceContext = XSLMainTab.getContext();
        IFile inputFile = this.getXMLInput(resourceContext);
        this.inputFileBlock = new InputFileBlock(inputFile);
        this.transformsBlock = new TransformsBlock();
        this.parametersBlock = new ParametersBlock(this.transformsBlock);
        this.setBlocks(new ILaunchConfigurationTab[]{this.inputFileBlock, this.transformsBlock, this.parametersBlock});
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        GridLayout layout = new GridLayout(1, false);
        comp.setLayout((Layout)layout);
        this.inputFileBlock.createControl(comp);
        this.transformsBlock.createControl(comp);
        this.parametersBlock.createControl(comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile[] stylesheets;
        LaunchPipeline lp = new LaunchPipeline();
        IResource[] resourceContext = XSLMainTab.getContext();
        IFile[] iFileArray = stylesheets = this.getXSLStylesheets(resourceContext);
        int n = stylesheets.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            LaunchTransform lt = new LaunchTransform(file.getFullPath().toPortableString(), "resource");
            lp.addTransformDef(lt);
            ++n2;
        }
        this.savePipeline(configuration, lp);
        super.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.pipeline = null;
        try {
            String s = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_PIPELINE", null);
            if (s != null && s.length() > 0) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
                this.pipeline = LaunchPipeline.fromXML((InputStream)inputStream);
            } else {
                this.pipeline = new LaunchPipeline();
            }
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
        this.transformsBlock.setPipeline(this.pipeline);
        super.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        this.savePipeline(configuration, this.pipeline);
    }

    private void savePipeline(ILaunchConfigurationWorkingCopy configuration, LaunchPipeline pipeline) {
        try {
            configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_PIPELINE", pipeline.toXML());
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    public String getName() {
        return MainTabMessages.XSLMainTab_TabName;
    }

    private static IResource[] getContext() {
        IWorkbenchPage page = XSLDebugUIPlugin.getActivePage();
        ArrayList resources = new ArrayList();
        if (page != null) {
            IEditorInput input;
            IFile file;
            ISelection selection = page.getSelection();
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                for (Object element : ss) {
                    if (!(element instanceof IResource)) continue;
                    resources.add(element);
                }
                return resources.toArray(new IResource[0]);
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null && (file = (IFile)(input = part.getEditorInput()).getAdapter(IFile.class)) != null) {
                return new IResource[]{file};
            }
        }
        return new IResource[0];
    }

    private IFile getXMLInput(IResource[] context) {
        IResource[] iResourceArray = context;
        int n = context.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && ("xml".equalsIgnoreCase(resource.getFileExtension()) || "xhtml".equalsIgnoreCase(resource.getFileExtension()))) {
                return (IFile)resource;
            }
            ++n2;
        }
        return null;
    }

    private IFile[] getXSLStylesheets(IResource[] context) {
        ArrayList<IResource> stylesheets = new ArrayList<IResource>();
        IResource[] iResourceArray = context;
        int n = context.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && XSLCore.isXSLFile((IFile)((IFile)resource))) {
                stylesheets.add(resource);
            }
            ++n2;
        }
        return stylesheets.toArray(new IFile[0]);
    }

    public Image getImage() {
        return XSLPluginImageHelper.getInstance().getImage("icons/xslt_launch.gif");
    }
}

