/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.debug;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.IDebugHandler;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.debug.Messages;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationVerifierJob
extends Job {
    static final String NOT_VALID_LOCATION = Messages.BreakpointLocationVerifierJob_notValidLocation;
    static final String BREAKPOINT_REMOVED = Messages.BreakpointLocationVerifierJob_breakpointRemoved;
    static final String BREAKPOINT_SET = Messages.BreakpointLocationVerifierJob_breakpointSet;
    static final String BREAKPOINT_MOVED_TO_VALID = Messages.BreakpointLocationVerifierJob_breakpointMovedToValid;
    private ProcIdentifier _proc;
    private SPLineBreakpoint[] _breakpoints;
    private IEditorStatusLine _statusLine;
    private boolean _silentMode = true;

    public BreakpointLocationVerifierJob(SPLineBreakpoint breakpoint, IEditorStatusLine statusLine) throws CoreException {
        this(breakpoint.getProcIdentifier(), new SPLineBreakpoint[]{breakpoint}, statusLine);
        this._silentMode = false;
    }

    public BreakpointLocationVerifierJob(ProcIdentifier proc, SPLineBreakpoint[] bps, IEditorStatusLine line) {
        super(Messages.BreakpointLocationVerifierJob_label);
        this._proc = proc;
        this._breakpoints = bps;
        this._statusLine = line;
        this.setSystem(true);
    }

    private int[] getValidLocation(ProcIdentifier proc, int[] lineNumbers) {
        IControlConnection con = EditorCorePlugin.getControlConnectionManager().getControlConnection(proc.getDatabaseIdentifier());
        if (con == null) {
            return lineNumbers;
        }
        IDebugHandler debugHandler = DebuggerCorePlugin.getDefault().getDebugHandlerManager().getOrCreateDebugHandler(proc.getDatabaseIdentifier().getProfileName());
        if (debugHandler == null) {
            return lineNumbers;
        }
        try {
            return debugHandler.getValidBreakpointLocations(proc, lineNumbers, con);
        }
        catch (SQLException e) {
            DebuggerCorePlugin.getDefault().log(e);
            return lineNumbers;
        }
    }

    public static IStatus findMostSevere(List statuses) {
        IStatus highest = null;
        int i = 0;
        while (i < statuses.size()) {
            IStatus s = (IStatus)statuses.get(i);
            if (s.getSeverity() == 4) {
                highest = s;
                break;
            }
            highest = highest == null ? s : (highest.getSeverity() > s.getSeverity() ? highest : s);
            ++i;
        }
        return highest;
    }

    public IStatus run(IProgressMonitor monitor) {
        int[] lines = new int[this._breakpoints.length];
        int i = 0;
        while (i < this._breakpoints.length) {
            try {
                lines[i] = this._breakpoints[i].getLineNumber();
            }
            catch (CoreException coreException) {
                lines[i] = -1;
            }
            ++i;
        }
        int[] lineNumbers = this.getValidLocation(this._proc, lines);
        ArrayList<IStatus> statuses = new ArrayList<IStatus>(this._breakpoints.length);
        int i2 = 0;
        while (i2 < this._breakpoints.length) {
            IStatus status;
            if (this._breakpoints[i2] instanceof SPLineBreakpoint && (status = this.runOne(monitor, this._proc, this._breakpoints[i2], lines[i2], lineNumbers[i2])) != null) {
                statuses.add(status);
            }
            ++i2;
        }
        return BreakpointLocationVerifierJob.findMostSevere(statuses);
    }

    public IStatus runOne(IProgressMonitor monitor, ProcIdentifier proc, SPLineBreakpoint bp, int originLine, int valieLine) {
        try {
            boolean breakpointExist;
            if (valieLine == -1) {
                this.report(NOT_VALID_LOCATION);
                if (bp != null) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)bp, true);
                }
                return new Status(0, DebuggerCorePlugin.PLUGIN_ID, 4, NOT_VALID_LOCATION, null);
            }
            boolean differentLineNumber = valieLine != originLine;
            SPLineBreakpoint breakpoint = SPDebugModelUtil.findLineBreakpoint(proc, valieLine);
            boolean bl = breakpointExist = breakpoint != null;
            if (differentLineNumber) {
                if (breakpointExist) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)bp, true);
                    return new Status(0, DebuggerCorePlugin.PLUGIN_ID, 4, NOT_VALID_LOCATION, null);
                }
                bp.setRegistered(false);
                bp.setLineNumber(valieLine);
                bp.setRegistered(true);
                return new Status(0, DebuggerCorePlugin.PLUGIN_ID, 2, BREAKPOINT_MOVED_TO_VALID, null);
            }
        }
        catch (CoreException e) {
            DebuggerCorePlugin.getDefault().log(Messages.BreakpointLocationVerifierJob_breakpoint_verification_fail, e);
        }
        return new Status(0, DebuggerCorePlugin.PLUGIN_ID, 0, BREAKPOINT_SET, null);
    }

    protected void report(final String message) {
        if (this._silentMode) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                if (BreakpointLocationVerifierJob.this._statusLine != null) {
                    BreakpointLocationVerifierJob.this._statusLine.setMessage(true, message, null);
                }
                if (message != null && DebuggerCorePlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }
}

