/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui;

import java.util.ArrayList;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.jsdt.web.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.JSDTContentAssistant;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class StructuredTextViewerConfigurationJSDT
extends StructuredTextViewerConfigurationHTML {
    private String[] fConfiguredContentTypes;
    private ILabelProvider fStatusLineLabelProvider;

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<Object> allStrategies = new ArrayList<Object>(0);
        Object externalAutoEditProvider = ExtendedConfigurationBuilder.getInstance().getConfiguration("autoeditstrategy", contentType);
        if (externalAutoEditProvider != null) {
            allStrategies.add(externalAutoEditProvider);
        } else {
            IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
            int i = 0;
            while (i < superStrategies.length) {
                allStrategies.add(superStrategies[i]);
                ++i;
            }
        }
        allStrategies.add(new AutoEditStrategyForTabs());
        return allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            this.fConfiguredContentTypes = super.getConfiguredContentTypes(sourceViewer);
        }
        return this.fConfiguredContentTypes;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        processors = partitionType == "org.eclipse.wst.html.SCRIPT" ? new IContentAssistProcessor[]{new JSDTContentAssistant()} : super.getContentAssistProcessors(sourceViewer, partitionType);
        return processors;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            IFormattingStrategy cf = (IFormattingStrategy)ExtendedConfigurationBuilder.getInstance().getConfiguration("contentformater", contentTypes[i]);
            if (cf != null && formatter instanceof MultiPassContentFormatter) {
                ((MultiPassContentFormatter)formatter).setSlaveStrategy(cf, contentTypes[i]);
            }
            ++i;
        }
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>(0);
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int m = 0;
        while (m < superDetectors.length) {
            IHyperlinkDetector detector = superDetectors[m];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++m;
        }
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            IHyperlinkDetector hl = (IHyperlinkDetector)ExtendedConfigurationBuilder.getInstance().getConfiguration("hyperlinkdetector", contentTypes[i]);
            if (hl != null) {
                allDetectors.add(hl);
            }
            ++i;
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return super.getIndentPrefixes(sourceViewer, contentType);
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        IInformationProvider provider = null;
        Object externalInfoProvider = ExtendedConfigurationBuilder.getInstance().getConfiguration("informationpresenter", partitionType);
        provider = externalInfoProvider != null ? (IInformationProvider)externalInfoProvider : super.getInformationProvider(sourceViewer, partitionType);
        return provider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = super.getLineStyleProviders(sourceViewer, partitionType);
        return providers;
    }

    public ILabelProvider getStatusLineLabelProvider(ISourceViewer sourceViewer) {
        if (this.fStatusLineLabelProvider == null) {
            this.fStatusLineLabelProvider = super.getStatusLineLabelProvider(sourceViewer);
        }
        return this.fStatusLineLabelProvider;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        ITextHover textHover = null;
        TextHoverManager manager = SSEUIPlugin.getDefault().getTextHoverManager();
        TextHoverManager.TextHoverDescriptor[] hoverDescs = manager.getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && EditorUtility.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                Object externalHover;
                String hoverType = hoverDescs[i].getId();
                if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    externalHover = ExtendedConfigurationBuilder.getInstance().getConfiguration("texthover", contentType);
                    textHover = externalHover != null ? manager.createBestMatchHover((ITextHover)externalHover) : super.getTextHover(sourceViewer, contentType, stateMask);
                } else if ("documentationHover".equalsIgnoreCase(hoverType)) {
                    externalHover = ExtendedConfigurationBuilder.getInstance().getConfiguration("texthover", contentType);
                    textHover = externalHover != null ? manager.createBestMatchHover((ITextHover)externalHover) : super.getTextHover(sourceViewer, contentType, stateMask);
                }
            }
            ++i;
        }
        if (textHover == null) {
            textHover = super.getTextHover(sourceViewer, contentType, stateMask);
        }
        return textHover;
    }

    public static final class externalTypeExtension {
        public static final String AUTOEDIT_ID = "autoeditstrategy";
        public static final String CONTENT_ASSIST = "contentassistprocessor";
        public static final String CONTENT_FORMATER = "contentformater";
        public static final String HOVER_ID = "texthover";
        public static final String HYPERLINK_DETECTOR = "hyperlinkdetector";
        public static final String HYPERLINK_DETECTOR_TARGETS = "hyperlinkdetector";
        public static final String INFORMATIONPROVIDER_ID = "informationpresenter";
    }
}

