/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.SaveReportAsWizard;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.SaveReportAsWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class FileReportProvider
implements IReportProvider {
    protected static Logger logger = Logger.getLogger(FileReportProvider.class.getName());
    private ModuleHandle model;
    private static final String VERSION_MESSAGE = Messages.getString((String)"TextPropertyDescriptor.Message.Version");

    public ModuleHandle getReportModuleHandle(Object element) {
        return this.getReportModuleHandle(element, false);
    }

    public ModuleHandle getReportModuleHandle(Object element, boolean reset) {
        IPath path;
        if ((this.model == null || reset) && element instanceof IPathEditorInput && (path = ((IPathEditorInput)element).getPath()) != null) {
            String fileName = path.toOSString();
            try {
                FileInputStream stream = new FileInputStream(path.toFile());
                HashMap<String, String> properties = new HashMap<String, String>();
                String designerVersion = MessageFormat.format(VERSION_MESSAGE, ReportPlugin.getVersion(), ReportPlugin.getBuildInfo());
                properties.put("createdBy", designerVersion);
                properties.put("createdBy", designerVersion);
                String projectFolder = this.getProjectFolder((IEditorInput)((IPathEditorInput)element));
                if (projectFolder != null) {
                    properties.put("resourceFolder", projectFolder);
                }
                this.model = SessionHandleAdapter.getInstance().init(fileName, (InputStream)stream, properties);
            }
            catch (DesignFileException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.model;
    }

    private String getProjectFolder(IEditorInput input) {
        Object fileAdapter = input.getAdapter(IFile.class);
        IFile file = null;
        if (fileAdapter != null) {
            file = (IFile)fileAdapter;
        }
        if (file != null && file.getProject() != null) {
            return file.getProject().getLocation().toOSString();
        }
        if (input instanceof IPathEditorInput) {
            File fileSystemFile = ((IPathEditorInput)input).getPath().toFile();
            return fileSystemFile.getParent();
        }
        return null;
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IProgressMonitor monitor) {
        this.saveReport(moduleHandle, element, null, monitor);
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IPath origReportPath, IProgressMonitor monitor) {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)element;
            this.saveFile(moduleHandle, input.getPath().toFile(), origReportPath, monitor);
        }
    }

    private void saveFile(final ModuleHandle moduleHandle, final File file, final IPath oldReportPath, IProgressMonitor monitor) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor pm) throws CoreException {
                            try {
                                this.execute(pm);
                            }
                            catch (CoreException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }

            public void execute(IProgressMonitor monitor) throws CoreException, IOException {
                if (file.exists() || file.createNewFile()) {
                    FileOutputStream out = new FileOutputStream(file);
                    moduleHandle.serialize((OutputStream)out);
                    out.close();
                    if (oldReportPath != null) {
                        FileReportProvider.copyReportConfigFile((IPath)new Path(file.getAbsolutePath()), oldReportPath);
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(UIUtil.getDefaultShell()).run(false, true, op);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void copyReportConfigFile(IPath newReportPath, IPath oldReportPath) throws IOException {
        if (oldReportPath != null) {
            String retConfigExtension = "rptconfig";
            IPath newConfigPath = newReportPath.removeFileExtension();
            IPath oldConfigPath = oldReportPath.removeFileExtension();
            newConfigPath = newConfigPath.addFileExtension(retConfigExtension);
            oldConfigPath = oldConfigPath.addFileExtension(retConfigExtension);
            File newConfigFile = newConfigPath.toFile();
            File oldConfigFile = oldConfigPath.toFile();
            if (oldConfigFile.exists()) {
                FileReportProvider.copyFile(oldConfigFile, newConfigFile);
            } else {
                newConfigFile.delete();
            }
        }
    }

    private static void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile.equals(destFile)) {
            return;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            ((FileChannel)fcin).transferTo(0L, ((FileChannel)fcin).size(), (WritableByteChannel)((Object)fcout));
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (fcin != null) {
                fcin.close();
            }
            if (fcout != null) {
                fcout.close();
            }
        }
    }

    public IPath getSaveAsPath(Object element) {
        if (element instanceof IPathEditorInput) {
            IEditorInput input = (IEditorInput)element;
            SaveReportAsWizardDialog dialog = new SaveReportAsWizardDialog(UIUtil.getDefaultShell(), (IWizard)new SaveReportAsWizard(this.model, input));
            if (dialog.open() == 0) {
                return dialog.getResult();
            }
        }
        return null;
    }

    public IEditorInput createNewEditorInput(IPath path) {
        File file = new File(path.toOSString());
        try {
            if (file.exists() || file.createNewFile()) {
                return new ReportEditorInput(file);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public IPath getInputPath(IEditorInput input) {
        if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath();
        }
        return null;
    }

    public IDocumentProvider getReportDocumentProvider(Object element) {
        return new FileReportDocumentProvider();
    }

    public void connect(ModuleHandle handle) {
        this.model = handle;
    }
}

