/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.views.property.GroupPropertyHandleWrapper;
import org.eclipse.birt.report.designer.core.model.views.property.PropertySheetRootElement;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ReportPropertySheetContentProvider
implements ITreeContentProvider {
    private static final String ROOT_DEFAUL_TITLE = Messages.getString((String)"ReportPropertySheetPage.Root.Default.Title");

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof List) {
            return ((List)parentElement).toArray();
        }
        if (parentElement instanceof PropertySheetRootElement) {
            ArrayList<Object> items = new ArrayList<Object>();
            HashMap<String, ArrayList<GroupPropertyHandleWrapper>> map = new HashMap<String, ArrayList<GroupPropertyHandleWrapper>>();
            GroupElementHandle handle = ((PropertySheetRootElement)parentElement).getModel();
            Iterator it = handle.visiblePropertyIterator();
            while (it.hasNext()) {
                GroupPropertyHandle property = (GroupPropertyHandle)it.next();
                IElementPropertyDefn defn = property.getPropertyDefn();
                if (defn.getGroupNameKey() == null) {
                    items.add(new GroupPropertyHandleWrapper(property));
                    continue;
                }
                ArrayList<GroupPropertyHandleWrapper> group = (ArrayList<GroupPropertyHandleWrapper>)map.get(defn.getGroupNameKey());
                if (group == null) {
                    group = new ArrayList<GroupPropertyHandleWrapper>();
                    items.add(group);
                    map.put(defn.getGroupNameKey(), group);
                }
                group.add(new GroupPropertyHandleWrapper(property));
            }
            return items.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof List && ((List)element).size() > 0 || element instanceof PropertySheetRootElement;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<PropertySheetRootElement> items = new ArrayList<PropertySheetRootElement>();
        if (inputElement instanceof GroupElementHandle) {
            PropertySheetRootElement root = new PropertySheetRootElement((GroupElementHandle)inputElement);
            String displayName = null;
            Object element = ((GroupElementHandle)inputElement).getElements().get(0);
            if (element instanceof DesignElementHandle && ((displayName = ((DesignElementHandle)element).getDefn().getDisplayName()) == null || "".equals(displayName))) {
                displayName = ((DesignElementHandle)element).getDefn().getName();
            }
            if (displayName == null || "".equals(displayName)) {
                displayName = ROOT_DEFAUL_TITLE;
            }
            root.setDisplayName(displayName);
            items.add(root);
        }
        return items.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

