/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.property.GroupPropertyHandleWrapper;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TabbedPropertyTitle;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.AlphabeticallyViewSorter;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.memento.Memento;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoElement;
import org.eclipse.birt.report.designer.internal.ui.views.property.PropertyEditorFactory;
import org.eclipse.birt.report.designer.internal.ui.views.property.PropertyMementoUtil;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetContentProvider;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetNameLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetValueLabelProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.widget.ExpressionDialogCellEditor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class ReportPropertySheetPage
extends Page
implements IPropertySheetPage,
Listener,
IColleague {
    private static final String COLUMN_TITLE_PROPERTY = Messages.getString((String)"ReportPropertySheetPage.Column.Title.Property");
    private static final String COLUMN_TITLE_VALUE = Messages.getString((String)"ReportPropertySheetPage.Column.Title.Value");
    private CustomTreeViewer viewer;
    private ISelection selection;
    private CellEditor cellEditor;
    private Tree tableTree;
    private TreeEditor tableTreeEditor;
    private ModuleHandle moduleHandle;
    private int columnToEdit = 1;
    private ICellEditorListener editorListener;
    private Object model;
    private List list;
    private TabbedPropertyTitle title;
    private Composite container;
    private IMemento propertySheetMemento;
    private IMemento viewerMemento;
    protected String propertyViewerID = "Report_Property_Sheet_Page_Viewer_ID";
    private boolean changed = false;

    public ReportPropertySheetPage(ModuleHandle module) {
        this.moduleHandle = module;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        this.title = new TabbedPropertyTitle(this.container, FormWidgetFactory.getInstance());
        this.title.setLayoutData((Object)new GridData(768));
        Composite viewerContainer = new Composite(this.container, 0);
        layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 3;
        viewerContainer.setLayout((Layout)layout);
        viewerContainer.setLayoutData((Object)new GridData(1808));
        this.viewer = new CustomTreeViewer(viewerContainer, 65536);
        this.tableTree = this.viewer.getTree();
        this.tableTree.setLayoutData((Object)new GridData(1808));
        this.tableTree.setHeaderVisible(true);
        this.tableTree.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ReportPropertySheetContentProvider());
        TreeViewerColumn tvc1 = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        tvc1.getColumn().setText(COLUMN_TITLE_PROPERTY);
        tvc1.getColumn().setWidth(300);
        tvc1.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ReportPropertySheetNameLabelProvider()));
        TreeViewerColumn tvc2 = new TreeViewerColumn((TreeViewer)this.viewer, 0);
        tvc2.getColumn().setText(COLUMN_TITLE_VALUE);
        tvc2.getColumn().setWidth(400);
        tvc2.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ReportPropertySheetValueLabelProvider()));
        AlphabeticallyViewSorter sorter = new AlphabeticallyViewSorter();
        sorter.setAscending(true);
        this.viewer.setSorter((ViewerSorter)sorter);
        this.hookControl();
        this.tableTreeEditor = new TreeEditor(this.tableTree);
        this.createEditorListener();
        this.handleGlobalAction();
        SessionHandleAdapter.getInstance().getMediator(this.moduleHandle).addColleague((IColleague)this);
        FormWidgetFactory.getInstance().paintFormStyle(parent);
        FormWidgetFactory.getInstance().adapt(parent);
        IWorkbenchPage page = this.getSite().getPage();
        MementoBuilder builder = new MementoBuilder();
        this.propertySheetMemento = builder.getRootMemento().getChild("org.eclipse.ui.views.PropertySheet");
        if (this.propertySheetMemento == null) {
            this.propertySheetMemento = builder.getRootMemento().createChild("org.eclipse.ui.views.PropertySheet", "View");
        }
        if ((this.viewerMemento = this.propertySheetMemento.getChild(this.propertyViewerID)) == null) {
            this.viewerMemento = this.propertySheetMemento.createChild(this.propertyViewerID, "Viewer");
        }
        this.handleSelectionChanged(page.getSelection());
    }

    private void expandToDefaultLevel() {
        this.viewer.expandToLevel(2);
    }

    private void createEditorListener() {
        this.editorListener = new ICellEditorListener(){

            public void cancelEditor() {
                ReportPropertySheetPage.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
                ReportPropertySheetPage.this.applyValue();
                if (ReportPropertySheetPage.this.changed) {
                    ReportPropertySheetPage.this.refresh();
                }
            }
        };
    }

    private void hookControl() {
        this.tableTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ReportPropertySheetPage.this.handleSelect((TreeItem)e.item);
            }
        });
        this.tableTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TreeItem item = ReportPropertySheetPage.this.tableTree.getItem(pt);
                if (item != null) {
                    ReportPropertySheetPage.this.handleSelect(item);
                }
            }
        });
        this.tableTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ReportPropertySheetPage.this.deactivateCellEditor();
                } else if (e.keyCode == 0x100000E) {
                    ReportPropertySheetPage.this.viewer.setInput(ReportPropertySheetPage.this.viewer.getInput());
                }
            }
        });
        this.tableTree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                if (e.item instanceof TreeItem) {
                    Memento element;
                    GroupElementHandle handle;
                    Object obj;
                    TreeItem item = (TreeItem)e.item;
                    if (ReportPropertySheetPage.this.viewer.getInput() != null && ReportPropertySheetPage.this.viewer.getInput() instanceof GroupElementHandle && (obj = (handle = (GroupElementHandle)ReportPropertySheetPage.this.viewer.getInput()).getElements().get(0)) instanceof DesignElementHandle && (element = (Memento)ReportPropertySheetPage.this.viewerMemento.getChild(PropertyMementoUtil.getElementType((DesignElementHandle)obj))) != null) {
                        MementoElement[] path = ReportPropertySheetPage.this.createItemPath(item);
                        PropertyMementoUtil.removeNode(element, path);
                    }
                    ReportPropertySheetPage.this.viewer.getTree().setSelection(item);
                    ReportPropertySheetPage.this.saveSelection(item);
                }
            }

            public void treeExpanded(TreeEvent e) {
                if (e.item instanceof TreeItem) {
                    Memento element;
                    GroupElementHandle handle;
                    Object obj;
                    TreeItem item = (TreeItem)e.item;
                    if (ReportPropertySheetPage.this.viewer.getInput() != null && ReportPropertySheetPage.this.viewer.getInput() instanceof GroupElementHandle && (obj = (handle = (GroupElementHandle)ReportPropertySheetPage.this.viewer.getInput()).getElements().get(0)) instanceof DesignElementHandle && (element = (Memento)ReportPropertySheetPage.this.viewerMemento.getChild(PropertyMementoUtil.getElementType((DesignElementHandle)obj))) != null) {
                        MementoElement[] path = ReportPropertySheetPage.this.createItemPath(item);
                        PropertyMementoUtil.addNode(element, path);
                    }
                    ReportPropertySheetPage.this.viewer.getTree().setSelection(item);
                    ReportPropertySheetPage.this.saveSelection(item);
                }
            }
        });
    }

    protected MementoElement[] createItemPath(TreeItem item) {
        MementoElement tempMemento = null;
        block0: while (item.getParentItem() != null) {
            TreeItem parent = item.getParentItem();
            int i = 0;
            while (i < parent.getItemCount()) {
                if (parent.getItem(i) == item) {
                    MementoElement memento = new MementoElement(item.getText(), (Object)new Integer(i), "Element");
                    if (tempMemento != null) {
                        memento.addChild(tempMemento);
                    }
                    tempMemento = memento;
                    item = parent;
                    continue block0;
                }
                ++i;
            }
        }
        MementoElement memento = new MementoElement(item.getText(), (Object)new Integer(0), "Element");
        if (tempMemento != null) {
            memento.addChild(tempMemento);
        }
        return PropertyMementoUtil.getNodePath(memento);
    }

    private void deactivateCellEditor() {
        this.tableTreeEditor.setEditor(null, null, this.columnToEdit);
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
    }

    protected void handleSelect(TreeItem selection) {
        TreeItem[] sel;
        if (this.cellEditor != null) {
            this.deactivateCellEditor();
        }
        if ((sel = new TreeItem[]{selection}).length != 0) {
            this.activateCellEditor(sel[0]);
        }
        this.saveSelection(selection);
    }

    protected void saveSelection(TreeItem selection) {
        Memento element;
        GroupElementHandle handle;
        Object obj;
        MementoElement[] selectPath = this.createItemPath(selection);
        if (this.viewer.getInput() != null && this.viewer.getInput() instanceof GroupElementHandle && (obj = (handle = (GroupElementHandle)this.viewer.getInput()).getElements().get(0)) instanceof DesignElementHandle && (element = (Memento)this.viewerMemento.getChild(PropertyMementoUtil.getElementType((DesignElementHandle)obj))) != null) {
            element.getMementoElement().setAttribute("Selected", (Object)selectPath);
        }
    }

    private void applyValue() {
        block4: {
            if (this.cellEditor == null || !this.cellEditor.isDirty()) {
                return;
            }
            if (this.model instanceof GroupPropertyHandleWrapper) {
                try {
                    ((GroupPropertyHandleWrapper)this.model).getModel().setValue(this.cellEditor.getValue());
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                    TreeItem[] sel = this.viewer.getTree().getSelection();
                    if (sel.length == 0) break block4;
                    this.activateCellEditor(sel[0]);
                }
            }
        }
    }

    private void activateCellEditor(TreeItem sel) {
        if (sel.isDisposed()) {
            return;
        }
        this.model = sel.getData();
        this.tableTree.showSelection();
        this.cellEditor = this.createCellEditor(this.model);
        if (this.cellEditor == null) {
            return;
        }
        this.tableTreeEditor.setEditor(this.cellEditor.getControl());
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.cellEditor.addListener(this.editorListener);
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableTreeEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableTreeEditor.grabHorizontal = layout.grabHorizontal;
        this.tableTreeEditor.minimumWidth = layout.minimumWidth;
        this.tableTreeEditor.setEditor(control, sel, this.columnToEdit);
        this.cellEditor.setFocus();
    }

    private CellEditor createCellEditor(Object data) {
        Object[] arrays;
        int len;
        CellEditor editor = null;
        if (data instanceof GroupPropertyHandleWrapper && ((GroupPropertyHandleWrapper)data).getModel().isVisible() && (editor = PropertyEditorFactory.getInstance().createPropertyEditor((Composite)this.tableTree, ((GroupPropertyHandleWrapper)data).getModel())) instanceof ExpressionDialogCellEditor && (len = (arrays = this.list.toArray()).length) > 0) {
            ((ExpressionDialogCellEditor)editor).setExpressionProvider((IExpressionProvider)new ExpressionProvider((DesignElementHandle)arrays[0]));
        }
        return editor;
    }

    private void addColumns() {
        TreeColumn column1 = new TreeColumn(this.tableTree, 16384);
        column1.setText(COLUMN_TITLE_PROPERTY);
        TreeColumn column2 = new TreeColumn(this.tableTree, 16384);
        column2.setText(COLUMN_TITLE_VALUE);
        ColumnWeightData c1Layout = new ColumnWeightData(40, false);
        ColumnWeightData c2Layout = new ColumnWeightData(60, true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)c1Layout);
        layout.addColumnData((ColumnLayoutData)c2Layout);
        this.tableTree.setLayout((Layout)layout);
    }

    public Control getControl() {
        if (this.container == null) {
            return null;
        }
        return this.container;
    }

    public void setFocus() {
        this.getControl().setFocus();
        if (this.changed) {
            this.refresh();
        }
    }

    protected void refresh() {
        GroupElementHandle handle;
        Object obj;
        this.viewer.refresh(true);
        if (!this.viewer.getTree().isDisposed() && this.viewer.getInput() != null && this.viewer.getInput() instanceof GroupElementHandle && (obj = (handle = (GroupElementHandle)this.viewer.getInput()).getElements().get(0)) instanceof DesignElementHandle) {
            IMemento memento = this.viewerMemento.getChild(PropertyMementoUtil.getElementType((DesignElementHandle)obj));
            if (memento == null) {
                this.expandToDefaultLevel();
                if (this.viewer.getTree().getItemCount() > 0) {
                    Memento elementMemento = (Memento)this.viewerMemento.createChild(PropertyMementoUtil.getElementType((DesignElementHandle)obj), "Element");
                    elementMemento.getMementoElement().setValue((Object)new Integer(0));
                }
            }
            if (memento != null && memento instanceof Memento) {
                this.expandToDefaultLevel();
                this.expandTreeFromMemento((Memento)memento);
            }
        }
        this.changed = false;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.deactivateCellEditor();
    }

    public void handleSelectionChanged(ISelection selection) {
        if (this.selection != null && this.selection.equals(selection)) {
            return;
        }
        this.selection = selection;
        this.deRegisterListeners();
        this.list = this.getModelList(selection);
        GroupElementHandle handle = DEUtil.getMultiSelectionHandle((List)this.list);
        if (handle != null && !handle.isSameType()) {
            this.viewer.setInput(null);
            this.setTitleDisplayName(null);
            return;
        }
        this.viewer.setInput(handle);
        this.setTitleDisplayName(handle);
        this.registerListeners();
        Object element = handle.getElements().get(0);
        if (element instanceof DesignElementHandle) {
            IMemento memento = this.viewerMemento.getChild(PropertyMementoUtil.getElementType((DesignElementHandle)element));
            if (memento == null) {
                this.expandToDefaultLevel();
                if (this.viewer.getTree().getItemCount() > 0) {
                    Memento elementMemento = (Memento)this.viewerMemento.createChild(PropertyMementoUtil.getElementType((DesignElementHandle)element), "Element");
                    elementMemento.getMementoElement().setValue((Object)new Integer(0));
                }
            } else if (memento instanceof Memento) {
                this.expandToDefaultLevel();
                this.expandTreeFromMemento((Memento)memento);
            }
        }
    }

    private void expandTreeFromMemento(Memento memento) {
        if (this.viewer.getTree().getItemCount() == 0) {
            return;
        }
        TreeItem root = this.viewer.getTree().getItem(0);
        if (memento.getMementoElement().getKey().equals(root.getText())) {
            this.restoreExpandedMemento(root, memento.getMementoElement());
            Object obj = memento.getMementoElement().getAttribute("Selected");
            if (obj != null) {
                this.restoreSelectedMemento(root, (MementoElement[])obj);
            }
        }
    }

    private void restoreSelectedMemento(TreeItem root, MementoElement[] selectedPath) {
        if (selectedPath.length <= 1) {
            return;
        }
        int i = 1;
        while (i < selectedPath.length) {
            MementoElement element = selectedPath[i];
            if (!root.getExpanded()) {
                this.viewer.createChildren((Widget)root);
                root.setExpanded(true);
            }
            if (root.getItemCount() <= (Integer)element.getValue()) {
                return;
            }
            root = root.getItem(((Integer)element.getValue()).intValue());
            ++i;
        }
        this.viewer.getTree().setSelection(root);
    }

    private void restoreExpandedMemento(TreeItem root, MementoElement memento) {
        if (memento.getKey().equals(root.getText())) {
            if (!root.getExpanded()) {
                this.viewer.createChildren((Widget)root);
            }
            if (root.getItemCount() > 0) {
                if (!root.getExpanded()) {
                    root.setExpanded(true);
                }
                MementoElement[] children = memento.getChildren();
                int i = 0;
                while (i < children.length) {
                    MementoElement child = children[i];
                    TreeItem item = root.getItem(((Integer)child.getValue()).intValue());
                    this.restoreExpandedMemento(item, child);
                    ++i;
                }
            }
        }
    }

    private void setTitleDisplayName(GroupElementHandle handle) {
        Object element;
        String displayName = null;
        if (handle != null && (element = handle.getElements().get(0)) instanceof DesignElementHandle) {
            displayName = PropertyMementoUtil.getElementType((DesignElementHandle)element);
        }
        if (displayName == null || "".equals(displayName)) {
            displayName = Messages.getString((String)"ReportPropertySheetPage.Root.Default.Title");
        }
        this.title.setTitle(displayName, null);
    }

    private List getModelList(ISelection selection) {
        List<Object> list = new ArrayList();
        if (selection == null) {
            return list;
        }
        if (!(selection instanceof StructuredSelection)) {
            return list;
        }
        StructuredSelection structured = (StructuredSelection)selection;
        if (structured.getFirstElement() instanceof ReportElementEditPart) {
            for (ReportElementEditPart object : structured) {
                if (object instanceof DummyEditpart) {
                    list.clear();
                    list.add(object.getModel());
                    break;
                }
                list.add(object.getModel());
            }
        } else {
            list = structured.toList();
        }
        return list;
    }

    protected void deRegisterListeners() {
        if (this.viewer == null) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input == null) {
            return;
        }
        if (input instanceof DesignElementHandle) {
            DesignElementHandle element = (DesignElementHandle)input;
            element.removeListener((Listener)this);
        }
    }

    protected void registerListeners() {
        if (this.viewer == null) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input == null) {
            return;
        }
        if (input instanceof GroupElementHandle) {
            GroupElementHandle element = (GroupElementHandle)input;
            ((DesignElementHandle)element.getElements().get(0)).addListener((Listener)this);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (!this.viewer.getTree().isDisposed()) {
            if (this.getControl().isFocusControl()) {
                IMemento memento = this.viewerMemento.getChild(PropertyMementoUtil.getElementType(focus));
                if (memento == null) {
                    this.expandToDefaultLevel();
                    if (this.viewer.getTree().getItemCount() > 0) {
                        Memento elementMemento = (Memento)this.viewerMemento.createChild(PropertyMementoUtil.getElementType(focus), "Element");
                        elementMemento.getMementoElement().setValue((Object)new Integer(0));
                    }
                }
                if (memento != null && memento instanceof Memento) {
                    this.expandToDefaultLevel();
                    this.expandTreeFromMemento((Memento)memento);
                }
                this.changed = false;
            } else {
                this.changed = true;
                if (this.changed) {
                    this.refresh();
                }
            }
        }
    }

    private void handleGlobalAction() {
        int i = 0;
        while (i < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length) {
            String id = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createStackAction((String)id, (CommandStack)SessionHandleAdapter.getInstance().getCommandStack(this.moduleHandle)));
            ++i;
        }
    }

    public void dispose() {
        SessionHandleAdapter.getInstance().getMediator(this.moduleHandle).removeColleague((IColleague)this);
        this.unregisterListeners();
        super.dispose();
    }

    protected void unregisterListeners() {
        if (this.viewer == null) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input == null) {
            return;
        }
        if (input instanceof GroupElementHandle) {
            GroupElementHandle element = (GroupElementHandle)input;
            ((DesignElementHandle)element.getElements().get(0)).removeListener((Listener)this);
        }
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            ArrayList selections = new ArrayList();
            selections.add(null);
            selections.addAll(request.getSelectionModelList());
            ArrayList<Object> nullList = new ArrayList<Object>();
            nullList.add(null);
            selections.removeAll(nullList);
            this.handleSelectionChanged((ISelection)new StructuredSelection(selections));
        }
    }

    class CustomTreeViewer
    extends TreeViewer {
        public CustomTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void createChildren(Widget widget) {
            super.createChildren(widget);
        }
    }
}

