/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.extension.EditorContributorManager;
import org.eclipse.birt.report.designer.internal.ui.extension.FormPageDef;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.ui.actions.NoneAction;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.designer.ui.editors.IMultiPageEditorActionBarContributor;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.EditorActionBarContributor;

public abstract class MultiPageEditorActionBarContributor
extends EditorActionBarContributor
implements IMultiPageEditorActionBarContributor {
    public static final String M_PAGE = "birtPage";
    public static final String PAGE_SET_GROUP = "pageSetGroup";
    public static final String PAGE_SET_GROUP_END = "pageSetGroupEnd";
    private SubActionBarDef currentActionBarDef;
    private Map subBarMap;

    public void setActiveEditor(IEditorPart targetEditor) {
        super.setActiveEditor(targetEditor);
        if (targetEditor instanceof IReportEditor) {
            targetEditor = ((IReportEditor)targetEditor).getEditorPart();
        }
        if (targetEditor instanceof AbstractMultiPageEditor) {
            AbstractMultiPageEditor editor = (AbstractMultiPageEditor)targetEditor;
            if (editor.getActivePageInstance() != null) {
                this.setActivePage(editor.getActivePageInstance());
            }
            if (this.currentActionBarDef != null) {
                this.currentActionBarDef.updateActionBars();
            }
        } else {
            return;
        }
        this.getActionBars().getToolBarManager().update(true);
        this.getActionBars().updateActionBars();
    }

    public void setActivePage(IFormPage page) {
        FormPageDef pageDef;
        EditorContributorManager.EditorContributor contributor;
        FormEditor editor;
        if (page == null) {
            return;
        }
        if (this.subBarMap == null) {
            this.subBarMap = new HashMap();
        }
        if (this.currentActionBarDef != null) {
            this.currentActionBarDef.deactivate();
            this.currentActionBarDef.dispose();
            this.currentActionBarDef = null;
        }
        IActionBars rootBar = this.getActionBars();
        if (page != null && this.currentActionBarDef == null && (editor = page.getEditor()) != null && (contributor = EditorContributorManager.getInstance().getEditorContributor(editor.getSite().getId())) != null && (pageDef = contributor.getPage(page.getId())) != null && pageDef.actionBarContributor != null) {
            this.currentActionBarDef = new SubActionBarDef(rootBar, pageDef.actionBarContributor);
            this.currentActionBarDef.init(this.getPage());
        }
        rootBar.clearGlobalActionHandlers();
        if (this.currentActionBarDef != null) {
            this.currentActionBarDef.setActiveEditor((IEditorPart)page);
            Map handlers = this.currentActionBarDef.getSubActionBar().getGlobalActionHandlers();
            if (handlers != null) {
                Set keys = handlers.keySet();
                for (String id : keys) {
                    rootBar.setGlobalActionHandler(id, (IAction)handlers.get(id));
                }
            }
            this.currentActionBarDef.activate();
            this.currentActionBarDef.updateActionBars();
        }
        rootBar.getToolBarManager().update(true);
        rootBar.updateActionBars();
    }

    public void dispose() {
        if (this.subBarMap != null) {
            for (SubActionBarDef def : this.subBarMap.values()) {
                def.dispose();
            }
            this.subBarMap.clear();
        }
        if (this.currentActionBarDef != null) {
            this.currentActionBarDef.deactivate();
            this.currentActionBarDef.dispose();
            this.currentActionBarDef = null;
        }
        super.dispose();
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        menuManager.insertAfter("edit", (IContributionItem)this.createPageMenu());
        menuManager.update();
    }

    public abstract String getEditorId();

    protected IMenuManager createPageMenu() {
        MenuManager menuManager = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.page"), M_PAGE);
        menuManager.add((IContributionItem)new Separator(PAGE_SET_GROUP));
        final ArrayList<IAction> updateActions = new ArrayList<IAction>();
        EditorContributorManager.EditorContributor editorContruContributor = EditorContributorManager.getInstance().getEditorContributor(this.getEditorId());
        int i = editorContruContributor.formPageList.size() - 1;
        while (i >= 0) {
            FormPageDef page = editorContruContributor.getPage(i);
            final IAction action = page.pageAction;
            if (action instanceof UpdateAction) {
                updateActions.add(action);
            }
            if (action instanceof MenuUpdateAction) {
                final MenuManager subMenu = new MenuManager(page.displayName);
                subMenu.add((IAction)new NoneAction());
                subMenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        ((MenuUpdateAction)action).updateMenu(subMenu);
                    }
                });
                menuManager.insertAfter(PAGE_SET_GROUP, (IContributionItem)subMenu);
            } else {
                menuManager.insertAfter(PAGE_SET_GROUP, action);
            }
            --i;
        }
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Iterator iter = updateActions.iterator();
                while (iter.hasNext()) {
                    ((UpdateAction)iter.next()).update();
                }
            }
        });
        menuManager.add((IContributionItem)new Separator(PAGE_SET_GROUP_END));
        return menuManager;
    }

    private static class SubActionBarDef {
        private SubActionBars subActionBar;
        private IEditorActionBarContributor actionBarContrubutor;

        public SubActionBarDef(IActionBars rootBar, IEditorActionBarContributor actionBarContrubutor) {
            this.subActionBar = new SubActionBars(rootBar);
            this.actionBarContrubutor = actionBarContrubutor;
        }

        public void init(IWorkbenchPage page) {
            this.actionBarContrubutor.init((IActionBars)this.subActionBar, page);
        }

        public SubActionBars getSubActionBar() {
            return this.subActionBar;
        }

        public void setActiveEditor(IEditorPart editor) {
            this.actionBarContrubutor.setActiveEditor(editor);
        }

        public void activate() {
            this.subActionBar.activate();
        }

        public void deactivate() {
            this.subActionBar.deactivate();
        }

        public void updateActionBars() {
            this.subActionBar.updateActionBars();
            this.subActionBar.getToolBarManager().update(true);
        }

        public void dispose() {
            this.subActionBar.deactivate();
            this.subActionBar.dispose();
        }
    }
}

