/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.UnsupportedFormatException;
import org.eclipse.birt.report.engine.api.impl.EngineLogger;
import org.eclipse.birt.report.engine.api.impl.EngineLoggerHandler;
import org.eclipse.birt.report.engine.api.impl.IInternalReportDocument;
import org.eclipse.birt.report.engine.api.impl.ParameterValidationException;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ScriptedDesignHandler;
import org.eclipse.birt.report.engine.api.impl.ScriptedDesignSearcher;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExtensionExecutor;
import org.eclipse.birt.report.engine.extension.engine.IContentProcessor;
import org.eclipse.birt.report.engine.extension.engine.IGenerateExtension;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentReaderV3;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.LayoutEngineFactory;
import org.eclipse.birt.report.engine.script.internal.ReportContextImpl;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.engine.util.SecurityUtil;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public abstract class EngineTask
implements IEngineTask {
    public static final String TASK_TYPE = "task_type";
    private static int id = 0;
    protected String pagination;
    protected static final String FORMAT_HTML = "html";
    protected boolean cancelFlag;
    protected int runningStatus;
    protected ReportEngine engine;
    protected Logger log;
    protected Locale locale = Locale.getDefault();
    protected TimeZone timeZone = TimeZone.getDefault();
    protected ExecutionContext executionContext;
    protected int taskID;
    protected IRenderOption renderOptions;
    protected String emitterID;
    protected String format;
    protected boolean parameterChanged = true;
    protected HashMap inputValues = new HashMap();
    protected HashMap runValues = new HashMap();
    protected int taskType = -1;
    private ClassLoader contextClassLoader;
    private IDocArchiveReader dataSource;
    private String dataSourceReportlet;

    protected EngineTask(ReportEngine engine, IReportRunnable runnable, int taskType) {
        this(engine, taskType);
        this.setReportRunnable(runnable);
    }

    protected EngineTask(ReportEngine engine, int taskType) {
        this.engine = engine;
        this.taskType = taskType;
        this.taskID = id++;
        this.log = engine.getLogger();
        this.executionContext = new ExecutionContext(this);
        this.executionContext.setReportContext(new ReportContextImpl(this.executionContext));
        this.setAppContext(null);
        this.cancelFlag = false;
        this.runningStatus = 0;
    }

    protected IReportRunnable getOnPreparedRunnable(IReportDocument doc) {
        IInternalReportDocument internalReportDoc = (IInternalReportDocument)doc;
        return internalReportDoc.getOnPreparedRunnable();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ULocale getULocale() {
        return ULocale.forLocale((Locale)this.locale);
    }

    public void setLocale(Locale locale) {
        this.log.log(Level.FINE, "EngineTask.setLocale: locale={0}", locale == null ? null : locale.getDisplayName());
        this.doSetLocale(locale);
    }

    private void doSetLocale(Locale locale) {
        this.locale = locale;
        this.executionContext.setLocale(locale);
        EngineException.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setLocale(ULocale uLocale) {
        this.log.log(Level.FINE, "EngineTask.setLocale: uLocale={0}", uLocale == null ? null : uLocale.getDisplayName());
        this.doSetLocale(uLocale.toLocale());
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.executionContext.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setAppContext(Map context) {
        HashMap appContext = new HashMap();
        HashMap sysAppContext = this.engine.getConfig().getAppContext();
        if (sysAppContext != null) {
            appContext.putAll(sysAppContext);
        }
        this.addAppContext(context, appContext);
        this.executionContext.setAppContext(appContext);
        StringBuffer logStr = null;
        if (this.log.isLoggable(Level.FINE)) {
            logStr = new StringBuffer();
        }
        if (!appContext.isEmpty()) {
            Set entries = appContext.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() instanceof String) {
                    this.executionContext.registerBean((String)entry.getKey(), entry.getValue());
                    if (logStr == null) continue;
                    logStr.append(entry.getKey());
                    logStr.append("=");
                    logStr.append(entry.getValue());
                    logStr.append(";");
                    continue;
                }
                this.log.log(Level.WARNING, "Map entry {0} is invalid and ignored, because its key is a not string.", entry.getKey().toString());
            }
        }
        if (logStr != null) {
            this.log.log(Level.FINE, "EngineTask.setAppContext: context={0}", logStr);
        }
    }

    private void addAppContext(Map from, Map to) {
        if (from == null || to == null) {
            return;
        }
        for (Map.Entry entry : from.entrySet()) {
            if (this.isDeprecatedEntry(entry)) continue;
            to.put(entry.getKey(), entry.getValue());
        }
    }

    private boolean isDeprecatedEntry(Map.Entry entry) {
        Object key = entry.getKey();
        if (("PARENT_CLASSLOADER".equals(key) || "webapplication.projectclasspath".equals(key) || "user.projectclasspath".equals(key) || "workspace.projectclasspath".equals(key)) && entry.getValue() != this.getAppContext().get(key)) {
            this.log.log(Level.WARNING, key + " could not be set in appContext of IEngineTask, please set it in appContext of IReportEngine");
            return true;
        }
        return false;
    }

    public Map getAppContext() {
        return this.executionContext.getAppContext();
    }

    public IReportEngine getEngine() {
        return this.engine;
    }

    public void setReportRunnable(IReportRunnable runnable) {
        if (runnable != null) {
            Properties systemProperties = SecurityUtil.getSystemProperties();
            this.executionContext.setRunnable(runnable);
            this.executionContext.registerBeans(systemProperties);
            this.executionContext.registerBeans(runnable.getTestConfig());
            this.executionContext.getConfigs().putAll(systemProperties);
            this.executionContext.getConfigs().putAll(runnable.getTestConfig());
        }
    }

    public IReportRunnable getReportRunnable() {
        return this.executionContext.getOriginalRunnable();
    }

    public void setRenderOption(IRenderOption options) {
        if (options == null) {
            throw new NullPointerException("options can't be null");
        }
        this.renderOptions = options;
    }

    public IRenderOption getRenderOption() {
        return this.renderOptions;
    }

    public void setEmitterID(String id) {
        this.emitterID = id;
    }

    public String getEmitterID() {
        return this.emitterID;
    }

    public DataRequestSession getDataSession() {
        return this.executionContext.getDataEngine().getDTESession();
    }

    public void addScriptableJavaObject(String jsName, Object obj) {
        this.executionContext.registerBean(jsName, obj);
    }

    public int getID() {
        return this.taskID;
    }

    protected Object convertToType(Object value, String type) {
        try {
            return EngineTask.convertParameterType(value, type);
        }
        catch (BirtException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static Object convertParameterType(Object value, String type) throws BirtException {
        if ("boolean".equals(type)) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if ("dateTime".equals(type)) {
            return DataTypeUtil.toDate((Object)value);
        }
        if ("date".equals(type)) {
            return DataTypeUtil.toSqlDate((Object)value);
        }
        if ("time".equals(type)) {
            return DataTypeUtil.toSqlTime((Object)value);
        }
        if ("decimal".equals(type)) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if ("float".equals(type)) {
            return DataTypeUtil.toDouble((Object)value);
        }
        if ("string".equals(type)) {
            return DataTypeUtil.toString((Object)value);
        }
        if ("integer".equals(type)) {
            return DataTypeUtil.toInteger((Object)value);
        }
        return value;
    }

    public boolean validateParameters() {
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable == null) {
            return false;
        }
        try {
            this.doValidateParameters();
            return true;
        }
        catch (ParameterValidationException ex) {
            this.log.log(Level.SEVERE, ex.getMessage(), (Throwable)((Object)ex));
            return false;
        }
    }

    protected boolean doValidateParameters() throws ParameterValidationException {
        this.usingParameterValues();
        if (this.log.isLoggable(Level.FINE)) {
            this.loggerParamters();
        }
        ParameterValidationVisitor pv = new ParameterValidationVisitor();
        boolean result = pv.visit(this.executionContext.getDesign(), null);
        if (pv.engineException != null) {
            throw pv.engineException;
        }
        return result;
    }

    protected void loggerParamters() {
        if (this.log.isLoggable(Level.FINE)) {
            final StringBuffer buffer = new StringBuffer();
            new ParameterVisitor(){

                boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
                    String paramName = param.getName();
                    Object paramValue = EngineTask.this.runValues.get(paramName);
                    buffer.append(paramName);
                    buffer.append(":");
                    buffer.append(paramValue);
                    buffer.append("\n");
                    return true;
                }

                boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                    return this.visitParametersInGroup(group, value);
                }
            }.visit(this.executionContext.getDesign(), null);
            this.log.log(Level.FINE, "Running the report with paramters: {0}", buffer);
        }
    }

    private boolean validateScalarParameter(ScalarParameterHandle paramHandle) throws ParameterValidationException {
        String paramType;
        String paramName = paramHandle.getName();
        Object paramValue = this.runValues.get(paramName);
        String type = paramHandle.getDataType();
        if (paramValue == null) {
            if (!paramHandle.isRequired()) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterValueIsNull", new String[]{paramName});
        }
        String source = paramHandle.getValidate();
        if (source != null && source.length() != 0) {
            try {
                Object result = this.executionContext.evaluate(source);
                if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) {
                    throw new ParameterValidationException("Error.ParamValidationFailure", new String[]{paramName});
                }
            }
            catch (ParameterValidationException pve) {
                throw pve;
            }
            catch (BirtException ex) {
                throw new ParameterValidationException(ex);
            }
        }
        if ("multi-value".equals(paramType = paramHandle.getParamType())) {
            if (paramValue instanceof Object[]) {
                boolean isValid = true;
                Object[] paramValueList = (Object[])paramValue;
                int i = 0;
                while (i < paramValueList.length) {
                    if (paramValueList[i] != null && !this.validateParameterValueType(paramName, paramValueList[i], type, paramHandle)) {
                        isValid = false;
                    }
                    ++i;
                }
                return isValid;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, "Object[]", paramValue.getClass().getName()});
        }
        return this.validateParameterValueType(paramName, paramValue, type, paramHandle);
    }

    private boolean validateParameterValueType(String paramName, Object paramValue, String type, ScalarParameterHandle paramHandle) throws ParameterValidationException {
        if ("decimal".equals(type) || "float".equals(type)) {
            if (paramValue instanceof Number) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("dateTime".equals(type)) {
            if (paramValue instanceof java.util.Date) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("date".equals(type)) {
            if (paramValue instanceof Date) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("time".equals(type)) {
            if (paramValue instanceof Time) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        if ("string".equals(type)) {
            String value;
            if (paramHandle.isRequired() && (value = paramValue.toString().trim()).length() == 0) {
                throw new ParameterValidationException("Error.ParameterValueIsBlank", new String[]{paramName});
            }
            return true;
        }
        if ("boolean".equals(type)) {
            if (paramValue instanceof Boolean) {
                return true;
            }
            throw new ParameterValidationException("Error.ParameterTypeIsInvalid", new String[]{paramName, type, paramValue.getClass().getName()});
        }
        return true;
    }

    public void setParameterValues(Map params) {
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setParameterValue(name, value);
        }
    }

    public void setParameterValue(String name, Object value) {
        this.log.log(Level.FINE, "EngineTask.setParameterValue: {0}={1} [{2}]", new Object[]{name, value, value == null ? null : value.getClass().getName()});
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            ((ParameterAttribute)parameter).setValue(value);
        } else {
            this.inputValues.put(name, new ParameterAttribute(value, null));
        }
    }

    public void setValue(String name, Object value) {
        this.setParameterValue(name, value);
    }

    public HashMap getParameterValues() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.inputValues.entrySet()) {
            ParameterAttribute parameter = (ParameterAttribute)entry.getValue();
            result.put(entry.getKey(), parameter.getValue());
        }
        return result;
    }

    public Object getParameterValue(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter == null) {
            return null;
        }
        assert (parameter instanceof ParameterAttribute);
        return ((ParameterAttribute)parameter).getValue();
    }

    public void setParameter(String name, Object value, String displayText) {
        this.parameterChanged = true;
        this.inputValues.put(name, new ParameterAttribute(value, displayText));
    }

    public String getParameterDisplayText(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            return ((ParameterAttribute)parameter).getDisplayText();
        }
        return null;
    }

    public void setParameterDisplayTexts(Map params) {
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            String text = (String)entry.getValue();
            this.setParameterDisplayText(name, text);
        }
    }

    public void setParameterDisplayText(String name, String displayText) {
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            assert (parameter instanceof ParameterAttribute);
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        } else {
            this.inputValues.put(name, new ParameterAttribute(null, displayText));
        }
    }

    public void cancel() {
        this.cancelFlag = true;
        this.executionContext.cancel();
    }

    public void cancel(Object signal) {
        if (signal == null) {
            throw new IllegalArgumentException("signal can't be null");
        }
        this.cancelFlag = true;
        long waitingTime = 0L;
        do {
            waitingTime += 100L;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            if (this.runningStatus == 1) continue;
            return;
        } while (waitingTime < 5000L);
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    public void setErrorHandlingOption(int option) {
        if (option == 1) {
            this.executionContext.setCancelOnError(true);
        } else {
            this.executionContext.setCancelOnError(false);
        }
    }

    protected IQueryResults executeDataSet(DataSetHandle hDataSet, HashMap parameters) {
        return null;
    }

    protected void usingParameterValues() {
        if (!this.parameterChanged) {
            return;
        }
        this.parameterChanged = false;
        this.executionContext.clearParameters();
        this.runValues.clear();
        for (Map.Entry entry : this.inputValues.entrySet()) {
            Object key = entry.getKey();
            ParameterAttribute attribute = (ParameterAttribute)entry.getValue();
            this.runValues.put(key, attribute.getValue());
            this.executionContext.setParameter((String)key, attribute.getValue(), attribute.getDisplayText());
        }
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable == null) {
            return;
        }
        new ParameterVisitor(){

            boolean visitScalarParameter(ScalarParameterHandle param, Object userData) {
                String name = param.getName();
                if (!EngineTask.this.inputValues.containsKey(name)) {
                    Object value = EngineTask.this.convertToType(param.getDefaultValue(), param.getDataType());
                    EngineTask.this.executionContext.setParameterValue(name, value);
                    EngineTask.this.runValues.put(name, value);
                }
                return true;
            }

            boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                return this.visitParametersInGroup(group, value);
            }
        }.visit((ReportDesignHandle)runnable.getDesignHandle());
    }

    public void close() {
        this.executionContext.close();
        EngineLoggerHandler.setLogger(null);
    }

    protected IContentEmitter createContentEmitter() throws EngineException {
        ExtensionManager extManager = ExtensionManager.getInstance();
        this.pagination = extManager.getPagination(this.emitterID);
        Boolean outputDisplayNone = extManager.getOutputDisplayNone(this.emitterID);
        if (!this.renderOptions.hasOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone")) {
            this.renderOptions.setOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone", outputDisplayNone);
        }
        IContentEmitter emitter = null;
        try {
            emitter = extManager.createEmitter(this.format, this.emitterID);
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Report engine can not create {0} emitter.", this.format);
            throw new EngineException("Error.CannotCreateExtensionInstance", this.format, t);
        }
        if (emitter == null) {
            this.log.log(Level.SEVERE, "Report engine can not create {0} emitter.", this.format);
            throw new EngineException("Error.CannotCreateExtensionInstance", this.format);
        }
        return emitter;
    }

    protected IReportLayoutEngine createReportLayoutEngine(String pagination, IRenderOption options) {
        IReportLayoutEngine layoutEngine = LayoutEngineFactory.createLayoutEngine(pagination);
        if (options != null) {
            Object dpi;
            Object pdfHyphenation;
            Object pdfFontSubstitution;
            Object pdfTextWrapping;
            Object outputDisplayNone;
            Object pageOverflow;
            Object pagebreakOnly;
            Object fitToPage = this.renderOptions.getOption("pdfRenderOption.fitToPage");
            if (fitToPage != null) {
                layoutEngine.setOption("pdfRenderOption.fitToPage", fitToPage);
            }
            if ((pagebreakOnly = this.renderOptions.getOption("pdfRenderOption.pagebreakPaginationOnly")) != null) {
                layoutEngine.setOption("pdfRenderOption.pagebreakPaginationOnly", pagebreakOnly);
            }
            if ((pageOverflow = this.renderOptions.getOption("pdfRenderOption.pageOverflow")) != null) {
                layoutEngine.setOption("pdfRenderOption.pageOverflow", pageOverflow);
            }
            if ((outputDisplayNone = this.renderOptions.getOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone")) != null) {
                layoutEngine.setOption("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone", outputDisplayNone);
            }
            if ((pdfTextWrapping = this.renderOptions.getOption("pdfRenderOption.textWrapping")) != null) {
                layoutEngine.setOption("pdfRenderOption.textWrapping", pdfTextWrapping);
            }
            if ((pdfFontSubstitution = this.renderOptions.getOption("pdfRenderOption.fontSubstitution")) != null) {
                layoutEngine.setOption("pdfRenderOption.fontSubstitution", pdfFontSubstitution);
            }
            layoutEngine.setOption("RTLFlag", this.renderOptions.getOption("RTLFlag"));
            Object pdfBidiProcessing = this.renderOptions.getOption("pdfRenderOption.bidiProcessing");
            if (pdfBidiProcessing != null) {
                layoutEngine.setOption("pdfRenderOption.bidiProcessing", pdfBidiProcessing);
            }
            if ((pdfHyphenation = this.renderOptions.getOption("pdfRenderOption.hyphenation")) != null) {
                layoutEngine.setOption("pdfRenderOption.hyphenation", pdfHyphenation);
            }
            if ((dpi = this.renderOptions.getOption("pdfRenderOption.dpi")) != null) {
                layoutEngine.setOption("pdfRenderOption.dpi", dpi);
            }
        }
        layoutEngine.setOption(TASK_TYPE, new Integer(this.taskType));
        return layoutEngine;
    }

    protected void loadDesign() {
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable != null) {
            String fileName;
            IncludeScriptHandle includeScript;
            ReportDesignHandle reportDesign = this.executionContext.getDesign();
            Iterator iter = reportDesign.includeLibraryScriptsIterator();
            while (iter.hasNext()) {
                includeScript = (IncludeScriptHandle)iter.next();
                fileName = includeScript.getFileName();
                this.executionContext.loadScript(fileName);
            }
            iter = reportDesign.includeScriptsIterator();
            while (iter.hasNext()) {
                includeScript = (IncludeScriptHandle)iter.next();
                fileName = includeScript.getFileName();
                this.executionContext.loadScript(fileName);
            }
            ReportScriptExecutor.handleInitialize(reportDesign, this.executionContext);
        }
    }

    protected void prepareDesign() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ScriptedDesignSearcher searcher = new ScriptedDesignSearcher(reportDesign);
        searcher.apply((DesignElementHandle)reportDesign);
        boolean hasOnprepare = searcher.hasOnPrepareScript();
        if (hasOnprepare) {
            ReportRunnable newRunnable = this.executionContext.getRunnable().cloneRunnable();
            ReportDesignHandle newDesign = newRunnable.designHandle;
            ScriptedDesignHandler visitor = new ScriptedDesignHandler(newDesign, this.executionContext);
            visitor.apply((DesignElementHandle)newDesign.getRoot());
            this.executionContext.updateRunnable(newRunnable);
        }
    }

    protected void startFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleBeforeFactory(reportDesign, this.executionContext);
    }

    protected void closeFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleAfterFactory(reportDesign, this.executionContext);
    }

    protected void startRender() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleBeforeRender(reportDesign, this.executionContext);
    }

    protected void closeRender() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleAfterRender(reportDesign, this.executionContext);
    }

    public void setDataSource(IDocArchiveReader dataSource) {
        this.setDataSource(dataSource, null);
    }

    public void setDataSource(IDocArchiveReader dataSource, String reportlet) {
        this.dataSource = dataSource;
        this.dataSourceReportlet = reportlet;
    }

    public int getStatus() {
        return this.runningStatus;
    }

    public List getErrors() {
        return this.executionContext.getErrors();
    }

    public IReportContext getReportContext() {
        return this.executionContext.getReportContext();
    }

    private void mergeOption(IRenderOption options, String name, Object value) {
        if (options != null && value != null && !options.hasOption(name)) {
            options.setOption(name, value);
        }
    }

    protected void setupRenderOption() throws EngineException {
        IRenderOption emitterOptions;
        IRenderOption formatOptions;
        Object renderContext;
        ExtensionManager extManager = ExtensionManager.getInstance();
        if (this.renderOptions != null) {
            this.format = this.renderOptions.getOutputFormat();
            this.emitterID = this.renderOptions.getEmitterID();
            if (this.emitterID != null) {
                boolean validEmitterID = extManager.isValidEmitterID(this.emitterID);
                if (!validEmitterID) {
                    this.log.log(Level.SEVERE, "Error.InvalidEmitterID", this.emitterID);
                    throw new EngineException("Error.InvalidEmitterID", this.emitterID);
                }
                String formatOfEmitter = extManager.getFormat(this.emitterID);
                if (this.format == null) {
                    this.renderOptions.setOutputFormat(formatOfEmitter);
                } else if (!this.format.equals(formatOfEmitter)) {
                    throw new EngineException("Error.OutputFormatNotSupported", this.format);
                }
            } else if (this.format == null) {
                this.format = FORMAT_HTML;
                this.renderOptions.setOutputFormat(this.format);
                this.emitterID = "org.eclipse.birt.report.engine.emitter.html";
            } else {
                boolean supportedFormat = extManager.isSupportedFormat(this.format);
                if (!supportedFormat) {
                    this.log.log(Level.SEVERE, "Error.OutputFormatNotSupported", this.format);
                    throw new UnsupportedFormatException("Error.OutputFormatNotSupported", this.format);
                }
                this.emitterID = extManager.getEmitterID(this.format);
            }
        }
        Map appContext = this.executionContext.getAppContext();
        if ("org.eclipse.birt.report.engine.emitter.pdf".equals(this.emitterID)) {
            renderContext = appContext.get("PDF_RENDER_CONTEXT");
            if (renderContext instanceof PDFRenderContext) {
                PDFRenderContext pdfContext = (PDFRenderContext)renderContext;
                this.mergeOption(this.renderOptions, "baseUrl", pdfContext.getBaseURL());
                this.mergeOption(this.renderOptions, "pdfRenderOption.fontDirectory", pdfContext.getFontDirectory());
                this.mergeOption(this.renderOptions, "supportedImageFormats", pdfContext.getSupportedImageFormats());
                this.mergeOption(this.renderOptions, "pdfRenderOption.embeddedFonts", new Boolean(pdfContext.isEmbededFont()));
            }
        } else {
            renderContext = appContext.get("HTML_RENDER_CONTEXT");
            if (renderContext instanceof HTMLRenderContext) {
                HTMLRenderContext htmlContext = (HTMLRenderContext)renderContext;
                this.mergeOption(this.renderOptions, "baseImageURL", htmlContext.getBaseImageURL());
                this.mergeOption(this.renderOptions, "baseUrl", htmlContext.getBaseURL());
                this.mergeOption(this.renderOptions, "imageDirectory", htmlContext.getImageDirectory());
                this.mergeOption(this.renderOptions, "supportedImageFormats", htmlContext.getSupportedImageFormats());
            }
        }
        HashMap options = new HashMap();
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IRenderOption defaultOptions = (IRenderOption)configs.get("org.eclipse.birt.report.engine.api.EngineConfig.defaultRenderOption");
        if (defaultOptions == null) {
            defaultOptions = (IRenderOption)configs.get(FORMAT_HTML);
        }
        if (defaultOptions != null) {
            options.putAll(defaultOptions.getOptions());
        }
        if ((formatOptions = (IRenderOption)configs.get(this.format)) != null) {
            options.putAll(formatOptions.getOptions());
        }
        if (this.emitterID != null && (emitterOptions = (IRenderOption)configs.get(this.emitterID)) != null) {
            options.putAll(emitterOptions.getOptions());
        }
        if (this.renderOptions != null) {
            options.putAll(this.renderOptions.getOptions());
        }
        RenderOption allOptions = new RenderOption(options);
        this.executionContext.setRenderOption(allOptions);
        if ("org.eclipse.birt.report.engine.emitter.pdf".equals(this.emitterID)) {
            Object renderContext2 = appContext.get("PDF_RENDER_CONTEXT");
            if (renderContext2 == null) {
                PDFRenderOption pdfOptions = new PDFRenderOption(allOptions);
                PDFRenderContext pdfContext = new PDFRenderContext();
                pdfContext.setBaseURL(pdfOptions.getBaseURL());
                pdfContext.setEmbededFont(pdfOptions.isEmbededFont());
                pdfContext.setFontDirectory(pdfOptions.getFontDirectory());
                pdfContext.setSupportedImageFormats(pdfOptions.getSupportedImageFormats());
                appContext.put("PDF_RENDER_CONTEXT", pdfContext);
            }
        } else {
            Object renderContext3 = appContext.get("HTML_RENDER_CONTEXT");
            if (renderContext3 == null) {
                HTMLRenderContext htmlContext = new HTMLRenderContext();
                HTMLRenderOption htmlOptions = new HTMLRenderOption(allOptions);
                htmlContext.setBaseImageURL(htmlOptions.getBaseImageURL());
                htmlContext.setBaseURL(htmlOptions.getBaseURL());
                htmlContext.setImageDirectory(htmlOptions.getImageDirectory());
                htmlContext.setSupportedImageFormats(htmlOptions.getSupportedImageFormats());
                htmlContext.SetRenderOption(allOptions);
                appContext.put("HTML_RENDER_CONTEXT", htmlContext);
            }
        }
    }

    protected void initializeContentEmitter(IContentEmitter emitter, IReportExecutor executor) {
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IReportContext reportContext = this.executionContext.getReportContext();
        IRenderOption options = this.executionContext.getRenderOption();
        EngineEmitterServices services = new EngineEmitterServices(reportContext, options, configs);
        emitter.initialize(services);
    }

    public int getTaskType() {
        return this.taskType;
    }

    protected void changeStatusToRunning() {
        this.runningStatus = 1;
    }

    protected void changeStatusToStopped() {
        this.runningStatus = this.cancelFlag ? 4 : (this.executionContext.hasErrors() ? 3 : 2);
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger logger) {
        if (logger == null || !EngineLogger.isValidLogger(logger)) {
            throw new IllegalArgumentException("the logger can't be NULL or children or in namespace of org.eclipse.birt");
        }
        EngineLoggerHandler.setLogger(logger);
        this.log = logger;
        this.executionContext.setLogger(logger);
    }

    protected void switchToOsgiClassLoader() {
        ClassLoader newLoader = Platform.getContextClassLoader();
        if (newLoader != null) {
            this.contextClassLoader = SecurityUtil.setContextClassLoader(newLoader);
        }
    }

    protected void switchClassLoaderBack() {
        if (this.contextClassLoader != null) {
            SecurityUtil.setContextClassLoader(this.contextClassLoader);
        }
    }

    protected void loadDataSource() throws EngineException {
        if (this.dataSource == null) {
            return;
        }
        try {
            ReportDocumentReader document = new ReportDocumentReader(this.engine, this.dataSource, true);
            try {
                Map values = document.getParameterValues();
                Map texts = document.getParameterDisplayTexts();
                this.setParameterValues(values);
                this.setParameterDisplayTexts(texts);
                if (this.dataSourceReportlet == null) {
                    this.executionContext.setDataSource(new DocumentDataSource(this.dataSource));
                    return;
                }
                this.loadReportletDataSource(document, this.dataSource, this.dataSourceReportlet);
            }
            finally {
                document.close();
            }
        }
        catch (IOException ioex) {
            throw new EngineException(ioex.getMessage(), ioex);
        }
    }

    private void loadReportletDataSource(ReportDocumentReader document, IDocArchiveReader dataSource, String reportletBookmark) throws EngineException, IOException {
        InstanceID reportletIid = null;
        if (document.isReporltetDocument()) {
            String bookmark = document.getReportletBookmark();
            if (!reportletBookmark.equals(bookmark)) {
                throw new EngineException("The user must specify the same reportlet with the one used to generate the document");
            }
            reportletIid = document.getReportletInstanceID();
        } else {
            long offset = document.getBookmarkOffset(reportletBookmark);
            if (offset == -1L) {
                throw new EngineException("The user specified reportlet {0} doesn''t exits in the report document", new Object[]{reportletBookmark});
            }
            ClassLoader loader = document.getClassLoader();
            RAInputStream in = dataSource.getInputStream("/content/content.dat");
            try {
                ReportContentReaderV3 reader = new ReportContentReaderV3(new ReportContent(), in, loader);
                try {
                    LinkedList<InstanceID> iids = new LinkedList<InstanceID>();
                    while (offset != -1L) {
                        IContent content = reader.readContent(offset);
                        iids.addFirst(content.getInstanceID());
                        offset = ((DocumentExtension)content.getExtension(0)).getParent();
                    }
                    for (InstanceID iid : iids) {
                        reportletIid = reportletIid == null ? iid : new InstanceID(reportletIid, iid);
                    }
                }
                finally {
                    reader.close();
                }
            }
            finally {
                in.close();
            }
        }
        this.executionContext.setDataSource(new DocumentDataSource(dataSource, reportletBookmark, reportletIid));
    }

    protected void updateRtLFlag() throws EngineException {
        if (this.renderOptions == null) {
            return;
        }
        ReportRunnable runnable = this.executionContext.getRunnable();
        if (runnable == null) {
            return;
        }
        ReportDesignHandle handle = (ReportDesignHandle)runnable.getDesignHandle();
        if (handle != null) {
            Object bidiFlag = this.renderOptions.getOption("RTLFlag");
            if (Boolean.TRUE.equals(bidiFlag)) {
                try {
                    handle.setBidiOrientation("rtl");
                }
                catch (SemanticException e) {
                    this.log.log(Level.WARNING, "An error happened while running the report. Cause:", e);
                    throw new EngineException("Failed to update RtL flag.");
                }
            } else if (handle.isDirectionRTL()) {
                this.renderOptions.setOption("RTLFlag", new Boolean(true));
                IRenderOption renderOptions2 = this.executionContext.getRenderOption();
                if (renderOptions2 != null) {
                    renderOptions2.setOption("RTLFlag", new Boolean(true));
                    this.executionContext.setRenderOption(renderOptions2);
                }
            }
        }
    }

    protected IReportExecutor createReportExtensionExecutor(IReportExecutor executor) throws EngineException {
        String[] extensions = this.executionContext.getEngineExtensions();
        if (extensions != null) {
            ArrayList<IContentProcessor> processors = new ArrayList<IContentProcessor>();
            EngineExtensionManager manager = this.executionContext.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProcessor processor;
                String extName = stringArray[n2];
                IGenerateExtension genExt = manager.getGenerateExtension(extName);
                if (genExt != null && (processor = genExt.createGenerateProcessor()) != null) {
                    processors.add(processor);
                }
                ++n2;
            }
            if (!processors.isEmpty()) {
                return new ReportExtensionExecutor(this.executionContext, executor, processors.toArray(new IContentProcessor[processors.size()]));
            }
        }
        return executor;
    }

    public void setUserACL(String[] acls) {
        if (acls != null) {
            String[] strippedAcls = this.strip(acls);
            this.executionContext.getAppContext().put("USER_ACL", strippedAcls);
        } else {
            this.executionContext.getAppContext().put("USER_ACL", null);
        }
    }

    protected String[] strip(String[] acls) {
        ArrayList<String> strippedAcls = new ArrayList<String>();
        int i = 0;
        while (i < acls.length) {
            String strippedAcl;
            String acl = acls[i];
            if (acl != null && (strippedAcl = acl.trim()).length() > 0) {
                strippedAcls.add(strippedAcl);
            }
            ++i;
        }
        return strippedAcls.toArray(new String[strippedAcls.size()]);
    }

    private class ParameterValidationVisitor
    extends ParameterVisitor {
        ParameterValidationException engineException;

        private ParameterValidationVisitor() {
        }

        boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
            try {
                return EngineTask.this.validateScalarParameter(param);
            }
            catch (ParameterValidationException pe) {
                this.engineException = pe;
                return false;
            }
        }

        boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
            return this.visitParametersInGroup(group, value);
        }
    }

    static abstract class ParameterVisitor {
        ParameterVisitor() {
        }

        boolean visitParametersInGroup(ParameterGroupHandle group, Object value) {
            SlotHandle parameters = group.getParameters();
            for (Object param : parameters) {
                if (!(param instanceof CascadingParameterGroupHandle ? !this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value) : (param instanceof ParameterGroupHandle ? !this.visitParameterGroup((ParameterGroupHandle)param, value) : param instanceof ScalarParameterHandle && !this.visitScalarParameter((ScalarParameterHandle)param, value)))) continue;
                return false;
            }
            return true;
        }

        boolean visitCascadingParamterGroup(CascadingParameterGroupHandle group, Object value) {
            return this.visitParameterGroup((ParameterGroupHandle)group, value);
        }

        boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
            return false;
        }

        boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
            return false;
        }

        boolean visit(ReportDesignHandle report) {
            return this.visit(report, null);
        }

        boolean visit(ReportDesignHandle report, Object value) {
            SlotHandle parameters = report.getParameters();
            for (Object param : parameters) {
                if (!(param instanceof CascadingParameterGroupHandle ? !this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value) : (param instanceof ParameterGroupHandle ? !this.visitParameterGroup((ParameterGroupHandle)param, value) : param instanceof ScalarParameterHandle && !this.visitScalarParameter((ScalarParameterHandle)param, value)))) continue;
                return false;
            }
            return true;
        }
    }
}

