/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.report.engine.api.impl.ScriptedDesignVisitor;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IReportItemPreparation;
import org.eclipse.birt.report.engine.extension.internal.PreparationContext;
import org.eclipse.birt.report.engine.extension.internal.ReportItemPreparationInfo;
import org.eclipse.birt.report.engine.script.internal.AutoTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ExtendedItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ImageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;

public class ScriptedDesignHandler
extends ScriptedDesignVisitor {
    protected static Logger logger = Logger.getLogger(ScriptedDesignHandler.class.getName());
    protected ExecutionContext executionContext;

    ScriptedDesignHandler(ReportDesignHandle handle, ExecutionContext executionContext) {
        super(handle);
        this.executionContext = executionContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOnPrepare(ReportItemHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null) {
                    this.executionContext.evaluate(this.getOnPrepareScriptExpression(handle));
                }
                return;
            }
            catch (BirtException ex) {
                this.executionContext.addException((DesignElementHandle)handle, ex);
                return;
            }
            finally {
                if (element != null) {
                    this.executionContext.exitScope();
                }
            }
        }
        try {
            if (handle instanceof DataItemHandle) {
                DataItemScriptExecutor.handleOnPrepare((DataItemHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof GridHandle) {
                GridScriptExecutor.handleOnPrepare((GridHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof ImageHandle) {
                ImageScriptExecutor.handleOnPrepare((ImageHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof LabelHandle) {
                LabelScriptExecutor.handleOnPrepare((LabelHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof ListHandle) {
                ListScriptExecutor.handleOnPrepare((ListHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof TableHandle) {
                TableScriptExecutor.handleOnPrepare((TableHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof TextItemHandle) {
                TextItemScriptExecutor.handleOnPrepare((TextItemHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof TextDataHandle) {
                DynamicTextScriptExecutor.handleOnPrepare((TextDataHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof AutoTextHandle) {
                AutoTextScriptExecutor.handleOnPrepare((AutoTextHandle)handle, this.executionContext);
                return;
            }
            if (handle instanceof ExtendedItemHandle) {
                ExtendedItemScriptExecutor.handleOnPrepare((ExtendedItemHandle)handle, this.executionContext);
                return;
            }
            try {
                try {
                    this.executionContext.newScope(handle);
                    this.executionContext.evaluate(this.getOnPrepareScriptExpression(handle));
                }
                catch (BirtException ex) {
                    this.executionContext.addException((DesignElementHandle)handle, ex);
                    this.executionContext.exitScope();
                    this.executionContext.popHandle();
                    return;
                }
            }
            finally {
                this.executionContext.exitScope();
            }
        }
        finally {
            this.executionContext.popHandle();
        }
    }

    protected ScriptExpression getOnPrepareScriptExpression(ReportItemHandle handle) {
        String scriptText;
        if (handle != null && (scriptText = handle.getOnPrepare()) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPrepare"));
            return new ScriptExpression(scriptText, id);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOnPrepare(CellHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                String scriptText;
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null && (scriptText = handle.getOnPrepare()) != null) {
                    String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPrepare"));
                    ScriptExpression scriptExpr = new ScriptExpression(scriptText, id);
                    this.executionContext.evaluate(scriptExpr);
                }
                return;
            }
            catch (BirtException ex) {
                this.executionContext.addException((DesignElementHandle)handle, ex);
                return;
            }
            finally {
                if (element != null) {
                    this.executionContext.exitScope();
                }
            }
        }
        try {
            CellScriptExecutor.handleOnPrepare(handle, this.executionContext);
            return;
        }
        finally {
            this.executionContext.popHandle();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOnPrepare(GroupHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                String scriptText;
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null && (scriptText = handle.getOnPrepare()) != null) {
                    String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPrepare"));
                    ScriptExpression expr = new ScriptExpression(scriptText, id);
                    this.executionContext.evaluate(expr);
                }
                return;
            }
            catch (BirtException ex) {
                this.executionContext.addException((DesignElementHandle)handle, ex);
                return;
            }
            finally {
                if (element != null) {
                    this.executionContext.exitScope();
                }
            }
        }
        try {
            if (handle instanceof TableGroupHandle) {
                TableGroupScriptExecutor.handleOnPrepare((TableGroupHandle)handle, this.executionContext);
            }
            if (!(handle instanceof ListGroupHandle)) return;
            ListGroupScriptExecutor.handleOnPrepare((ListGroupHandle)handle, this.executionContext);
            return;
        }
        finally {
            this.executionContext.popHandle();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOnPrepare(RowHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                String scriptText;
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null && (scriptText = handle.getOnPrepare()) != null) {
                    String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPrepare"));
                    ScriptExpression expr = new ScriptExpression(scriptText, id);
                    this.executionContext.evaluate(expr);
                }
                return;
            }
            catch (BirtException ex) {
                this.executionContext.addException((DesignElementHandle)handle, ex);
                return;
            }
            finally {
                if (element != null) {
                    this.executionContext.exitScope();
                }
            }
        }
        try {
            RowScriptExecutor.handleOnPrepare(handle, this.executionContext);
            return;
        }
        finally {
            this.executionContext.popHandle();
        }
    }

    protected void visitExtendedItem(ExtendedItemHandle handle) {
        IReportItemPreparation itemPreparation = this.executionContext.getExtendedItemManager().createPreparation(handle);
        if (itemPreparation != null) {
            ReportItemPreparationInfo preparationInfo = new ReportItemPreparationInfo((DesignElementHandle)handle, new PreparationContext(this.executionContext, this));
            itemPreparation.init(preparationInfo);
            try {
                itemPreparation.prepare();
            }
            catch (BirtException ex) {
                logger.log(Level.WARNING, "An error happens when preparing extended report item", ex);
                this.executionContext.addException((DesignElementHandle)handle, ex);
            }
        } else {
            ExtendedItemScriptExecutor.handleOnPrepare(handle, this.executionContext);
            Iterator propIter = handle.getPropertyIterator();
            while (propIter.hasNext()) {
                PropertyHandle propHandle = (PropertyHandle)propIter.next();
                IElementPropertyDefn property = propHandle.getPropertyDefn();
                if (property.getTypeCode() != 23) continue;
                Object children = propHandle.getValue();
                if (children instanceof List) {
                    List tempList = (List)children;
                    int i = 0;
                    while (tempList != null && i < tempList.size()) {
                        Object tempObj = tempList.get(i);
                        if (tempObj instanceof ReportItemHandle) {
                            this.apply((DesignElementHandle)((ReportItemHandle)tempObj));
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(children instanceof ReportItemHandle)) continue;
                this.apply((DesignElementHandle)((ReportItemHandle)children));
            }
        }
    }
}

