/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data;

import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DataGenerationEngine;
import org.eclipse.birt.report.engine.data.dte.DataInteractiveEngine;
import org.eclipse.birt.report.engine.data.dte.DataPresentationEngine;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;

public class DataEngineFactory {
    protected static DataEngineFactory sm_instance;

    private DataEngineFactory() {
    }

    public static synchronized DataEngineFactory getInstance() {
        if (sm_instance == null) {
            sm_instance = new DataEngineFactory();
        }
        return sm_instance;
    }

    public IDataEngine createDataEngine(ExecutionContext context) throws Exception {
        DocumentDataSource dataSource = context.getDataSource();
        if (dataSource != null) {
            ReportDocumentWriter writer = context.getReportDocWriter();
            IDocArchiveWriter archiverWriter = null;
            if (writer != null) {
                archiverWriter = writer.getArchive();
            }
            return new DataInteractiveEngine(context, dataSource.getDataSource(), archiverWriter);
        }
        ReportDocumentWriter writer = context.getReportDocWriter();
        if (writer != null) {
            return new DataGenerationEngine(context, context.getReportDocWriter().getArchive());
        }
        IReportDocument document = context.getReportDocument();
        if (document != null) {
            if (context.getEngineTask().getTaskType() == 4) {
                return new DataInteractiveEngine(context, context.getReportDocument().getArchive(), null);
            }
            return new DataPresentationEngine(context, context.getReportDocument().getArchive());
        }
        return new DteDataEngine(context);
    }
}

