/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import com.lowagie.text.Image;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class EmitterUtil {
    protected static Logger logger = Logger.getLogger(EmitterUtil.class.getName());

    public static OutputStream getOuputStream(IEmitterServices services, String defaultOutputFile) {
        FilterOutputStream out = null;
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                out = new BufferedOutputStream(new FileOutputStream(file));
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (out == null) {
            Object value = services.getOption("outputStream");
            if (value != null && value instanceof OutputStream) {
                Object closeOnExitValue = services.getOption("closeOutputStreamOnExit");
                boolean closeOnExit = false;
                if (closeOnExitValue != null && closeOnExitValue instanceof Boolean) {
                    closeOnExit = (Boolean)closeOnExitValue;
                }
                out = new EmitterOutputStream((OutputStream)value, closeOnExit);
            } else {
                try {
                    file = new File(defaultOutputFile);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return out;
    }

    public static Image getImage(IImageContent content) {
        Image image = null;
        try {
            String uri = content.getURI();
            String mimeType = content.getMIMEType();
            String extension = content.getExtension();
            switch (content.getImageSource()) {
                case 0: {
                    ReportDesignHandle design = content.getReportContent().getDesign().getReportDesign();
                    URL url = design.findResource(uri, 1);
                    InputStream in = url.openStream();
                    try {
                        try {
                            byte[] buffer;
                            if (SvgFile.isSvg(content.getURI())) {
                                buffer = SvgFile.transSvgToArray(in);
                            } else {
                                ArrayList<Byte> bytes = new ArrayList<Byte>();
                                int data = in.read();
                                while (data != -1) {
                                    bytes.add((byte)data);
                                    data = in.read();
                                }
                                buffer = new byte[bytes.size()];
                                int i = 0;
                                while (i < buffer.length) {
                                    buffer[i] = (Byte)bytes.get(i);
                                    ++i;
                                }
                            }
                            image = Image.getInstance((byte[])buffer);
                        }
                        catch (Exception ex) {
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                            in.close();
                        }
                        break;
                    }
                    finally {
                        in.close();
                    }
                }
                case 1: 
                case 2: {
                    byte[] data = content.getData();
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    if (SvgFile.isSvg(mimeType, uri, extension)) {
                        data = SvgFile.transSvgToArray(in);
                    }
                    image = Image.getInstance((byte[])data);
                    break;
                }
                case 3: {
                    image = SvgFile.isSvg(uri) ? Image.getInstance((byte[])SvgFile.transSvgToArray(uri)) : Image.getInstance((URL)new URL(content.getURI()));
                    break;
                }
                default: {
                    assert (false);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        return image;
    }

    private static class EmitterOutputStream
    extends FilterOutputStream {
        private boolean closeOutputStreamOnExit;

        public EmitterOutputStream(OutputStream out, boolean closeOutputStreamOnExit) {
            super(out);
            this.closeOutputStreamOnExit = closeOutputStreamOnExit;
        }

        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {}
            if (this.closeOutputStreamOnExit) {
                this.out.close();
            }
        }
    }
}

