/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class ImageItemExecutor
extends QueryItemExecutor {
    public ImageItemExecutor(ExecutorManager manager) {
        super(manager, 1);
    }

    public IContent execute() {
        ImageItemDesign imageDesign = (ImageItemDesign)this.getDesign();
        IImageContent imageContent = this.report.createImageContent();
        this.setContent(imageContent);
        this.executeQuery();
        this.initializeContent(imageDesign, imageContent);
        this.processAction(imageDesign, imageContent);
        this.processBookmark(imageDesign, imageContent);
        this.processStyle(imageDesign, imageContent);
        this.processVisibility(imageDesign, imageContent);
        try {
            this.handleImage(imageDesign, imageContent);
        }
        catch (BirtException ex) {
            this.context.addException(ex);
        }
        if (this.context.isInFactory()) {
            this.handleOnCreate(imageContent);
        }
        this.startTOCEntry(imageContent);
        return imageContent;
    }

    public void close() {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }

    protected void handleImage(ImageItemDesign imageDesign, IImageContent imageContent) throws BirtException {
        switch (imageDesign.getImageSource()) {
            case 0: {
                String imageExpr = imageDesign.getImageUri();
                if (imageExpr == null) break;
                this.handleURIImage(imageExpr, imageContent);
                break;
            }
            case 3: {
                String fileExpr = imageDesign.getImageUri();
                assert (fileExpr != null);
                this.handleFileExpressionImage(fileExpr, imageContent);
                break;
            }
            case 1: {
                String imageName = imageDesign.getImageName();
                assert (imageName != null);
                this.handleNamedImage(imageName, imageContent);
                break;
            }
            case 2: {
                String imgExpr = imageDesign.getImageExpression();
                String fmtExpr = imageDesign.getImageFormat();
                assert (imgExpr != null);
                this.handleValueImage(imgExpr, fmtExpr, imageContent);
                break;
            }
            default: {
                this.getLogger().log(Level.SEVERE, "[ImageItemExecutor] invalid image source");
                this.context.addException(imageDesign.getHandle(), (BirtException)new EngineException("Error.InvalidImageSourceError"));
                assert (false);
                break;
            }
        }
    }

    protected void handleURIImage(String uriExpr, IImageContent imageContent) throws BirtException {
        imageContent.setImageSource(3);
        assert (uriExpr != null);
        try {
            Object uriObj = this.evaluate(uriExpr);
            String strUri = null;
            if (uriObj != null) {
                strUri = uriObj.toString();
            } else if (uriExpr != null && uriExpr.length() > 0) {
                strUri = uriExpr;
            }
            imageContent.setURI(strUri);
        }
        catch (BirtException ex) {
            if (uriExpr != null && uriExpr.length() > 0) {
                imageContent.setURI(uriExpr);
            }
            throw ex;
        }
    }

    protected void handleNamedImage(String imageName, IImageContent imageContent) throws BirtException {
        imageContent.setImageSource(1);
        imageContent.setURI(null);
        EmbeddedImage embeddedImage = this.context.getReport().getReportDesign().findImage(imageName);
        if (embeddedImage != null) {
            imageContent.setData(embeddedImage.getData(this.context.getDesign().getModule()));
            String mimeType = embeddedImage.getType(this.context.getDesign().getModule());
            if (mimeType != null) {
                imageContent.setMIMEType(mimeType);
                String extension = FileUtil.getExtFromType(mimeType);
                if (extension != null) {
                    imageContent.setExtension(extension);
                }
            } else {
                String extension = FileUtil.getExtFromFileName(imageName);
                if (extension != null) {
                    imageContent.setExtension(extension);
                    mimeType = FileUtil.getTypeFromExt(extension);
                    if (mimeType != null) {
                        imageContent.setMIMEType(mimeType);
                    }
                }
            }
            imageContent.setURI(imageName);
        }
    }

    protected void handleValueImage(String imgExpr, String fmtExpr, IImageContent imageContent) throws BirtException {
        byte[] imgData = null;
        String imgExt = null;
        String mimeType = null;
        imageContent.setImageSource(2);
        Object value = this.evaluate(imgExpr);
        if (value instanceof byte[]) {
            imgData = (byte[])value;
        }
        BirtException tempEx = null;
        if (fmtExpr != null) {
            try {
                Object strValue = this.evaluate(fmtExpr);
                if (strValue != null) {
                    mimeType = strValue.toString();
                    imgExt = FileUtil.getExtFromType(mimeType);
                }
            }
            catch (BirtException ex) {
                tempEx = ex;
            }
        }
        if (imgData != null) {
            imageContent.setData(imgData);
            imageContent.setExtension(imgExt);
            imageContent.setURI(null);
            imageContent.setMIMEType(mimeType);
        }
        if (tempEx != null) {
            throw tempEx;
        }
    }

    protected void handleFileExpressionImage(String fileExpr, IImageContent imageContent) throws BirtException {
        String imageFile = "";
        try {
            Object file = this.evaluate(fileExpr);
            if (file != null) {
                imageFile = file.toString();
            } else if (fileExpr != null && fileExpr.length() > 0) {
                imageFile = fileExpr;
            }
            this.handleFileImage(imageFile, imageContent);
        }
        catch (BirtException ex) {
            if (fileExpr != null && fileExpr.length() > 0) {
                this.handleFileImage(fileExpr, imageContent);
            }
            throw ex;
        }
    }

    protected void handleFileImage(String imageFile, IImageContent imageContent) {
        imageContent.setURI(imageFile);
        imageContent.setImageSource(0);
        String imgExt = FileUtil.getExtFromFileName(imageFile);
        if (imgExt != null) {
            imageContent.setExtension(imgExt);
            String mimeType = FileUtil.getTypeFromExt(imgExt);
            if (mimeType != null) {
                imageContent.setMIMEType(mimeType);
            }
        }
        if (imageFile == null) {
            this.getLogger().log(Level.SEVERE, "[ImageItemExecutor] Source image file is missing");
            this.context.addException(this.design.getHandle(), (BirtException)new EngineException("Error.MissingImageFileError"));
        }
    }
}

