/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.optimize;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.optimize.ExecutionPolicy;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.w3c.dom.css.CSSValue;

public class ExecutionOptimize {
    public ExecutionPolicy optimize(Report report) {
        return new OptimizeVisitor(report).optimize();
    }

    private static class OptimizeVisitor
    extends DefaultReportItemVisitorImpl {
        Report report;
        boolean suppressDuplicate;
        PolicyNode currentNode;
        PolicyNode parentNode;
        LinkedList rows = new LinkedList();

        OptimizeVisitor(Report report) {
            this.report = report;
        }

        ExecutionPolicy optimize() {
            ExecutionPolicy policies = new ExecutionPolicy();
            this.handleContent(policies);
            this.handleMasterPage(policies);
            return policies;
        }

        protected void handleContent(ExecutionPolicy policy) {
            PolicyNode root;
            this.parentNode = root = new PolicyNode();
            PolicyNode dummyFirst = new PolicyNode();
            dummyFirst.parent = root;
            dummyFirst.breakAfter = true;
            root.children.add(dummyFirst);
            this.currentNode = dummyFirst;
            int count = this.report.getContentCount();
            int i = 0;
            while (i < count) {
                ReportItemDesign design = this.report.getContent(i);
                design.accept(this, null);
                ++i;
            }
            PolicyNode dummyLast = new PolicyNode();
            dummyLast.parent = root;
            dummyLast.breakBefore = true;
            root.children.add(dummyLast);
            this.generateExecutionPolicy(policy, root);
        }

        protected void handleMasterPage(ExecutionPolicy policy) {
            PolicyNode root;
            this.parentNode = root = new PolicyNode();
            this.currentNode = root;
            PageSetupDesign pageSetup = this.report.getPageSetup();
            int count = pageSetup.getMasterPageCount();
            int i = 0;
            while (i < count) {
                MasterPageDesign masterPage = pageSetup.getMasterPage(i);
                if (masterPage instanceof SimpleMasterPageDesign) {
                    SimpleMasterPageDesign simple = (SimpleMasterPageDesign)masterPage;
                    ArrayList headerList = simple.getHeaders();
                    for (ReportItemDesign design : headerList) {
                        design.accept(this, null);
                    }
                    ArrayList footerList = simple.getFooters();
                    for (ReportItemDesign design : footerList) {
                        design.accept(this, null);
                    }
                }
                ++i;
            }
            this.generateMasterPageExecutionPolicy(policy, root);
        }

        protected void generateMasterPageExecutionPolicy(ExecutionPolicy policy, PolicyNode root) {
            PolicyNode child;
            ArrayList children = root.children;
            int i = 0;
            while (i < children.size()) {
                child = (PolicyNode)children.get(i);
                child.executeAll = true;
                ++i;
            }
            i = 0;
            while (i < children.size()) {
                child = (PolicyNode)children.get(i);
                this.analysisExecutionPolicy(policy, child);
                ++i;
            }
        }

        protected void generateExecutionPolicy(ExecutionPolicy policy, PolicyNode root) {
            PolicyNode child;
            ArrayList children = root.children;
            int i = 0;
            while (i < children.size()) {
                child = (PolicyNode)children.get(i);
                this.handlePageBreak(child);
                ++i;
            }
            i = 0;
            while (i < children.size()) {
                child = (PolicyNode)children.get(i);
                this.analysisExecutionPolicy(policy, child);
                ++i;
            }
            if (this.suppressDuplicate) {
                policy.enableSuppressDuplicate();
            }
        }

        protected boolean analysisExecutionPolicy(ExecutionPolicy policy, PolicyNode node) {
            int i = 0;
            while (i < node.children.size()) {
                PolicyNode child = (PolicyNode)node.children.get(i);
                if (node.executeAll) {
                    child.execute = true;
                    child.executeAll = true;
                }
                if (this.analysisExecutionPolicy(policy, child)) {
                    node.execute = true;
                }
                ++i;
            }
            if ((node.execute || node.executeAll) && node.design != null) {
                policy.setExecute(node.design);
            }
            return node.execute;
        }

        protected PolicyNode findLastLeafNode(PolicyNode root) {
            if (root != null && root.children.size() > 0) {
                return this.findLastLeafNode((PolicyNode)root.children.get(root.children.size() - 1));
            }
            return root;
        }

        protected PolicyNode findPreviousNode(PolicyNode node) {
            if (node == null || node.parent == null) {
                return null;
            }
            int index = node.parent.children.indexOf(node);
            if (index < 1) {
                return this.findPreviousNode(node.parent);
            }
            return (PolicyNode)node.parent.children.get(index - 1);
        }

        protected PolicyNode findNextNode(PolicyNode node) {
            int count;
            if (node == null || node.parent == null) {
                return null;
            }
            int index = node.parent.children.indexOf(node);
            if (index < (count = node.parent.children.size()) - 1) {
                return (PolicyNode)node.parent.children.get(index + 1);
            }
            return this.findPreviousNode(node.parent);
        }

        protected void handlePageBreak(PolicyNode node) {
            PolicyNode leaf;
            if (node.breakBefore) {
                node.execute = true;
                leaf = this.findLastLeafNode(this.findPreviousNode(node));
                if (leaf != null) {
                    leaf.execute = true;
                }
            }
            if (node.breakAfter) {
                PolicyNode next;
                node.execute = true;
                leaf = this.findLastLeafNode(node);
                if (leaf != null) {
                    leaf.execute = true;
                }
                if ((next = this.findNextNode(node)) != null) {
                    next.execute = true;
                }
            }
            int i = 0;
            while (i < node.children.size()) {
                PolicyNode child = (PolicyNode)node.children.get(i);
                this.handlePageBreak(child);
                ++i;
            }
        }

        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            PolicyNode parent = this.parentNode;
            this.visitReportItem(item, Boolean.TRUE);
            this.parentNode = this.currentNode;
            List children = item.getChildren();
            if (children != null) {
                for (ReportItemDesign child : children) {
                    child.accept(this, Boolean.TRUE);
                }
            }
            this.parentNode = parent;
            return Boolean.TRUE;
        }

        public Object visitTemplate(TemplateDesign template, Object value) {
            this.visitReportItem(template, Boolean.TRUE);
            return value;
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            PolicyNode parent = this.parentNode;
            this.visitReportItem(container, value);
            this.parentNode = this.currentNode;
            int count = container.getItemCount();
            int i = 0;
            while (i < count) {
                ReportItemDesign item = container.getItem(i);
                item.accept(this, null);
                ++i;
            }
            this.parentNode = parent;
            return Boolean.TRUE;
        }

        public Object visitListing(ListingDesign listing, Object value) {
            int groupCount;
            PolicyNode parent = this.parentNode;
            this.visitReportItem(listing, Boolean.TRUE);
            this.parentNode = this.currentNode;
            this.currentNode.breakAfter = true;
            BandDesign header = listing.getHeader();
            if (header != null) {
                header.accept(this, null);
            }
            if ((groupCount = listing.getGroupCount()) > 0) {
                this.processGroup(listing, 0, header != null);
                this.processGroup(listing, 0, false);
            } else {
                this.processDetail(listing, header != null);
                this.processDetail(listing, false);
            }
            BandDesign footer = listing.getFooter();
            if (footer != null) {
                footer.accept(this, Boolean.TRUE);
            }
            this.parentNode = parent;
            return Boolean.TRUE;
        }

        protected void processDetail(ListingDesign listing, boolean breakBefore) {
            BandDesign detail = listing.getDetail();
            if (detail != null) {
                PolicyNode parent = this.parentNode;
                this.visitReportItem(detail, Boolean.TRUE);
                this.parentNode = this.currentNode;
                if (listing.getPageBreakInterval() > 0) {
                    this.currentNode.breakAfter = true;
                }
                if (breakBefore) {
                    this.currentNode.breakBefore = true;
                }
                int count = detail.getContentCount();
                int i = 0;
                while (i < count) {
                    ReportItemDesign item = detail.getContent(i);
                    item.accept(this, Boolean.TRUE);
                    ++i;
                }
                this.parentNode = parent;
            }
        }

        protected void processGroup(ListingDesign listing, int groupLevel, boolean breakBefore) {
            BandDesign header;
            GroupDesign group = listing.getGroup(groupLevel);
            PolicyNode parent = this.parentNode;
            this.visitReportItem(group, Boolean.TRUE);
            this.parentNode = this.currentNode;
            if (group.getPageBreakAfter() != null) {
                this.currentNode.breakAfter = true;
            }
            if (breakBefore || group.getPageBreakBefore() != null) {
                this.currentNode.breakBefore = true;
            }
            if ((header = group.getHeader()) != null) {
                header.accept(this, null);
            }
            if (++groupLevel < listing.getGroupCount()) {
                this.processGroup(listing, groupLevel, header != null);
                this.processGroup(listing, groupLevel, false);
            } else {
                this.processDetail(listing, true);
                this.processDetail(listing, false);
            }
            BandDesign footer = group.getFooter();
            if (footer != null) {
                footer.accept(this, Boolean.TRUE);
            }
            this.parentNode = parent;
        }

        public Object visitBand(BandDesign band, Object value) {
            PolicyNode parent = this.parentNode;
            this.visitReportItem(band, value);
            this.parentNode = this.currentNode;
            int count = band.getContentCount();
            int i = 0;
            while (i < count) {
                ReportItemDesign item = band.getContent(i);
                item.accept(this, null);
                ++i;
            }
            this.parentNode = parent;
            return Boolean.TRUE;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            PolicyNode parent = this.parentNode;
            this.visitReportItem(grid, value);
            this.parentNode = this.currentNode;
            this.currentNode.breakAfter = true;
            int count = grid.getRowCount();
            int i = 0;
            while (i < count) {
                RowDesign row = grid.getRow(i);
                row.accept(this, null);
                ++i;
            }
            this.parentNode = parent;
            return Boolean.TRUE;
        }

        public Object visitRow(RowDesign row, Object value) {
            PolicyNode parent = this.parentNode;
            this.visitReportItem(row, true);
            this.parentNode = this.currentNode;
            this.rows.addLast(this.currentNode);
            int cellCount = row.getCellCount();
            int i = 0;
            while (i < cellCount) {
                CellDesign cell = row.getCell(i);
                cell.accept(this, null);
                ++i;
            }
            this.parentNode = parent;
            this.rows.removeLast();
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            PolicyNode parent = this.parentNode;
            this.visitReportItem(cell, value);
            this.parentNode = this.currentNode;
            String drop = cell.getDrop();
            if (cell.getRowSpan() != 1 || cell.getColSpan() != 1 || drop != null && !"none".equals(drop)) {
                this.currentNode.execute = true;
            }
            int count = cell.getContentCount();
            int i = 0;
            while (i < count) {
                ReportItemDesign item = cell.getContent(i);
                item.accept(this, null);
                ++i;
            }
            this.parentNode = parent;
            return value;
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            this.visitReportItem(image, Boolean.TRUE);
            return value;
        }

        public Object visitDynamicTextItem(DynamicTextItemDesign multiLine, Object value) {
            this.visitReportItem(multiLine, Boolean.TRUE);
            return value;
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            this.visitReportItem(text, Boolean.TRUE);
            return value;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            this.visitReportItem(data, value);
            if (data.getSuppressDuplicate()) {
                this.suppressDuplicate = true;
            }
            return value;
        }

        public Object visitReportItem(ReportItemDesign item, Object value) {
            boolean needExecute;
            PolicyNode node = new PolicyNode();
            node.parent = this.parentNode;
            node.design = item;
            boolean bl = needExecute = value == Boolean.TRUE;
            if (needExecute) {
                node.execute = true;
            }
            this.setupPageBreak(node);
            this.parentNode.children.add(node);
            this.currentNode = node;
            return needExecute;
        }

        protected void setupPageBreak(PolicyNode node) {
            ReportItemDesign item = node.design;
            String styleClass = item.getStyleName();
            if (styleClass != null) {
                IStyle style = this.report.findStyle(styleClass);
                CSSValue masterPage = style.getProperty(5);
                CSSValue pageBreakBefore = style.getProperty(58);
                CSSValue pageBreakAfter = style.getProperty(56);
                if (masterPage != null || pageBreakBefore != null && !pageBreakBefore.equals(IStyle.AUTO_VALUE)) {
                    node.breakBefore = true;
                    node.execute = true;
                }
                if (pageBreakAfter != null && !pageBreakAfter.equals(IStyle.AUTO_VALUE)) {
                    node.breakAfter = true;
                    node.execute = true;
                }
            }
            if (item.getJavaClass() != null || item.getOnCreate() != null || item.getOnPageBreak() != null) {
                node.breakBefore = true;
                node.breakAfter = true;
                node.execute = true;
            }
            if (node.breakBefore || node.breakAfter) {
                for (PolicyNode row : this.rows) {
                    row.executeAll = true;
                }
                return;
            }
            if (item.getHighlight() != null || item.getMap() != null) {
                node.execute = true;
            }
            if (item.getTOC() != null || item.getBookmark() != null || item.getAction() != null) {
                node.execute = true;
            }
            if (item.getQueries() != null) {
                node.execute = true;
            }
            if (item.getVisibility() != null) {
                node.execute = true;
            }
        }
    }

    private static class PolicyNode {
        PolicyNode parent;
        ArrayList children = new ArrayList();
        ReportItemDesign design;
        boolean execute;
        boolean breakBefore;
        boolean breakAfter;
        boolean executeAll;

        private PolicyNode() {
        }
    }
}

