/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.v1.PageHintReaderV1;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.internal.document.v3.PageHintReaderV3;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class PageHintReader
implements IPageHintReader {
    IPageHintReader reader;

    public PageHintReader(IReportDocument document) throws IOException {
        String version = document.getProperty("page hint version");
        this.reader = "1".equals(version) ? new PageHintReaderV1(document) : ("2".equals(version) ? new PageHintReaderV2(document.getArchive()) : new PageHintReaderV3(document.getArchive()));
    }

    public int getVersion() {
        return this.reader.getVersion();
    }

    public void close() {
        this.reader.close();
    }

    public long getTotalPage() throws IOException {
        return this.reader.getTotalPage();
    }

    public IPageHint getPageHint(long pageNumber) throws IOException {
        return this.reader.getPageHint(pageNumber);
    }

    public long getPageOffset(long pageNumber, String masterPage) throws IOException {
        return this.reader.getPageOffset(pageNumber, masterPage);
    }
}

