/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.PageBufferFactory;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLLayoutContext {
    protected String masterPage = null;
    protected boolean allowPageBreak = true;
    protected boolean finished;
    protected long pageNumber = 1L;
    protected long pageCount = 1L;
    protected HTMLReportLayoutEngine engine;
    protected HashMap layoutHint = new HashMap();
    protected ArrayList pageHints = new ArrayList();
    protected IPageBuffer bufferMgr;
    protected boolean needLayoutPageContent = true;
    protected String newMasterPage = null;
    protected PageBufferFactory bufferFactory = new PageBufferFactory(this);
    protected boolean emptyPage = false;
    protected boolean outputDisplayNone = false;
    boolean cancelFlag = false;
    protected HashMap<String, UnresolvedRowHint> currentHints = new HashMap();
    protected HashMap<String, UnresolvedRowHint> hints = new HashMap();
    ArrayList pageRowHints = new ArrayList();
    protected ArrayList columnHints = new ArrayList();

    public PageBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public void setNextMasterPage(String newMasterPage) {
        this.newMasterPage = newMasterPage;
    }

    public void initilizePage() {
        if (this.newMasterPage != null) {
            this.masterPage = this.newMasterPage;
            this.newMasterPage = null;
        }
    }

    public void setLayoutPageContent(boolean needLayoutPageContent) {
        this.needLayoutPageContent = needLayoutPageContent;
    }

    public boolean needLayoutPageContent() {
        return this.needLayoutPageContent;
    }

    public HTMLReportLayoutEngine getLayoutEngine() {
        return this.engine;
    }

    public void setPageBufferManager(IPageBuffer bufferMgr) {
        this.bufferMgr = bufferMgr;
    }

    public IPageBuffer getPageBufferManager() {
        return this.bufferMgr;
    }

    public void setPageHint(List hints) {
        this.pageHints.addAll(hints);
    }

    public ArrayList getPageHint() {
        ArrayList hints = new ArrayList();
        hints.addAll(this.pageHints);
        return hints;
    }

    public void reset() {
        this.layoutHint = new HashMap();
        this.finished = false;
        this.allowPageBreak = true;
        this.masterPage = null;
    }

    public void addLayoutHint(IContent content, boolean finished) {
        this.layoutHint.put(content, new Boolean(finished));
    }

    public void removeLayoutHint(IContent content) {
        this.layoutHint.remove(content);
    }

    public boolean getLayoutHint(IContent content) {
        Object finished = this.layoutHint.get(content);
        if (finished != null && finished instanceof Boolean) {
            return (Boolean)finished;
        }
        return true;
    }

    public void removeLayoutHint() {
        this.layoutHint.clear();
    }

    public String getMasterPage() {
        return this.masterPage;
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    public HTMLLayoutContext(HTMLReportLayoutEngine engine) {
        this.engine = engine;
    }

    public boolean allowPageBreak() {
        return this.allowPageBreak;
    }

    public void setAllowPageBreak(boolean allowPageBreak) {
        this.allowPageBreak = allowPageBreak;
    }

    public void setFinish(boolean finished) {
        this.finished = finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    void setCancelFlag(boolean flag) {
        this.cancelFlag = flag;
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    public void generatePageRowHints(Collection<String> keys) {
        this.pageRowHints.clear();
        for (String key : keys) {
            UnresolvedRowHint hint = this.hints.get(key);
            if (hint == null) continue;
            this.pageRowHints.add(hint);
        }
    }

    public List<UnresolvedRowHint> getUnresolvedRowHints() {
        return this.pageRowHints;
    }

    public List getTableColumnHints() {
        return this.columnHints;
    }

    public void addTableColumnHints(List hints) {
        this.columnHints.addAll(hints);
    }

    public void addTableColumnHint(TableColumnHint hint) {
        this.columnHints.add(hint);
    }

    public UnresolvedRowHint getUnresolvedRowHint(String key) {
        if (this.hints.size() > 0) {
            return this.hints.get(key);
        }
        return null;
    }

    public void addUnresolvedRowHint(String key, UnresolvedRowHint hint) {
        this.currentHints.put(key, hint);
    }

    public void clearPageHint() {
        this.columnHints.clear();
        this.pageHints.clear();
    }

    public void resetRowHint() {
        if (!this.emptyPage) {
            this.hints.clear();
            this.hints.putAll(this.currentHints);
            this.currentHints.clear();
        }
    }

    public void setEmptyPage(boolean emptyPage) {
        this.emptyPage = emptyPage;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setLayoutPageHint(IPageHint pageHint) {
        if (pageHint != null) {
            this.pageNumber = pageHint.getPageNumber();
            this.masterPage = pageHint.getMasterPage();
            int count = pageHint.getTableColumnHintCount();
            int i = 0;
            while (i < count) {
                this.columnHints.add(pageHint.getTableColumnHint(i));
                ++i;
            }
            count = pageHint.getUnresolvedRowCount();
            if (count > 0) {
                i = 0;
                while (i < count) {
                    UnresolvedRowHint hint = pageHint.getUnresolvedRowHint(i);
                    String key = this.getHintMapKey(hint.getTableId());
                    this.hints.put(key, hint);
                    ++i;
                }
            }
        }
    }

    public String getHintMapKey(String tableId) {
        String key = tableId;
        List hints = this.getTableColumnHint(key);
        for (int[] vs : hints) {
            key = String.valueOf(key) + "-" + vs[0] + "-" + vs[1];
        }
        return key;
    }

    public List getTableColumnHint(String tableId) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        if (this.columnHints.size() > 0) {
            for (TableColumnHint hint : this.columnHints) {
                if (!tableId.equals(hint.getTableId())) continue;
                list.add(new int[]{hint.getStart(), hint.getStart() + hint.getColumnCount()});
            }
        }
        return list;
    }

    public void setOutputDisplayNone(boolean outputDisplayNone) {
        this.outputDisplayNone = outputDisplayNone;
    }

    public boolean getOutputDisplayNone() {
        return this.outputDisplayNone;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }
}

