/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import com.lowagie.text.Image;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ObjectContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockTextLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ConcreteImageLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.util.FlashFile;

public class ImageLayout
extends Layout {
    public static final int TYPE_IMAGE_OBJECT = 0;
    public static final int TYPE_FLASH_OBJECT = 1;
    private Layout layout = null;
    private ContainerLayout parentLayout = null;
    private int objectType = 0;
    private boolean withFlashVars = false;
    private static final HashMap<Integer, ArrayList<String>> unsupportedFormats = new HashMap();

    static {
        ArrayList<String> flashUnsupportedFormatList = new ArrayList<String>();
        flashUnsupportedFormatList.add("postscript");
        flashUnsupportedFormatList.add("ppt");
        unsupportedFormats.put(1, flashUnsupportedFormatList);
    }

    public ImageLayout(LayoutEngineContext context, ContainerLayout parentContext, IContent content) {
        super(context, parentContext, content);
        this.parentLayout = parentContext;
    }

    public void layout() {
        if (this.layout != null) {
            this.layout.layout();
        }
    }

    protected void closeLayout() {
        if (this.layout != null) {
            this.layout.closeLayout();
        }
    }

    protected void initialize() {
        this.checkObjectType();
        IImageContent imageContent = (IImageContent)this.content;
        Image imageObject = null;
        boolean isFlash = FlashFile.isFlash(imageContent.getMIMEType(), imageContent.getURI(), imageContent.getExtension());
        if (!isFlash) {
            imageObject = EmitterUtil.getImage(imageContent);
        }
        if (this.isOutputSupported(this.objectType) && (isFlash || imageObject != null)) {
            this.layout = new ConcreteImageLayout(this.context, this.parentLayout, this.content, imageObject);
        } else {
            IReportContent report = this.context.getReport();
            if (report == null) {
                return;
            }
            ITextContent altTextContent = report.createTextContent(imageContent);
            altTextContent.setText(imageContent.getAltText());
            this.layout = new BlockTextLayout(this.context, this.parentLayout, altTextContent);
            this.layout.initialize();
        }
    }

    protected void checkObjectType() {
        String extension;
        IImageContent image = (IImageContent)this.content;
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        if (FlashFile.isFlash(mimeType, uri, extension = image.getExtension())) {
            this.objectType = 1;
            ObjectContent flash = (ObjectContent)image;
            if (flash.getParamValueByName("flashvars") != null) {
                this.withFlashVars = true;
            }
        } else {
            this.objectType = 0;
        }
    }

    private boolean isOutputSupported(int type) {
        if (this.withFlashVars) {
            return false;
        }
        ArrayList<String> formats = unsupportedFormats.get(type);
        return formats == null || !formats.contains(this.context.getFormat().toLowerCase());
    }
}

