/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockTextLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.CellLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.IInlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ImageLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineBlockLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineTextLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LineLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ListGroupLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ListLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PageLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RowLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableBandLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableGroupLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TemplateLayout;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class LayoutContextFactory {
    private ContentVisitor visitor = new ContentVisitor();
    ContainerLayout layoutContext = null;
    ContainerLayout parent = null;
    private LayoutEngineContext context = null;
    protected IReportExecutor executor;

    public LayoutContextFactory(IReportExecutor executor, LayoutEngineContext context) {
        this.context = context;
        this.executor = executor;
    }

    public Layout createLayoutManager(ContainerLayout parent, IContent content) {
        this.parent = parent;
        if (content == null) {
            return new LineLayout(this.context, parent);
        }
        return (Layout)content.accept(this.visitor, null);
    }

    private class ContentVisitor
    implements IContentVisitor {
        private ContentVisitor() {
        }

        public Object visit(IContent content, Object value) {
            return this.visitContent(content, value);
        }

        public Object visitContent(IContent content, Object value) {
            boolean isInline = PropertyUtil.isInlineElement(content);
            if (isInline) {
                return new InlineBlockLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, content);
            }
            return new BlockStackingLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, content);
        }

        public Object visitPage(IPageContent page, Object value) {
            return new PageLayout(LayoutContextFactory.this.executor, LayoutContextFactory.this.context, LayoutContextFactory.this.parent, page);
        }

        public Object visitContainer(IContainerContent container, Object value) {
            boolean isInline = PropertyUtil.isInlineElement(container);
            if (isInline) {
                return new InlineContainerLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, container);
            }
            return new BlockStackingLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, container);
        }

        public Object visitTable(ITableContent table, Object value) {
            return new TableLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, table);
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            return new TableBandLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, tableBand);
        }

        public Object visitRow(IRowContent row, Object value) {
            return new RowLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, row);
        }

        public Object visitCell(ICellContent cell, Object value) {
            return new CellLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, cell);
        }

        public Object visitText(ITextContent text, Object value) {
            return this.handleText(text);
        }

        public Object visitLabel(ILabelContent label, Object value) {
            return this.handleText(label);
        }

        public Object visitData(IDataContent data, Object value) {
            return this.handleText(data);
        }

        public Object visitImage(IImageContent image, Object value) {
            return new ImageLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, image);
        }

        public Object visitForeign(IForeignContent foreign, Object value) {
            boolean isInline = PropertyUtil.isInlineElement(foreign);
            if (isInline) {
                return new InlineContainerLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, foreign);
            }
            return new BlockStackingLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, foreign);
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            int type = autoText.getType();
            if (type == 0 || type == 2) {
                LayoutContextFactory.this.context.addUnresolvedContent(autoText);
                return new TemplateLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, autoText);
            }
            return this.handleText(autoText);
        }

        private Object handleText(ITextContent content) {
            boolean isInline = LayoutContextFactory.this.parent instanceof IInlineStackingLayout;
            if (isInline) {
                return new InlineTextLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, content);
            }
            String text = content.getText();
            if (text == null || "".equals(text)) {
                content.setText(" ");
            }
            return new BlockTextLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, content);
        }

        public Object visitList(IListContent list, Object value) {
            return new ListLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, list);
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            assert (false);
            return null;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            return new ListGroupLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, group);
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            return new TableGroupLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, group);
        }

        public Object visitGroup(IGroupContent group, Object value) {
            return new BlockStackingLayout(LayoutContextFactory.this.context, LayoutContextFactory.this.parent, group);
        }
    }
}

