/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutContextFactory;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RepeatableLayout;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;

public class PDFLayoutEmitter
extends LayoutEmitterAdapter
implements IContentEmitter {
    IContentEmitter emitter;
    Stack layoutStack = new Stack();
    ContainerLayout current;
    LayoutContextFactory factory;
    LayoutEngineContext context;
    Map options;
    protected boolean isFirst = true;

    public PDFLayoutEmitter(IReportExecutor executor, IContentEmitter emitter, LayoutEngineContext context) {
        this.emitter = emitter;
        this.context = context;
        this.factory = new LayoutContextFactory(executor, context);
    }

    public PDFLayoutEmitter(LayoutEngineContext context) {
        this.context = context;
        this.factory = new LayoutContextFactory(null, context);
    }

    public void initialize(IEmitterServices service) {
        this.emitter.initialize(service);
    }

    public String getOutputFormat() {
        return this.emitter.getOutputFormat();
    }

    public void start(IReportContent report) {
        this.emitter.start(report);
        this.context.setReport(report);
    }

    public void end(IReportContent report) {
        this.resolveTotalPage(this.emitter);
        this.emitter.end(report);
    }

    protected void resolveTotalPage(IContentEmitter emitter) {
        IContent con = this.context.getUnresolvedContent();
        if (!(con instanceof IAutoTextContent)) {
            return;
        }
        IAutoTextContent totalPageContent = (IAutoTextContent)con;
        if (totalPageContent != null) {
            int spacing;
            String align;
            boolean isRightAligned;
            NumberFormatter nf = new NumberFormatter();
            String patternStr = totalPageContent.getComputedStyle().getNumberFormat();
            nf.applyPattern(patternStr);
            long totalPageCount = 0L;
            totalPageCount = this.context.autoPageBreak ? this.context.pageCount : (this.context.totalPage > 0L ? this.context.totalPage : this.context.pageCount);
            totalPageContent.setText(nf.format(totalPageCount));
            AbstractArea totalPageArea = null;
            ChunkGenerator cg = new ChunkGenerator(this.context.getFontManager(), totalPageContent, true, true);
            if (cg.hasMore()) {
                Chunk c = cg.getNext();
                Dimension d = new Dimension((int)(c.getFontInfo().getWordWidth(c.getText()) * 1000.0f), (int)(c.getFontInfo().getWordHeight() * 1000.0f));
                totalPageArea = (AbstractArea)AreaFactory.createTextArea((ITextContent)totalPageContent, c.getFontInfo(), false);
                totalPageArea.setWidth(Math.min(this.context.getMaxWidth(), d.getWidth()));
                totalPageArea.setHeight(Math.min(this.context.getMaxHeight(), d.getHeight()));
            }
            if (((isRightAligned = BidiAlignmentResolver.isRightAligned((IContent)totalPageContent, align = totalPageContent.getComputedStyle().getTextAlign(), false)) || "center".equalsIgnoreCase(align)) && (spacing = this.context.getTotalPageTemplateWidth() - totalPageArea.getWidth()) > 0) {
                if (isRightAligned) {
                    totalPageArea.setAllocatedPosition(spacing + totalPageArea.getAllocatedX(), totalPageArea.getAllocatedY());
                } else if ("center".equalsIgnoreCase(align)) {
                    totalPageArea.setAllocatedPosition(spacing / 2 + totalPageArea.getAllocatedX(), totalPageArea.getAllocatedY());
                }
            }
            totalPageContent.setExtension(1, totalPageArea);
            emitter.startAutoText(totalPageContent);
        }
    }

    public void startContainer(IContainerContent container) {
        this._startContainer(container);
    }

    public void _startContainer(IContent container) {
        Layout layout;
        boolean isInline = PropertyUtil.isInlineElement(container);
        if (isInline) {
            if (!(this.current instanceof InlineStackingLayout)) {
                Layout lineLayout = this.factory.createLayoutManager(this.current, null);
                lineLayout.initialize();
                this.current = (ContainerLayout)lineLayout;
            }
        } else if (this.current instanceof InlineStackingLayout) {
            while (this.current instanceof InlineStackingLayout) {
                this.current.closeLayout();
                this.current = this.current.getParent();
            }
        }
        if ((layout = this.factory.createLayoutManager(this.current, container)) != null) {
            this.current = (ContainerLayout)layout;
            layout.initialize();
        }
    }

    public void endContainer(IContainerContent container) {
        this._endContainer(container);
    }

    private void _endContainer(IContent container) {
        boolean isInline = PropertyUtil.isInlineElement(container);
        if (isInline) {
            boolean cfr_ignored_0 = this.current instanceof InlineStackingLayout;
        } else if (this.current instanceof InlineStackingLayout) {
            while (this.current instanceof InlineStackingLayout) {
                this.current.closeLayout();
                this.current = this.current.getParent();
            }
        }
        this.current.closeLayout();
        this.current = this.current.getParent();
    }

    public void startContent(IContent content) {
        Layout layout;
        boolean isInline = PropertyUtil.isInlineElement(content);
        if (isInline) {
            if (!(this.current instanceof InlineStackingLayout)) {
                ContainerLayout lineLayout = (ContainerLayout)this.factory.createLayoutManager(this.current, null);
                lineLayout.initialize();
                this.current = lineLayout;
            }
        } else if (this.current instanceof InlineStackingLayout) {
            while (this.current instanceof InlineStackingLayout) {
                this.current.closeLayout();
                this.current = this.current.getParent();
            }
        }
        if ((layout = this.factory.createLayoutManager(this.current, content)) != null) {
            layout.initialize();
            layout.layout();
            layout.closeLayout();
        }
    }

    public void endContent(IContent content) {
    }

    public void startListBand(IListBandContent listBand) {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = listBand.getBandType();
        }
    }

    public void startListGroup(IListGroupContent listGroup) {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = 0;
        }
        super.startListGroup(listGroup);
    }

    public void endListBand(IListBandContent listBand) {
    }

    public void startPage(IPageContent page) {
        long number;
        super.startPage(page);
        if (!this.context.autoPageBreak && (number = page.getPageNumber()) > 0L) {
            this.context.pageNumber = number;
        }
    }

    boolean showPageFooter(SimpleMasterPageDesign masterPage, IPageContent page) {
        boolean showFooter = true;
        if (!masterPage.isShowFooterOnLast() && page.getPageNumber() == this.context.totalPage) {
            showFooter = false;
        }
        return showFooter;
    }

    public void outputPage(IPageContent page) {
        Object obj;
        MasterPageDesign mp = (MasterPageDesign)page.getGenerateBy();
        if (mp instanceof SimpleMasterPageDesign && (obj = page.getExtension(1)) != null && obj instanceof PageArea) {
            PageArea pageArea = (PageArea)obj;
            if (this.isFirst && !((SimpleMasterPageDesign)mp).isShowHeaderOnFirst()) {
                pageArea.removeHeader();
                this.isFirst = false;
            }
            if (!this.showPageFooter((SimpleMasterPageDesign)mp, page)) {
                pageArea.removeFooter();
            }
            if (((SimpleMasterPageDesign)mp).isFloatingFooter()) {
                ContainerArea footer = (ContainerArea)((Object)page.getFooter());
                IContainerArea body = pageArea.getBody();
                IContainerArea header = pageArea.getHeader();
                if (footer != null) {
                    footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
                }
            }
        }
        this.emitter.startPage(page);
        this.emitter.endPage(page);
        ++this.context.pageCount;
    }

    public void endPage(IPageContent page) {
        super.endPage(page);
    }

    protected void startTableContainer(IContainerContent container) {
        ContainerLayout layout;
        this.current = layout = (ContainerLayout)this.factory.createLayoutManager(this.current, container);
        this.current.initialize();
    }

    protected void endTableContainer(IContainerContent container) {
        this.current.closeLayout();
        this.current = this.current.getParent();
    }

    public void startRow(IRowContent row) {
        this.startTableContainer(row);
    }

    public void endRow(IRowContent row) {
        this.endTableContainer(row);
    }

    public void startTableBand(ITableBandContent band) {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = band.getBandType();
        }
        this.startTableContainer(band);
    }

    public void startTableGroup(ITableGroupContent group) {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = 0;
        }
        this.startTableContainer(group);
    }

    public void endTableBand(ITableBandContent band) {
        this.endTableContainer(band);
    }

    public void endTableGroup(ITableGroupContent group) {
        this.endTableContainer(group);
    }

    public void startCell(ICellContent cell) {
        this.startTableContainer(cell);
    }

    public void endCell(ICellContent cell) {
        this.endContainer(cell);
    }

    protected void visitContent(IContent content, IContentEmitter emitter) {
        ContentEmitterUtil.startContent(content, emitter);
        Collection children = content.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IContent child : children) {
                this.visitContent(child, emitter);
            }
        }
        ContentEmitterUtil.endContent(content, emitter);
    }

    public void startForeign(IForeignContent foreign) {
        if ("text/html".equals(foreign.getRawType())) {
            this._startContainer(foreign);
            HTML2Content.html2Content(foreign);
            Collection children = foreign.getChildren();
            if (children != null && !children.isEmpty()) {
                Iterator iter = children.iterator();
                IContent child = (IContent)iter.next();
                this.visitContent(child, this);
            }
            foreign.getChildren().clear();
            this._endContainer(foreign);
        } else {
            this.startContent(foreign);
        }
    }
}

