/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.engine.parser.StylePropertyMapping;
import org.eclipse.birt.report.engine.parser.TableItemDesignLayout;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.StyleRuleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.core.runtime.Assert;

public class EngineIRVisitor
extends DesignVisitor {
    static final String PREFIX_STYLE_NAME = "style_";
    static final String DEFAULT_MASTERPAGE_NAME = "NewSimpleMasterPage";
    static final double DEFAULT_MASTERPAGE_TOP_MARGIN = 1.0;
    static final double DEFAULT_MASTERPAGE_LEFT_MARGIN = 1.25;
    static final double DEFAULT_MASTERPAGE_BOTTOM_MARGIN = 1.0;
    static final double DEFAULT_MASTERPAGE_RIGHT_MARGIN = 1.25;
    protected static Logger logger = Logger.getLogger(EngineIRVisitor.class.getName());
    protected Object currentElement;
    protected Report report;
    protected ReportDesignHandle handle;
    protected CSSEngine cssEngine;
    StyleDeclaration nonInheritableReportStyle;
    StyleDeclaration inheritableReportStyle;
    protected long currentElementId = -1L;
    long newCellId = -1L;

    public EngineIRVisitor(ReportDesignHandle handle) {
        this.handle = handle;
    }

    public Report translate() {
        this.report = new Report();
        this.cssEngine = this.report.getCSSEngine();
        this.report.setReportDesign(this.handle);
        this.apply((DesignElementHandle)this.handle);
        return this.report;
    }

    public ReportItemDesign translate(ReportElementHandle handle, Report report) {
        this.report = report;
        this.cssEngine = report.getCSSEngine();
        this.newCellId = handle.getID() * -100000000L;
        this.apply((DesignElementHandle)handle);
        assert (this.currentElement instanceof ReportItemDesign);
        return (ReportItemDesign)this.currentElement;
    }

    public void visitReportDesign(ReportDesignHandle handle) {
        this.setupNamedExpressions((DesignElementHandle)handle, this.report.getNamedExpressions());
        SharedStyleHandle defaultStyle = handle.findStyle("report");
        this.createReportDefaultStyles((StyleHandle)defaultStyle);
        PageSetupDesign pageSetup = new PageSetupDesign();
        SlotHandle pageSlot = handle.getMasterPages();
        int i = 0;
        while (i < pageSlot.getCount()) {
            this.apply(pageSlot.get(i));
            if (this.currentElement != null) {
                pageSetup.addMasterPage((MasterPageDesign)this.currentElement);
            }
            ++i;
        }
        if (pageSlot.getCount() < 1) {
            SimpleMasterPageDesign masterPage = new SimpleMasterPageDesign();
            masterPage.setID(this.generateUniqueID());
            masterPage.setName(DEFAULT_MASTERPAGE_NAME);
            masterPage.setPageType("us-letter");
            masterPage.setOrientation("auto");
            DimensionType top = new DimensionType(1.0, "in");
            DimensionType left = new DimensionType(1.25, "in");
            DimensionType bottom = new DimensionType(1.0, "in");
            DimensionType right = new DimensionType(1.25, "in");
            masterPage.setMargin(top, left, bottom, right);
            pageSetup.addMasterPage(masterPage);
        }
        this.report.setPageSetup(pageSetup);
        SlotHandle bodySlot = handle.getBody();
        int i2 = 0;
        while (i2 < bodySlot.getCount()) {
            this.apply(bodySlot.get(i2));
            if (this.currentElement != null) {
                this.report.addContent((ReportItemDesign)this.currentElement);
            }
            ++i2;
        }
    }

    private void setupNamedExpressions(DesignElementHandle handle, Map namedExpressions) {
        List userProperties = handle.getUserProperties();
        if (userProperties == null || namedExpressions == null) {
            return;
        }
        int i = 0;
        while (i < userProperties.size()) {
            String name;
            String exprString;
            UserPropertyDefn userDef = (UserPropertyDefn)userProperties.get(i);
            if (userDef.getTypeCode() == 7 && (exprString = handle.getStringProperty(name = userDef.getName())) != null && !exprString.trim().equals("")) {
                namedExpressions.put(name, exprString);
            }
            ++i;
        }
    }

    private void setupMasterPage(MasterPageDesign page, MasterPageHandle handle) {
        this.setupStyledElement(page, (ReportElementHandle)handle);
        page.setPageType(handle.getPageType());
        DimensionValue effectWidth = handle.getPageWidth();
        DimensionValue effectHeight = handle.getPageHeight();
        DimensionType width = null;
        DimensionType height = null;
        if (effectWidth != null) {
            width = new DimensionType(effectWidth.getMeasure(), effectWidth.getUnits());
        }
        if (effectHeight != null) {
            height = new DimensionType(effectHeight.getMeasure(), effectHeight.getUnits());
        }
        page.setPageSize(width, height);
        page.setOrientation(handle.getOrientation());
        DimensionType top = this.createDimension(handle.getTopMargin(), true);
        DimensionType left = this.createDimension(handle.getLeftMargin(), true);
        DimensionType bottom = this.createDimension(handle.getBottomMargin(), true);
        DimensionType right = this.createDimension(handle.getRightMargin(), true);
        page.setMargin(top, left, bottom, right);
    }

    protected void visitDesignElement(DesignElementHandle obj) {
        this.currentElement = null;
    }

    public void visitGraphicMasterPage(GraphicMasterPageHandle handle) {
        GraphicMasterPageDesign page = new GraphicMasterPageDesign();
        this.setupMasterPage(page, (MasterPageHandle)handle);
        page.setColumns(handle.getColumnCount());
        DimensionType spacing = this.createDimension(handle.getColumnSpacing(), true);
        page.setColumnSpacing(spacing);
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            if (this.currentElement != null) {
                page.addContent((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        this.setCurrentElement(page);
        Assert.isTrue((boolean)false, (String)"Graphic master page is not supported now!");
    }

    private void setCurrentElement(ReportElementDesign element) {
        this.currentElement = element;
        this.currentElementId = -1L;
    }

    public void visitSimpleMasterPage(SimpleMasterPageHandle handle) {
        SimpleMasterPageDesign page = new SimpleMasterPageDesign();
        this.setupMasterPage(page, (MasterPageHandle)handle);
        page.setHeaderHeight(this.createDimension(handle.getHeaderHeight(), true));
        page.setFooterHeight(this.createDimension(handle.getFooterHeight(), true));
        page.setShowFooterOnLast(handle.showFooterOnLast());
        page.setShowHeaderOnFirst(handle.showHeaderOnFirst());
        page.setFloatingFooter(handle.isFloatingFooter());
        SlotHandle headerSlot = handle.getPageHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            if (this.currentElement != null) {
                page.addHeader((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        SlotHandle footerSlot = handle.getPageFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            if (this.currentElement != null) {
                page.addFooter((ReportItemDesign)this.currentElement);
            }
            ++i2;
        }
        this.setCurrentElement(page);
    }

    public void visitList(ListHandle handle) {
        SlotHandle footerSlot;
        ListItemDesign listItem = new ListItemDesign();
        this.setupListingItem(listItem, (ListingHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            ListBandDesign header = this.createListBand(headerSlot);
            header.setBandType(1);
            listItem.setHeader(header);
            listItem.setRepeatHeader(handle.repeatHeader());
        }
        SlotHandle groupsSlot = handle.getGroups();
        int i = 0;
        while (i < groupsSlot.getCount()) {
            this.apply(groupsSlot.get(i));
            if (this.currentElement != null) {
                GroupDesign group = (GroupDesign)this.currentElement;
                group.setGroupLevel(i);
                listItem.addGroup(group);
            }
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            ListBandDesign detail = this.createListBand(detailSlot);
            detail.setBandType(0);
            listItem.setDetail(detail);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            ListBandDesign footer = this.createListBand(footerSlot);
            footer.setBandType(2);
            listItem.setFooter(footer);
        }
        this.setCurrentElement(listItem);
    }

    public void visitFreeForm(FreeFormHandle handle) {
        FreeFormItemDesign container = new FreeFormItemDesign();
        this.setupReportItem(container, (ReportItemHandle)handle);
        SlotHandle slot = handle.getReportItems();
        int i = 0;
        while (i < slot.getCount()) {
            this.apply(slot.get(i));
            if (this.currentElement != null) {
                container.addItem((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        this.setCurrentElement(container);
    }

    public void visitTextDataItem(TextDataHandle handle) {
        DynamicTextItemDesign dynamicTextItem = new DynamicTextItemDesign();
        this.setupReportItem(dynamicTextItem, (ReportItemHandle)handle);
        String valueExpr = handle.getValueExpr();
        String contentType = handle.getContentType();
        dynamicTextItem.setContent(this.createExpression(valueExpr));
        dynamicTextItem.setContentType(contentType);
        this.setupHighlight(dynamicTextItem, valueExpr);
        this.setMap(dynamicTextItem, valueExpr);
        this.setCurrentElement(dynamicTextItem);
    }

    public void visitLabel(LabelHandle handle) {
        LabelItemDesign labelItem = new LabelItemDesign();
        this.setupReportItem(labelItem, (ReportItemHandle)handle);
        String text = handle.getText();
        String textKey = handle.getTextKey();
        labelItem.setText(textKey, text);
        ActionHandle action = handle.getActionHandle();
        if (action != null) {
            labelItem.setAction(this.createAction(action));
        }
        labelItem.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        this.setCurrentElement(labelItem);
    }

    public void visitAutoText(AutoTextHandle handle) {
        AutoTextItemDesign autoTextItem = new AutoTextItemDesign();
        this.setupReportItem(autoTextItem, (ReportItemHandle)handle);
        autoTextItem.setType(handle.getAutoTextType());
        this.setCurrentElement(autoTextItem);
    }

    public void visitDataItem(DataItemHandle handle) {
        ActionHandle action;
        DataItemDesign data = new DataItemDesign();
        this.setupReportItem(data, (ReportItemHandle)handle);
        String expr = handle.getResultSetColumn();
        if (expr != null && expr.trim().length() > 0) {
            data.setBindingColumn(expr);
        }
        if ((action = handle.getActionHandle()) != null) {
            data.setAction(this.createAction(action));
        }
        data.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        this.setupHighlight(data, expr);
        this.setMap(data, expr);
        this.setCurrentElement(data);
    }

    public void visitGrid(GridHandle handle) {
        GridItemDesign grid = new GridItemDesign();
        this.setupReportItem(grid, (ReportItemHandle)handle);
        String summary = handle.getSummary();
        if (summary != null) {
            grid.setSummary(summary);
        }
        String caption = handle.getCaption();
        String captionKey = handle.getCaptionKey();
        if (caption != null || captionKey != null) {
            grid.setCaption(captionKey, caption);
        }
        SlotHandle columnSlot = handle.getColumns();
        int i = 0;
        while (i < columnSlot.getCount()) {
            ColumnHandle columnHandle = (ColumnHandle)columnSlot.get(i);
            this.apply((DesignElementHandle)columnHandle);
            if (this.currentElement != null) {
                ColumnDesign columnDesign = (ColumnDesign)this.currentElement;
                int j = 0;
                while (j < columnHandle.getRepeatCount()) {
                    grid.addColumn(columnDesign);
                    ++j;
                }
            }
            ++i;
        }
        SlotHandle rowSlot = handle.getRows();
        int i2 = 0;
        while (i2 < rowSlot.getCount()) {
            this.apply(rowSlot.get(i2));
            if (this.currentElement != null) {
                grid.addRow((RowDesign)this.currentElement);
            }
            ++i2;
        }
        this.newCellId = new TableItemDesignLayout().layout(grid, this.newCellId);
        this.applyColumnHighlight(grid);
        this.setCurrentElement(grid);
    }

    public void visitImage(ImageHandle handle) {
        ImageItemDesign image = new ImageItemDesign();
        this.setupReportItem(image, (ReportItemHandle)handle);
        ActionHandle action = handle.getActionHandle();
        if (action != null) {
            image.setAction(this.createAction(action));
        }
        image.setAltText(handle.getAltTextKey(), handle.getAltText());
        image.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        String imageSrc = handle.getSource();
        if ("url".equals(imageSrc)) {
            image.setImageUri(this.createExpression(handle.getURL()));
        } else if ("expr".equals(imageSrc)) {
            String valueExpr = handle.getValueExpression();
            String typeExpr = handle.getTypeExpression();
            String imageValue = this.createExpression(valueExpr);
            String imageType = this.createExpression(typeExpr);
            image.setImageExpression(imageValue, imageType);
        } else if ("embed".equals(imageSrc)) {
            image.setImageName(handle.getImageName());
        } else if ("file".equals(imageSrc)) {
            image.setImageFile(this.createExpression(handle.getFile()));
        } else assert (false);
        this.setCurrentElement(image);
    }

    public void visitTable(TableHandle handle) {
        SlotHandle footerSlot;
        TableItemDesign table = new TableItemDesign();
        table.setRepeatHeader(handle.repeatHeader());
        this.setupListingItem(table, (ListingHandle)handle);
        String summary = handle.getSummary();
        if (summary != null) {
            table.setSummary(summary);
        }
        String caption = handle.getCaption();
        String captionKey = handle.getCaptionKey();
        if (caption != null || captionKey != null) {
            table.setCaption(captionKey, caption);
        }
        SlotHandle columnSlot = handle.getColumns();
        int i = 0;
        while (i < columnSlot.getCount()) {
            ColumnHandle columnHandle = (ColumnHandle)columnSlot.get(i);
            this.apply((DesignElementHandle)columnHandle);
            if (this.currentElement != null) {
                ColumnDesign columnDesign = (ColumnDesign)this.currentElement;
                int j = 0;
                while (j < columnHandle.getRepeatCount()) {
                    table.addColumn(columnDesign);
                    ++j;
                }
            }
            ++i;
        }
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            TableBandDesign header = this.createTableBand(headerSlot);
            header.setBandType(1);
            table.setHeader(header);
        }
        SlotHandle groupSlot = handle.getGroups();
        int i2 = 0;
        while (i2 < groupSlot.getCount()) {
            this.apply(groupSlot.get(i2));
            if (this.currentElement != null) {
                TableGroupDesign group = (TableGroupDesign)this.currentElement;
                group.setGroupLevel(i2);
                table.addGroup(group);
            }
            ++i2;
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            TableBandDesign detail = this.createTableBand(detailSlot);
            detail.setBandType(0);
            table.setDetail(detail);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            TableBandDesign footer = this.createTableBand(footerSlot);
            footer.setBandType(2);
            table.setFooter(footer);
        }
        this.newCellId = new TableItemDesignLayout().layout(table, this.newCellId);
        int i3 = 0;
        while (i3 < table.getGroupCount()) {
            TableGroupDesign group = (TableGroupDesign)table.getGroup(i3);
            this.locateGroupIcon(group);
            ++i3;
        }
        this.applyColumnHighlight(table);
        TableBandDesign detail = (TableBandDesign)table.getDetail();
        if (detail != null) {
            int i4 = 0;
            while (i4 < detail.getRowCount()) {
                RowDesign row = detail.getRow(i4);
                int j = 0;
                while (j < row.getCellCount()) {
                    ReportItemDesign item;
                    int k;
                    CellDesign cell = row.getCell(j);
                    ColumnDesign column = table.getColumn(cell.getColumn());
                    if (column.getSuppressDuplicate()) {
                        k = 0;
                        while (k < cell.getContentCount()) {
                            item = cell.getContent(k);
                            if (item instanceof DataItemDesign) {
                                DataItemDesign dataItem = (DataItemDesign)item;
                                dataItem.setSuppressDuplicate(true);
                            }
                            ++k;
                        }
                    }
                    if (!column.hasDataItemsInDetail()) {
                        k = 0;
                        while (k < cell.getContentCount()) {
                            item = cell.getContent(k);
                            if (item instanceof DataItemDesign) {
                                column.setHasDataItemsInDetail(true);
                                break;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i4;
            }
        }
        this.setCurrentElement(table);
    }

    private void locateGroupIcon(TableGroupDesign group) {
        GroupHandle groupHandle = (GroupHandle)group.getHandle();
        TableHandle tableHandle = (TableHandle)groupHandle.getContainer();
        String keyExpression = groupHandle.getKeyExpr();
        if (keyExpression == null) {
            return;
        }
        keyExpression = keyExpression.trim();
        BandDesign groupHeader = group.getHeader();
        if (group.getHeader() == null) {
            return;
        }
        CellDesign firstStuffedCell = null;
        String columnBindingExpression = this.getColumnBinding(tableHandle, keyExpression);
        int i = 0;
        while (i < groupHeader.getContentCount()) {
            RowDesign row = (RowDesign)groupHeader.getContent(i);
            int j = 0;
            while (j < row.getCellCount()) {
                CellDesign cell = row.getCell(j);
                int k = 0;
                while (k < cell.getContentCount()) {
                    ReportItemDesign item = cell.getContent(k);
                    if (this.hasExpression(tableHandle, item, keyExpression, columnBindingExpression)) {
                        cell.setDisplayGroupIcon(true);
                        return;
                    }
                    ++k;
                }
                if (cell.getContentCount() > 0 && firstStuffedCell == null) {
                    firstStuffedCell = cell;
                }
                ++j;
            }
            ++i;
        }
        if (firstStuffedCell != null) {
            firstStuffedCell.setDisplayGroupIcon(true);
        } else {
            CellDesign cell;
            RowDesign row = (RowDesign)groupHeader.getContent(0);
            if (row != null && (cell = row.getCell(0)) != null) {
                cell.setDisplayGroupIcon(true);
            }
        }
    }

    private boolean hasExpression(TableHandle tableHandle, ReportItemDesign item, String keyExpression, String columnBindingExpression) {
        assert (keyExpression != null);
        if (item instanceof DataItemDesign) {
            DataItemDesign data = (DataItemDesign)item;
            String columnBinding = data.getBindingColumn();
            String value = ExpressionUtil.createJSRowExpression((String)columnBinding);
            if (value != null && keyExpression.equals(value.trim())) {
                return true;
            }
            columnBinding = this.getColumnBinding(tableHandle, value);
            if (columnBinding != null && columnBindingExpression != null && columnBindingExpression.equals(columnBinding)) {
                return true;
            }
        }
        if (item instanceof GridItemDesign) {
            GridItemDesign grid = (GridItemDesign)item;
            GridHandle gridHandle = (GridHandle)grid.getHandle();
            PropertyHandle columnBindings = gridHandle.getColumnBindings();
            if (columnBindings != null && columnBindings.iterator().hasNext()) {
                return false;
            }
            int i = 0;
            while (i < grid.getRowCount()) {
                RowDesign row = grid.getRow(i);
                int j = 0;
                while (j < row.getCellCount()) {
                    CellDesign cell = row.getCell(j);
                    int k = 0;
                    while (k < cell.getContentCount()) {
                        ReportItemDesign reportItem = cell.getContent(k);
                        if (this.hasExpression(tableHandle, reportItem, keyExpression, columnBindingExpression)) {
                            return true;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    private String getColumnBinding(TableHandle tableHandle, String keyExpression) {
        String columnBindingName = null;
        try {
            columnBindingName = ExpressionUtil.getColumnBindingName((String)keyExpression);
        }
        catch (BirtException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
        return this.getColumnBindingByName(tableHandle, columnBindingName);
    }

    private String getColumnBindingByName(TableHandle tableHandle, String columnBindingName) {
        if (columnBindingName == null) {
            return null;
        }
        Iterator iterator = tableHandle.columnBindingsIterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnBinding = (ComputedColumnHandle)iterator.next();
            if (!columnBindingName.equals(columnBinding.getName())) continue;
            return columnBinding.getExpression();
        }
        return null;
    }

    private void applyColumnHighlight(TableItemDesign table) {
        this.applyColumnHighlight(table, table.getHeader());
        this.applyColumnHighlight(table, table.getDetail());
        this.applyColumnHighlight(table, table.getFooter());
        int i = 0;
        while (i < table.getGroupCount()) {
            this.applyColumnHighlight(table, table.getGroup(i).getHeader());
            this.applyColumnHighlight(table, table.getGroup(i).getFooter());
            ++i;
        }
    }

    private void applyColumnHighlight(GridItemDesign grid) {
        int i = 0;
        while (i < grid.getRowCount()) {
            RowDesign row = grid.getRow(i);
            int j = 0;
            while (j < row.getCellCount()) {
                CellDesign cell = row.getCell(j);
                ColumnDesign column = grid.getColumn(cell.getColumn());
                this.applyColumnHighlight(column, cell);
                ++j;
            }
            ++i;
        }
    }

    private void applyColumnHighlight(TableItemDesign table, BandDesign band) {
        if (band == null) {
            return;
        }
        int i = 0;
        while (i < band.getContentCount()) {
            ReportItemDesign content = band.getContent(i);
            if (content instanceof RowDesign) {
                RowDesign row = (RowDesign)content;
                int j = 0;
                while (j < row.getCellCount()) {
                    CellDesign cell = row.getCell(j);
                    ColumnDesign column = table.getColumn(cell.getColumn());
                    this.applyColumnHighlight(column, cell);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void applyColumnHighlight(ColumnDesign column, CellDesign cell) {
        HighlightDesign columnHighlight = column.getHighlight();
        if (columnHighlight != null && columnHighlight.getRuleCount() > 0) {
            HighlightDesign cellHighlight = cell.getHighlight();
            if (cellHighlight == null) {
                cellHighlight = new HighlightDesign();
                cell.setHighlight(cellHighlight);
            }
            int i = 0;
            while (i < columnHighlight.getRuleCount()) {
                cellHighlight.addRule(new HighlightRuleDesign(columnHighlight.getRule(i)));
                ++i;
            }
        }
    }

    public void visitColumn(ColumnHandle handle) {
        ColumnDesign col = new ColumnDesign();
        this.setupReportElement(col, (DesignElementHandle)handle);
        StyleDeclaration style = this.createColumnStyle((ReportElementHandle)handle);
        if (style != null && !style.isEmpty()) {
            col.setStyleName(this.assignStyleName(style));
        }
        col.setColumnHeaderState(false);
        DimensionType width = this.createDimension(handle.getWidth(), false);
        col.setWidth(width);
        boolean supress = handle.suppressDuplicates();
        col.setSuppressDuplicate(supress);
        VisibilityDesign visibility = this.createVisibility(handle.visibilityRulesIterator());
        col.setVisibility(visibility);
        this.setCurrentElement(col);
    }

    public void visitRow(RowHandle handle) {
        String OnRenderScriptText;
        RowDesign row = new RowDesign();
        this.setupStyledElement(row, (ReportElementHandle)handle);
        DimensionType height = this.createDimension(handle.getHeight(), false);
        row.setHeight(height);
        String bookmark = handle.getBookmark();
        row.setBookmark(this.createExpression(bookmark));
        VisibilityDesign visibility = this.createVisibility(handle.visibilityRulesIterator());
        row.setVisibility(visibility);
        SlotHandle cellSlot = handle.getCells();
        int i = 0;
        while (i < cellSlot.getCount()) {
            this.apply(cellSlot.get(i));
            if (this.currentElement != null) {
                row.addCell((CellDesign)this.currentElement);
            }
            ++i;
        }
        String onCreate = handle.getOnCreate();
        String OnCreateScriptText = this.createExpression(onCreate);
        if (OnCreateScriptText != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            ScriptExpression scriptExpr = new ScriptExpression(OnCreateScriptText, id);
            row.setOnCreate(scriptExpr);
        }
        if ((OnRenderScriptText = handle.getOnRender()) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            ScriptExpression scriptExpr = new ScriptExpression(OnRenderScriptText, id);
            row.setOnRender(scriptExpr);
        }
        this.setupHighlight(row, null);
        this.setCurrentElement(row);
    }

    private boolean isContainer(ReportElementHandle handle) {
        if (handle instanceof TextItemHandle) {
            return false;
        }
        if (handle instanceof DataItemHandle) {
            return false;
        }
        if (handle instanceof LabelHandle) {
            return false;
        }
        if (handle instanceof TextDataHandle) {
            return false;
        }
        if (handle instanceof ExtendedItemHandle) {
            return false;
        }
        return !(handle instanceof ImageHandle);
    }

    protected void setupStyledElement(StyledElementDesign design, ReportElementHandle handle) {
        this.setupReportElement(design, (DesignElementHandle)handle);
        StyleDeclaration style = this.createPrivateStyle(handle, this.isContainer(handle));
        if (style != null && !style.isEmpty()) {
            design.setStyleName(this.assignStyleName(style));
        }
    }

    public void visitCell(CellHandle handle) {
        String OnRenderScriptText;
        String onCreate;
        String onCreateScriptText;
        CellDesign cell = new CellDesign();
        this.setupStyledElement(cell, (ReportElementHandle)handle);
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            if (this.currentElement != null) {
                cell.addContent((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        cell.setColSpan(handle.getColumnSpan());
        int columnId = handle.getColumn() - 1;
        if (columnId < 0) {
            columnId = -1;
        }
        cell.setColumn(columnId);
        cell.setRowSpan(handle.getRowSpan());
        if (this.isCellInGroupHeader(handle)) {
            cell.setDrop(handle.getDrop());
        }
        if ((onCreateScriptText = this.createExpression(onCreate = handle.getOnCreate())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            ScriptExpression scriptExpr = new ScriptExpression(onCreateScriptText, id);
            cell.setOnCreate(scriptExpr);
        }
        if ((OnRenderScriptText = handle.getOnRender()) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            ScriptExpression scriptExpr = new ScriptExpression(OnRenderScriptText, id);
            cell.setOnRender(scriptExpr);
        }
        this.setupHighlight(cell, null);
        this.setCurrentElement(cell);
    }

    private boolean isCellInGroupHeader(CellHandle cellHandle) {
        SlotHandle slot;
        DesignElementHandle groupHandle;
        DesignElementHandle rowHandle = cellHandle.getContainer();
        return rowHandle instanceof RowHandle && (groupHandle = rowHandle.getContainer()) instanceof TableGroupHandle && (slot = rowHandle.getContainerSlotHandle()) != null && slot.getSlotID() == 0;
    }

    private ListBandDesign createListBand(SlotHandle elements) {
        ListBandDesign band = new ListBandDesign();
        band.setID(this.generateUniqueID());
        this.setupElementIDMap(band);
        int i = 0;
        while (i < elements.getCount()) {
            this.apply(elements.get(i));
            if (this.currentElement != null) {
                band.addContent((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        return band;
    }

    public void visitListGroup(ListGroupHandle handle) {
        SlotHandle footerSlot;
        ListGroupDesign listGroup = new ListGroupDesign();
        this.setupGroup(listGroup, (GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            ListBandDesign header = this.createListBand(headerSlot);
            header.setBandType(3);
            header.setGroup(listGroup);
            listGroup.setHeader(header);
            listGroup.setHeaderRepeat(handle.repeatHeader());
            String toc = handle.getTocExpression();
            if (toc != null && !"".equals(toc.trim())) {
                listGroup.setTOC(this.createExpression(toc));
            }
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            ListBandDesign footer = this.createListBand(footerSlot);
            footer.setBandType(4);
            footer.setGroup(listGroup);
            listGroup.setFooter(footer);
        }
        boolean hideDetail = handle.hideDetail();
        listGroup.setHideDetail(hideDetail);
        this.setCurrentElement(listGroup);
    }

    public void visitTableGroup(TableGroupHandle handle) {
        SlotHandle footerSlot;
        TableGroupDesign tableGroup = new TableGroupDesign();
        this.setupGroup(tableGroup, (GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            TableBandDesign header = this.createTableBand(handle.getHeader());
            header.setBandType(3);
            header.setGroup(tableGroup);
            tableGroup.setHeader(header);
            tableGroup.setHeaderRepeat(handle.repeatHeader());
            String toc = handle.getTocExpression();
            if (toc != null && !"".equals(toc.trim())) {
                tableGroup.setTOC(this.createExpression(toc));
            }
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            TableBandDesign footer = this.createTableBand(handle.getFooter());
            footer.setBandType(4);
            footer.setGroup(tableGroup);
            tableGroup.setFooter(footer);
        }
        boolean hideDetail = handle.hideDetail();
        tableGroup.setHideDetail(hideDetail);
        this.setCurrentElement(tableGroup);
    }

    public void visitTextItem(TextItemHandle handle) {
        TextItemDesign textItem = new TextItemDesign();
        this.setupReportItem(textItem, (ReportItemHandle)handle);
        String contentType = handle.getContentType();
        if (contentType != null) {
            textItem.setTextType(contentType);
        }
        textItem.setText(handle.getContentKey(), handle.getContent());
        this.currentElement = textItem;
    }

    protected void visitExtendedItem(ExtendedItemHandle obj) {
        ExtendedItemDesign extendedItem = new ExtendedItemDesign();
        this.setupReportItem(extendedItem, (ReportItemHandle)obj);
        extendedItem.setAltText(obj.getAltTextKey(), obj.getAltText());
        this.handleExtendedItemChildren(extendedItem, obj);
        this.setCurrentElement(extendedItem);
    }

    private void handleExtendedItemChildren(ExtendedItemDesign extendedItem, ExtendedItemHandle extendedHandle) {
        if (extendedHandle == null) {
            return;
        }
        Iterator propIter = extendedHandle.getPropertyIterator();
        while (propIter.hasNext()) {
            PropertyHandle propHandle = (PropertyHandle)propIter.next();
            IElementPropertyDefn property = propHandle.getPropertyDefn();
            if (property.getTypeCode() != 23) continue;
            Object children = propHandle.getValue();
            if (children instanceof List) {
                List tempList = (List)children;
                int i = 0;
                while (tempList != null && i < tempList.size()) {
                    Object tempObj = tempList.get(i);
                    if (tempObj instanceof ReportItemHandle) {
                        this.apply((DesignElementHandle)((ReportItemHandle)tempObj));
                        extendedItem.getChildren().add(this.currentElement);
                    }
                    ++i;
                }
                continue;
            }
            if (!(children instanceof ReportItemHandle)) continue;
            this.apply((DesignElementHandle)((ReportItemHandle)children));
            extendedItem.getChildren().add(this.currentElement);
        }
    }

    public void visitTemplateReportItem(TemplateReportItemHandle obj) {
        TemplateDesign template = new TemplateDesign();
        this.setupTemplateReportElement(template, obj);
        template.setPromptText(obj.getDescription());
        template.setPromptTextKey(obj.getDescriptionKey());
        template.setAllowedType(obj.getAllowedType());
        this.setCurrentElement(template);
    }

    protected void setupGroup(GroupDesign group, GroupHandle handle) {
        ScriptExpression scriptExpr;
        String id;
        group.setID(handle.getID());
        this.setupElementIDMap(group);
        group.setName(handle.getName());
        String pageBreakBefore = handle.getStringProperty("pageBreakBefore");
        String pageBreakAfter = handle.getStringProperty("pageBreakAfter");
        String pageBreakInside = handle.getStringProperty("pageBreakInside");
        group.setPageBreakBefore(pageBreakBefore);
        group.setPageBreakAfter(pageBreakAfter);
        group.setPageBreakInside(pageBreakInside);
        TOCHandle tocHandle = handle.getTOC();
        if (tocHandle != null) {
            String toc = tocHandle.getExpression();
            group.setTOC(this.createExpression(toc));
        }
        String bookmark = handle.getBookmark();
        group.setBookmark(bookmark);
        String scriptText = handle.getOnCreate();
        if (scriptText != null) {
            id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            scriptExpr = new ScriptExpression(scriptText, id);
            group.setOnCreate(scriptExpr);
        }
        if ((scriptText = handle.getOnRender()) != null) {
            id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            scriptExpr = new ScriptExpression(scriptText, id);
            group.setOnRender(scriptExpr);
        }
        if ((scriptText = handle.getOnPageBreak()) != null) {
            id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageBreak"));
            scriptExpr = new ScriptExpression(scriptText, id);
            group.setOnPageBreak(scriptExpr);
        }
        group.setHandle((DesignElementHandle)handle);
        group.setJavaClass(handle.getEventHandlerClass());
    }

    private TableBandDesign createTableBand(SlotHandle elements) {
        TableBandDesign band = new TableBandDesign();
        band.setID(this.generateUniqueID());
        this.setupElementIDMap(band);
        int i = 0;
        while (i < elements.getCount()) {
            this.apply(elements.get(i));
            if (this.currentElement != null) {
                band.addRow((RowDesign)this.currentElement);
            }
            ++i;
        }
        return band;
    }

    protected VisibilityDesign createVisibility(Iterator visibilityRulesIterator) {
        if (visibilityRulesIterator != null && visibilityRulesIterator.hasNext()) {
            VisibilityDesign visibility = new VisibilityDesign();
            do {
                VisibilityRuleDesign hide = this.createHide((HideRuleHandle)visibilityRulesIterator.next());
                visibility.addRule(hide);
            } while (visibilityRulesIterator.hasNext());
            return visibility;
        }
        return null;
    }

    protected VisibilityRuleDesign createHide(HideRuleHandle handle) {
        VisibilityRuleDesign rule = new VisibilityRuleDesign();
        rule.setExpression(this.createExpression(handle.getExpression()));
        String format = handle.getFormat();
        if ("viewer".equalsIgnoreCase(format)) {
            format = "html";
        }
        rule.setFormat(format);
        return rule;
    }

    private void setupReportItem(ReportItemDesign item, ReportItemHandle handle) {
        String OnPageBreakScriptText;
        String OnRenderScriptText;
        this.setupStyledElement(item, (ReportElementHandle)handle);
        DimensionType height = this.createDimension(handle.getHeight(), false);
        DimensionType width = this.createDimension(handle.getWidth(), false);
        DimensionType x = this.createDimension(handle.getX(), false);
        DimensionType y = this.createDimension(handle.getY(), false);
        item.setHeight(height);
        item.setWidth(width);
        item.setX(x);
        item.setY(y);
        TOCHandle tocHandle = handle.getTOC();
        if (tocHandle != null) {
            String toc = tocHandle.getExpression();
            item.setTOC(this.createExpression(toc));
        }
        String bookmark = handle.getBookmark();
        item.setBookmark(this.createExpression(bookmark));
        String onCreate = handle.getOnCreate();
        String onCreateScriptText = this.createExpression(onCreate);
        if (onCreateScriptText != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            ScriptExpression scriptExpr = new ScriptExpression(onCreateScriptText, id);
            item.setOnCreate(scriptExpr);
        }
        if ((OnRenderScriptText = handle.getOnRender()) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            ScriptExpression scriptExpr = new ScriptExpression(OnRenderScriptText, id);
            item.setOnRender(scriptExpr);
        }
        if ((OnPageBreakScriptText = handle.getOnPageBreak()) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageBreak"));
            ScriptExpression scriptExpr = new ScriptExpression(OnPageBreakScriptText, id);
            item.setOnPageBreak(scriptExpr);
        }
        Iterator visibilityIter = handle.visibilityRulesIterator();
        VisibilityDesign visibility = this.createVisibility(visibilityIter);
        item.setVisibility(visibility);
        this.setupHighlight(item, null);
        if (handle.getDataBindingReference() != null) {
            item.setUseCachedResult(true);
        }
    }

    private void setupReportElement(ReportElementDesign element, DesignElementHandle handle) {
        element.setHandle(handle);
        element.setName(handle.getName());
        long id = this.currentElementId == -1L ? handle.getID() : this.currentElementId;
        element.setID(id);
        List list = handle.getUserProperties();
        if (list != null) {
            for (UserPropertyDefn propDefn : list) {
                String propName = propDefn.getName();
                PropertyHandle propHandle = handle.getPropertyHandle(propName);
                String propValue = propHandle.getStringValue();
                element.getCustomProperties().put(propName, propValue);
            }
        }
        this.setupNamedExpressions(handle, element.getNamedExpressions());
        this.setupElementIDMap(element);
        element.setJavaClass(handle.getEventHandlerClass());
    }

    private void setupTemplateReportElement(ReportItemDesign element, TemplateReportItemHandle handle) {
        this.setupReportElement(element, (DesignElementHandle)handle);
        Iterator visibilityIter = handle.visibilityRulesIterator();
        VisibilityDesign visibility = this.createVisibility(visibilityIter);
        element.setVisibility(visibility);
    }

    protected String createExpression(String expr) {
        if (expr != null && !expr.trim().equals("")) {
            return expr;
        }
        return null;
    }

    protected ActionDesign createAction(ActionHandle handle) {
        ActionDesign action = new ActionDesign();
        String linkType = handle.getLinkType();
        action.setTooltip(handle.getToolTip());
        if ("hyperlink".equals(linkType)) {
            action.setHyperlink(this.createExpression(handle.getURI()));
            action.setTargetWindow(handle.getTargetWindow());
        } else if ("bookmark-link".equals(linkType)) {
            action.setBookmark(this.createExpression(handle.getTargetBookmark()));
        } else if ("drill-through".equals(linkType)) {
            action.setTargetWindow(handle.getTargetWindow());
            action.setTargetFileType(handle.getTargetFileType());
            DrillThroughActionDesign drillThrough = new DrillThroughActionDesign();
            action.setDrillThrough(drillThrough);
            drillThrough.setReportName(handle.getReportName());
            drillThrough.setFormat(handle.getFormatType());
            drillThrough.setBookmark(this.createExpression(handle.getTargetBookmark()));
            drillThrough.setBookmarkType(!"toc".equals(handle.getTargetBookmarkType()));
            HashMap<String, String> params = new HashMap<String, String>();
            Iterator paramIte = handle.paramBindingsIterator();
            while (paramIte.hasNext()) {
                ParamBindingHandle member = (ParamBindingHandle)paramIte.next();
                params.put(member.getParamName(), this.createExpression(member.getExpression()));
            }
            drillThrough.setParameters(params);
        } else assert (false);
        return action;
    }

    protected HighlightRuleDesign createHighlightRule(HighlightRuleHandle ruleHandle, String defaultStr) {
        boolean isListStyle = ModuleUtil.isListStyleRuleValue((StyleRuleHandle)ruleHandle);
        HighlightRuleDesign rule = new HighlightRuleDesign();
        if (isListStyle) {
            rule.setExpression(ruleHandle.getOperator(), ruleHandle.getValue1List());
        } else {
            rule.setExpression(ruleHandle.getOperator(), ruleHandle.getValue1(), ruleHandle.getValue2());
        }
        String testExpr = ruleHandle.getTestExpression();
        if (testExpr != null && testExpr.length() > 0) {
            rule.setTestExpression(testExpr);
        } else if (defaultStr != null && defaultStr.length() > 0) {
            rule.setTestExpression(defaultStr);
        } else {
            return null;
        }
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        this.setupStyle((StructureHandle)ruleHandle, style);
        if (style.isEmpty()) {
            return null;
        }
        rule.setStyle(style);
        return rule;
    }

    protected void setupHighlight(StyledElementDesign item, String defaultStr) {
        StyleHandle handle = item.getHandle().getPrivateStyle();
        if (handle == null) {
            return;
        }
        Iterator iter = handle.highlightRulesIterator();
        if (iter == null) {
            return;
        }
        if (iter.hasNext()) {
            HighlightDesign highlight = new HighlightDesign();
            do {
                HighlightRuleHandle ruleHandle;
                HighlightRuleDesign rule;
                if ((rule = this.createHighlightRule(ruleHandle = (HighlightRuleHandle)iter.next(), defaultStr)) == null) continue;
                highlight.addRule(rule);
            } while (iter.hasNext());
            item.setHighlight(highlight);
        }
    }

    protected void setMap(StyledElementDesign item, String defaultStr) {
        StyleHandle handle = item.getHandle().getPrivateStyle();
        if (handle == null) {
            return;
        }
        Iterator iter = handle.mapRulesIterator();
        if (iter == null) {
            return;
        }
        MapDesign map = new MapDesign();
        while (iter.hasNext()) {
            MapRuleHandle ruleHandle = (MapRuleHandle)iter.next();
            MapRuleDesign rule = this.createMapRule(ruleHandle, defaultStr);
            if (rule == null) continue;
            map.addRule(rule);
        }
        if (map.getRuleCount() > 0) {
            item.setMap(map);
        }
    }

    protected MapRuleDesign createMapRule(MapRuleHandle handle, String defaultStr) {
        boolean isListStyle = ModuleUtil.isListStyleRuleValue((StyleRuleHandle)handle);
        MapRuleDesign rule = new MapRuleDesign();
        if (isListStyle) {
            rule.setExpression(handle.getOperator(), handle.getValue1List());
        } else {
            rule.setExpression(handle.getOperator(), handle.getValue1(), handle.getValue2());
        }
        String displayText = handle.getDisplay();
        rule.setDisplayText(handle.getDisplayKey(), displayText == null ? "" : displayText);
        String testExpr = handle.getTestExpression();
        if (testExpr != null && testExpr.length() > 0) {
            rule.setTestExpression(testExpr);
        } else if (defaultStr != null && defaultStr.length() > 0) {
            rule.setTestExpression(defaultStr);
        } else {
            return null;
        }
        return rule;
    }

    private String assignStyleName(StyleDeclaration style) {
        if (style == null || style.isEmpty()) {
            return null;
        }
        Map styles = this.report.getStyles();
        for (Map.Entry entry : styles.entrySet()) {
            StyleDeclaration cachedStyle = (StyleDeclaration)entry.getValue();
            if (!cachedStyle.equals(style)) continue;
            style = cachedStyle;
            return (String)entry.getKey();
        }
        String styleName = PREFIX_STYLE_NAME + styles.size();
        this.report.addStyle(styleName, style);
        return styleName;
    }

    protected String getElementProperty(ReportElementHandle handle, String name) {
        return this.getElementProperty(handle, name, false);
    }

    protected String getElementProperty(ReportElementHandle handle, String name, boolean isColorProperty) {
        FactoryPropertyHandle prop = handle.getFactoryPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            if (isColorProperty) {
                return prop.getColorValue();
            }
            return prop.getStringValue();
        }
        return null;
    }

    String getElementColorProperty(ReportElementHandle handle, String name) {
        FactoryPropertyHandle prop = handle.getFactoryPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            return prop.getColorValue();
        }
        return null;
    }

    protected StyleDeclaration createPrivateStyle(ReportElementHandle handle) {
        return this.createPrivateStyle(handle, true);
    }

    protected String decodePageBreak(String pageBreak) {
        if (pageBreak == null) {
            return null;
        }
        if ("always".equals(pageBreak)) {
            return "always";
        }
        if ("always-excluding-last".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        if ("always".equals(pageBreak)) {
            return "always";
        }
        if ("always-excluding-first".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        return "auto";
    }

    protected StyleDeclaration createColumnStyle(ReportElementHandle handle) {
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        String pageBreakAfter = this.getElementProperty(handle, "pageBreakAfter");
        style.setPageBreakAfter(this.decodePageBreak(pageBreakAfter));
        String pageBreakBefore = this.getElementProperty(handle, "pageBreakBefore");
        style.setPageBreakBefore(this.decodePageBreak(pageBreakBefore));
        return style;
    }

    protected StyleDeclaration createPrivateStyle(ReportElementHandle handle, boolean isContainer) {
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        style.setBackgroundColor(this.getElementProperty(handle, "backgroundColor", true));
        style.setBackgroundImage(this.getElementProperty(handle, "backgroundImage"));
        style.setBackgroundPositionX(this.getElementProperty(handle, "backgroundPositionX"));
        style.setBackgroundPositionY(this.getElementProperty(handle, "backgroundPositionY"));
        style.setBackgroundRepeat(this.getElementProperty(handle, "backgroundRepeat"));
        style.setTextAlign(this.getElementProperty(handle, "textAlign"));
        style.setTextIndent(this.getElementProperty(handle, "textIndent"));
        style.setTextUnderline(this.getElementProperty(handle, "textUnderline"));
        style.setTextLineThrough(this.getElementProperty(handle, "textLineThrough"));
        style.setTextOverline(this.getElementProperty(handle, "textOverline"));
        style.setLetterSpacing(this.getElementProperty(handle, "letterSpacing"));
        style.setLineHeight(this.getElementProperty(handle, "lineHeight"));
        style.setOrphans(this.getElementProperty(handle, "orphans"));
        style.setTextTransform(this.getElementProperty(handle, "textTransform"));
        style.setVerticalAlign(this.getElementProperty(handle, "verticalAlign"));
        style.setWhiteSpace(this.getElementProperty(handle, "whiteSpace"));
        style.setWidows(this.getElementProperty(handle, "widows"));
        style.setWordSpacing(this.getElementProperty(handle, "wordSpacing"));
        style.setDisplay(this.getElementProperty(handle, "display"));
        style.setMasterPage(this.getElementProperty(handle, "masterPage"));
        String pageBreakAfter = this.getElementProperty(handle, "pageBreakAfter");
        style.setPageBreakAfter(this.decodePageBreak(pageBreakAfter));
        String pageBreakBefore = this.getElementProperty(handle, "pageBreakBefore");
        style.setPageBreakBefore(this.decodePageBreak(pageBreakBefore));
        style.setPageBreakInside(this.getElementProperty(handle, "pageBreakInside"));
        style.setFontFamily(this.getElementProperty(handle, "fontFamily"));
        style.setColor(this.getElementProperty(handle, "color", true));
        style.setFontSize(this.getElementProperty(handle, "fontSize"));
        style.setFontStyle(this.getElementProperty(handle, "fontStyle"));
        style.setFontWeight(this.getElementProperty(handle, "fontWeight"));
        style.setFontVariant(this.getElementProperty(handle, "fontVariant"));
        style.setBorderBottomColor(this.getElementProperty(handle, "borderBottomColor", true));
        style.setBorderBottomStyle(this.getElementProperty(handle, "borderBottomStyle"));
        style.setBorderBottomWidth(this.getElementProperty(handle, "borderBottomWidth"));
        style.setBorderLeftColor(this.getElementProperty(handle, "borderLeftColor", true));
        style.setBorderLeftStyle(this.getElementProperty(handle, "borderLeftStyle"));
        style.setBorderLeftWidth(this.getElementProperty(handle, "borderLeftWidth"));
        style.setBorderRightColor(this.getElementProperty(handle, "borderRightColor", true));
        style.setBorderRightStyle(this.getElementProperty(handle, "borderRightStyle"));
        style.setBorderRightWidth(this.getElementProperty(handle, "borderRightWidth"));
        style.setBorderTopColor(this.getElementProperty(handle, "borderTopColor", true));
        style.setBorderTopStyle(this.getElementProperty(handle, "borderTopStyle"));
        style.setBorderTopWidth(this.getElementProperty(handle, "borderTopWidth"));
        style.setMarginTop(this.getElementProperty(handle, "marginTop"));
        style.setMarginLeft(this.getElementProperty(handle, "marginLeft"));
        style.setMarginBottom(this.getElementProperty(handle, "marginBottom"));
        style.setMarginRight(this.getElementProperty(handle, "marginRight"));
        style.setPaddingTop(this.getElementProperty(handle, "paddingTop"));
        style.setPaddingLeft(this.getElementProperty(handle, "paddingLeft"));
        style.setPaddingBottom(this.getElementProperty(handle, "paddingBottom"));
        style.setPaddingRight(this.getElementProperty(handle, "paddingRight"));
        style.setNumberAlign(this.getElementProperty(handle, "numberAlign"));
        style.setDateFormat(this.getElementProperty(handle, "dateFormat"));
        style.setDateTimeFormat(this.getElementProperty(handle, "dateTimeFormat"));
        style.setTimeFormat(this.getElementProperty(handle, "timeFormat"));
        style.setNumberFormat(this.getElementProperty(handle, "numberFormat"));
        style.setStringFormat(this.getElementProperty(handle, "stringFormat"));
        style.setDirection(this.getElementProperty(handle, "bidiTextDirection"));
        style.setCanShrink(this.getElementProperty(handle, "canShrink"));
        style.setShowIfBlank(this.getElementProperty(handle, "showIfBlank"));
        return style;
    }

    String getMemberProperty(StructureHandle handle, String name) {
        MemberHandle prop = handle.getMember(name);
        if (prop != null) {
            return prop.getStringValue();
        }
        return null;
    }

    IStyle setupStyle(StructureHandle highlight, IStyle style) {
        style.setBackgroundColor(this.getMemberProperty(highlight, "backgroundColor"));
        style.setTextAlign(this.getMemberProperty(highlight, "textAlign"));
        style.setTextIndent(this.getMemberProperty(highlight, "textIndent"));
        style.setTextUnderline(this.getMemberProperty(highlight, "textUnderline"));
        style.setTextLineThrough(this.getMemberProperty(highlight, "textLineThrough"));
        style.setTextOverline(this.getMemberProperty(highlight, "textOverline"));
        style.setTextTransform(this.getMemberProperty(highlight, "textTransform"));
        style.setFontFamily(this.getMemberProperty(highlight, "fontFamily"));
        style.setColor(this.getMemberProperty(highlight, "color"));
        style.setFontSize(this.getMemberProperty(highlight, "fontSize"));
        style.setFontStyle(this.getMemberProperty(highlight, "fontStyle"));
        style.setFontWeight(this.getMemberProperty(highlight, "fontWeight"));
        style.setFontVariant(this.getMemberProperty(highlight, "fontVariant"));
        style.setBorderBottomColor(this.getMemberProperty(highlight, "borderBottomColor"));
        style.setBorderBottomStyle(this.getMemberProperty(highlight, "borderBottomStyle"));
        style.setBorderBottomWidth(this.getMemberProperty(highlight, "borderBottomWidth"));
        style.setBorderLeftColor(this.getMemberProperty(highlight, "borderLeftColor"));
        style.setBorderLeftStyle(this.getMemberProperty(highlight, "borderLeftStyle"));
        style.setBorderLeftWidth(this.getMemberProperty(highlight, "borderLeftWidth"));
        style.setBorderRightColor(this.getMemberProperty(highlight, "borderRightColor"));
        style.setBorderRightStyle(this.getMemberProperty(highlight, "borderRightStyle"));
        style.setBorderRightWidth(this.getMemberProperty(highlight, "borderRightWidth"));
        style.setBorderTopColor(this.getMemberProperty(highlight, "borderTopColor"));
        style.setBorderTopStyle(this.getMemberProperty(highlight, "borderTopStyle"));
        style.setBorderTopWidth(this.getMemberProperty(highlight, "borderTopWidth"));
        style.setNumberAlign(this.getMemberProperty(highlight, "numberAlign"));
        style.setDateFormat(this.getMemberProperty(highlight, "dateTimeFormat"));
        style.setNumberFormat(this.getMemberProperty(highlight, "numberFormat"));
        style.setStringFormat(this.getMemberProperty(highlight, "stringFormat"));
        return style;
    }

    protected DimensionType createDimension(DimensionHandle handle, boolean useDefault) {
        if (handle == null || !useDefault && !handle.isSet()) {
            return null;
        }
        if (handle.isKeyword()) {
            return new DimensionType(handle.getStringValue());
        }
        double measure = handle.getMeasure();
        String unit = handle.getUnits();
        if (unit == null || unit.length() == 0) {
            unit = handle.getDefaultUnit();
        }
        return new DimensionType(measure, unit);
    }

    protected void setupListingItem(ListingDesign listing, ListingHandle handle) {
        this.setupReportItem(listing, (ReportItemHandle)handle);
        listing.setPageBreakInterval(handle.getPageBreakInterval());
    }

    protected void addReportDefaultPropertyValue(String name, StyleHandle handle) {
        this.addReportDefaultPropertyValue(name, handle, false);
    }

    protected void addReportDefaultPropertyValue(String name, StyleHandle handle, boolean isColorProperty) {
        Object value = null;
        int index = StylePropertyMapping.getPropertyID(name);
        if (StylePropertyMapping.canInherit(name)) {
            if (handle != null) {
                value = isColorProperty ? handle.getColorProperty(name).getStringValue() : handle.getProperty(name);
            }
            if (value == null) {
                value = StylePropertyMapping.getDefaultValue(name, this.handle);
            }
            this.inheritableReportStyle.setCssText(index, value == null ? null : value.toString());
        } else {
            value = StylePropertyMapping.getDefaultValue(name, this.handle);
            this.nonInheritableReportStyle.setCssText(index, value == null ? null : value.toString());
        }
    }

    protected void createReportDefaultStyles(StyleHandle handle) {
        this.nonInheritableReportStyle = new StyleDeclaration(this.cssEngine);
        this.inheritableReportStyle = new StyleDeclaration(this.cssEngine);
        this.addReportDefaultPropertyValue("backgroundColor", handle, true);
        this.addReportDefaultPropertyValue("backgroundImage", handle);
        this.addReportDefaultPropertyValue("backgroundPositionX", handle);
        this.addReportDefaultPropertyValue("backgroundPositionY", handle);
        this.addReportDefaultPropertyValue("backgroundRepeat", handle);
        this.addReportDefaultPropertyValue("bidiTextDirection", handle);
        this.addReportDefaultPropertyValue("textAlign", handle);
        this.addReportDefaultPropertyValue("textIndent", handle);
        this.addReportDefaultPropertyValue("letterSpacing", handle);
        this.addReportDefaultPropertyValue("lineHeight", handle);
        this.addReportDefaultPropertyValue("orphans", handle);
        this.addReportDefaultPropertyValue("textTransform", handle);
        this.addReportDefaultPropertyValue("verticalAlign", handle);
        this.addReportDefaultPropertyValue("whiteSpace", handle);
        this.addReportDefaultPropertyValue("widows", handle);
        this.addReportDefaultPropertyValue("wordSpacing", handle);
        this.addReportDefaultPropertyValue("display", handle);
        this.addReportDefaultPropertyValue("masterPage", handle);
        this.addReportDefaultPropertyValue("pageBreakAfter", handle);
        this.addReportDefaultPropertyValue("pageBreakBefore", handle);
        this.addReportDefaultPropertyValue("pageBreakInside", handle);
        this.addReportDefaultPropertyValue("fontFamily", handle);
        this.addReportDefaultPropertyValue("color", handle, true);
        this.addReportDefaultPropertyValue("fontSize", handle);
        this.addReportDefaultPropertyValue("fontStyle", handle);
        this.addReportDefaultPropertyValue("fontWeight", handle);
        this.addReportDefaultPropertyValue("fontVariant", handle);
        this.addReportDefaultPropertyValue("textLineThrough", handle);
        this.addReportDefaultPropertyValue("textOverline", handle);
        this.addReportDefaultPropertyValue("textUnderline", handle);
        this.addReportDefaultPropertyValue("borderBottomColor", handle, true);
        this.addReportDefaultPropertyValue("borderBottomStyle", handle);
        this.addReportDefaultPropertyValue("borderBottomWidth", handle);
        this.addReportDefaultPropertyValue("borderLeftColor", handle, true);
        this.addReportDefaultPropertyValue("borderLeftStyle", handle);
        this.addReportDefaultPropertyValue("borderLeftWidth", handle);
        this.addReportDefaultPropertyValue("borderRightColor", handle, true);
        this.addReportDefaultPropertyValue("borderRightStyle", handle);
        this.addReportDefaultPropertyValue("borderRightWidth", handle);
        this.addReportDefaultPropertyValue("borderTopColor", handle, true);
        this.addReportDefaultPropertyValue("borderTopStyle", handle);
        this.addReportDefaultPropertyValue("borderTopWidth", handle);
        this.addReportDefaultPropertyValue("marginTop", handle);
        this.addReportDefaultPropertyValue("marginLeft", handle);
        this.addReportDefaultPropertyValue("marginBottom", handle);
        this.addReportDefaultPropertyValue("marginRight", handle);
        this.addReportDefaultPropertyValue("paddingTop", handle);
        this.addReportDefaultPropertyValue("paddingLeft", handle);
        this.addReportDefaultPropertyValue("paddingBottom", handle);
        this.addReportDefaultPropertyValue("paddingRight", handle);
        this.addReportDefaultPropertyValue("stringFormat", handle);
        this.addReportDefaultPropertyValue("numberFormat", handle);
        this.addReportDefaultPropertyValue("dateTimeFormat", handle);
        this.report.setRootStyleName(this.assignStyleName(this.inheritableReportStyle));
    }

    protected String setupBodyStyle(MasterPageDesign design) {
        String styleName = design.getStyleName();
        IStyle style = this.report.findStyle(styleName);
        if (style == null || style.isEmpty()) {
            return null;
        }
        StyleDeclaration contentStyle = new StyleDeclaration(this.cssEngine);
        contentStyle.setProperty(20, style.getProperty(20));
        contentStyle.setProperty(37, style.getProperty(37));
        contentStyle.setProperty(54, style.getProperty(54));
        contentStyle.setProperty(48, style.getProperty(48));
        contentStyle.setProperty(14, style.getProperty(14));
        String bodyStyleName = this.assignStyleName(contentStyle);
        return bodyStyleName;
    }

    private void setupElementIDMap(ReportElementDesign rptElement) {
        this.report.setReportItemInstanceID(rptElement.getID(), rptElement);
    }

    protected long generateUniqueID() {
        --this.newCellId;
        return this.newCellId;
    }
}

