/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl.DBProfileStatement;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;

public class Connection
extends org.eclipse.birt.report.data.oda.jdbc.Connection
implements org.eclipse.datatools.connectivity.oda.IConnection {
    private static final String JDBC_CONN_TYPE = "java.sql.Connection";
    private static final Logger sm_logger = Logger.getLogger(Connection.class.getName());
    private IConnectionProfile m_dbProfile;

    public void open(Properties connProperties) throws OdaException {
        IConnectionProfile dbProfile = OdaProfileExplorer.getInstance().getProfileByName(connProperties, null);
        OdaException originalEx = null;
        try {
            this.open(dbProfile);
        }
        catch (OdaException ex) {
            sm_logger.log(Level.WARNING, Messages.connection_openFailed, ex);
            originalEx = ex;
        }
        try {
            if (!this.isOpen()) {
                super.open(connProperties);
            }
        }
        catch (OdaException odaException) {
            if (originalEx != null) {
                throw originalEx;
            }
            throw new OdaException(Messages.connection_openFailed);
        }
    }

    public void open(IConnectionProfile dbProfile) throws OdaException {
        IStatus connectStatus;
        this.jdbcConn = null;
        this.m_dbProfile = dbProfile;
        if (this.m_dbProfile == null) {
            throw new OdaException(Messages.connection_nullProfile);
        }
        if (this.m_dbProfile.getConnectionState() != 1 && ((connectStatus = this.m_dbProfile.connect()) == null || connectStatus.getSeverity() > 1)) {
            throw new OdaException(Connection.getStatusException(connectStatus));
        }
        this.jdbcConn = this.getJDBCConnection(this.m_dbProfile);
    }

    private java.sql.Connection getJDBCConnection(IConnectionProfile dbProfile) {
        if (dbProfile == null) {
            return null;
        }
        IManagedConnection mgtConn = dbProfile.getManagedConnection(JDBC_CONN_TYPE);
        if (mgtConn == null) {
            return null;
        }
        IConnection connObj = mgtConn.getConnection();
        if (connObj == null) {
            return null;
        }
        java.sql.Connection jdbcConn = (java.sql.Connection)connObj.getRawConnection();
        return jdbcConn;
    }

    public void close() throws OdaException {
        if (this.m_dbProfile != null) {
            this.m_dbProfile.disconnect(null);
            this.jdbcConn = null;
            return;
        }
        super.close();
    }

    public boolean isOpen() throws OdaException {
        if (this.m_dbProfile != null) {
            return this.m_dbProfile.getConnectionState() == 1;
        }
        return super.isOpen();
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new DBProfileStatement(this.jdbcConn);
    }

    protected IConnectionProfile getDbProfile() {
        return this.m_dbProfile;
    }

    public static Throwable getStatusException(IStatus status) {
        if (status == null) {
            return null;
        }
        Throwable ex = status.getException();
        if (ex != null) {
            return ex;
        }
        IStatus[] childrenStatus = status.getChildren();
        int i = 0;
        while (i < childrenStatus.length && ex == null) {
            ex = childrenStatus[i].getException();
            ++i;
        }
        return ex;
    }
}

