/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class FilteredServiceListener
implements ServiceListener {
    private final FilterImpl filter;
    private final ServiceListener listener;
    private final BundleContextImpl context;
    private final boolean allservices;
    private final String objectClass;
    private boolean matched;

    public FilteredServiceListener(BundleContextImpl context, ServiceListener listener, String filterstring) throws InvalidSyntaxException {
        if (filterstring == null) {
            this.filter = null;
            this.objectClass = null;
        } else {
            FilterImpl filterImpl = new FilterImpl(filterstring);
            String clazz = filterImpl.getRequiredObjectClass();
            if (clazz == null) {
                this.objectClass = null;
                this.filter = filterImpl;
            } else {
                this.objectClass = clazz.intern();
                String objectClassFilter = FilterImpl.getObjectClassFilterString(this.objectClass);
                this.filter = objectClassFilter.equals(filterstring) ? null : filterImpl;
            }
        }
        this.matched = false;
        this.listener = listener;
        this.context = context;
        this.allservices = listener instanceof AllServiceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReferenceImpl reference;
        block15: {
            block14: {
                reference = (ServiceReferenceImpl)event.getServiceReference();
                if (this.objectClass != null) {
                    String[] classes = reference.getClasses();
                    int size = classes.length;
                    int i = 0;
                    while (i < size) {
                        if (classes[i] != this.objectClass) {
                            ++i;
                            continue;
                        }
                        break block14;
                    }
                    return;
                }
            }
            if (!ServiceRegistry.hasListenServicePermission(event, this.context)) {
                return;
            }
            if (Debug.DEBUG_EVENTS) {
                String listenerName = String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this));
                Debug.println("filterServiceEvent(" + listenerName + ", \"" + this.filter + "\", " + reference.getRegistration().getProperties() + ")");
            }
            if (this.filter != null) {
                boolean match = this.filter.match(reference);
                FilteredServiceListener filteredServiceListener = this;
                synchronized (filteredServiceListener) {
                    if (match) {
                        this.matched = true;
                        break block15;
                    }
                    if (this.matched) {
                        this.matched = false;
                        if (event.getType() == 2) {
                            event = new ServiceEvent(8, reference);
                            break block15;
                        }
                    }
                }
                return;
            }
        }
        if (this.allservices || ServiceRegistry.isAssignableTo(this.context, reference)) {
            if (Debug.DEBUG_EVENTS) {
                String listenerName = String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this.listener));
                Debug.println("dispatchFilteredServiceEvent(" + listenerName + ")");
            }
            this.listener.serviceChanged(event);
        }
    }

    public String toString() {
        return this.filter == null ? this.listener.toString() : this.filter.toString();
    }
}

