/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServicePermission;

public class ServiceRegistry {
    public static final String PROP_SCOPE_SERVICE_EVENTS = "osgi.scopeServiceEvents";
    public static final boolean scopeEvents = Boolean.valueOf(FrameworkProperties.getProperty("osgi.scopeServiceEvents", "true"));
    private final HashMap publishedServicesByClass = new HashMap(50);
    private final ArrayList allPublishedServices;
    private final HashMap publishedServicesByContext = new HashMap(50);
    private long serviceid = 1L;
    private static final int initialCapacity = 50;

    public ServiceRegistry() {
        this.allPublishedServices = new ArrayList(50);
    }

    public ServiceRegistrationImpl registerService(BundleContextImpl context, String[] clazzes, Object service, Dictionary properties) {
        String invalidService;
        if (service == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new IllegalArgumentException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int size = clazzes.length;
        if (size == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        String[] copy = new String[clazzes.length];
        int i = clazzes.length - 1;
        while (i >= 0) {
            copy[i] = clazzes[i].intern();
            --i;
        }
        clazzes = copy;
        ServiceRegistry.checkRegisterServicePermission(clazzes);
        if (!(service instanceof ServiceFactory) && (invalidService = ServiceRegistry.checkServiceClass(clazzes, service)) != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + invalidService);
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, invalidService));
        }
        ServiceRegistrationImpl registration = new ServiceRegistrationImpl(this, context, clazzes, service);
        registration.register(properties);
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReferenceImpl[] getServiceReferences(BundleContextImpl context, String clazz, String filterstring, boolean allservices) throws InvalidSyntaxException {
        if (Debug.DEBUG_SERVICES) {
            Debug.println(String.valueOf(allservices ? "getAllServiceReferences(" : "getServiceReferences(") + clazz + ", \"" + filterstring + "\")");
        }
        if (clazz != null) {
            try {
                ServiceRegistry.checkGetServicePermission(clazz);
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        Filter filter = filterstring == null ? null : context.createFilter(filterstring);
        List references = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            references = this.lookupServiceReferences(clazz, filter);
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                ServiceReferenceImpl reference = (ServiceReferenceImpl)iter.next();
                if (allservices || ServiceRegistry.isAssignableTo(context, reference)) {
                    if (clazz != null) continue;
                    try {
                        ServiceRegistry.checkGetServicePermission(reference.getClasses());
                    }
                    catch (SecurityException securityException) {
                        iter.remove();
                    }
                    continue;
                }
                iter.remove();
            }
        }
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    public ServiceReferenceImpl getServiceReference(BundleContextImpl context, String clazz) {
        block12: {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + clazz + ")");
            }
            try {
                ServiceReferenceImpl[] references = this.getServiceReferences(context, clazz, null, false);
                if (references != null) {
                    int index = 0;
                    int length = references.length;
                    if (length > 1) {
                        int[] rankings = new int[length];
                        int count = 0;
                        int maxRanking = Integer.MIN_VALUE;
                        int i = 0;
                        while (i < length) {
                            int ranking;
                            rankings[i] = ranking = references[i].getRanking();
                            if (ranking > maxRanking) {
                                index = i;
                                maxRanking = ranking;
                                count = 1;
                            } else if (ranking == maxRanking) {
                                ++count;
                            }
                            ++i;
                        }
                        if (count > 1) {
                            long minId = Long.MAX_VALUE;
                            int i2 = 0;
                            while (i2 < length) {
                                long id;
                                if (rankings[i2] == maxRanking && (id = references[i2].getId()) < minId) {
                                    index = i2;
                                    minId = id;
                                }
                                ++i2;
                            }
                        }
                    }
                    return references[index];
                }
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block12;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public Object getService(BundleContextImpl context, ServiceReferenceImpl reference) {
        ServiceRegistrationImpl registration = reference.getRegistration();
        ServiceRegistry.checkGetServicePermission(registration.getClasses());
        return registration.getService(context);
    }

    public boolean ungetService(BundleContextImpl context, ServiceReferenceImpl reference) {
        ServiceRegistrationImpl registration = reference.getRegistration();
        return registration.ungetService(context);
    }

    public synchronized ServiceReferenceImpl[] getRegisteredServices(BundleContextImpl context) {
        List references = this.lookupServiceReferences(context);
        ListIterator iter = references.listIterator();
        while (iter.hasNext()) {
            ServiceReferenceImpl reference = (ServiceReferenceImpl)iter.next();
            try {
                ServiceRegistry.checkGetServicePermission(reference.getClasses());
            }
            catch (SecurityException securityException) {
                iter.remove();
            }
        }
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceReferenceImpl[] getServicesInUse(BundleContextImpl context) {
        Map servicesInUse = context.getServicesInUseMap();
        if (servicesInUse == null) {
            return null;
        }
        Map map = servicesInUse;
        synchronized (map) {
            ServiceReferenceImpl[] references;
            block10: {
                int size = servicesInUse.size();
                if (size == 0) {
                    return null;
                }
                references = new ServiceReferenceImpl[size];
                int refcount = 0;
                Iterator regsIter = servicesInUse.keySet().iterator();
                int i = 0;
                while (true) {
                    block11: {
                        if (i >= size) {
                            if (refcount < size) {
                                if (refcount != 0) break;
                                return null;
                            }
                            break block10;
                        }
                        ServiceRegistrationImpl registration = (ServiceRegistrationImpl)regsIter.next();
                        try {
                            ServiceRegistry.checkGetServicePermission(registration.getClasses());
                        }
                        catch (SecurityException securityException) {
                            break block11;
                        }
                        references[refcount] = registration.getReferenceImpl();
                        ++refcount;
                    }
                    ++i;
                }
                ServiceReferenceImpl[] refs = references;
                references = new ServiceReferenceImpl[refcount];
                System.arraycopy(refs, 0, references, 0, refcount);
            }
            return references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServices(BundleContextImpl context) {
        List registrations;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            registrations = this.lookupServiceRegistrations(context);
        }
        ListIterator iter = registrations.listIterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            try {
                registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServicesInUse(BundleContextImpl context) {
        ServiceRegistrationImpl[] usedServices;
        int usedSize;
        Map servicesInUse = context.getServicesInUseMap();
        if (servicesInUse == null) {
            return;
        }
        Map map = servicesInUse;
        synchronized (map) {
            usedSize = servicesInUse.size();
            if (usedSize == 0) {
                return;
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Releasing services");
            }
            usedServices = servicesInUse.keySet().toArray(new ServiceRegistrationImpl[usedSize]);
        }
        int i = 0;
        while (i < usedSize) {
            usedServices[i].releaseService(context);
            ++i;
        }
    }

    long getNextServiceId() {
        long id = this.serviceid++;
        return id;
    }

    void addServiceRegistration(BundleContextImpl context, ServiceRegistrationImpl registration) {
        ArrayList<ServiceRegistrationImpl> contextServices = (ArrayList<ServiceRegistrationImpl>)this.publishedServicesByContext.get(context);
        if (contextServices == null) {
            contextServices = new ArrayList<ServiceRegistrationImpl>(10);
            this.publishedServicesByContext.put(context, contextServices);
        }
        contextServices.add(registration);
        String[] clazzes = registration.getClasses();
        int size = clazzes.length;
        int i = 0;
        while (i < size) {
            String clazz = clazzes[i];
            ArrayList<ServiceRegistrationImpl> services = (ArrayList<ServiceRegistrationImpl>)this.publishedServicesByClass.get(clazz);
            if (services == null) {
                services = new ArrayList<ServiceRegistrationImpl>(10);
                this.publishedServicesByClass.put(clazz, services);
            }
            services.add(registration);
            ++i;
        }
        this.allPublishedServices.add(registration);
    }

    void removeServiceRegistration(BundleContextImpl context, ServiceRegistrationImpl serviceReg) {
        ArrayList contextServices = (ArrayList)this.publishedServicesByContext.get(context);
        if (contextServices != null) {
            contextServices.remove(serviceReg);
        }
        String[] clazzes = serviceReg.getClasses();
        int size = clazzes.length;
        int i = 0;
        while (i < size) {
            String clazz = clazzes[i];
            ArrayList services = (ArrayList)this.publishedServicesByClass.get(clazz);
            services.remove(serviceReg);
            ++i;
        }
        this.allPublishedServices.remove(serviceReg);
    }

    private List lookupServiceReferences(String clazz, Filter filter) {
        ArrayList result;
        if (clazz == null) {
            result = this.allPublishedServices;
        } else {
            result = (ArrayList)this.publishedServicesByClass.get(clazz);
            if (result == null) {
                return Collections.EMPTY_LIST;
            }
        }
        result = new ArrayList(result);
        ListIterator<ServiceReferenceImpl> iter = result.listIterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            ServiceReferenceImpl reference = registration.getReferenceImpl();
            if (filter == null || filter.match(reference)) {
                iter.set(reference);
                continue;
            }
            iter.remove();
        }
        return result;
    }

    private List lookupServiceRegistrations(BundleContextImpl context) {
        ArrayList result = (ArrayList)this.publishedServicesByContext.get(context);
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        result = new ArrayList(result);
        return result;
    }

    private List lookupServiceReferences(BundleContextImpl context) {
        List result = this.lookupServiceRegistrations(context);
        ListIterator<ServiceReferenceImpl> iter = result.listIterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            ServiceReferenceImpl reference = registration.getReferenceImpl();
            iter.set(reference);
        }
        return result;
    }

    private static void checkRegisterServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int len = names.length;
            int i = 0;
            while (i < len) {
                sm.checkPermission(new ServicePermission(names[i], "register"));
                ++i;
            }
        }
    }

    private static void checkGetServicePermission(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServicePermission(name, "get"));
        }
    }

    private static void checkGetServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SecurityException se = null;
            int len = names.length;
            int i = 0;
            while (i < len) {
                try {
                    sm.checkPermission(new ServicePermission(names[i], "get"));
                    return;
                }
                catch (SecurityException e) {
                    se = e;
                    ++i;
                }
            }
            throw se;
        }
    }

    static boolean hasListenServicePermission(ServiceEvent event, BundleContextImpl context) {
        BundleProtectionDomain domain = context.getBundleImpl().getProtectionDomain();
        if (domain == null) {
            return true;
        }
        ServiceReferenceImpl reference = (ServiceReferenceImpl)event.getServiceReference();
        String[] names = reference.getClasses();
        int len = names.length;
        int i = 0;
        while (i < len) {
            if (domain.implies(new ServicePermission(names[i], "get"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String checkServiceClass(String[] clazzes, final Object serviceObject) {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return serviceObject.getClass().getClassLoader();
            }
        });
        int i = 0;
        while (i < clazzes.length) {
            block4: {
                try {
                    Class<?> serviceClazz;
                    Class<?> clazz = serviceClazz = cl == null ? Class.forName(clazzes[i]) : cl.loadClass(clazzes[i]);
                    if (!serviceClazz.isInstance(serviceObject)) {
                        return clazzes[i];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!ServiceRegistry.extensiveCheckServiceClass(clazzes[i], serviceObject.getClass())) break block4;
                    return clazzes[i];
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String clazz, Class serviceClazz) {
        if (clazz.equals(serviceClazz.getName())) {
            return false;
        }
        Class<?>[] interfaces = serviceClazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!ServiceRegistry.extensiveCheckServiceClass(clazz, interfaces[i])) {
                return false;
            }
            ++i;
        }
        Class superClazz = serviceClazz.getSuperclass();
        return superClazz == null || ServiceRegistry.extensiveCheckServiceClass(clazz, superClazz);
    }

    static boolean isAssignableTo(BundleContextImpl context, ServiceReferenceImpl reference) {
        if (!scopeEvents) {
            return true;
        }
        AbstractBundle bundle = context.getBundleImpl();
        String[] clazzes = reference.getClasses();
        int i = 0;
        while (i < clazzes.length) {
            if (!reference.isAssignableTo(bundle, clazzes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

