/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

abstract class AbstractTracked {
    static final boolean DEBUG = false;
    private final Map tracked = new HashMap();
    private int trackingCount = 0;
    private final ArrayList adding = new ArrayList(6);
    protected volatile boolean closed = false;
    private final LinkedList initial = new LinkedList();

    protected AbstractTracked() {
    }

    protected void setInitial(Object[] list) {
        if (list == null) {
            return;
        }
        int size = list.length;
        int i = 0;
        while (i < size) {
            Object item = list[i];
            if (item != null) {
                this.initial.add(item);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackInitial() {
        while (true) {
            Object item;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.initial.size() == 0) {
                    return;
                }
                item = this.initial.removeFirst();
                if (this.tracked.get(item) != null) {
                    continue;
                }
                if (this.adding.contains(item)) {
                    continue;
                }
                this.adding.add(item);
            }
            this.trackAdding(item, null);
        }
    }

    protected void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void track(Object item, Object related) {
        Object object;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            object = this.tracked.get(item);
        }
        if (object != null) {
            abstractTracked = this;
            synchronized (abstractTracked) {
                this.modified();
            }
            this.customizerModified(item, related, object);
            return;
        }
        abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.adding.contains(item)) {
                return;
            }
            this.adding.add(item);
        }
        this.trackAdding(item, related);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackAdding(Object item, Object related) {
        Object object = null;
        boolean becameUntracked = false;
        try {
            object = this.customizerAdding(item, related);
        }
        catch (Throwable throwable) {
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.adding.remove(item)) {
                    if (object != null) {
                        this.tracked.put(item, object);
                        this.modified();
                        this.notifyAll();
                    }
                } else {
                    becameUntracked = true;
                }
            }
            throw throwable;
        }
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.adding.remove(item)) {
                if (object != null) {
                    this.tracked.put(item, object);
                    this.modified();
                    this.notifyAll();
                }
            } else {
                becameUntracked = true;
            }
        }
        if (becameUntracked) {
            this.customizerRemoved(item, related, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untrack(Object item, Object related) {
        Object object;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.initial.remove(item)) {
                return;
            }
            if (this.adding.remove(item)) {
                return;
            }
            object = this.tracked.remove(item);
            if (object == null) {
                return;
            }
            this.modified();
        }
        this.customizerRemoved(item, related, object);
    }

    protected int size() {
        return this.tracked.size();
    }

    protected Object getCustomizedObject(Object item) {
        return this.tracked.get(item);
    }

    protected void getTracked(Object[] list) {
        Iterator iter = this.tracked.keySet().iterator();
        int i = 0;
        while (i < list.length && iter.hasNext()) {
            list[i] = iter.next();
            ++i;
        }
    }

    protected void modified() {
        ++this.trackingCount;
    }

    protected int getTrackingCount() {
        return this.trackingCount;
    }

    protected abstract Object customizerAdding(Object var1, Object var2);

    protected abstract void customizerModified(Object var1, Object var2, Object var3);

    protected abstract void customizerRemoved(Object var1, Object var2, Object var3);
}

