/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.core.script.IJavascriptInitializer;
import org.eclipse.birt.core.script.IJavascriptWrapper;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptExpression;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContext {
    protected static Logger logger = Logger.getLogger(ScriptContext.class.getName());
    protected Context context;
    protected ImporterTopLevel global;
    protected Scriptable sharedScope;
    protected Scriptable scope;
    protected Map<String, Script> compiledScripts;
    protected HashMap<String, ScriptExpression> scriptExpressionCache;
    protected NativeObject params;

    public ScriptContext() {
        this(null);
    }

    public ScriptContext(ScriptableObject root) {
        block4: {
            this.compiledScripts = new HashMap<String, Script>();
            this.scriptExpressionCache = new HashMap();
            try {
                this.context = Context.enter();
                this.global = new ImporterTopLevel();
                if (root != null) {
                    this.global.exportAsJSClass(3, (Scriptable)this.global, false);
                    this.global.delete("constructor");
                    this.global.setPrototype((Scriptable)root);
                } else {
                    this.global.initStandardObjects(this.context, true);
                }
                this.scope = this.global;
                this.sharedScope = this.context.newObject(this.scope);
                this.sharedScope.setParentScope(this.scope);
            }
            catch (Exception ex) {
                Context.exit();
                this.scope = null;
                this.context = null;
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, ex.getMessage());
            }
        }
    }

    public void setCompiledScripts(Map<String, Script> compiledScripts) {
        this.compiledScripts = compiledScripts;
    }

    public void registerBean(String name, Object value) {
        Object sObj = Context.javaToJS((Object)value, (Scriptable)this.global);
        this.global.put(name, (Scriptable)this.global, sObj);
    }

    public void exit() {
        if (this.context != null) {
            Context.exit();
            this.context = null;
            this.compiledScripts = null;
            this.scriptExpressionCache.clear();
        }
    }

    public Scriptable enterScope() {
        return this.enterScope(null);
    }

    public Scriptable enterScope(Scriptable newScope) {
        if (newScope == null) {
            newScope = this.context.newObject(this.scope);
        }
        newScope.setParentScope(this.scope);
        this.scope = newScope;
        this.sharedScope.setParentScope(this.scope);
        return newScope;
    }

    public void exitScope() {
        Scriptable protoScope = this.scope.getParentScope();
        if (protoScope != null) {
            this.scope = protoScope;
        }
        this.sharedScope.setParentScope(this.scope);
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public Scriptable getSharedScope() {
        return this.sharedScope;
    }

    public Scriptable getRootScope() {
        return this.global;
    }

    public Context getContext() {
        return this.context;
    }

    public Object lookupBean(String name) {
        assert (this.context != null);
        return this.scope.get(name, this.scope);
    }

    public Object eval(String source) throws BirtException {
        if (source != null && source.length() > 0) {
            ScriptExpression scriptExpression = this.scriptExpressionCache.get(source);
            if (scriptExpression == null) {
                scriptExpression = new ScriptExpression(source);
                this.scriptExpressionCache.put(source, scriptExpression);
            }
            return this.eval(scriptExpression);
        }
        return null;
    }

    public Object eval(String source, Scriptable scope) throws BirtException {
        if (source != null && source.length() > 0) {
            ScriptExpression expr = this.scriptExpressionCache.get(source);
            if (expr == null) {
                expr = new ScriptExpression(source);
                this.scriptExpressionCache.put(source, expr);
            }
            return this.eval(scope, expr);
        }
        return null;
    }

    private Object eval(Scriptable scope, ScriptExpression expr) throws BirtException {
        String source = expr.getScriptText();
        Script script = expr.getCompiledScript();
        try {
            if (script == null) {
                String text = expr.getScriptText();
                if (this.context.getDebugger() != null) {
                    source = String.valueOf(text) + expr.getLineNumber();
                }
                if ((script = this.compiledScripts.get(source)) == null) {
                    script = this.compile(expr.getScriptText(), expr.getId(), expr.getLineNumber());
                    this.compiledScripts.put(source, script);
                }
                expr.setCompiledScript(script);
            }
            Object value = script.exec(this.context, scope);
            return this.jsToJava(value);
        }
        catch (Throwable ex) {
            throw new CoreException("birt.core.JavascriptCommonError", new Object[]{source, ex.getMessage()});
        }
    }

    private Script compile(final String script, final String id, final int lineNumber) {
        return AccessController.doPrivileged(new PrivilegedAction<Script>(){

            @Override
            public Script run() {
                return ScriptContext.this.context.compileString(script, id, lineNumber, null);
            }
        });
    }

    public Object eval(ScriptExpression expr) throws BirtException {
        assert (this.context != null);
        if (expr == null) {
            return null;
        }
        return this.eval(this.scope, expr);
    }

    public Object jsToJava(Object jsValue) {
        return JavascriptEvalUtil.convertJavascriptValue(jsValue);
    }

    public Object javaToJs(Object value) {
        return Context.javaToJS((Object)value, (Scriptable)this.scope);
    }

    public static synchronized void registerInitializer(IJavascriptInitializer initializer) {
    }

    public static synchronized void unregisterInitializer(IJavascriptInitializer initializer) {
    }

    public static synchronized void registerWrapper(IJavascriptWrapper wrapper) {
    }

    public static synchronized void unregisterWrapper(IJavascriptWrapper wrapper) {
    }

    public void setApplicationClassLoader(ClassLoader appLoader) {
        ClassLoader loader = appLoader;
        try {
            appLoader.loadClass("org.mozilla.javascript.Context");
        }
        catch (ClassNotFoundException classNotFoundException) {
            loader = new RhinoClassLoaderDecoration(appLoader, this.getClass().getClassLoader());
        }
        this.getContext().setApplicationClassLoader(loader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RhinoClassLoaderDecoration
    extends ClassLoader {
        private ClassLoader applicationClassLoader;
        private ClassLoader rhinoClassLoader;

        public RhinoClassLoaderDecoration(ClassLoader applicationClassLoader, ClassLoader rhinoClassLoader) {
            this.applicationClassLoader = applicationClassLoader;
            this.rhinoClassLoader = rhinoClassLoader;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.applicationClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.rhinoClassLoader.loadClass(name);
            }
        }
    }
}

