/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.ValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public abstract class ComplexValueHandle
extends ValueHandle {
    protected ElementPropertyDefn propDefn = null;
    protected MemberRef memberRef = null;

    public ComplexValueHandle(DesignElementHandle element, ElementPropertyDefn thePropDefn) {
        super(element);
        assert (thePropDefn != null);
        this.propDefn = thePropDefn;
    }

    public ComplexValueHandle(DesignElementHandle element, MemberRef theMemberRef) {
        super(element);
        assert (theMemberRef != null);
        this.propDefn = theMemberRef.getPropDefn();
        assert (this.propDefn != null);
        this.memberRef = theMemberRef;
    }

    public void setValue(Object value) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        if (this.memberRef == null) {
            cmd.setProperty(this.propDefn, value);
        } else {
            cmd.setMember(this.memberRef, value);
        }
    }

    public Object getValue() {
        Object value = null;
        value = this.memberRef == null ? this.getElement().getProperty(this.getModule(), this.propDefn) : this.memberRef.getValue(this.getModule(), this.getElement());
        return value;
    }

    public void setStringValue(String value) throws SemanticException {
        this.setValue(value);
    }

    public String getStringValue() {
        PropertyDefn prop = this.memberRef == null ? this.propDefn : this.memberRef.getMemberDefn();
        return prop.getStringValue(this.getModule(), this.getValue());
    }

    public String getDisplayValue() {
        PropertyDefn prop = this.memberRef == null ? this.propDefn : this.memberRef.getMemberDefn();
        return prop.getDisplayValue(this.getModule(), this.getValue());
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.propDefn;
    }

    public MemberRef getReference() {
        return this.memberRef;
    }

    protected IPropertyDefn getDefn() {
        if (this.memberRef != null) {
            return this.memberRef.getMemberDefn();
        }
        return this.propDefn;
    }

    public boolean isSet() {
        if (this.memberRef == null) {
            FactoryPropertyHandle handle = new FactoryPropertyHandle(this.elementHandle, this.propDefn);
            return handle.isSet();
        }
        Object value = this.memberRef.getValue(this.getModule(), this.getElement());
        return value != null;
    }
}

